/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.breakpoints.BreakpointFactory;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EPDCReadThread;
import com.ibm.debug.pdt.internal.core.model.EPDCRequestProcessor;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Expression;
import com.ibm.debug.pdt.internal.core.model.Expression2;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionLocal;
import com.ibm.debug.pdt.internal.core.model.ExpressionLocal2;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegister;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ProcessCCEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessTraceEvent;
import com.ibm.debug.pdt.internal.core.model.Stack;
import com.ibm.debug.pdt.internal.core.model.Storage;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.ECPCC;
import com.ibm.debug.pdt.internal.epdc.ECPFCT;
import com.ibm.debug.pdt.internal.epdc.ECPLog;
import com.ibm.debug.pdt.internal.epdc.ECPModule;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr2;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.ECPPart;
import com.ibm.debug.pdt.internal.epdc.ECPRegister;
import com.ibm.debug.pdt.internal.epdc.ECPStack;
import com.ibm.debug.pdt.internal.epdc.ECPStorage;
import com.ibm.debug.pdt.internal.epdc.ECPThread;
import com.ibm.debug.pdt.internal.epdc.ECPTrace;
import com.ibm.debug.pdt.internal.epdc.EPDC_Base;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.ERepError;
import com.ibm.debug.pdt.internal.epdc.ERepInitializeDE;
import com.ibm.debug.pdt.internal.epdc.ERepMultiRequest;
import com.ibm.debug.pdt.internal.epdc.ERepPreparePgm;
import com.ibm.debug.pdt.internal.epdc.ERepProcessAttach;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;
import com.ibm.debug.pdt.internal.epdc.ERepReSync;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEntry;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionRepTypeSet;
import com.ibm.debug.pdt.internal.epdc.EStdLogLine;
import com.ibm.debug.pdt.internal.epdc.EStdTraceBinaryEntry;
import com.ibm.debug.pdt.internal.epdc.IMultiReply;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

final class EPDCReplyProcessor
extends Thread {
    private static final DebuggeeThread[] EMPTYTHREADS = new DebuggeeThread[0];
    private ArrayList<DebuggeeThread> fProcessedThreads;
    private final DebugEngine fDebugEngine;
    private boolean fContinue = true;
    private final EPDC_EngineSession fEngineSession;
    private final EPDCReadThread fReadThread;

    EPDCReplyProcessor(EPDCRequestProcessor requestProcessor, EPDCReadThread readThread) {
        super("Reply processor");
        this.setDaemon(true);
        this.fDebugEngine = requestProcessor.getDebugEngine();
        this.fReadThread = readThread;
        this.fEngineSession = this.fDebugEngine.getEngineSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        do {
            block38: {
                block34: {
                    block35: {
                        reply = null;
                        reply = this.fReadThread.getReply();
                        if (reply != null) break block34;
                        if (reply == null) break block35;
                        var4_5 = reply;
                        synchronized (var4_5) {
                            if (PDTCorePlugin.fEPDCThreads) {
                                PDTCoreUtils.logString(this, String.format(".notifyReply(rep %s(%d))", new Object[]{reply, reply.getReplyCode()}));
                            }
                            reply._processed = true;
                            reply.notify();
                            break;
                        }
                    }
                    if (!PDTCorePlugin.fEPDCThreads) break;
                    PDTCoreUtils.logString(this, ".notifyReply(none)");
                    break;
                }
                try {
                    if (reply instanceof ERepError || reply.getReplyCode() == 42) {
                        this.fContinue = false;
                    }
                    this.updateModel(reply, false);
                }
                catch (InterruptedException e) {
                    this.fContinue = false;
                    if (reply != null) {
                        var4_5 = reply;
                        synchronized (var4_5) {
                            if (PDTCorePlugin.fEPDCThreads) {
                                PDTCoreUtils.logString(this, String.format(".notifyReply(rep %s(%d))", new Object[]{reply, reply.getReplyCode()}));
                            }
                            reply._processed = true;
                            reply.notify();
                        }
                    }
                    if (!PDTCorePlugin.fEPDCThreads) ** GOTO lbl93
                    PDTCoreUtils.logString(this, ".notifyReply(none)");
                }
                catch (Exception e) {
                    block37: {
                        try {
                            this.fContinue = false;
                            PDTCoreUtils.logError(e);
                            if (reply == null) break block37;
                            var4_5 = reply;
                        }
                        catch (Throwable var3_6) {
                            if (reply != null) {
                                var4_5 = reply;
                                synchronized (var4_5) {
                                    if (PDTCorePlugin.fEPDCThreads) {
                                        PDTCoreUtils.logString(this, String.format(".notifyReply(rep %s(%d))", new Object[]{reply, reply.getReplyCode()}));
                                    }
                                    reply._processed = true;
                                    reply.notify();
                                }
                            } else if (PDTCorePlugin.fEPDCThreads) {
                                PDTCoreUtils.logString(this, ".notifyReply(none)");
                            }
                            throw var3_6;
                        }
                        synchronized (var4_5) {
                            if (PDTCorePlugin.fEPDCThreads) {
                                PDTCoreUtils.logString(this, String.format(".notifyReply(rep %s(%d))", new Object[]{reply, reply.getReplyCode()}));
                            }
                            reply._processed = true;
                            reply.notify();
                        }
                    }
                    if (!PDTCorePlugin.fEPDCThreads) ** GOTO lbl93
                    PDTCoreUtils.logString(this, ".notifyReply(none)");
                }
                if (reply == null) break block38;
                var4_5 = reply;
                synchronized (var4_5) {
                    if (PDTCorePlugin.fEPDCThreads) {
                        PDTCoreUtils.logString(this, String.format(".notifyReply(rep %s(%d))", new Object[]{reply, reply.getReplyCode()}));
                    }
                    reply._processed = true;
                    reply.notify();
                }
            }
            if (!PDTCorePlugin.fEPDCThreads) continue;
            PDTCoreUtils.logString(this, ".notifyReply(none)");
lbl93:
            // 9 sources

        } while (this.fContinue);
        if (PDTCorePlugin.fEPDCThreads) {
            PDTCoreUtils.logString(this, String.format(".exitingRunningState(continue = %b)", new Object[]{this.fContinue}));
        }
    }

    private void processReply(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, ".processReply(" + EPDC_Base.getClassName(reply) + ")");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        String replyMessageText = reply.getMessageText();
        int returnCode = reply.getReturnCode();
        boolean isMultiReplyParentOk = this.isMultiReplyParentOk(reply);
        if (returnCode != 0) {
            if (PDTCorePlugin.fLogEngineErrors) {
                PDTCoreUtils.logString(this, " RC = " + returnCode + " Text:<" + replyMessageText + ">", 1);
            }
            if (isMultiReplyParentOk) {
                this.fDebugEngine.handleError(reply);
            } else {
                this.logErrorOnly(reply);
            }
        } else if (replyMessageText != null && !replyMessageText.isEmpty()) {
            if (isMultiReplyParentOk) {
                this.fDebugEngine.sendMessage(replyMessageText, reply.getRequest());
            } else {
                this.logErrorOnly(reply);
            }
        }
        switch (reply.getReplyCode()) {
            case 29: {
                ERepInitializeDE initializeReply = (ERepInitializeDE)reply;
                this.fDebugEngine.initialize(initializeReply);
                break;
            }
            case 78: {
                ERepReSync resyncReply = (ERepReSync)reply;
                this.fDebugEngine.initialize(resyncReply);
                if (this.fDebugEngine.getProcess() != null) break;
                process = new DebuggeeProcess(this.fDebugEngine, resyncReply.getReplyCode(), null, null, null, null, null);
                this.fDebugEngine.add(process);
                break;
            }
            case 30: {
                if (reply.getReturnCode() != 0) break;
                ERepPreparePgm prepareReply = (ERepPreparePgm)reply;
                this.fDebugEngine.updateViewOrder();
                process = new DebuggeeProcess(this.fDebugEngine, prepareReply.getReplyCode(), prepareReply.getProcessId(), prepareReply.getQualifiedName(), prepareReply.getProfileName(), prepareReply.getTimeStamp(), prepareReply.getDateStamp());
                this.fDebugEngine.add(process);
                break;
            }
            case 46: 
            case 49: {
                if (reply.getReturnCode() != 0) break;
                ERepProcessAttach attachReply = (ERepProcessAttach)reply;
                this.fDebugEngine.updateViewOrder();
                process = new DebuggeeProcess(this.fDebugEngine, attachReply.getReplyCode(), attachReply.getProcessId(), attachReply.getQualifiedName(), attachReply.getProfileName(), attachReply.getTimeStamp(), attachReply.getDateStamp());
                this.fDebugEngine.add(process);
                break;
            }
        }
        if (reply instanceof ERepProcessStop && process != null) {
            process.setProcessStopInfo(((ERepProcessStop)reply).getStopInfo());
        }
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Change Packets for reply [" + EPDC_Base.getClassName(reply) + "]");
        }
        if (reply.isFCTChgd()) {
            this.processFCTChg(reply);
        }
        if (reply.isModuleEntryChgd()) {
            this.processModChg(reply);
        }
        if (reply.isPartChgd()) {
            this.processPartChg(reply);
        }
        if (reply.isThreadStateChgd()) {
            this.processThreadChg(reply);
        }
        if (reply.isMonStackChgd()) {
            this.processMonStackChg(reply);
        }
        if (this.fProcessedThreads != null) {
            this.updateTopStackframes(this.getProcessedThreads());
            this.fProcessedThreads.clear();
        }
        if (reply.isMonVariableChgd()) {
            this.processMonVarChg(reply);
        }
        if (reply.isBrkPtChgd()) {
            this.processBrkPtChg(reply);
        }
        if (reply.isMonStorChgd()) {
            this.processMonStorChg(reply);
        }
        if (reply.isMonRegsChgd()) {
            this.processMonRegChg(reply);
        }
        if (reply.isLogChgd()) {
            this.processLogChg(reply);
        }
        if (reply.isCCChgd()) {
            this.processCCChg(reply);
        }
        if (reply.isTraceChgd()) {
            this.processTraceChg(reply);
        }
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Finished processing change packets for reply [" + EPDC_Base.getClassName(reply) + "]");
        }
        switch (reply.getReplyCode()) {
            case 25: {
                if (process == null) break;
                process.setEnded();
                break;
            }
            case 42: {
                this.fDebugEngine.setEnded();
                break;
            }
            case 998: 
            case 999: {
                if (process != null) {
                    process.setEnded();
                }
                this.fDebugEngine.setEnded();
                break;
            }
            case 2: 
            case 30: 
            case 31: 
            case 44: 
            case 46: 
            case 49: 
            case 76: 
            case 230: 
            case 235: 
            case 236: {
                ProcessStopInfo stopInfo;
                if (returnCode != 0 || process == null) break;
                if (this.fDebugEngine.isRunningCC()) {
                    this.fDebugEngine.getEventManager().fireAllQueuedEvents();
                }
                if ((stopInfo = process.getProcessStopInfo()).isEnded()) {
                    process.setEnded();
                    break;
                }
                if (stopInfo.isStillProcessing()) break;
                process.clearMemoryCache();
                if (this.fEngineSession.supportsAsync()) break;
                process.hasStopped(stopInfo);
                break;
            }
            case 47: {
                if (returnCode != 0 || process == null) break;
                process.hasDetached();
                break;
            }
            case 72: {
                if (process == null) break;
                process.clearMemoryCache();
                break;
            }
        }
        if (reply instanceof IMultiReply) {
            EPDC_Reply[] replies;
            EPDC_Reply[] ePDC_ReplyArray = replies = ((IMultiReply)((Object)reply)).getReplies();
            int n = replies.length;
            int n2 = 0;
            while (n2 < n) {
                EPDC_Reply r = ePDC_ReplyArray[n2];
                this.processReply(r);
                ++n2;
            }
        }
    }

    protected void updateModel(EPDC_Reply reply, boolean innerCall) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, ".updateModel(" + EPDC_Base.getClassName(reply) + "," + EPDC_Base.getClassName(reply.getRequest()) + ")");
        }
        if (reply != null) {
            try {
                this.processReply(reply);
            }
            catch (Exception e) {
                PDTCoreUtils.logError(e);
            }
        }
        if (this.fDebugEngine.getEventManager().fireAllQueuedEvents()) {
            return;
        }
        if (!innerCall) {
            this.fDebugEngine.fireEvent(new ModelStateReadyEvent(this.fDebugEngine, reply.getEventCode()));
        }
    }

    private void processFCTChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing FCT change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPFCT[] changePackets = reply.getFCTChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing FCT change packet", 2);
            return;
        }
        if (process != null && this.fEngineSession.supportsPostMortemDebug()) {
            process.setIsPostMortem();
        }
    }

    private void processThreadChg(EPDC_Reply reply) {
        ECPThread firstChangePkt;
        DebuggeeProcess process;
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing thread change packets");
        }
        if ((process = this.fDebugEngine.getProcess()) == null) {
            PDTCoreUtils.logString(this, " Missing process", 4);
            return;
        }
        ECPThread[] changePackets = reply.getThreadChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing thread change packet(s)", 2);
            return;
        }
        int stoppingThreadID = 0;
        if (changePackets.length > 1 && reply instanceof ERepProcessStop && (stoppingThreadID = ((ERepProcessStop)reply).getStopInfo().getStoppingThreadId()) != 0 && ((firstChangePkt = changePackets[0]).getId() != stoppingThreadID || firstChangePkt.getDebugState() != 4)) {
            ArrayList<ECPThread> list = new ArrayList<ECPThread>(changePackets.length);
            int cursor = 0;
            int i = 0;
            while (i < changePackets.length) {
                ECPThread chgPkt = changePackets[i];
                if (chgPkt.getDebugState() == 2) {
                    list.add(cursor++, chgPkt);
                } else if (chgPkt.getDebugState() == 4 && chgPkt.getId() == stoppingThreadID) {
                    list.add(cursor, chgPkt);
                } else {
                    list.add(chgPkt);
                }
                ++i;
            }
            changePackets = list.toArray(new ECPThread[changePackets.length]);
        }
        boolean incompleteStopInfo = reply instanceof ERepProcessStop && !((ERepProcessStop)reply).isStopInfoComplete();
        ECPThread[] eCPThreadArray = changePackets;
        int n = changePackets.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                DebuggeeThread thread;
                ECPThread threadItem;
                block16: {
                    threadItem = eCPThreadArray[n2];
                    thread = process.getThread(threadItem.getId());
                    if (thread != null) break block16;
                    if (threadItem.isTerminated()) break block17;
                    thread = new DebuggeeThread(process, threadItem);
                    if (incompleteStopInfo) {
                        incompleteStopInfo = false;
                        ProcessStopInfo stopInfo = new ProcessStopInfo(threadItem);
                        ((ERepProcessStop)reply).setStopInfo(stopInfo);
                        process.setProcessStopInfo(stopInfo);
                    }
                    process.add(thread);
                }
                if (threadItem.isTerminated()) {
                    process.remove(thread);
                } else {
                    this.addProcessedThread(thread);
                    thread.change(threadItem, reply);
                }
            }
            ++n2;
        }
    }

    private void processModChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Module  change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPModule[] changePackets = reply.getModuleChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing module change packet(s)", 2);
            return;
        }
        int i = 0;
        while (i < changePackets.length) {
            Module module;
            ECPModule moduleChangeItem = changePackets[i];
            if (moduleChangeItem.hasBeenDeleted()) {
                process.removeModule(moduleChangeItem.moduleID());
            } else if (moduleChangeItem.isNewModule()) {
                process.add(new Module(process, moduleChangeItem, this.fDebugEngine));
            } else if (moduleChangeItem.hasChanged() && (module = process.getModule(moduleChangeItem.moduleID())) != null) {
                module.change(moduleChangeItem);
            }
            ++i;
        }
    }

    private void processPartChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Part change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPPart[] changePackets = reply.getPartChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing part change packet(s)", 2);
            return;
        }
        int i = 0;
        while (i < changePackets.length) {
            ECPPart partChangeItem = changePackets[i];
            Module module = process.getModule(partChangeItem.getModuleID());
            if (partChangeItem.isDeletedPart()) {
                if (module != null) {
                    module.delete(partChangeItem);
                }
            } else if (partChangeItem.isNewPart()) {
                if (module == null) {
                    PDTCoreUtils.logString(this, "Creating part (" + partChangeItem.getId() + ") but module (" + partChangeItem.getModuleID() + ") missing, part create ignored", 2);
                } else {
                    module.add(new Part(module, partChangeItem, this.fDebugEngine));
                }
            } else if (module == null) {
                PDTCoreUtils.logString(this, "Updating part (" + partChangeItem.getId() + ") but module (" + partChangeItem.getModuleID() + ") missing, part change ignored", 2);
            } else {
                Part part = process.getPart(partChangeItem.getId());
                if (part != null) {
                    part.change(partChangeItem);
                }
            }
            ++i;
        }
    }

    private void processMonVarChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Monitor change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPMonitorExprBase[] changePackets = reply.getMonitorChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing monitor change packet(s)", 2);
            return;
        }
        int i = 0;
        while (i < changePackets.length) {
            block28: {
                short monitorType;
                DebuggeeThread thread;
                ECPMonitorExprBase monitorChangeItem;
                block29: {
                    monitorChangeItem = changePackets[i];
                    if (!monitorChangeItem.isValid()) break block28;
                    thread = null;
                    monitorType = monitorChangeItem.getType();
                    if (monitorType == 3 || monitorType == 2) {
                        try {
                            thread = process.getThread(monitorChangeItem.getThreadID());
                        }
                        catch (NullPointerException npe) {
                            PDTCoreUtils.logError(npe);
                        }
                    }
                    if (!monitorChangeItem.isDeleted()) break block29;
                    int id = monitorChangeItem.getId();
                    switch (monitorType) {
                        case 3: {
                            if (thread != null) {
                                thread.removeLocal(id);
                                break;
                            }
                            break block28;
                        }
                        case 0: {
                            process.removeMonitoredExpression(id);
                            break;
                        }
                        case 2: {
                            if (thread == null) break block28;
                            thread.removeEvaluatedExpression(id);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block28;
                }
                if (monitorChangeItem.isNewMonitor()) {
                    ExpressionBase monitoredExpression = null;
                    HashMap restoredReps = (HashMap)reply.retrieveObject(7);
                    switch (monitorType) {
                        case 3: {
                            if (thread == null) break;
                            monitoredExpression = monitorChangeItem instanceof ECPMonitorExpr ? new ExpressionLocal(process, (ECPMonitorExpr)monitorChangeItem, this.fDebugEngine) : new ExpressionLocal2(process, (ECPMonitorExpr2)monitorChangeItem, this.fDebugEngine);
                            thread.add(monitoredExpression);
                            break;
                        }
                        case 0: {
                            monitoredExpression = monitorChangeItem instanceof ECPMonitorExpr ? new Expression(process, (ECPMonitorExpr)monitorChangeItem, this.fDebugEngine) : new Expression2(process, (ECPMonitorExpr2)monitorChangeItem, restoredReps, this.fDebugEngine);
                            process.add(monitoredExpression);
                            break;
                        }
                        case 2: {
                            if (thread == null) break;
                            monitoredExpression = monitorChangeItem instanceof ECPMonitorExpr ? new Expression(process, (ECPMonitorExpr)monitorChangeItem, this.fDebugEngine) : new Expression2(process, (ECPMonitorExpr2)monitorChangeItem, restoredReps, this.fDebugEngine);
                            thread.setEvaluatedExpression(reply.retrieveObject(2), monitoredExpression);
                            break;
                        }
                    }
                    this.processPendingRequests(monitoredExpression);
                } else {
                    process.clearMemoryCache();
                    ExpressionBase monitoredExpression = null;
                    int id = monitorChangeItem.getId();
                    switch (monitorType) {
                        case 3: {
                            if (thread == null) break;
                            monitoredExpression = thread.getLocal(id);
                            break;
                        }
                        case 0: {
                            monitoredExpression = process.getMonitoredExpression(id);
                            break;
                        }
                        case 2: {
                            if (thread == null) break;
                            monitoredExpression = thread.getEvaluatedExpression(id);
                            break;
                        }
                    }
                    if (monitoredExpression != null) {
                        monitoredExpression.update(monitorChangeItem);
                        this.processPendingRequests(monitoredExpression);
                    }
                }
            }
            ++i;
        }
    }

    private void processPendingRequests(ExpressionBase monitoredExpression) {
        if (monitoredExpression instanceof Expression2 && monitoredExpression.isEnabled() && !monitoredExpression.isDeferred()) {
            EPDC_Request[] pendingRequests;
            EPDC_Request[] ePDC_RequestArray = pendingRequests = ((Expression2)monitoredExpression).getPendingRequests();
            int n = pendingRequests.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    EPDC_Request request = ePDC_RequestArray[n2];
                    try {
                        try {
                            if (request instanceof EReqExpressionRepTypeSet) {
                                monitoredExpression.setSuppressChangeFlags(true);
                                this.fDebugEngine.processRequest(request);
                            } else {
                                this.fDebugEngine.processRequest(request);
                            }
                        }
                        catch (EngineRequestException e) {
                            PDTCoreUtils.logError(e);
                            monitoredExpression.setSuppressChangeFlags(false);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        monitoredExpression.setSuppressChangeFlags(false);
                        throw throwable;
                    }
                    monitoredExpression.setSuppressChangeFlags(false);
                }
                ++n2;
            }
        }
    }

    private void processBrkPtChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Breakpoint change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPBreakpoint[] changePackets = reply.getBreakpointChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing breakpoint change packet(s)", 2);
            return;
        }
        Map<Integer, Object> properties = reply.getProperties();
        int i = 0;
        while (i < changePackets.length) {
            block18: {
                ECPBreakpoint breakpointChangeItem;
                block19: {
                    block17: {
                        breakpointChangeItem = changePackets[i];
                        if (reply instanceof ERepMultiRequest) {
                            properties = ((ERepMultiRequest)reply).getProperties(breakpointChangeItem, i);
                        }
                        if (!breakpointChangeItem.isDeleted()) break block17;
                        process.removeBreakpoint(breakpointChangeItem.getId());
                        break block18;
                    }
                    if (!breakpointChangeItem.isNew()) break block19;
                    Breakpoint breakpoint = null;
                    BreakpointFactory brkFactory = this.fEngineSession.getBreakpointFactory();
                    switch (breakpointChangeItem.getType()) {
                        case 0: {
                            breakpoint = brkFactory.createLineBreakpoint(process, breakpointChangeItem, properties);
                            break;
                        }
                        case 3: {
                            breakpoint = brkFactory.createMacroBreakpoint(process, breakpointChangeItem, properties);
                            break;
                        }
                        case 2: {
                            breakpoint = brkFactory.createEntryBreakpoint(process, breakpointChangeItem, properties);
                            EPDC_Request request = reply.getRequest();
                            if (!(request instanceof EReqBreakpointLocation) || request instanceof EReqBreakpointEntry) break;
                            String errorMessage = NLS.bind((String)PICLMessages.MacroBPWizard_macro_not_found, (Object)((EntryBreakpoint)breakpoint).getFunctionName());
                            ((ERepBreakpointLocation)reply).setError(321, errorMessage, breakpoint);
                            break;
                        }
                        case 1: {
                            breakpoint = brkFactory.createAddressBreakpoint(process, breakpointChangeItem, properties);
                            break;
                        }
                        case 6: {
                            breakpoint = brkFactory.createWatchpoint(process, breakpointChangeItem, properties);
                            break;
                        }
                        case 5: {
                            breakpoint = brkFactory.createModuleLoadBreakpoint(process, breakpointChangeItem, properties, false);
                            break;
                        }
                        case 12: {
                            breakpoint = brkFactory.createModuleLoadBreakpoint(process, breakpointChangeItem, properties, true);
                            break;
                        }
                        case 7: {
                            breakpoint = brkFactory.createEnhancedWatchpoint(process, breakpointChangeItem, properties);
                            break;
                        }
                        case 8: {
                            breakpoint = brkFactory.createOccurrenceBreakpoint(process, breakpointChangeItem, properties);
                            break;
                        }
                        case 13: {
                            breakpoint = brkFactory.createZeroAddressBreakpoint(process, breakpointChangeItem, properties);
                            break;
                        }
                        default: {
                            PDTCoreUtils.logString(this, String.format(" Unknown breakpoint type (%x)", breakpointChangeItem.getType()));
                            break block18;
                        }
                    }
                    process.add(breakpoint);
                    break block18;
                }
                Breakpoint bkp = process.getBreakpoint(breakpointChangeItem.getId());
                if (bkp != null) {
                    bkp.change(breakpointChangeItem, properties);
                }
            }
            ++i;
        }
    }

    @Deprecated
    private void processMonStorChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Storage change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPStorage[] changePackets = reply.getStorageChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing storage change packet(s)", 2);
            return;
        }
        int i = 0;
        while (i < changePackets.length) {
            ECPStorage storageChangeItem = changePackets[i];
            if (storageChangeItem.isDeleted()) {
                process.removeStorage();
            } else if (storageChangeItem.isNew()) {
                process.add(new Storage(process, storageChangeItem, this.fDebugEngine));
            } else {
                Storage storage = process.getStorage();
                if (storage != null) {
                    storage.change(storageChangeItem, false);
                }
            }
            ++i;
        }
    }

    private void processMonRegChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Register change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPRegister[] changePackets = reply.getRegisterChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing register change packet(s)", 2);
            return;
        }
        int i = 0;
        while (i < changePackets.length) {
            ECPRegister chgdRegister = changePackets[i];
            DebuggeeThread owningThread = process.getThread(chgdRegister.getThreadID());
            if (owningThread != null) {
                MonitoredRegisterGroup monRegGroup = owningThread.getRegisterGroup(chgdRegister.getGroupID()).getMonitoredRegisterGroup();
                MonitoredRegister monReg = monRegGroup.getRegister(chgdRegister.getRegisterID());
                if (chgdRegister.isDeleted()) {
                    monRegGroup.remove(monReg);
                } else if (monReg == null) {
                    monRegGroup.add(new MonitoredRegister(monRegGroup, chgdRegister, this.fDebugEngine));
                } else {
                    process.clearMemoryCache();
                    monReg.change(chgdRegister);
                }
            }
            ++i;
        }
    }

    private void processMonStackChg(EPDC_Reply reply) {
        ECPStack[] changePackets;
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Stack change packets");
        }
        if ((changePackets = reply.getStackChanges()).length == 0) {
            PDTCoreUtils.logString(this, " Missing stack change packet(s)", 2);
            return;
        }
        int i = 0;
        while (i < changePackets.length) {
            ECPStack stackChangeItem = changePackets[i];
            DebuggeeThread owningThread = this.fDebugEngine.getProcess().getThread(stackChangeItem.getThreadID());
            if (owningThread != null) {
                if (stackChangeItem.isStackDeleted()) {
                    owningThread.removeStack();
                } else {
                    Stack stack = owningThread.getStack();
                    if (stackChangeItem.isNewStack()) {
                        if (stack == null) {
                            owningThread.add(new Stack(owningThread, stackChangeItem, this.fDebugEngine));
                        } else {
                            stack.change(stackChangeItem);
                        }
                    } else {
                        this.removeProcessedThread(owningThread);
                        stack.change(stackChangeItem);
                    }
                }
            }
            ++i;
        }
    }

    private void processLogChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing log change packets");
        }
        DebuggeeProcess process = this.fDebugEngine.getProcess();
        ECPLog[] changePackets = reply.getLogChanges();
        if (changePackets.length == 0) {
            PDTCoreUtils.logString(this, " Missing log change packet(s)", 2);
            return;
        }
        ArrayList<String> cmdLogLines = new ArrayList<String>();
        ArrayList<String> pgmOutputLines = new ArrayList<String>();
        ArrayList<String> pgmErrorLines = new ArrayList<String>();
        ArrayList<String> cmdEchoLines = new ArrayList<String>();
        int i = 0;
        while (i < changePackets.length) {
            ECPLog logChangeItem = changePackets[i];
            EStdLogLine[] chgPktLogLines = logChangeItem.getLogLines();
            int k = 0;
            while (k < chgPktLogLines.length) {
                EStdLogLine logLine = chgPktLogLines[k];
                if (logLine != null) {
                    switch (logLine.getLineType()) {
                        case 1: {
                            cmdLogLines.add(logLine.getLogLineString());
                            break;
                        }
                        case 2: {
                            pgmOutputLines.add(logLine.getLogLineString());
                            break;
                        }
                        case 3: {
                            pgmErrorLines.add(logLine.getLogLineString());
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 5: {
                            cmdEchoLines.add(logLine.getLogLineString());
                            break;
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
        if (!cmdLogLines.isEmpty()) {
            String[] tmpArray = cmdLogLines.toArray(new String[cmdLogLines.size()]);
            this.fDebugEngine.commandLogResponse(tmpArray, false);
        }
        if (!cmdEchoLines.isEmpty()) {
            String[] tmpArray = cmdEchoLines.toArray(new String[cmdEchoLines.size()]);
            this.fDebugEngine.commandLogResponse(tmpArray, true);
        }
        if (!pgmOutputLines.isEmpty() && process != null) {
            String[] tmpArray = pgmOutputLines.toArray(new String[pgmOutputLines.size()]);
            process.programOutput(tmpArray);
        }
        if (!pgmErrorLines.isEmpty() && process != null) {
            String[] tmpArray = pgmErrorLines.toArray(new String[pgmErrorLines.size()]);
            process.programError(tmpArray);
        }
    }

    private void processCCChg(EPDC_Reply reply) {
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing CC change packets");
        }
        ECPCC[] chgPkt = reply.getCCChanges();
        ProcessCCEvent event = new ProcessCCEvent(this, this.fDebugEngine.getProcess());
        ECPCC[] eCPCCArray = chgPkt;
        int n = chgPkt.length;
        int n2 = 0;
        while (n2 < n) {
            ECPCC element = eCPCCArray[n2];
            switch (element.getType()) {
                case EXECUTABLELINES: {
                    event.addExecutableLines(element.getExecutableLines());
                    break;
                }
                case HITLINES: {
                    event.addHitLines(element.getHitLines());
                    break;
                }
                case FLOWPOINTS: {
                    event.addFlowPoints(element.getFileFlowPoints());
                    break;
                }
                case FLOWPOINTSHIT: {
                    event.addFlowPointsHit(element.getFlowPointsHit());
                    break;
                }
                case TRACE: {
                    event.addTraceEntries(element.getTraceEntries());
                    break;
                }
            }
            ++n2;
        }
        this.fDebugEngine.getProcess().processCCEvent(event);
    }

    private void processTraceChg(EPDC_Reply reply) {
        ECPTrace[] changePackets;
        if (PDTCorePlugin.fModelEPDC) {
            PDTCoreUtils.logString(this, "  Processing Trace change packets");
        }
        if ((changePackets = reply.getTraceChanges()).length == 0) {
            PDTCoreUtils.logString(this, " Missing register trace packet(s)", 2);
            return;
        }
        ProcessTraceEvent event = new ProcessTraceEvent(this, this.fDebugEngine.getProcess());
        ECPTrace[] eCPTraceArray = changePackets;
        int n = changePackets.length;
        int n2 = 0;
        while (n2 < n) {
            ECPTrace element = eCPTraceArray[n2];
            EStdTraceBinaryEntry[] entries = element.getBinaryTraceEntries();
            if (entries != null && entries.length > 0) {
                event.addBinaryTraceEntries(entries);
            }
            ++n2;
        }
        this.fDebugEngine.getProcess().processTraceEvent(event);
    }

    public void stopProcessing() {
        this.fContinue = false;
    }

    private void addProcessedThread(DebuggeeThread thread) {
        if (this.fProcessedThreads == null) {
            this.fProcessedThreads = new ArrayList();
        }
        this.fProcessedThreads.add(thread);
    }

    private void removeProcessedThread(DebuggeeThread thread) {
        if (this.fProcessedThreads == null) {
            return;
        }
        this.fProcessedThreads.remove(thread);
    }

    private DebuggeeThread[] getProcessedThreads() {
        if (this.fProcessedThreads == null) {
            return EMPTYTHREADS;
        }
        return this.fProcessedThreads.toArray(new DebuggeeThread[this.fProcessedThreads.size()]);
    }

    private void updateTopStackframes(DebuggeeThread[] processedThreads) {
        DebuggeeThread[] debuggeeThreadArray = processedThreads;
        int n = processedThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Stack stack;
            DebuggeeThread thread = debuggeeThreadArray[n2];
            if (thread.isMonitoringStack() && (stack = thread.getStack()) != null) {
                stack.updateTopStackFrame();
            }
            ++n2;
        }
    }

    private void logErrorOnly(EPDC_Reply reply) {
        String message = reply.getMessageText();
        int returnCode = reply.getReturnCode();
        if (message == null || message.isEmpty()) {
            message = "Unexpected return code in child reply.";
        }
        if (returnCode == 0) {
            PDTCoreUtils.logString(reply, String.format("Multi-reply child error: %s. rc=%d", message, returnCode), 4);
        }
    }

    private boolean isMultiReplyParentOk(EPDC_Reply reply) {
        EPDC_Request parent = reply.getMultiRequestParent();
        if (parent != null) {
            return parent.getReply().getReturnCode() == 0 && (parent.getReply().getMessageText() == null || parent.getReply().getMessageText().trim().isEmpty());
        }
        return true;
    }
}

