/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepConnectionError;
import com.ibm.debug.pdt.internal.epdc.ERepConnectionTerminated;
import com.ibm.debug.pdt.internal.epdc.ERepError;
import com.ibm.debug.pdt.internal.epdc.ERepNotify;
import com.ibm.debug.pdt.internal.epdc.ERepRequestCancelled;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.LinkedList;

final class EPDCReadThread
extends Thread {
    private boolean fContinue = true;
    private LinkedList<EPDC_Request> fRequestQueue = new LinkedList();
    private LinkedList<EPDC_Reply> fReplyQueue = new LinkedList();
    private EPDC_EngineSession fEngineSession;
    private InputStream fInputStream;
    private boolean fConnectionTerminated = false;
    private Socket fConnection;

    EPDCReadThread(DebugEngine debugEngine) throws IOException {
        super("Read thread");
        this.setDaemon(true);
        this.fEngineSession = debugEngine.getEngineSession();
        this.fInputStream = debugEngine.getConnection().getInputStream();
        this.fConnection = debugEngine.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            EPDC_Reply reply = null;
            try {
                reply = EPDC_Reply.decodeReplyStream(this.fInputStream, 0, this.fEngineSession, true);
            }
            catch (Exception exception) {
                if (this.fConnectionTerminated) {
                    reply = new ERepConnectionTerminated(this.fEngineSession, exception);
                } else {
                    reply = new ERepConnectionError(this.fEngineSession, exception);
                    if (this.getCurrentRequest() == null || this.getCurrentRequest().isProgramTerminating()) {
                        PDTCoreUtils.logError(exception);
                    }
                }
                try {
                    this.fConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.fContinue = false;
            }
            if (reply instanceof ERepNotify) {
                this.queueReplyForProcessing(reply);
            } else {
                EPDC_Request request = this.getRequest();
                if (request == null) {
                    if (!(reply instanceof ERepError)) {
                        PDTCoreUtils.logString(this, " Reply <" + reply.getDescription() + "> is missing pending request", 2);
                    }
                    this.queueReplyForProcessing(reply);
                } else {
                    EPDC_Request ePDC_Request = request;
                    synchronized (ePDC_Request) {
                        if (request.getTimerTask() != null) {
                            request.getTimerTask().cancel();
                        }
                        if (!request.isMatchingReply(reply) && !(reply instanceof ERepError)) {
                            PDTCoreUtils.logString(this, " REQ:" + request.getDescription() + " != REP:" + reply.getDescription(), 2);
                        }
                        request.setReply(reply);
                        reply.setRequest(request);
                        this.queueReplyForProcessing(reply);
                        request._replyReceived = true;
                        request.notify();
                    }
                }
            }
            if (reply.getReplyCode() != 42) continue;
            this.fContinue = false;
        } while (this.fContinue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueReplyForProcessing(EPDC_Reply reply) {
        LinkedList<EPDC_Reply> linkedList = this.fReplyQueue;
        synchronized (linkedList) {
            this.fReplyQueue.add(reply);
            this.fReplyQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EPDC_Reply getReply() throws InterruptedException {
        LinkedList<EPDC_Reply> linkedList = this.fReplyQueue;
        synchronized (linkedList) {
            while (this.fReplyQueue.isEmpty()) {
                this.fReplyQueue.wait();
            }
            EPDC_Reply reply = this.fReplyQueue.removeFirst();
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EPDC_Reply getReply(EPDC_Request request) throws InterruptedException {
        LinkedList<EPDC_Reply> linkedList = this.fReplyQueue;
        synchronized (linkedList) {
            int extractionIndex;
            EPDC_Reply reply = this.fReplyQueue.isEmpty() ? this.getReply() : ((extractionIndex = this.fReplyQueue.indexOf(request.getReply())) < 0 ? null : this.fReplyQueue.remove(extractionIndex));
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequest(EPDC_Request request) {
        LinkedList<EPDC_Request> linkedList = this.fRequestQueue;
        synchronized (linkedList) {
            this.fRequestQueue.add(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EPDC_Request getRequest() {
        LinkedList<EPDC_Request> linkedList = this.fRequestQueue;
        synchronized (linkedList) {
            EPDC_Request request = this.fRequestQueue.isEmpty() ? null : this.fRequestQueue.removeFirst();
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EPDC_Request getCurrentRequest() {
        LinkedList<EPDC_Request> linkedList = this.fRequestQueue;
        synchronized (linkedList) {
            return this.fRequestQueue.isEmpty() ? null : this.fRequestQueue.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAllPendingRequsts() {
        LinkedList<EPDC_Request> linkedList = this.fRequestQueue;
        synchronized (linkedList) {
            for (EPDC_Request request : this.fRequestQueue) {
                this.cancelRequest(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRequest(EPDC_Request request) {
        LinkedList<EPDC_Request> linkedList = this.fRequestQueue;
        synchronized (linkedList) {
            if (!this.fRequestQueue.isEmpty()) {
                if (this.fRequestQueue.removeLast() != request) {
                    PDTCoreUtils.logString(this, "Cancelled request doesn't match last in the queue", 2);
                } else if (request != null) {
                    EPDC_Request ePDC_Request = request;
                    synchronized (ePDC_Request) {
                        if (request.getTimerTask() != null) {
                            request.getTimerTask().cancel();
                        }
                        ERepRequestCancelled reply = new ERepRequestCancelled(this.fEngineSession);
                        request.setReply(reply);
                        reply.setRequest(request);
                        request._replyReceived = true;
                        request.notify();
                    }
                }
            }
        }
    }

    void setConnectionTerminated() {
        this.fConnectionTerminated = true;
    }
}

