/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import java.util.Hashtable;

public abstract class DelimitersBasedIdentifierParser
extends IdentifierParser {
    protected Hashtable<Character, Character> table = new Hashtable();

    public DelimitersBasedIdentifierParser() {
        char[] chars = this.getDelimiters();
        int i = 0;
        while (i < chars.length) {
            this.table.put(Character.valueOf(chars[i]), Character.valueOf(chars[i]));
            ++i;
        }
    }

    public abstract char[] getDelimiters();

    @Override
    public int[] identifierInString(String input, int index) {
        if (input == null || index + 1 > input.length()) {
            return null;
        }
        int[] ans = new int[2];
        int left = 0;
        int right = input.length() - 1;
        char[] buffer = input.toCharArray();
        int i = index;
        while (i >= 0) {
            if (this.table.containsKey(Character.valueOf(buffer[i]))) {
                left = i + 1;
                break;
            }
            --i;
        }
        if (left > index) {
            ans[0] = -1;
            ans[1] = -1;
            return ans;
        }
        i = index + 1;
        while (i < buffer.length) {
            if (this.table.containsKey(Character.valueOf(buffer[i]))) {
                right = i - 1;
                break;
            }
            ++i;
        }
        ans[0] = left;
        ans[1] = right;
        return ans;
    }

    @Override
    public String findIdentifier(String input, int index) {
        int[] pos = this.identifierInString(input, index);
        if (pos == null || pos[0] == -1) {
            return null;
        }
        return input.substring(pos[0], pos[1] + 1);
    }
}

