/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.IDebuggerProfileDeleter;
import com.ibm.debug.pdt.internal.core.model.ModelObjectInputStream;
import com.ibm.debug.pdt.internal.core.model.ModelObjectOutputStream;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class DebuggerPersistentProfile
implements IDebuggerProfileDeleter {
    final int version;
    private boolean fReadComplete;

    DebuggerPersistentProfile(int version) {
        this.version = version;
    }

    protected void read(String profileName) throws IOException, ModelObjectInputStream.VersionException, ClassNotFoundException {
        ModelObjectInputStream mois = new ModelObjectInputStream(new FileInputStream(new File(profileName)), this.version);
        this.readObjects(mois);
        mois.close();
        this.fReadComplete = true;
    }

    boolean isReadComplete() {
        return this.fReadComplete;
    }

    protected abstract void readObjects(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    void write(String profileName) throws IOException {
        ModelObjectOutputStream moos = new ModelObjectOutputStream(new FileOutputStream(this.getProfileFile(profileName)), this.version);
        this.writeObjects(moos);
        moos.close();
    }

    private File getProfileFile(String profileName) throws IOException {
        File file = new File(profileName);
        File parent = file.getParentFile();
        if (!parent.mkdirs()) {
            PDTCoreUtils.logEvent(parent.getName() + " could not be created.", this);
        }
        if (!file.createNewFile()) {
            PDTCoreUtils.logEvent(file.getName() + " could not be created.", this);
        }
        return file;
    }

    protected abstract void writeObjects(ObjectOutputStream var1) throws IOException;

    @Override
    public void deleteAllSavedDebuggerProfiles() {
        File saveDir = new File(PDTCoreUtils.getProfileSaveRestoreLocation());
        PDTCoreUtils.deleteFiles(saveDir);
    }

    public static IDebuggerProfileDeleter getDefaultDeleter() {
        return new DeletionOnly();
    }

    public void setReadComplete(boolean fReadComplete) {
        this.fReadComplete = fReadComplete;
    }

    private static class DeletionOnly
    extends DebuggerPersistentProfile {
        private DeletionOnly() {
            super(0);
        }

        @Override
        protected void readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
        }

        @Override
        protected void writeObjects(ObjectOutputStream out) throws IOException {
        }
    }
}

