/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.EmptyStackFrame;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracer;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracerTarget;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PDTRecorderManager;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.PICLRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.AggregateExprNode;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineBusyException;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionChangedEvent;
import com.ibm.debug.pdt.internal.core.model.ExpressionEmpty;
import com.ibm.debug.pdt.internal.core.model.ExpressionEndedEvent;
import com.ibm.debug.pdt.internal.core.model.GlobalRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.IExpressionEventListener;
import com.ibm.debug.pdt.internal.core.model.IThreadEventListener;
import com.ibm.debug.pdt.internal.core.model.LocalFilter;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.Stack;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.ThreadChangedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPThread;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepGetFile;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextStackEntry;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteExamineException;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteForkFollowBoth;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteForkFollowChild;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteForkFollowParent;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteGo;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteJumpToLocation;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteRunException;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteRunToLocation;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteSkipNext;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteStepDebug;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteStepException;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteStepInto;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteStepOver;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteStepReturn;
import com.ibm.debug.pdt.internal.epdc.EReqExpression;
import com.ibm.debug.pdt.internal.epdc.EReqLocalVariable;
import com.ibm.debug.pdt.internal.epdc.EReqLocalVariableFree;
import com.ibm.debug.pdt.internal.epdc.EReqRegistersFree2;
import com.ibm.debug.pdt.internal.epdc.EReqRemoteHalt;
import com.ibm.debug.pdt.internal.epdc.EReqStack;
import com.ibm.debug.pdt.internal.epdc.EReqThreadFreeze;
import com.ibm.debug.pdt.internal.epdc.EReqThreadThaw;
import com.ibm.debug.pdt.internal.epdc.EStdAttribute;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.osgi.util.NLS;

public class DebuggeeThread
extends DebugModelObject
implements IThread,
IDisconnect,
IStepFilters,
IExpressionEventListener {
    private DebuggeeProcess fProcess;
    private Part fCurrentPart;
    private IPDTDebugTarget fDebugTarget;
    private Stack fStack;
    private Object fStackLock = new Object();
    private boolean fMonitoringStack;
    private PICLRegisterGroup[] fMonRegisterGroups;
    private boolean fStackFrameTopMonitored = false;
    private TreeMap<Integer, ExpressionBase> fStackFrameLocals = new TreeMap();
    private boolean fLocalsChanged = false;
    private Object fLocalMonitorLock = new Object();
    private final ExprNodeBase[] EMPTYLOCALS = new ExprNodeBase[1];
    private final IStackFrame[] EMPTYSTACKFRAMES = new IStackFrame[1];
    private static final PICLRegisterGroup[] EMPTYREGISTERGROUPS = new PICLRegisterGroup[0];
    private Location fCurrentLocation;
    private HashMap<Object, ExpressionBase> fPopupExpression = new HashMap();
    private int fCurrentState;
    private int fPreviousState;
    private boolean fStepping;
    private ECPThread fEpdcThread;
    private boolean fSupportsMonitorAnyLocals;
    private boolean fSupportsStepInto;
    private boolean fSupportsStepOver;
    private boolean fSupportsStepReturn;
    private boolean fSupportsHalt;
    private boolean fSupportsFreezeThaw;
    private boolean fSupportsJumpToLocation;
    private boolean fSupportsRunToLocation;
    private boolean fSupportsStepDebug;
    private boolean fSupportsMonitoringStack;
    private boolean fSupportsExceptionRun;
    private boolean fSupportsExceptionStep;
    private boolean fSupportsExceptionExamine;
    private boolean fSupportsAsyncMode;
    private boolean fSupportsSkipNext;
    private boolean fAlreadyTriedToMonitorStackThisStep;
    private boolean fStopMonitoringLocals;
    private boolean fStopMonitoringRegisters;
    private boolean fStopMonitoringStack;
    private StackFrame fStackFrameMonitored;
    public boolean fStackFramesRequested;

    DebuggeeThread(DebuggeeProcess owningProcess, ECPThread epdcThread) {
        super(owningProcess.getDebugEngine());
        this.fEpdcThread = epdcThread;
        this.fDebugTarget = (IPDTDebugTarget)this.getDebugTarget();
        EPDC_EngineSession engineSession = this.getEngineSession();
        this.fSupportsAsyncMode = engineSession.supportsAsync();
        this.fSupportsHalt = engineSession.supportsHalt();
        this.fSupportsMonitorAnyLocals = engineSession.supportsMonitorAnyLocals();
        this.fSupportsMonitoringStack = engineSession.supportsStack();
        this.fSupportsExceptionRun = engineSession.supportsExceptionRun();
        this.fSupportsExceptionStep = engineSession.supportsExceptionStep();
        this.fSupportsExceptionExamine = engineSession.supportsExceptionExamine();
        this.fSupportsStepInto = engineSession.supportsStepInto();
        this.fSupportsStepOver = engineSession.supportsStepOver();
        this.fSupportsStepReturn = engineSession.supportsStepReturn();
        this.fSupportsFreezeThaw = engineSession.supportsThreadFreezeThaw();
        this.fSupportsJumpToLocation = engineSession.supportsJumpToLocation();
        this.fSupportsRunToLocation = engineSession.supportsRunToLocation();
        this.fSupportsStepDebug = engineSession.supportsStepDebug();
        this.fSupportsSkipNext = engineSession.supportsSkipNext();
        this.EMPTYLOCALS[0] = new ExpressionEmpty(owningProcess, this.getDebugEngine(), this).getRootNode();
        this.EMPTYSTACKFRAMES[0] = new EmptyStackFrame(this, this.getDebugEngine());
        this.fProcess = owningProcess;
        this.fCurrentState = 5;
        this.fStepping = false;
    }

    public void addEventListener(IThreadEventListener eventListener) {
        this.addListener(eventListener);
    }

    public void freeze() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".freeze()");
        }
        if (!this.isDisabled()) {
            EReqThreadFreeze request = new EReqThreadFreeze(this.getId(), this.getEngineSession());
            this.getDebugEngine().processRequest(request);
        }
    }

    public void thaw() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".thaw()");
        }
        if (this.isDisabled()) {
            EReqThreadThaw request = new EReqThreadThaw(this.getId(), this.getEngineSession());
            this.getDebugEngine().processRequest(request);
        }
    }

    void change(ECPThread epdcThread, EPDC_Reply reply) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".change(<thread> " + epdcThread.getId() + ")");
        }
        this.fCurrentLocation = null;
        this.fEpdcThread = epdcThread;
        int newState = !this.getEngineSession().supportsAsync() ? (reply instanceof ERepProcessStop && ((ERepProcessStop)reply).getStopInfo().getReason() == 22 ? 7 : (reply instanceof ERepGetFile && this.fCurrentState == 7 ? 7 : this.getDebugState())) : this.getDebugState();
        boolean stateChanged = this.fCurrentState != newState;
        this.fCurrentState = newState;
        EStdView[] epdcLocation = epdcThread.getStoppingLocations();
        int currentPartID = -1;
        int oldPartID = this.fCurrentPart != null ? this.fCurrentPart.getId() : -1;
        this.fCurrentPart = null;
        int i = 0;
        while (i < epdcLocation.length) {
            if (epdcLocation[i] != null && (currentPartID = epdcLocation[i].getPartID()) != 0) {
                this.fCurrentPart = this.fProcess.getPart(currentPartID);
                break;
            }
            ++i;
        }
        if (this.fStack == null && oldPartID != currentPartID) {
            this.EMPTYSTACKFRAMES[0] = new EmptyStackFrame(this, this.getDebugEngine());
        }
        if (this.fCurrentState == 4 || this.fCurrentState == 6 || this.fCurrentState == 7) {
            if (!this.getEngineSession().supportsAsync() && reply instanceof ERepProcessStop) {
                ProcessStopInfo stopInfo = ((ERepProcessStop)reply).getStopInfo();
                switch (epdcThread.getWhyStop()) {
                    case 19: 
                    case 20: 
                    case 21: {
                        if (!stopInfo.isStoppedByException()) {
                            this.addEvent(new ThreadStoppedEvent(this, this, new ProcessStopInfo(epdcThread)));
                            break;
                        }
                        this.addEvent(new ThreadStoppedEvent(this, this, stopInfo));
                        break;
                    }
                    default: {
                        this.addEvent(new ThreadStoppedEvent(this, this, stopInfo));
                        break;
                    }
                }
            } else {
                ProcessStopInfo stopInfo = new ProcessStopInfo(epdcThread);
                this.addEvent(new ThreadStoppedEvent(this, this, stopInfo));
            }
        } else if (this.fCurrentState == 5) {
            this.addEvent(new ThreadChangedEvent(this, this, stateChanged));
        }
    }

    public EStdAttribute[] getAttributes() {
        if (this.fEpdcThread == null) {
            return new EStdAttribute[0];
        }
        return (EStdAttribute[])this.fEpdcThread.getAttributes().clone();
    }

    public String getRuntimeId() {
        EStdAttribute[] attributes;
        EStdAttribute[] eStdAttributeArray = attributes = this.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            EStdAttribute attr = eStdAttributeArray[n2];
            if (attr.getType() == 8) {
                return attr.getValue();
            }
            ++n2;
        }
        return null;
    }

    public String getSystemState() {
        if (this.fEpdcThread == null) {
            return "";
        }
        return this.fEpdcThread.getSystemState();
    }

    private short getDebugState() {
        if (this.fEpdcThread == null) {
            return 2;
        }
        return this.fEpdcThread.getDebugState();
    }

    public int getId() {
        if (this.fEpdcThread == null) {
            return 0;
        }
        return this.fEpdcThread.getId();
    }

    public Location getLocation() {
        if (this.fCurrentPart == null) {
            return null;
        }
        View currentView = this.fCurrentPart.getCurrentView();
        if (this.fCurrentLocation != null && this.fCurrentLocation.getView() == currentView) {
            return this.fCurrentLocation;
        }
        try {
            this.fCurrentPart.verify();
        }
        catch (EngineRequestException e1) {
            return null;
        }
        EStdView epdcLocation = this.fEpdcThread.getStoppingLocations()[currentView.getId()];
        try {
            this.fCurrentLocation = new Location(this.fProcess, epdcLocation);
            return this.fCurrentLocation;
        }
        catch (LocationConstructionException e) {
            return null;
        }
    }

    EStdView[] getEStdViews() {
        return this.fEpdcThread.getStoppingLocations();
    }

    public void monitorExpression(Location location, String expression) throws EngineRequestException {
        this.fProcess.monitorExpression(location.getEStdView(), this.fEpdcThread.getId(), expression, (byte)-128, (short)0, null, null, null, null);
    }

    public ExpressionBase evaluateExpression(Location location, String expression, int expansionLevel, int maximumNumberOfChildren, boolean delete) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".evaluateExpression(" + expression + ")");
        }
        EStdView epdcLocation = location.getEStdView();
        EStdExpression2 expr = new EStdExpression2(epdcLocation, expression, this.fEpdcThread.getId(), 0, this.getEngineSession());
        String stmtNum = epdcLocation == null ? null : this.getDebugEngine().getStmtNumber(epdcLocation);
        EReqExpression request = new EReqExpression(-128, 2, expr, null, null, null, stmtNum, this.getEngineSession());
        Object key = new Object();
        request.putProperty(new EPDC_Request.EProperty(2, key));
        this.getDebugEngine().processRequest(request);
        ExpressionBase evaluatedExpression = this.getEvaluatedExpression(key);
        if (evaluatedExpression == null) {
            throw new EngineRequestException();
        }
        this.setEvaluatedExpression(evaluatedExpression.getId(), evaluatedExpression);
        this.removeEvaluatedExpression(key);
        ExprNodeBase rootNode = evaluatedExpression.getRootNode();
        if (rootNode instanceof AggregateExprNode && maximumNumberOfChildren > 0) {
            ((AggregateExprNode)rootNode).retrieveNodes(1, maximumNumberOfChildren);
        }
        if (delete) {
            evaluatedExpression.remove();
        }
        return evaluatedExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitoringLocalVariables(StackFrame stackFrame) throws EngineRequestException {
        ERepGetNextStackEntry stkEntry;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".startMonitoringLocalVariables(" + stackFrame.getId() + ")");
        }
        if (stackFrame == this.fStackFrameMonitored) {
            return;
        }
        if (stackFrame.isTopStackFrame() && this.fStackFrameTopMonitored) {
            return;
        }
        if (this.fStackFrameMonitored != null || this.fStackFrameTopMonitored) {
            this.stopMonitoringLocalVariables();
        }
        if (stackFrame.isTopStackFrame()) {
            stkEntry = null;
            this.fStackFrameTopMonitored = true;
            this.fStackFrameMonitored = null;
        } else {
            if (!this.fSupportsMonitorAnyLocals) {
                Object stkEntry2 = null;
                this.fStackFrameTopMonitored = false;
                this.fStackFrameMonitored = null;
                return;
            }
            stkEntry = stackFrame.getEpdcStackEntry();
            this.fStackFrameTopMonitored = false;
            this.fStackFrameMonitored = stackFrame;
        }
        LocalFilter[] filters = this.getDebugEngine().getLocalFilters();
        int numEnabled = 0;
        int i = 0;
        while (i < filters.length) {
            if (filters[i].isEnabled()) {
                ++numEnabled;
            }
            ++i;
        }
        int[] enabledFilters = new int[numEnabled];
        int i2 = 0;
        int j = 0;
        while (i2 < filters.length) {
            if (filters[i2].isEnabled()) {
                enabledFilters[j++] = filters[i2].getId();
            }
            ++i2;
        }
        try {
            this.getDebugEngine().processRequest(new EReqLocalVariable(this.getId(), stkEntry, enabledFilters, this.getEngineSession()));
        }
        catch (EngineRequestException e) {
            TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
            synchronized (treeMap) {
                this.fStackFrameLocals.clear();
            }
            this.fStackFrameTopMonitored = false;
            this.fStackFrameMonitored = null;
            throw e;
        }
    }

    public void stopMonitoringLocalsOnNextStep() {
        this.fStopMonitoringLocals = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoringLocalVariables() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".stopMonitoringLocalVariables()");
        }
        this.fStopMonitoringLocals = false;
        if (this.fStackFrameMonitored == null && !this.fStackFrameTopMonitored) {
            TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
            synchronized (treeMap) {
                this.fStackFrameLocals.clear();
            }
            return;
        }
        try {
            this.getDebugEngine().processRequest(new EReqLocalVariableFree(this.getId(), this.getEngineSession()));
        }
        catch (Throwable throwable) {
            TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
            synchronized (treeMap) {
                this.fStackFrameLocals.clear();
            }
            this.fStackFrameTopMonitored = false;
            this.fStackFrameMonitored = null;
            throw throwable;
        }
        TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
        synchronized (treeMap) {
            this.fStackFrameLocals.clear();
        }
        this.fStackFrameTopMonitored = false;
        this.fStackFrameMonitored = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExprNodeBase[] getLocals(StackFrame stackframe) throws EngineRequestException {
        if (!this.isSuspended()) {
            return this.EMPTYLOCALS;
        }
        Object object = this.fLocalMonitorLock;
        synchronized (object) {
            try {
                this.startMonitoringLocalVariables(stackframe);
            }
            catch (EngineBusyException ebe) {
                return this.EMPTYLOCALS;
            }
            catch (EngineRequestErrorException ere) {
                if (ere.getReturnCode() != 330) {
                    throw ere;
                }
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logError(e);
                return this.EMPTYLOCALS;
            }
            if (this.fStackFrameLocals.isEmpty()) {
                return this.EMPTYLOCALS;
            }
            Object[] exprs = this.EMPTYLOCALS;
            TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
            synchronized (treeMap) {
                exprs = new ExprNodeBase[this.fStackFrameLocals.size()];
                Collection<ExpressionBase> values = this.fStackFrameLocals.values();
                int i = 0;
                for (ExpressionBase element : values) {
                    exprs[i] = element.getRootNode();
                    ++i;
                }
            }
            if (PDTCorePlugin.isSortLocals()) {
                Arrays.sort(exprs);
            }
            return exprs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ExpressionBase localExpression) {
        TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
        synchronized (treeMap) {
            this.fStackFrameLocals.put(localExpression.getId(), localExpression);
        }
        this.fLocalsChanged = true;
        localExpression.addEventListener(this);
        this.addEvent(new ExpressionAddedEvent(this, localExpression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocal(int id) {
        ExpressionBase expr = null;
        TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
        synchronized (treeMap) {
            expr = this.fStackFrameLocals.remove(id);
        }
        if (expr != null) {
            this.fLocalsChanged = true;
            expr.removeListener(this);
        }
    }

    public void handleLocalsChanged() {
        if (!this.fLocalsChanged) {
            return;
        }
        StackFrame monitoredStackFrame = this.getMonitoredStackFrame();
        if (monitoredStackFrame != null) {
            monitoredStackFrame.fireChangeEvent(512);
        }
        this.fLocalsChanged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExpressionBase getLocal(int id) {
        TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
        synchronized (treeMap) {
            return this.fStackFrameLocals.get(id);
        }
    }

    public void runToLocation(Location location) throws EngineRequestException {
        block6: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".runToLocation()");
            }
            this.traceThreadAction((short)6);
            if (!location.isComplete()) {
                throw new EngineRequestException(PICLMessages.picl_engine_request_cannot_use_incomplete_location);
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preResume(false);
                this.preResume();
                this.fireResumeEvent(32);
            } else {
                this.fDebugTarget.preResume(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(32);
            }
            EReqExecuteRunToLocation request = new EReqExecuteRunToLocation(this.getId(), location.getEStdView(), this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.resumeErrorRecovery(e);
                if (ere == null) break block6;
                throw ere;
            }
        }
    }

    public void jumpToLocation(Location location) throws EngineRequestException {
        block6: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".jumpToLocation()");
            }
            this.traceThreadAction((short)7);
            if (!location.isComplete()) {
                throw new EngineRequestException(PICLMessages.picl_engine_request_cannot_use_incomplete_location);
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preStepping(false);
                this.preStepping();
                this.fireResumeEvent(32);
            } else {
                this.fDebugTarget.preStepping(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(32);
            }
            EReqExecuteJumpToLocation request = new EReqExecuteJumpToLocation(this.getId(), location.getEStdView(), this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.stepErrorRecovery(e);
                if (ere == null) break block6;
                throw ere;
            }
        }
    }

    public void stepWithFilters() throws DebugException {
        block6: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".stepDebug()");
            }
            this.traceThreadAction((short)0);
            ViewInformation vi = this.getViewInformation();
            if (vi == null) {
                return;
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preStepping(false);
                this.preStepping();
                this.fireResumeEvent(1);
            } else {
                this.fDebugTarget.preStepping(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(1);
            }
            try {
                EReqExecuteStepDebug request = new EReqExecuteStepDebug(this.getId(), vi.getViewNum(), this.getEngineSession());
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.stepErrorRecovery(e);
                if (ere == null) break block6;
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, ere.getMessage(), (Throwable)ere));
            }
        }
    }

    private void monitorStack() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".monitorStack()");
        }
        if (!this.fSupportsMonitoringStack || this.fMonitoringStack) {
            return;
        }
        if (this.haveDoneCleanup()) {
            return;
        }
        if (this.fAlreadyTriedToMonitorStackThisStep) {
            return;
        }
        if (this.fStack == null) {
            EReqStack request = new EReqStack(this.getId(), this.getEngineSession());
            this.fAlreadyTriedToMonitorStackThisStep = true;
            this.fMonitoringStack = true;
            this.getDebugEngine().processRequest(request);
            this.getDebugEngine().getDefaultColumnIds();
        }
    }

    public void stopMonitoringStackOnNextStep() {
        this.fStopMonitoringStack = true;
    }

    private void stopMonitoringStack() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".releaseStackMonitor()");
        }
        this.fStopMonitoringStack = false;
        if (!this.fSupportsMonitoringStack || !this.fMonitoringStack) {
            return;
        }
        if (this.fStack != null) {
            try {
                this.fStack.freeStack();
            }
            catch (EngineRequestException engineRequestException) {
                // empty catch block
            }
            this.fMonitoringStack = false;
            this.fAlreadyTriedToMonitorStackThisStep = false;
        }
    }

    public DebuggeeProcess getProcess() {
        return this.fProcess;
    }

    public Stack getStack() {
        return this.fStack;
    }

    void add(Stack stack) {
        this.fStack = stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStack() {
        if (this.fStack == null) {
            return;
        }
        Object object = this.fStackLock;
        synchronized (object) {
            this.fStack.doCleanup();
            this.fStack = null;
        }
    }

    PICLRegisterGroup getRegisterGroup(int groupID) {
        if (this.fMonRegisterGroups == null) {
            this.getRegisterGroups();
        }
        int i = 0;
        while (i < this.fMonRegisterGroups.length) {
            if (this.fMonRegisterGroups[i].getId() == groupID) {
                return this.fMonRegisterGroups[i];
            }
            ++i;
        }
        return null;
    }

    public PICLRegisterGroup[] getRegisterGroups() {
        if (this.haveDoneCleanup()) {
            return EMPTYREGISTERGROUPS;
        }
        if (this.fMonRegisterGroups == null) {
            GlobalRegisterGroup[] groups = this.getDebugEngine().getGlobalRegisterGroups();
            this.fMonRegisterGroups = new PICLRegisterGroup[groups.length];
            int i = 0;
            while (i < groups.length) {
                this.fMonRegisterGroups[i] = new PICLRegisterGroup(this, new MonitoredRegisterGroup(this, groups[i], this.getDebugEngine()), this.fDebugTarget);
                ++i;
            }
            Arrays.sort(this.fMonRegisterGroups, new Comparator<PICLRegisterGroup>(){

                @Override
                public int compare(PICLRegisterGroup o1, PICLRegisterGroup o2) {
                    return o1.getId() - o2.getId();
                }
            });
        }
        return Arrays.copyOf(this.fMonRegisterGroups, this.fMonRegisterGroups.length);
    }

    public void stopMonitoringRegistersOnNextStep() {
        this.fStopMonitoringRegisters = true;
    }

    public void stopMonitoringRegisterGroups() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".stopMonitoringRegisterGroups()");
        }
        this.fStopMonitoringRegisters = false;
        if (this.isOneRegisterGroupMonitored()) {
            EReqRegistersFree2 request = new EReqRegistersFree2(this.getId(), 0, this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logError(e);
            }
            PICLRegisterGroup[] pICLRegisterGroupArray = this.fMonRegisterGroups;
            int n = this.fMonRegisterGroups.length;
            int n2 = 0;
            while (n2 < n) {
                PICLRegisterGroup group = pICLRegisterGroupArray[n2];
                group.clearRegisters();
                ++n2;
            }
        }
    }

    private boolean isOneRegisterGroupMonitored() {
        if (this.fMonRegisterGroups == null) {
            return false;
        }
        PICLRegisterGroup[] pICLRegisterGroupArray = this.fMonRegisterGroups;
        int n = this.fMonRegisterGroups.length;
        int n2 = 0;
        while (n2 < n) {
            PICLRegisterGroup group = pICLRegisterGroupArray[n2];
            if (group.hasRetrievedRegisters()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void stepException() throws EngineRequestException {
        block6: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".stepException()");
            }
            this.traceThreadAction((short)8);
            if (!this.fSupportsExceptionStep) {
                return;
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preStepping(false);
                this.preStepping();
                this.fireResumeEvent(1);
            } else {
                this.fDebugTarget.preStepping(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(1);
            }
            try {
                EReqExecuteStepException request = new EReqExecuteStepException(this.getId(), 1, this.getEngineSession());
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.stepErrorRecovery(e);
                if (ere == null) break block6;
                throw ere;
            }
        }
    }

    public void ignoreException() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".ignoreException()");
        }
        this.traceThreadAction((short)9);
        if (!this.fSupportsExceptionExamine) {
            return;
        }
        EReqExecuteExamineException request = new EReqExecuteExamineException(this.getId(), 1, this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    public void executeForkAndFollowChild() throws EngineRequestException {
        block5: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".executeForkAndFollowChild()");
            }
            this.traceFork((short)1);
            int threadID = 0;
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preResume(false);
                this.preResume();
                this.fireResumeEvent(32);
                threadID = this.getId();
            } else {
                this.fDebugTarget.preResume(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(32);
            }
            EReqExecuteForkFollowChild request = new EReqExecuteForkFollowChild(threadID, this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.resumeErrorRecovery(e);
                if (ere == null) break block5;
                throw ere;
            }
        }
    }

    public void executeForkAndFollowParent() throws EngineRequestException {
        block5: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".executeForkAndFollowParent()");
            }
            this.traceFork((short)0);
            int threadID = 0;
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preResume(false);
                this.preResume();
                this.fireResumeEvent(32);
                threadID = this.getId();
            } else {
                this.fDebugTarget.preResume(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(32);
            }
            EReqExecuteForkFollowParent request = new EReqExecuteForkFollowParent(threadID, this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.resumeErrorRecovery(e);
                if (ere == null) break block5;
                throw ere;
            }
        }
    }

    public void executeForkAndFollowBoth() throws EngineRequestException {
        block5: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".executeForkAndFollowBoth()");
            }
            this.traceFork((short)2);
            int threadID = 0;
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preResume(false);
                this.preResume();
                this.fireResumeEvent(32);
                threadID = this.getId();
            } else {
                this.fDebugTarget.preResume(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(32);
            }
            EReqExecuteForkFollowBoth request = new EReqExecuteForkFollowBoth(threadID, this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.resumeErrorRecovery(e);
                if (ere == null) break block5;
                throw ere;
            }
        }
    }

    public int getPriority() {
        return this.fEpdcThread.getPriority();
    }

    @Override
    protected void doCleanupDetails() {
        this.fEpdcThread = null;
        this.fProcess = null;
        this.removeAllEventListeners();
        this.fCurrentPart = null;
        this.fStack = null;
        this.fMonRegisterGroups = null;
        this.fCurrentLocation = null;
        if (this.fPopupExpression != null) {
            this.fPopupExpression.clear();
        }
        this.addEvent(new ThreadEndedEvent(this, this));
        this.fireTerminateEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetChanged() {
        TreeMap<Integer, ExpressionBase> treeMap = this.fStackFrameLocals;
        synchronized (treeMap) {
            Iterator<ExpressionBase> iter = this.fStackFrameLocals.values().iterator();
            while (iter.hasNext()) {
                iter.next().resetChanged();
            }
        }
        if (this.fMonRegisterGroups != null) {
            int i = 0;
            while (i < this.fMonRegisterGroups.length) {
                this.fMonRegisterGroups[i].resetChanged();
                ++i;
            }
        }
    }

    public IBreakpoint[] getBreakpoints() {
        return this.fDebugTarget.getStoppingBreakpoints();
    }

    public String getName() throws DebugException {
        if (this.fEpdcThread == null) {
            return "";
        }
        return this.fEpdcThread.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStackFrame[] getStackFrames() throws DebugException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "getStackFrames()");
        }
        if (this.isTerminated()) {
            return this.EMPTYSTACKFRAMES;
        }
        Object object = this.fStackLock;
        synchronized (object) {
            this.fStackFramesRequested = true;
            if (!this.fMonitoringStack) {
                try {
                    this.monitorStack();
                }
                catch (EngineRequestErrorException ere) {
                    if (ere.getReturnCode() != 325) {
                        throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", ere.getMessage()));
                    }
                }
                catch (EngineRequestException e) {
                    throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", e.getMessage()));
                }
            }
            if (this.fStack == null) {
                return this.EMPTYSTACKFRAMES;
            }
            StackFrame[] frames = this.fStack.getStackFrames();
            IStackFrame[] sortFrames = new IStackFrame[frames.length];
            int i = 0;
            int total = sortFrames.length - 1;
            while (i < sortFrames.length) {
                sortFrames[i] = frames[total - i];
                ++i;
            }
            return sortFrames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStackFrame getTopStackFrame() throws DebugException {
        if (!this.hasStackFrames()) {
            return null;
        }
        Object object = this.fStackLock;
        synchronized (object) {
            if (this.fStack == null) {
                this.getStackFrames();
            }
            StackFrame topStackFrame = null;
            if (this.fStack != null) {
                topStackFrame = this.fStack.getTopStackFrame();
            }
            if (topStackFrame == null) {
                return this.EMPTYSTACKFRAMES[0];
            }
            return topStackFrame;
        }
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended() && !this.haveDoneCleanup();
    }

    public boolean canResume() {
        if (this.fProcess == null) {
            return false;
        }
        if (this.fProcess.isPostMortem()) {
            return false;
        }
        return this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }

    public boolean canSuspend() {
        return this.fSupportsHalt && !this.isSuspended() && !this.isExceptionBeingHandled();
    }

    public boolean isSuspended() {
        return this.fCurrentState == 4 || this.fCurrentState == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        this.traceThreadAction((short)4);
        if (this.fSupportsAsyncMode) {
            this.fDebugTarget.preResume(false);
            this.preResume();
            this.fireResumeEvent(32);
            try {
                this.getDebugEngine().processRequest(new EReqExecuteGo(this.getId(), this.getEngineSession()));
                return;
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.resumeErrorRecovery(e);
                if (ere == null) return;
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, ere.getMessage(), (Throwable)ere));
            }
        } else {
            this.fDebugTarget.resume();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runException() throws EngineRequestException {
        if (!this.fSupportsExceptionRun) {
            return;
        }
        this.traceThreadAction((short)10);
        if (this.fSupportsAsyncMode) {
            this.fDebugTarget.preResume(false);
            this.preResume();
            this.fireResumeEvent(32);
            try {
                this.getDebugEngine().processRequest(new EReqExecuteRunException(this.getId(), 1, this.getEngineSession()));
                return;
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.resumeErrorRecovery(e);
                if (ere == null) return;
                throw ere;
            }
        } else {
            this.fDebugTarget.resume(true);
        }
    }

    public void preResume() {
        if (this.fStopMonitoringLocals) {
            try {
                this.stopMonitoringLocalVariables();
            }
            catch (EngineRequestException e1) {
                PDTCoreUtils.logError(e1);
            }
        }
        if (this.fStopMonitoringRegisters) {
            this.stopMonitoringRegisterGroups();
        }
        if (this.fStackFramesRequested) {
            this.fStackFramesRequested = false;
        } else {
            this.stopMonitoringStack();
        }
        this.fAlreadyTriedToMonitorStackThisStep = false;
        this.resetChanged();
        this.fPreviousState = this.fCurrentState;
        this.fCurrentState = 5;
    }

    public void postResume() {
    }

    public void suspend() throws DebugException {
        this.traceThreadAction((short)5);
        if (this.fSupportsAsyncMode) {
            try {
                int id = this.getId();
                this.getDebugEngine().processImmediateRequest(new EReqRemoteHalt(id, this.getEngineSession()), id);
            }
            catch (EngineRequestException e) {
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), null));
            }
        } else {
            this.fDebugTarget.suspend();
        }
    }

    public boolean canStepInto() {
        return this.fSupportsStepInto && this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }

    public boolean canStepOver() {
        return this.fSupportsStepOver && this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }

    public boolean canStepReturn() {
        return this.fSupportsStepReturn && this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }

    public boolean canStepDebug() {
        return this.fSupportsStepDebug && this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        block7: {
            if (this.fDebugTarget.isStepFiltersEnabled() && this.canStepDebug()) {
                this.stepWithFilters();
                return;
            }
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".stepInto()");
            }
            this.traceThreadAction((short)1);
            ViewInformation vi = this.getViewInformation();
            if (vi == null) {
                return;
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preStepping(false);
                this.preStepping();
                this.fireResumeEvent(1);
            } else {
                this.fDebugTarget.preStepping(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(1);
            }
            try {
                EReqExecuteStepInto request = new EReqExecuteStepInto(this.getId(), vi.getViewNum(), this.getEngineSession());
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.stepErrorRecovery(e);
                if (ere == null) break block7;
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, ere.getMessage(), (Throwable)ere));
            }
        }
    }

    public void stepOver() throws DebugException {
        block6: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".stepOver()");
            }
            this.traceThreadAction((short)2);
            ViewInformation vi = this.getViewInformation();
            if (vi == null) {
                return;
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preStepping(false);
                this.preStepping();
                this.fireResumeEvent(2);
            } else {
                this.fDebugTarget.preStepping(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(2);
            }
            try {
                EReqExecuteStepOver request = new EReqExecuteStepOver(this.getId(), vi.getViewNum(), this.getEngineSession());
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.stepErrorRecovery(e);
                if (ere == null) break block6;
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, ere.getMessage(), (Throwable)ere));
            }
        }
    }

    public void stepReturn() throws DebugException {
        block6: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".stepReturn()");
            }
            this.traceThreadAction((short)3);
            ViewInformation vi = this.getViewInformation();
            if (vi == null) {
                return;
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preStepping(false);
                this.preStepping();
                this.fireResumeEvent(4);
            } else {
                this.fDebugTarget.preStepping(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(4);
            }
            try {
                EReqExecuteStepReturn request = new EReqExecuteStepReturn(this.getId(), vi.getViewNum(), this.getEngineSession());
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.stepErrorRecovery(e);
                if (ere == null) break block6;
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, ere.getMessage(), (Throwable)ere));
            }
        }
    }

    public boolean canTerminate() {
        return this.fDebugTarget.canTerminate();
    }

    public boolean isTerminated() {
        return this.fCurrentState == 2 || this.fCurrentState == 6 || this.haveDoneCleanup();
    }

    public void terminate() throws DebugException {
        this.traceThreadAction((short)11);
        this.fDebugTarget.terminate();
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean canDisconnect() {
        return this.fDebugTarget.canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.fDebugTarget.disconnect();
    }

    public boolean isDisconnected() {
        if (this.fDebugTarget == null) {
            return true;
        }
        return this.fDebugTarget.isDisconnected();
    }

    public boolean isStepFiltersEnabled() {
        return this.fDebugTarget.isStepFiltersEnabled();
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.fDebugTarget.setStepFiltersEnabled(enabled);
    }

    public boolean supportsStepFilters() {
        return this.fSupportsStepDebug && !this.haveDoneCleanup() && this.isSuspended();
    }

    @Override
    public void expressionChanged(ExpressionChangedEvent event) {
        this.fLocalsChanged = true;
    }

    @Override
    public void expressionEnded(ExpressionEndedEvent event) {
        event.getExpression().removeListener(this);
    }

    public void preStepping() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".startStepping()");
        }
        this.fAlreadyTriedToMonitorStackThisStep = false;
        if (this.fStopMonitoringLocals) {
            try {
                this.stopMonitoringLocalVariables();
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logError(e);
            }
        }
        if (this.fStopMonitoringRegisters) {
            this.stopMonitoringRegisterGroups();
        }
        if (this.fStopMonitoringStack) {
            this.stopMonitoringStack();
        }
        this.resetChanged();
        this.fStepping = true;
        this.fPreviousState = this.fCurrentState;
        this.fCurrentState = 5;
    }

    public void postStepping() {
        this.fStepping = false;
    }

    public boolean canEnableDisableThread() {
        return this.fSupportsFreezeThaw && (this.isSuspended() || this.isDisabled()) && !this.isExceptionBeingHandled();
    }

    public boolean canJumpToLocation() {
        return this.fSupportsJumpToLocation && this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }

    public boolean canRunToLocation() {
        return this.fSupportsRunToLocation && this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }

    public boolean isDisabled() {
        return this.fCurrentState == 1;
    }

    @Override
    public String getLabel() {
        if (this.haveDoneCleanup()) {
            return PICLLabels.picl_thread_state_terminated;
        }
        StringBuffer labelString = new StringBuffer();
        String name = "";
        try {
            name = this.getName();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        labelString.append(PICLLabels.picl_thread_label_normal);
        String state = this.getSystemState();
        if (!(state != null && this.fSupportsAsyncMode || this.fCurrentState != 5)) {
            state = PICLLabels.picl_debug_target_state_running;
        }
        labelString.append(NLS.bind((String)PICLLabels.picl_thread_label_addstate, (Object[])new String[]{name, state.trim()}));
        return labelString.toString();
    }

    private StackFrame getMonitoredStackFrame() {
        try {
            return this.fStackFrameTopMonitored ? (StackFrame)this.getTopStackFrame() : this.fStackFrameMonitored;
        }
        catch (DebugException e) {
            PDTCoreUtils.logString(this, ".getStackFrameMonitored(): error getting top stackframe", 2, (Exception)((Object)e));
            return null;
        }
    }

    protected boolean isStoppedByBreakpoint() {
        PDTDebugTarget target = (PDTDebugTarget)this.getParentElement();
        if (target == null || !target.isStoppedByBreakpoint()) {
            return false;
        }
        if (this.fProcess == null) {
            return false;
        }
        ProcessStopInfo stopInfo = this.fProcess.getProcessStopInfo();
        if (stopInfo == null || stopInfo.getReason() != 1) {
            return false;
        }
        DebuggeeThread debuggeeThread = this.fProcess.getStoppingThread();
        if (debuggeeThread == null) {
            return false;
        }
        return debuggeeThread.equals(this);
    }

    private EngineRequestException stepErrorRecovery(EngineRequestException e) {
        if (e instanceof EngineConnectionException) {
            return null;
        }
        if (this.fSupportsAsyncMode) {
            this.fDebugTarget.postStepping();
            this.resetState();
            this.fireSuspendEvent(8);
        } else {
            this.fDebugTarget.postStepping();
            DebuggeeThread[] threads = this.fProcess.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].resetState();
                ++i;
            }
            ((DebugElement)this.fDebugTarget).fireSuspendEvent(0);
            this.fireSuspendEvent(8);
        }
        if (e instanceof EngineBusyException) {
            return null;
        }
        return e;
    }

    public EngineRequestException resumeErrorRecovery(EngineRequestException e) {
        if (e instanceof EngineConnectionException) {
            return null;
        }
        if (this.fSupportsAsyncMode) {
            this.fDebugTarget.postResume();
            this.resetState();
            this.fireSuspendEvent(32);
        } else {
            this.fDebugTarget.postResume();
            DebuggeeThread[] threads = this.fProcess.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].resetState();
                ++i;
            }
            ((DebugElement)this.fDebugTarget).fireSuspendEvent(0);
            this.fireSuspendEvent(32);
        }
        if (e instanceof EngineBusyException) {
            return null;
        }
        return e;
    }

    public void resetState() {
        this.fCurrentState = this.fPreviousState;
        this.fStepping = false;
    }

    void setEvaluatedExpression(Object key, ExpressionBase evaluatedExpression) {
        this.fPopupExpression.put(key, evaluatedExpression);
    }

    ExpressionBase getEvaluatedExpression(Object key) {
        return this.fPopupExpression.get(key);
    }

    void removeEvaluatedExpression(Object key) {
        this.fPopupExpression.remove(key);
    }

    private ViewInformation getViewInformation() {
        try {
            return this.getLocation().getView().getViewInformation();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public boolean isMonitoringStack() {
        return this.fMonitoringStack;
    }

    public void traceThreadAction(short actionType) {
        try {
            if (this.fDebugTarget instanceof IPDTDebugTracerTarget) {
                IPDTDebugTracer[] tracerClasses;
                IPDTDebugTracer[] iPDTDebugTracerArray = tracerClasses = ((IPDTDebugTracerTarget)((Object)this.fDebugTarget)).getDebugTracers();
                int n = tracerClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDTDebugTracer tracerClass = iPDTDebugTracerArray[n2];
                    tracerClass.traceThreadAction(this, actionType);
                    ++n2;
                }
            }
            if (PDTCorePlugin.getInstance().isRecordDebugActions()) {
                PDTRecorderManager.getInstance().recordDebugAction((IDebugElement)this, actionType);
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public void traceFork(short actionType) {
        try {
            if (this.fDebugTarget instanceof IPDTDebugTracerTarget) {
                IPDTDebugTracer[] tracerClasses;
                IPDTDebugTracer[] iPDTDebugTracerArray = tracerClasses = ((IPDTDebugTracerTarget)((Object)this.fDebugTarget)).getDebugTracers();
                int n = tracerClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDTDebugTracer tracerClass = iPDTDebugTracerArray[n2];
                    tracerClass.traceFork(this, actionType);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    private boolean isExceptionBeingHandled() {
        return this.getDebugTarget() instanceof PDTDebugTarget && ((PDTDebugTarget)this.getDebugTarget()).isExceptionBeingHandled();
    }

    public void stepSkipNext() throws DebugException, EngineRequestUnsupportedException {
        block7: {
            if (!this.getEngineSession().supportsSkipNext()) {
                throw new EngineRequestUnsupportedException();
            }
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".stepSkipNext()");
            }
            this.traceThreadAction((short)12);
            ViewInformation vi = this.getViewInformation();
            if (vi == null) {
                return;
            }
            if (this.fSupportsAsyncMode) {
                this.fDebugTarget.preStepping(false);
                this.preStepping();
                this.fireResumeEvent(2);
            } else {
                this.fDebugTarget.preStepping(true);
                ((DebugElement)this.fDebugTarget).fireResumeEvent(2);
            }
            try {
                EReqExecuteSkipNext request = new EReqExecuteSkipNext(this.getId(), vi.getViewNum(), this.getEngineSession());
                this.getDebugEngine().processRequest(request);
            }
            catch (EngineRequestException e) {
                EngineRequestException ere = this.stepErrorRecovery(e);
                if (ere == null) break block7;
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, ere.getMessage(), (Throwable)ere));
            }
        }
    }

    public boolean canSkipNext() {
        return this.fSupportsSkipNext && this.isSuspended() && !this.isDisabled() && !this.isExceptionBeingHandled();
    }
}

