/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.saverestore.IPersister;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracer;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracerTarget;
import com.ibm.debug.pdt.internal.core.IPDTLabelProvider;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.PICLStreamsProxy;
import com.ibm.debug.pdt.internal.core.model.Address;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.BreakpointAddedEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.DebuggerPersistentProfile;
import com.ibm.debug.pdt.internal.core.model.EReqBreakpointModuleLoadRunToEntry;
import com.ibm.debug.pdt.internal.core.model.EngineBusyException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.ExpressionAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Memory;
import com.ibm.debug.pdt.internal.core.model.MemoryException;
import com.ibm.debug.pdt.internal.core.model.ModelObjectInputStream;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.ModuleAddedEvent;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ProcessCCEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessDetachedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmError;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmOutput;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessTraceEvent;
import com.ibm.debug.pdt.internal.core.model.ProgramProfile2;
import com.ibm.debug.pdt.internal.core.model.Storage;
import com.ibm.debug.pdt.internal.core.model.ThreadAddedEvent;
import com.ibm.debug.pdt.internal.core.util.DebuggerProfileMigrator;
import com.ibm.debug.pdt.internal.core.util.EntryListItem;
import com.ibm.debug.pdt.internal.core.util.FileListItem;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepEntryGetNext;
import com.ibm.debug.pdt.internal.epdc.ERepEntrySearch;
import com.ibm.debug.pdt.internal.epdc.ERepGetList;
import com.ibm.debug.pdt.internal.epdc.ERepGetListItem;
import com.ibm.debug.pdt.internal.epdc.ERepStorageConvertToAddress;
import com.ibm.debug.pdt.internal.epdc.ERepStorageGetBlock;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointAddress;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointAddressRange;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointClear;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEnhancedWatchpoint;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEntry;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEvent;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLine;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointMacro;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointModuleLoad;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointOccurrence;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointWatchpoint;
import com.ibm.debug.pdt.internal.epdc.EReqEntrySearch;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteGo;
import com.ibm.debug.pdt.internal.epdc.EReqExecuteRunException;
import com.ibm.debug.pdt.internal.epdc.EReqExpression;
import com.ibm.debug.pdt.internal.epdc.EReqGetList;
import com.ibm.debug.pdt.internal.epdc.EReqProcessDetach;
import com.ibm.debug.pdt.internal.epdc.EReqProgramInput;
import com.ibm.debug.pdt.internal.epdc.EReqRemoteHalt;
import com.ibm.debug.pdt.internal.epdc.EReqStartPgm;
import com.ibm.debug.pdt.internal.epdc.EReqStorage2;
import com.ibm.debug.pdt.internal.epdc.EReqStorageConvertToAddress;
import com.ibm.debug.pdt.internal.epdc.EReqStorageGetBlock;
import com.ibm.debug.pdt.internal.epdc.EReqStoragePutBlock;
import com.ibm.debug.pdt.internal.epdc.EReqStorageUpdate;
import com.ibm.debug.pdt.internal.epdc.EReqStorageUsageCheckSet;
import com.ibm.debug.pdt.internal.epdc.EReqTerminatePgm;
import com.ibm.debug.pdt.internal.epdc.EReqZeroAddressBreapoint;
import com.ibm.debug.pdt.internal.epdc.EStdEnhancedWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdModuleLoadData;
import com.ibm.debug.pdt.internal.epdc.EStdOccurrenceBPData;
import com.ibm.debug.pdt.internal.epdc.EStdStorageSegment;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.EStdWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdZeroAddressBPData;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.osgi.util.NLS;

public class DebuggeeProcess
extends DebugModelObject
implements IProcess {
    private int _replyCode;
    private String _processID;
    private String _qualifiedName;
    private String _profileName;
    private String _timeStamp;
    private String _dateStamp;
    private TreeMap<Integer, Module> fModules = new TreeMap();
    private TreeMap<Integer, Part> fParts = new TreeMap();
    private TreeMap<Integer, DebuggeeThread> fThreads = new TreeMap();
    private boolean _hasBeenRunToMainEntryPoint = false;
    private ProcessStopInfo _processStopInfo;
    protected TreeMap<Integer, ExpressionBase> fMonitoredExpressions = new TreeMap();
    protected TreeMap<Integer, Breakpoint> fBreakpoints = new TreeMap();
    private Storage _storage;
    private TreeMap<Integer, Function> fFunctions = new TreeMap();
    private boolean _isPostMortem = false;
    private byte _bigEndian = 0;
    private boolean _heapCheckEnabled = false;
    private Hashtable<String, Memory> fMemoryCache = new Hashtable();
    private PICLStreamsProxy fStreamsProxy = null;
    private TreeSet<EntryListItem> fFunctionListNonDbg = new TreeSet();
    private TreeSet<EntryListItem> fFunctionListDbg = new TreeSet();
    private TreeSet<FileListItem> fFileListDbg = new TreeSet();
    private boolean fDetached = false;
    private IPDTLabelProvider fLabelProvider;
    private Properties fAttributes = new Properties();
    private static final byte BIGENDIAN = 1;
    private static final byte LITTLEENDIAN = 2;
    private static final ExpressionBase[] EMPTYEXPRESSIONS = new ExpressionBase[0];
    private static final Breakpoint[] EMPTYBREAKPOINTS = new Breakpoint[0];
    private static final Module[] EMPTYMODULES = new Module[0];
    private static final Function[] EMPTYFUNCTIONS = new Function[0];
    static final int BREAKPOINTS_HAVE_CHANGED = 0x20000000;
    static final int PROGRAM_MONITORS_HAVE_CHANGED = 0x10000000;
    static final int STORAGE_MONITORS_HAVE_CHANGED = 0x4000000;
    public static final int MEMOP_OK = 0;
    public static final int MEMOP_ERROR = 1;
    private static final int PRE_PDT_SPLIT_PROFILE_VERSION = 20060529;
    private static final int TPF344GA_PROFILE_VERSION = 20060529;

    DebuggeeProcess(DebugEngine debugEngine, int replyCode, String processID, String qualifiedName, String profileName, String timeStamp, String dateStamp) {
        super(debugEngine);
        this._replyCode = replyCode;
        this._processID = processID;
        this._timeStamp = timeStamp;
        this._dateStamp = dateStamp;
        this._qualifiedName = qualifiedName;
        this._profileName = profileName;
        this.fStreamsProxy = new PICLStreamsProxy(this);
        this.addEventListener(this.fStreamsProxy);
        this.initProcessAttributes();
    }

    public void addEventListener(IProcessEventListener eventListener) {
        this.addListener(eventListener);
    }

    private void initProcessAttributes() {
        this.fAttributes.put(IProcess.ATTR_PROCESS_LABEL, this.getLabel());
        if (this.getEngineSession().isiSeriesEngine()) {
            if (this._processID != null) {
                StringTokenizer st = new StringTokenizer(this._processID, "/");
                try {
                    if (st.countTokens() == 3) {
                        String jobNumber = st.nextToken();
                        String jobUser = st.nextToken();
                        String jobName = st.nextToken();
                        this.fAttributes.put("iseries_jobName", jobName);
                        this.fAttributes.put("iseries_jobNumber", jobNumber);
                        this.fAttributes.put("iseries_jobUser", jobUser);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
            try {
                this.fAttributes.put("iseries_connectionName", config.getAttribute("com.ibm.etools.systems.as400.debug.ui.connection.connectionName.", ""));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public String getProcessID() {
        return this._processID;
    }

    public void setProcessID(String id) {
        this._processID = id;
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    public void setQualifiedName(String name) {
        this._qualifiedName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module[] getModules(boolean hasDebugInfo) {
        TreeMap<Integer, Module> treeMap = this.fModules;
        synchronized (treeMap) {
            if (this.fModules.isEmpty()) {
                return EMPTYMODULES;
            }
            Collection<Module> modules = this.fModules.values();
            ArrayList<Module> returnList = new ArrayList<Module>(this.fModules.size());
            for (Module element : modules) {
                if (element == null) continue;
                if (hasDebugInfo) {
                    if (!element.hasDebugInfo()) continue;
                    returnList.add(element);
                    continue;
                }
                returnList.add(element);
            }
            return returnList.toArray(new Module[returnList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breakpoint[] getBreakpoints() {
        TreeMap<Integer, Breakpoint> treeMap = this.fBreakpoints;
        synchronized (treeMap) {
            if (this.fBreakpoints.isEmpty()) {
                return EMPTYBREAKPOINTS;
            }
            Collection<Breakpoint> values = this.fBreakpoints.values();
            return values.toArray(new Breakpoint[this.fBreakpoints.size()]);
        }
    }

    public EPDC_Reply programInput(String inputText) throws EngineRequestException {
        return this.getDebugEngine().processRequest(new EReqProgramInput(inputText, this.getEngineSession()));
    }

    public void halt() throws EngineRequestException {
        this.getDebugEngine().processImmediateRequest(new EReqRemoteHalt(0, this.getEngineSession()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggeeThread[] getThreads() {
        TreeMap<Integer, DebuggeeThread> treeMap = this.fThreads;
        synchronized (treeMap) {
            Collection<DebuggeeThread> values = this.fThreads.values();
            return values.toArray(new DebuggeeThread[this.fThreads.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionBase[] getMonitoredExpressions() {
        TreeMap<Integer, ExpressionBase> treeMap = this.fMonitoredExpressions;
        synchronized (treeMap) {
            if (this.fMonitoredExpressions.isEmpty()) {
                return EMPTYEXPRESSIONS;
            }
            Collection<ExpressionBase> values = this.fMonitoredExpressions.values();
            return values.toArray(new ExpressionBase[this.fMonitoredExpressions.size()]);
        }
    }

    @Deprecated
    protected Storage getStorage() {
        return this._storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggeeThread getThread(int threadID) {
        TreeMap<Integer, DebuggeeThread> treeMap = this.fThreads;
        synchronized (treeMap) {
            return this.fThreads.get(threadID);
        }
    }

    public void runToMainEntryPoint() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".runToMainEntryPoint()");
        }
        if (this._hasBeenRunToMainEntryPoint) {
            return;
        }
        this.getDebugEngine().processRequest(new EReqStartPgm(this.getEngineSession()));
        this._hasBeenRunToMainEntryPoint = true;
    }

    public void resetRunToMainEntryPoint() {
        this._hasBeenRunToMainEntryPoint = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Module module) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(<module> " + module.getName() + ")");
        }
        TreeMap<Integer, Module> treeMap = this.fModules;
        synchronized (treeMap) {
            this.fModules.put(module.getId(), module);
        }
        this.addEvent(new ModuleAddedEvent(this, module));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Breakpoint breakpoint) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(<breakpoint> (" + breakpoint.getId() + "))");
        }
        TreeMap<Integer, Breakpoint> treeMap = this.fBreakpoints;
        synchronized (treeMap) {
            this.fBreakpoints.put(breakpoint.getId(), breakpoint);
        }
        this.addEvent(new BreakpointAddedEvent(this, breakpoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(Part part) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".delete(<part> (" + part.getId() + "))");
        }
        TreeMap<Integer, Part> treeMap = this.fParts;
        synchronized (treeMap) {
            this.fParts.remove(part.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Part part) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(<part> " + part.getName() + "(" + part.getId() + "))");
        }
        TreeMap<Integer, Part> treeMap = this.fParts;
        synchronized (treeMap) {
            this.fParts.put(part.getId(), part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(DebuggeeThread debuggeeThread) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(<thread> " + debuggeeThread.getId() + ")");
        }
        TreeMap<Integer, DebuggeeThread> treeMap = this.fThreads;
        synchronized (treeMap) {
            this.fThreads.put(debuggeeThread.getId(), debuggeeThread);
        }
        this.addEvent(new ThreadAddedEvent(this, debuggeeThread));
        debuggeeThread.fireCreationEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasThreads() {
        TreeMap<Integer, DebuggeeThread> treeMap = this.fThreads;
        synchronized (treeMap) {
            return !this.fThreads.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ExpressionBase monitor) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(<monitor> " + monitor.getId() + ")");
        }
        try {
            if (this.getDebugTarget() instanceof IPDTDebugTracerTarget) {
                IPDTDebugTracer[] tracerClasses;
                IPDTDebugTracer[] iPDTDebugTracerArray = tracerClasses = ((IPDTDebugTracerTarget)this.getDebugTarget()).getDebugTracers();
                int n = tracerClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDTDebugTracer tracerClass = iPDTDebugTracerArray[n2];
                    tracerClass.traceUserAction(monitor, (short)1, null);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
        TreeMap<Integer, ExpressionBase> treeMap = this.fMonitoredExpressions;
        synchronized (treeMap) {
            this.fMonitoredExpressions.put(monitor.getId(), monitor);
        }
        this.addEvent(new ExpressionAddedEvent(this, monitor));
    }

    @Deprecated
    void add(Storage storage) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(<storage> " + storage.getId() + ")");
        }
        this._storage = storage;
    }

    void programOutput(String[] lines) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".programOutput()");
        }
        ProcessPgmOutput event = new ProcessPgmOutput(this, this, lines);
        this.addEvent(event);
    }

    void programError(String[] lines) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".programError()");
        }
        ProcessPgmError event = new ProcessPgmError(this, this, lines);
        this.addEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DebuggeeThread debuggeeThread) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".remove(<thread> " + debuggeeThread.getId() + ")");
        }
        TreeMap<Integer, DebuggeeThread> treeMap = this.fThreads;
        synchronized (treeMap) {
            this.fThreads.remove(debuggeeThread.getId());
        }
        debuggeeThread.doCleanup();
    }

    @Deprecated
    void removeStorage() {
        this._storage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeModule(int moduleID) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".removeModule(" + moduleID + ")");
        }
        TreeMap<Integer, Module> treeMap = this.fModules;
        synchronized (treeMap) {
            Module module = this.getModule(moduleID);
            if (module == null) {
                return;
            }
            Part[] parts = module.getParts();
            int i = 0;
            while (i < parts.length) {
                module.delete(parts[i]);
                ++i;
            }
            module.prepareToDie();
            this.fModules.remove(moduleID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoint(int breakpointID) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".removeBreakpoint(" + breakpointID + ")");
        }
        TreeMap<Integer, Breakpoint> treeMap = this.fBreakpoints;
        synchronized (treeMap) {
            Breakpoint breakpoint = this.getBreakpoint(breakpointID);
            if (breakpoint != null) {
                breakpoint.prepareToDie();
                this.fBreakpoints.remove(breakpointID);
            }
        }
    }

    public void removeBreakpoint(Breakpoint bkp) {
        this.removeBreakpoint(bkp.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitoredExpression(int id) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".removeMonitoredExpression(" + id + ")");
        }
        TreeMap<Integer, ExpressionBase> treeMap = this.fMonitoredExpressions;
        synchronized (treeMap) {
            ExpressionBase expr = this.getMonitoredExpression(id);
            if (expr == null) {
                return;
            }
            expr.prepareToDie();
            this.fMonitoredExpressions.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Module getModule(int id) {
        TreeMap<Integer, Module> treeMap = this.fModules;
        synchronized (treeMap) {
            return this.fModules.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breakpoint getBreakpoint(int id) {
        TreeMap<Integer, Breakpoint> treeMap = this.fBreakpoints;
        synchronized (treeMap) {
            return this.fBreakpoints.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Part getPart(int id) {
        TreeMap<Integer, Part> treeMap = this.fParts;
        synchronized (treeMap) {
            return this.fParts.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Part[] getParts() {
        TreeMap<Integer, Part> treeMap = this.fParts;
        synchronized (treeMap) {
            Collection<Part> values = this.fParts.values();
            return values.toArray(new Part[this.fParts.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExpressionBase getMonitoredExpression(int id) {
        TreeMap<Integer, ExpressionBase> treeMap = this.fMonitoredExpressions;
        synchronized (treeMap) {
            return this.fMonitoredExpressions.get(id);
        }
    }

    void hasStopped(ProcessStopInfo stopInfo) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".hasStopped()");
        }
        this.addEvent(new ProcessStoppedEvent(this, stopInfo, this));
    }

    public void setEnded() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".hasEnded()");
        }
        this.getDebugEngine().setProgramTerminating();
        if (this.haveDoneCleanup()) {
            return;
        }
        ((IPDTDebugTarget)this.getDebugTarget()).saveToProfile();
        this.addEvent(new ProcessEndedEvent(this, this));
        this.doCleanup();
    }

    void hasDetached() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".hasDetached()");
        }
        this.getDebugEngine().setProgramTerminating();
        if (this.haveDoneCleanup()) {
            return;
        }
        ((IPDTDebugTarget)this.getDebugTarget()).saveToProfile();
        this.fDetached = true;
        this.addEvent(new ProcessDetachedEvent(this, this));
        this.doCleanup();
    }

    public ProcessStopInfo getProcessStopInfo() {
        return this._processStopInfo;
    }

    public void setProcessStopInfo(ProcessStopInfo stopInfo) {
        this._processStopInfo = stopInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggeeThread getStoppingThread() {
        if (this.getProcessStopInfo() != null) {
            DebuggeeThread stoppingThread = this.getThread(this.getProcessStopInfo().getStoppingThreadId());
            if (stoppingThread != null) {
                return stoppingThread;
            }
            TreeMap<Integer, DebuggeeThread> treeMap = this.fThreads;
            synchronized (treeMap) {
                if (this.fThreads.size() > 0) {
                    return this.getThreads()[0];
                }
            }
        }
        return null;
    }

    public void run(boolean exception) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".run()");
        }
        if (exception) {
            this.getDebugEngine().processRequest(new EReqExecuteRunException(0, 1, this.getEngineSession()));
        } else {
            this.getDebugEngine().processRequest(new EReqExecuteGo(0, this.getEngineSession()));
        }
    }

    public void removeAllBreakpoints() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".removeAllBreakpoints()");
        }
        this.getDebugEngine().processRequest(new EReqBreakpointClear(0, this.getEngineSession()));
    }

    public void terminate(byte terminateType) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".terminate()");
        }
        this.getDebugEngine().processRequest(new EReqTerminatePgm(terminateType, this.getEngineSession()));
    }

    public void detach(int detachAction) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".detach()");
        }
        this.getDebugEngine().processRequest(new EReqProcessDetach(this._processID, detachAction, this.getEngineSession()));
    }

    public Address convertToAddress(String expression, Location evaluationContext, DebuggeeThread evaluationThread) throws MemoryException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "convertToAddress(" + expression + ")");
        }
        if (!this.getEngineSession().supportsEnhancedStorage()) {
            throw new MemoryException(PICLMessages.picl_memory_error_enhanced_not_supported);
        }
        EStdExpression2 epdcExpression = new EStdExpression2(evaluationContext == null ? null : evaluationContext.getEStdView(), expression, evaluationThread == null ? 0 : evaluationThread.getId(), 0, this.getEngineSession());
        EReqStorageConvertToAddress request = new EReqStorageConvertToAddress(epdcExpression, this.getEngineSession());
        ERepStorageConvertToAddress reply = (ERepStorageConvertToAddress)this.processMemoryRequest(request);
        this._bigEndian = (byte)(reply.isBigEndian() ? 1 : 2);
        return new Address(reply.getAddress(), reply.getAddressSize());
    }

    public boolean isBigEndian() {
        if (this._bigEndian == 0) {
            try {
                this.convertToAddress("0", null, null);
            }
            catch (MemoryException me) {
                this._bigEndian = this.getEngineSession().isIntel() ? (byte)2 : (byte)1;
            }
        }
        return this._bigEndian == 1;
    }

    @Deprecated
    public Memory getMemory(String addressExpression, int numBytesToGet, Location evaluationContext, DebuggeeThread evaluationThread, int offset) throws MemoryException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getMemory() <deprecated>");
        }
        if (!this.getEngineSession().supportsStorage()) {
            return null;
        }
        if (numBytesToGet == 0 || evaluationContext == null || evaluationThread == null) {
            return null;
        }
        EStdExpression2 epdcExpression = null;
        if (addressExpression != null) {
            epdcExpression = new EStdExpression2(evaluationContext.getEStdView(), addressExpression, evaluationThread.getId(), 0, this.getEngineSession());
        }
        int offsetToFirstLine = offset;
        int offsetToLastLine = numBytesToGet + offset - 1;
        int numUnitsPerLine = 1;
        EReqStorage2 request = new EReqStorage2(epdcExpression, offsetToFirstLine, offsetToLastLine, 1, numUnitsPerLine, true, true, this.getEngineSession());
        this.processMemoryRequest(request);
        Storage storage = this.getStorage();
        Memory mem = new Memory(storage, this.isBigEndian(), numBytesToGet);
        try {
            storage.remove();
            return mem;
        }
        catch (EngineRequestException e1) {
            return null;
        }
    }

    public Memory getMemory(String address, int numBytesToGet) throws MemoryException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getMemory(" + address + ")");
        }
        if (address == null || address.length() == 0 || numBytesToGet == 0) {
            throw new MemoryException(PICLMessages.picl_memory_error_invalid_address);
        }
        if (!this.getEngineSession().supportsEnhancedStorage()) {
            throw new MemoryException(PICLMessages.picl_memory_error_enhanced_not_supported);
        }
        Memory cachedMemory = this.getMemoryFromCache(address, numBytesToGet);
        if (cachedMemory != null) {
            return cachedMemory;
        }
        EReqStorageGetBlock request = new EReqStorageGetBlock(address, numBytesToGet, this.getEngineSession());
        ERepStorageGetBlock reply = (ERepStorageGetBlock)this.processMemoryRequest(request);
        EStdStorageSegment[] segments = reply.getStorageSegments();
        Memory memory = new Memory(segments, this.isBigEndian(), numBytesToGet);
        this.addMemoryCache(memory, address);
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemoryCache(Memory memory, String addr) {
        Hashtable<String, Memory> hashtable = this.fMemoryCache;
        synchronized (hashtable) {
            this.fMemoryCache.put(addr, memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memory getMemoryFromCache(String addr, int numBytes) {
        Memory found;
        Hashtable<String, Memory> hashtable = this.fMemoryCache;
        synchronized (hashtable) {
            found = this.fMemoryCache.get(addr);
        }
        if (found != null && found.getNumBytes() >= numBytes) {
            if (found.getNumBytes() == numBytes) {
                return found;
            }
            MemoryByte[] memBytes = found.getMemory();
            MemoryByte[] requestedBytes = new MemoryByte[numBytes];
            System.arraycopy(memBytes, 0, requestedBytes, 0, numBytes);
            return new Memory(requestedBytes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMemoryCache() {
        Hashtable<String, Memory> hashtable = this.fMemoryCache;
        synchronized (hashtable) {
            this.fMemoryCache.clear();
        }
    }

    @Deprecated
    public void putMemory(String address, Memory newContents, String expression) throws MemoryException {
        int offsetToLastLine;
        int numUnitsPerLine;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".putMemory() <deprecated>");
        }
        if (!this.getEngineSession().supportsStorage()) {
            throw new MemoryException(PICLMessages.picl_memory_error_not_supported);
        }
        if (address == null || address.length() == 0 || newContents == null || newContents.getNumBytes() == 0) {
            throw new MemoryException(PICLMessages.picl_memory_error_invalid_memory_operation);
        }
        int MAXBYTESTOSEND = 8;
        DebuggeeThread stoppingThread = this.getStoppingThread();
        Location loc = stoppingThread.getLocation();
        if (loc == null) {
            throw new MemoryException(PICLMessages.picl_memory_error_invalid_location);
        }
        String tmpAddr = this.getEngineSession().isiSeriesEngine() ? expression : address;
        EStdExpression2 epdcExpression = new EStdExpression2(loc.getEStdView(), tmpAddr, stoppingThread.getId(), 0, this.getEngineSession());
        int numBytesToProcess = newContents.getNumBytes();
        int offsetToFirstLine = 0;
        if (numBytesToProcess <= 8) {
            numUnitsPerLine = numBytesToProcess;
            offsetToLastLine = 0;
        } else {
            numUnitsPerLine = 8;
            offsetToLastLine = numBytesToProcess / numUnitsPerLine;
        }
        EReqStorage2 request = new EReqStorage2(epdcExpression, offsetToFirstLine, offsetToLastLine, 1, numUnitsPerLine, true, true, this.getEngineSession());
        try {
            this.getDebugEngine().processRequest(request);
        }
        catch (EngineRequestErrorException ere) {
            throw new MemoryException(ere.getMessage());
        }
        catch (EngineBusyException eb) {
            throw new MemoryException(NLS.bind((String)PICLMessages.CRRDG3061W, (Object)request.toString()));
        }
        catch (EngineRequestException e) {
            throw new MemoryException(PICLMessages.picl_memory_error_unable_to_retrieve_memory);
        }
        Storage storage = this.getStorage();
        if (storage == null) {
            throw new MemoryException(PICLMessages.picl_memory_error_unable_to_retrieve_memory);
        }
        byte[] bytes = newContents.getRawMemory();
        StringBuffer newValue = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int b = bytes[i];
            int v = b >= 0 ? b : 256 + b;
            if (v < 16 && v >= 0) {
                newValue.append("0" + Integer.toString(v, 16));
            } else {
                newValue.append(Integer.toString(v, 16));
            }
            ++i;
        }
        int numPackets = numBytesToProcess / 8;
        if (numBytesToProcess % 8 != 0) {
            ++numPackets;
        }
        int numBytesLeftToUpdate = numBytesToProcess;
        boolean success = false;
        String errorMsg = null;
        int packet = 1;
        while (packet <= numPackets) {
            int numBytesInPacket = Math.min(numBytesLeftToUpdate, 8);
            numBytesLeftToUpdate -= numBytesInPacket;
            int startPosn = (packet - 1) * 8 * 2;
            String updateString = newValue.substring(startPosn, startPosn + numBytesInPacket * 2);
            EReqStorageUpdate req = new EReqStorageUpdate(storage.getId(), address, packet - 1, 0, 1, numBytesInPacket, updateString, this.getEngineSession());
            try {
                this.getDebugEngine().processRequest(req);
                success = true;
            }
            catch (EngineRequestErrorException ere) {
                errorMsg = ere.isEngineMessage() ? ere.getMessage() : PICLMessages.picl_memory_error_unable_to_write_memory;
                success = false;
            }
            catch (EngineRequestException e1) {
                success = false;
            }
            if (!success) break;
            ++packet;
        }
        try {
            storage.remove();
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        if (!success) {
            throw new MemoryException(errorMsg);
        }
    }

    public void putMemory(String address, byte[] bytes) throws MemoryException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".putMemory(" + address + ")");
        }
        if (address == null || address.length() == 0) {
            throw new MemoryException(PICLMessages.picl_memory_error_invalid_address);
        }
        if (!this.getEngineSession().supportsEnhancedStorage()) {
            throw new MemoryException(PICLMessages.picl_memory_error_enhanced_not_supported);
        }
        EReqStoragePutBlock request = new EReqStoragePutBlock(address, bytes, this.getEngineSession());
        this.processMemoryRequest(request);
    }

    public void setAddressBreakpoint(boolean enable, String addrOrExpr, Location conditionLocation, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        this.setAddressBreakpoint(enable, addrOrExpr, conditionLocation, optBpData, property, false);
    }

    public void setAddressBreakpoint(boolean enable, String addrOrExpr, Location conditionLocation, OptionalBreakpointData optBpData, EPDC_Request.EProperty property, boolean isRange) throws EngineRequestException {
        EReqBreakpointLocation request = this.createAddressBreakpointRequest(enable, addrOrExpr, conditionLocation, optBpData, isRange);
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public EReqBreakpointLocation createAddressBreakpointRequest(boolean enable, String addrOrExpr, Location conditionLocation, OptionalBreakpointData optBpData) throws EngineRequestException {
        return this.createAddressBreakpointRequest(enable, addrOrExpr, conditionLocation, optBpData, false);
    }

    public EReqBreakpointLocation createAddressBreakpointRequest(boolean enable, String addrOrExpr, Location conditionLocation, OptionalBreakpointData optBpData, boolean isRange) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, (isRange ? ".setAddressRangeBreakpoint(" : ".setAddressBreakpoint(") + addrOrExpr + ")");
        }
        if (!this.getEngineSession().supportsAddressBreakpoints()) {
            throw new EngineRequestUnsupportedException();
        }
        short attributes = enable ? (short)Short.MIN_VALUE : 0;
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        EEveryClause clause = optBpData.getEEveryClause();
        EStdExpression2 conditionalExpr = optBpData.getEStdExpression2(null, this.getEngineSession());
        EStdView context = null;
        if (conditionLocation != null && conditionLocation.isComplete()) {
            context = conditionLocation.getEStdView();
        }
        int threadId = optBpData.getThreadId(this);
        if (isRange) {
            return new EReqBreakpointAddressRange(attributes, clause, addrOrExpr, null, null, null, conditionalExpr, threadId, context, optBpData.getBreakpointAction(), this.getEngineSession());
        }
        return new EReqBreakpointAddress(attributes, clause, addrOrExpr, null, null, null, conditionalExpr, threadId, context, optBpData.getBreakpointAction(), this.getEngineSession());
    }

    public void setWatchpoint(boolean deferred, boolean enable, String addrOrExpr, int byteCount, OptionalBreakpointData optBpData, EPDC_Request.EProperty property, EStdView esv, String bkpFileName, String bkpModuleName, String bkpPartName, String bkpRestoreAddress) throws EngineRequestException {
        if (!this.getEngineSession().supportsChangeAddrBreakpoints() || !optBpData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        EEveryClause everyClause = optBpData.getEEveryClause();
        EStdExpression2 condExpr = null;
        if (this.getEngineSession().supportsChgAddrContionalBkp()) {
            condExpr = optBpData.getEStdExpression2(esv, this.getEngineSession());
        }
        int threadId = optBpData.getThreadId(this);
        EStdWatchBPData bkpData = new EStdWatchBPData(addrOrExpr, byteCount, esv, this.getEngineSession());
        bkpData.setConditionalExpr(condExpr);
        bkpData.setAction(optBpData.getBreakpointAction());
        bkpData.setFileName(bkpFileName);
        bkpData.setModuleName(bkpModuleName);
        bkpData.setPartName(bkpPartName);
        bkpData.setRestoreAddress(bkpRestoreAddress);
        short attributes = deferred ? (short)16384 : 0;
        attributes = (short)(attributes | (enable ? Short.MIN_VALUE : 0));
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        EReqBreakpointWatchpoint request = new EReqBreakpointWatchpoint(attributes, everyClause, threadId, bkpData, this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void setEnhancedWatchpoint(boolean enable, String addrOrExpr, String register, int byteCount, String matchContents, String matchModuleName, String matchPartName, String fromAddrRange, String toAddrRange, OptionalBreakpointData optData, EPDC_Request.EProperty property, EStdView esv) throws EngineRequestException {
        if (!this.getEngineSession().supportsEnhancedWatchpointBreakpoints() || !optData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        EEveryClause everyClause = optData.getEEveryClause();
        EStdExpression2 condExpr = optData.getEStdExpression2(esv, this.getEngineSession());
        EStdEnhancedWatchBPData bkpData = new EStdEnhancedWatchBPData(addrOrExpr, byteCount, esv, this.getEngineSession());
        bkpData.setAction(optData.getBreakpointAction());
        bkpData.setRegister(register);
        bkpData.setMatchContents(matchContents);
        bkpData.setMatchModuleName(matchModuleName);
        bkpData.setMatchPartName(matchPartName);
        bkpData.setFromAddrRange(fromAddrRange);
        bkpData.setToAddrRange(toAddrRange);
        bkpData.setConditionalExpr(condExpr);
        short attributes = enable ? (short)Short.MIN_VALUE : 0;
        EReqBreakpointEnhancedWatchpoint request = new EReqBreakpointEnhancedWatchpoint(attributes, everyClause, optData.getThreadId(), bkpData, this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void setModuleLoadBreakpoint(boolean enable, String moduleName, OptionalBreakpointData optBpData, EPDC_Request.EProperty property, boolean isRunToEntry) throws EngineRequestException {
        if (!this.getEngineSession().supportsLoadBreakpoints() || !optBpData.areAllOptionalDataSupported(this.getEngineSession()) || isRunToEntry && !this.getEngineSession().supportsRunToEntry()) {
            throw new EngineRequestUnsupportedException();
        }
        short attributes = enable ? (short)Short.MIN_VALUE : 0;
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        EEveryClause everyClause = optBpData.getEEveryClause();
        int threadId = optBpData.getThreadId(this);
        EStdModuleLoadData bkpData = new EStdModuleLoadData(moduleName, this.getEngineSession(), isRunToEntry);
        EReqBreakpointEvent request = null;
        request = isRunToEntry ? new EReqBreakpointModuleLoadRunToEntry(attributes, everyClause, threadId, bkpData, this.getEngineSession()) : new EReqBreakpointModuleLoad(attributes, everyClause, threadId, bkpData, this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void setZeroAddressBreakpoint(boolean enable, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (!this.getEngineSession().supportsZeroAddressBreakpoint() || !optBpData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        short attributes = enable ? (short)Short.MIN_VALUE : 0;
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        EEveryClause everyClause = optBpData.getEEveryClause();
        int threadId = optBpData.getThreadId(this);
        EStdZeroAddressBPData bkpData = new EStdZeroAddressBPData(this.getEngineSession());
        EReqZeroAddressBreapoint request = new EReqZeroAddressBreapoint(attributes, everyClause, threadId, bkpData, this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void setOccurrenceBreakpoint(boolean enable, String condition, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (!this.getEngineSession().supportsOccurrenceBreakpoints() || !optBpData.areAllOptionalDataSupported(this.getEngineSession())) {
            throw new EngineRequestUnsupportedException();
        }
        short attributes = enable ? (short)Short.MIN_VALUE : 0;
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        EEveryClause everyClause = optBpData.getEEveryClause();
        int threadId = optBpData.getThreadId(this);
        EStdOccurrenceBPData bkpData = new EStdOccurrenceBPData(condition, this.getEngineSession());
        bkpData.setAction(optBpData.getBreakpointAction());
        EReqBreakpointOccurrence request = new EReqBreakpointOccurrence(attributes, everyClause, threadId, bkpData, this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void setDeferredLineBreakpoint(boolean enable, int lineNumber, String stmtNumber, String functionName, String moduleName, String partName, String fileName, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".setDeferredLineBreakpoint(" + lineNumber + ")");
        }
        if (!(this.getEngineSession().supportsDeferredBreakpoints() && this.getEngineSession().supportsLineBreakpoints() && optBpData.areAllOptionalDataSupported(this.getEngineSession()))) {
            throw new EngineRequestException();
        }
        short attributes = 16384;
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        if (enable) {
            attributes = (short)(attributes | Short.MIN_VALUE);
        }
        EEveryClause clause = optBpData.getEEveryClause();
        EStdView epdcContext = new EStdView(0, 0, 0, lineNumber);
        EStdExpression2 conditionalExpr = optBpData.getEStdExpression2(epdcContext, this.getEngineSession());
        int threadId = optBpData.getThreadId(this);
        EReqBreakpointLine request = new EReqBreakpointLine(attributes, clause, functionName, moduleName, partName, fileName, conditionalExpr, threadId, stmtNumber, epdcContext, null, optBpData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void setDeferredEntryBreakpoint(boolean enable, String entryName, String moduleName, String partName, boolean caseSensitive, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".setDeferredEntryBreakpoint(" + entryName + ")");
        }
        if (!(this.getEngineSession().supportsDeferredBreakpoints() && this.getEngineSession().supportsFunctionBreakpoints() && optBpData.areAllOptionalDataSupported(this.getEngineSession()))) {
            return;
        }
        short attributes = 16384;
        attributes = (short)(attributes | (enable ? Short.MIN_VALUE : 0));
        attributes = (short)(attributes | (caseSensitive ? 8192 : 0));
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        EEveryClause clause = optBpData.getEEveryClause();
        EStdExpression2 conditionalExpr = optBpData.getEStdExpression2(null, this.getEngineSession());
        int threadId = optBpData.getThreadId(this);
        EReqBreakpointEntry request = new EReqBreakpointEntry(attributes, clause, entryName, moduleName, partName, null, conditionalExpr, threadId, 0, optBpData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        String stackPattern = optBpData.getStackPattern();
        if (stackPattern != null) {
            request.putProperty(new EPDC_Request.EProperty(8, stackPattern));
            request.putProperty(new EPDC_Request.EProperty(9, optBpData.isStackPatternEnabled()));
        }
        this.getDebugEngine().processRequest(request);
    }

    public void setDeferredMacroBreakpoint(boolean enable, String macroName, String moduleName, String partName, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        boolean validRequest;
        boolean bl = validRequest = this.getEngineSession().supportsMacroBreakpoints() || this.getEngineSession().supportsMacroGroupBreakpoints();
        if (!validRequest) {
            return;
        }
        short attributes = 16384;
        attributes = (short)(attributes | (enable ? Short.MIN_VALUE : 0));
        attributes = (short)(attributes | optBpData.getSyncStopControlAttribute());
        EEveryClause clause = optBpData.getEEveryClause();
        EStdExpression2 conditionalExpr = optBpData.getEStdExpression2(null, this.getEngineSession());
        int threadId = optBpData.getThreadId(this);
        EReqBreakpointMacro request = new EReqBreakpointMacro(attributes, clause, macroName, moduleName, partName, conditionalExpr, threadId, 0, optBpData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(property);
        request.putProperty(new EPDC_Request.EProperty(6, optBpData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    public void monitorExpression(EStdView location, int threadId, String expression, byte attribute, short type, String moduleName, String partName, String fileName, String stmtNum) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".monitorExpression(" + expression + ")");
        }
        if (stmtNum == null && location != null) {
            stmtNum = this.getDebugEngine().getStmtNumber(location);
        }
        EStdExpression2 expr = new EStdExpression2(location, expression, threadId, 0, this.getEngineSession());
        EReqExpression request = new EReqExpression(attribute, type, expr, moduleName, partName, fileName, stmtNum, this.getEngineSession());
        this.getDebugEngine().processRequest(request);
    }

    public boolean savePgmObjects(String profileName) {
        Breakpoint[] breakpoints;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".savePgmObjects()");
        }
        Breakpoint[] breakpointArray = breakpoints = this.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Breakpoint breakpoint = breakpointArray[n2];
            if (!breakpoint.isSaveInProfile()) {
                this.removeBreakpoint(breakpoint.getId());
            }
            ++n2;
        }
        ProgramProfile saveme = new ProgramProfile(this);
        try {
            saveme.write(profileName);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean savePgmObjects2() {
        ExpressionBase[] expressions;
        Breakpoint[] breakpoints;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".savePgmObjects()");
        }
        Breakpoint[] breakpointArray = breakpoints = this.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Breakpoint breakpoint = breakpointArray[n2];
            if (!breakpoint.isSaveInProfile()) {
                this.removeBreakpoint(breakpoint.getId());
            }
            ++n2;
        }
        ExpressionBase[] expressionBaseArray = expressions = this.getMonitoredExpressions();
        int n3 = expressions.length;
        n = 0;
        while (n < n3) {
            ExpressionBase expr = expressionBaseArray[n];
            if (!expr.isSaveInProfile()) {
                this.removeMonitoredExpression(expr.getId());
            }
            ++n;
        }
        ProgramProfile2 programProfile = new ProgramProfile2(this);
        try {
            IPersister profilePersister = PDTCorePlugin.getPersister();
            IPath savePath = PDTCoreUtils.getProfileSaveRestorePath();
            profilePersister.save(programProfile, savePath);
            return true;
        }
        catch (Exception ex) {
            String errorMsg = PDTCoreUtils.getSaveErrorMsg(programProfile, ex);
            PDTCoreUtils.logString(this, errorMsg);
            return false;
        }
    }

    public boolean restorePgmObjects(int flags) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".restorePgmObjects()");
        }
        String profileName = this.getPgmProfileName(true);
        this.saveActivePgmObjects(profileName);
        ProgramProfile savedProfile = new ProgramProfile();
        try {
            savedProfile.read(profileName);
        }
        catch (Exception e) {
            profileName = this.getPgmProfileNameOldEscape(true);
            return this.restoreFromOldProfile(profileName, flags, savedProfile);
        }
        return savedProfile.restore(this, flags);
    }

    private void saveActivePgmObjects(String profileName) {
        IDebugTarget[] targets;
        if (PDTCoreUtils.isEmpty(profileName)) {
            return;
        }
        IDebugTarget[] iDebugTargetArray = targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            String otherProfileName;
            IPDTDebugTarget pdtTarget;
            IProcess process;
            IDebugTarget target = iDebugTargetArray[n2];
            if (target instanceof IPDTDebugTarget && (process = (pdtTarget = (IPDTDebugTarget)target).getProcess()) instanceof DebuggeeProcess && process != this && profileName.equals(otherProfileName = ((DebuggeeProcess)process).getPgmProfileName(true))) {
                pdtTarget.saveToProfile();
            }
            ++n2;
        }
    }

    private boolean restoreFromOldProfile(String profileName, int flags, ProgramProfile savedProfile) {
        try {
            savedProfile.read(profileName);
        }
        catch (ModelObjectInputStream.VersionException ve) {
            savedProfile = new ProgramProfile(20060529);
            try {
                savedProfile.read(profileName);
            }
            catch (Exception e) {
                return DebuggerProfileMigrator.restoreUsingOldProfile(this, ve.actualStreamVersion, profileName, flags);
            }
        }
        catch (ClassNotFoundException cnfe) {
            PDTCoreUtils.logString(this, "No profile will be loaded: unexpected layout for version = 20090814", 1, cnfe);
            return false;
        }
        catch (FileNotFoundException fnfe) {
            return DebuggerProfileMigrator.restoreUsingOldProfile(this, 20060529, profileName, flags);
        }
        catch (Exception e) {
            return false;
        }
        return savedProfile.restore(this, flags);
    }

    public boolean restorePgmObjects2(int flags) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".restorePgmObjects2()");
        }
        ProgramProfile2 savedProfile = new ProgramProfile2(this);
        String profileName = savedProfile.getFileName();
        this.saveActivePgmObjects(profileName);
        IPersister profilePersister = PDTCorePlugin.getPersister();
        IPath restorePath = PDTCoreUtils.getProfileSaveRestorePath();
        Object restoredObject = null;
        try {
            restoredObject = profilePersister.restore(savedProfile, restorePath);
        }
        catch (Throwable ex1) {
            if (ex1 instanceof FileNotFoundException) {
                if (PDTCorePlugin.fProfile) {
                    PDTCoreUtils.logString(this, " Cannot find " + savedProfile.getFileName());
                }
                try {
                    restoredObject = this.restoreViaMigration(savedProfile, restorePath);
                }
                catch (Exception ex2) {
                    if (PDTCorePlugin.fProfile) {
                        PDTCoreUtils.logString(this, PDTCoreUtils.getRestoreErrorMsg(savedProfile, false, ex2));
                    }
                    return this.restorePgmObjects(flags);
                }
            }
            PDTCoreUtils.logString(this, PDTCoreUtils.getRestoreErrorMsg(savedProfile, true, ex1));
            return false;
        }
        if (restoredObject != null) {
            savedProfile = (ProgramProfile2)restoredObject;
            savedProfile.setReadComplete(true);
            return savedProfile.restore(this, flags);
        }
        return false;
    }

    private Object restoreViaMigration(ProgramProfile2 savedProfile, IPath restorePath) throws Exception {
        throw new Exception("XML Migration not implemented yet!");
    }

    protected ExpressionBase getMonitoredExpression(ExpressionBase expr) {
        return ProgramProfile.getMonitoredExpression(this, expr.getEPDCMonitoredExpression());
    }

    public String getBasePgmProfileName() {
        return this._profileName;
    }

    public void setBasePgmProfileName(String name) {
        this._profileName = name;
    }

    public String getTimeStamp() {
        return this._timeStamp;
    }

    public String getDateString() {
        return this._dateStamp;
    }

    public String getPgmProfileName(boolean qualified) {
        String baseName = PDTCoreUtils.getValidFileName(this._profileName) + ".@" + this.getEngineSession().getUniqueEngineKey() + Language.getLanguageMnemonic(this.getDebugEngine().getDominantLanguage());
        if (!qualified) {
            return baseName;
        }
        return this.getDirectoryName() + baseName;
    }

    public String getPgmProfileNameOldEscape(boolean qualified) {
        String baseName = PDTCoreUtils.getValidFileNameOldEscape(this._profileName) + ".@" + this.getEngineSession().getUniqueEngineKey() + Language.getLanguageMnemonic(this.getDebugEngine().getDominantLanguage());
        if (!qualified) {
            return baseName;
        }
        return this.getDirectoryName() + baseName;
    }

    private String getDirectoryName() {
        Object directoryName = this.getDebugEngine().getDebuggeeStartupOptions().getSaveRestoreDirectory();
        if (directoryName == null) {
            directoryName = "";
        } else {
            String fileSeparator = System.getProperty("file.separator");
            if (!((String)directoryName).endsWith(fileSeparator)) {
                directoryName = (String)directoryName + fileSeparator;
            }
        }
        return directoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(int id) {
        TreeMap<Integer, Function> treeMap = this.fFunctions;
        synchronized (treeMap) {
            return this.fFunctions.get(id);
        }
    }

    public Function[] getFunctions(String name, boolean caseSensitive) {
        EReqEntrySearch request = new EReqEntrySearch(0, name, 0, caseSensitive ? (byte)0 : 1, this.getEngineSession());
        try {
            ERepEntrySearch reply = (ERepEntrySearch)this.getDebugEngine().processRequest(request);
            return this.processEntrySearch(reply);
        }
        catch (EngineRequestException engineRequestException) {
            return EMPTYFUNCTIONS;
        }
    }

    public Function[] getFunctions(Part part) {
        if (part == null) {
            return EMPTYFUNCTIONS;
        }
        return this.getFunctions(null, part.getId(), false);
    }

    public Function[] getFunctions(String functionName, int partId, boolean caseSensitive) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getFunctions(" + functionName + ", " + partId + ", " + caseSensitive + ")");
        }
        EReqEntrySearch request = new EReqEntrySearch((short)partId, functionName, 0, caseSensitive ? (byte)0 : 1, this.getEngineSession());
        try {
            ERepEntrySearch reply = (ERepEntrySearch)this.getDebugEngine().processRequest(request);
            return this.processEntrySearch(reply);
        }
        catch (EngineRequestException engineRequestException) {
            return EMPTYFUNCTIONS;
        }
    }

    public Function[] getFunctions(String functionName, int partId, int functionId) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getFunctions(" + functionName + ", " + partId + ", " + functionId + ")");
        }
        EReqEntrySearch request = new EReqEntrySearch((short)partId, functionName, functionId, 0, this.getEngineSession());
        try {
            ERepEntrySearch reply = (ERepEntrySearch)this.getDebugEngine().processRequest(request);
            return this.processEntrySearch(reply);
        }
        catch (EngineRequestException engineRequestException) {
            return EMPTYFUNCTIONS;
        }
    }

    public EntryListItem[] getFunctionList(boolean dbgFilter) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getFunctionList()");
        }
        int listType = dbgFilter ? 5 : 1;
        EntryListItem[] functionList = null;
        EReqGetList request = new EReqGetList(listType, 0, this.getEngineSession());
        try {
            this.getDebugEngine().processRequest(request);
            if (request.getReply() instanceof ERepGetList) {
                ERepGetList reply = (ERepGetList)request.getReply();
                ERepGetListItem[] functions = reply.getItems();
                int j = 0;
                while (j < functions.length) {
                    if (functions[j].getMetadata4() == 1) {
                        this.fFunctionListDbg.add(new EntryListItem(functions[j].getItem(), functions[j].getMetadata1(), functions[j].getMetadata2(), functions[j].getMetadata3(), functions[j].getMetadata4()));
                    } else {
                        this.fFunctionListNonDbg.add(new EntryListItem(functions[j].getItem(), functions[j].getMetadata1(), functions[j].getMetadata2(), functions[j].getMetadata3(), functions[j].getMetadata4()));
                    }
                    ++j;
                }
            }
        }
        catch (EngineRequestException reply) {
            // empty catch block
        }
        if (dbgFilter) {
            functionList = this.fFunctionListDbg.toArray(new EntryListItem[this.fFunctionListDbg.size()]);
        } else {
            TreeSet<EntryListItem> combinedList = new TreeSet<EntryListItem>((SortedSet<EntryListItem>)this.fFunctionListNonDbg);
            combinedList.addAll(this.fFunctionListDbg);
            functionList = combinedList.toArray(new EntryListItem[combinedList.size()]);
        }
        return functionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Function[] processEntrySearch(ERepEntrySearch reply) {
        TreeMap<Integer, Function> treeMap = this.fFunctions;
        synchronized (treeMap) {
            DebugEngine engine = this.getDebugEngine();
            ERepEntryGetNext[] epdcEntries = reply.getEntries();
            ArrayList<Function> functions = new ArrayList<Function>(epdcEntries.length);
            ERepEntryGetNext[] eRepEntryGetNextArray = epdcEntries;
            int n = epdcEntries.length;
            int n2 = 0;
            while (n2 < n) {
                ERepEntryGetNext entry = eRepEntryGetNextArray[n2];
                int partId = entry.getEStdView().getPartID();
                Part part = this.getPart(partId);
                Function functionNew = new Function(entry, part, engine);
                Function function = this.fFunctions.get(functionNew.getId());
                if (function != null) {
                    function.updateEntry(entry);
                } else {
                    function = functionNew;
                }
                this.fFunctions.put(function.getId(), function);
                functions.add(function);
                ++n2;
            }
            return functions.toArray(new Function[functions.size()]);
        }
    }

    public boolean isAttached() {
        return this._replyCode == 46 || this._replyCode == 49;
    }

    public boolean isHeapCheckEnabled() {
        return this._heapCheckEnabled;
    }

    public void setHeapCheckEnabled(boolean heapCheckEnabled) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".setHeapCheckEnabled(" + heapCheckEnabled + ")");
        }
        if (!this.getEngineSession().supportsStorageUsageCheck()) {
            return;
        }
        int heapCheckAttribute = heapCheckEnabled ? Integer.MIN_VALUE : 0;
        this.getDebugEngine().processRequest(new EReqStorageUsageCheckSet(heapCheckAttribute, this.getEngineSession()));
        this._heapCheckEnabled = heapCheckEnabled;
    }

    void setIsPostMortem() {
        this._isPostMortem = true;
    }

    public boolean isPostMortem() {
        return this._isPostMortem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCleanupDetails() {
        Collection<DebugModelObject> values;
        Cloneable cloneable = this.fModules;
        synchronized (cloneable) {
            values = this.fModules.values();
            for (DebugModelObject element : values) {
                element.doCleanup();
            }
            this.fModules.clear();
        }
        cloneable = this.fParts;
        synchronized (cloneable) {
            this.fParts.clear();
        }
        cloneable = this.fThreads;
        synchronized (cloneable) {
            values = this.fThreads.values();
            for (DebugModelObject element : values) {
                element.doCleanup();
            }
            this.fThreads.clear();
        }
        cloneable = this.fMonitoredExpressions;
        synchronized (cloneable) {
            this.fMonitoredExpressions.clear();
        }
        cloneable = this.fBreakpoints;
        synchronized (cloneable) {
            this.fBreakpoints.clear();
        }
        this._processStopInfo = null;
        if (this._storage != null) {
            this._storage.cleanup();
            this._storage = null;
        }
        cloneable = this.fFunctions;
        synchronized (cloneable) {
            this.fFunctions.clear();
        }
        cloneable = this.fFunctionListDbg;
        synchronized (cloneable) {
            this.fFunctionListDbg.clear();
        }
        cloneable = this.fFunctionListNonDbg;
        synchronized (cloneable) {
            this.fFunctionListNonDbg.clear();
        }
        cloneable = this.fFileListDbg;
        synchronized (cloneable) {
            this.fFileListDbg.clear();
        }
    }

    public String getAttribute(String key) {
        return this.fAttributes.getProperty(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    @Override
    public String getLabel() {
        StringBuffer label = new StringBuffer();
        if (this.fDetached) {
            Object[] substitutionText = new String[]{PICLLabels.picl_process_disconnected, this._processID, this._qualifiedName};
            label.append(NLS.bind((String)PICLLabels.picl_process_label_state, (Object[])substitutionText));
        } else if (this.isTerminated()) {
            Object[] substitutionText = new String[]{PICLLabels.picl_process_terminated, this._processID, this._qualifiedName};
            label.append(NLS.bind((String)PICLLabels.picl_process_label_state, (Object[])substitutionText));
        } else {
            label.append(NLS.bind((String)PICLLabels.picl_process_label, (Object)this._processID, (Object)this._qualifiedName));
        }
        if (this.fLabelProvider != null) {
            return this.fLabelProvider.getLabel(this, label.toString());
        }
        return label.toString();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsProxy;
    }

    public void setAttribute(String key, String value) {
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.haveDoneCleanup();
    }

    public void terminate() throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        if (this.getEngineSession().supportsRestart()) {
            try {
                this.terminate(this.getEngineSession().getTerminateType());
            }
            catch (EngineRequestException e) {
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), (Throwable)e));
            }
        } else {
            ((IPDTDebugTarget)this.getDebugTarget()).terminate();
        }
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public Object getEditableValue() {
        return null;
    }

    public FileListItem[] getFileNamesList() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getFileListRemote()");
        }
        EReqGetList request = new EReqGetList(6, 0, this.getEngineSession());
        try {
            this.getDebugEngine().processRequest(request);
            if (request.getReply() instanceof ERepGetList) {
                ERepGetList reply = (ERepGetList)request.getReply();
                ERepGetListItem[] files = reply.getItems();
                int j = 0;
                while (j < files.length) {
                    this.fFileListDbg.add(new FileListItem(files[j].getItem(), files[j].getMetadata1(), files[j].getMetadata3()));
                    ++j;
                }
            }
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return this.fFileListDbg.toArray(new FileListItem[this.fFileListDbg.size()]);
    }

    private EPDC_Reply processMemoryRequest(EPDC_Request memoryRequest) throws MemoryException {
        try {
            return this.getDebugEngine().processRequest(memoryRequest);
        }
        catch (EngineRequestErrorException ere) {
            throw new MemoryException(ere.isEngineMessage() ? ere.getMessage() : PICLMessages.picl_memory_error_unable_to_retrieve_memory, ere);
        }
        catch (EngineRequestException e) {
            throw new MemoryException(PICLMessages.picl_memory_error_unable_to_retrieve_memory, e);
        }
    }

    void processCCEvent(ProcessCCEvent event) {
        this.addEvent(event);
    }

    void processTraceEvent(ProcessTraceEvent event) {
        this.addEvent(event);
    }

    public void setLabelProvider(IPDTLabelProvider provider) {
        this.fLabelProvider = provider;
    }

    public static class ProgramProfile
    extends DebuggerPersistentProfile {
        public static final int CURRENT_VERSION = 20090814;
        protected TreeMap<Integer, Breakpoint> fBreakpoints;
        protected TreeMap<Integer, ExpressionBase> fMonitoredExpressions;
        protected DebuggeeException[] fExceptions;
        protected HashMap<Integer, Language> fLanguages;
        protected boolean fHeapCheckEnabled;

        public ProgramProfile() {
            super(20090814);
        }

        public ProgramProfile(int version) {
            super(version);
        }

        ProgramProfile(DebuggeeProcess from) {
            super(20090814);
            this.fBreakpoints = from.fBreakpoints;
            this.fMonitoredExpressions = from.fMonitoredExpressions;
            this.fExceptions = from.getDebugEngine().getExceptions();
            this.fLanguages = from.getDebugEngine()._languages;
            this.fHeapCheckEnabled = from.isHeapCheckEnabled();
        }

        @Override
        protected void writeObjects(ObjectOutputStream out) throws IOException {
            out.writeObject(this.fBreakpoints);
            out.writeObject(this.fMonitoredExpressions);
            out.writeObject(this.fExceptions);
            out.writeObject(this.fLanguages);
            out.writeBoolean(this.fHeapCheckEnabled);
        }

        @Override
        protected void readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.fBreakpoints = (TreeMap)in.readObject();
            this.fMonitoredExpressions = (TreeMap)in.readObject();
            this.fExceptions = (DebuggeeException[])in.readObject();
            this.fLanguages = (HashMap)in.readObject();
            this.fHeapCheckEnabled = in.readBoolean();
        }

        public boolean restore(DebuggeeProcess to, int flags) {
            if (!this.isReadComplete()) {
                return false;
            }
            boolean completeSuccess = true;
            if ((flags & 0x20000000) != 0) {
                boolean bl = completeSuccess = this.restoreBreakpoints(to) && completeSuccess;
            }
            if ((flags & 0x2000000) != 0) {
                boolean bl = completeSuccess = this.restoreLanguages(to) && completeSuccess;
            }
            if ((flags & 0x10000000) != 0) {
                boolean bl = completeSuccess = this.restoreMonitoredExpressions(to) && completeSuccess;
            }
            if ((flags & 0x1000000) != 0) {
                boolean bl = completeSuccess = this.restoreExceptions(to) && completeSuccess;
            }
            if ((flags & 0x800000) != 0) {
                completeSuccess = this.restoreSpecialOptions(to) && completeSuccess;
            }
            return completeSuccess;
        }

        protected boolean restoreBreakpoints(DebuggeeProcess to) {
            int size;
            if (this.fBreakpoints == null || (size = this.fBreakpoints.size()) == 0) {
                return true;
            }
            boolean bpok = true;
            boolean supportsMultiRequests = to.getDebugEngine().getEngineSession().supportsMultipleRequests();
            if (supportsMultiRequests) {
                to.getDebugEngine().startMultipleRequest();
            }
            Breakpoint[] breakpointArray = this.fBreakpoints.values().toArray(new Breakpoint[size]);
            int n = breakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Breakpoint bp = breakpointArray[n2];
                if (bp != null) {
                    bpok = bp.restore(to) && bpok;
                }
                ++n2;
            }
            if (supportsMultiRequests) {
                EPDC_Reply reply = to.getDebugEngine().endMultipleRequest(false);
                bpok = reply != null && reply.getReturnCode() == 0;
            }
            return bpok;
        }

        protected boolean restoreLanguages(DebuggeeProcess to) {
            int size;
            if (this.fLanguages == null || (size = this.fLanguages.size()) == 0) {
                return true;
            }
            boolean lok = true;
            Language[] languageArray = this.fLanguages.values().toArray(new Language[size]);
            int n = languageArray.length;
            int n2 = 0;
            while (n2 < n) {
                Language lang = languageArray[n2];
                try {
                    lang.restore(to);
                }
                catch (EngineRequestException e) {
                    lok = false;
                }
                ++n2;
            }
            return lok;
        }

        protected boolean restoreMonitoredExpressions(DebuggeeProcess to) {
            int size;
            if (this.fMonitoredExpressions == null || (size = this.fMonitoredExpressions.size()) == 0) {
                return true;
            }
            boolean meok = true;
            ExpressionBase[] expressionBaseArray = this.fMonitoredExpressions.values().toArray(new ExpressionBase[size]);
            int n = expressionBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExpressionBase expr = expressionBaseArray[n2];
                if (expr != null) {
                    try {
                        expr.restore(to);
                    }
                    catch (EngineRequestException e) {
                        meok = false;
                    }
                }
                ++n2;
            }
            return meok;
        }

        protected static ExpressionBase getMonitoredExpression(DebuggeeProcess activating, ECPMonitorExprBase testExpr) {
            ExpressionBase[] mons = activating.getMonitoredExpressions();
            if (mons == null) {
                return null;
            }
            int i = 0;
            while (i < mons.length) {
                if (mons[i] != null && testExpr.isSame(mons[i].getEPDCMonitoredExpression())) {
                    return mons[i];
                }
                ++i;
            }
            return null;
        }

        protected boolean restoreExceptions(DebuggeeProcess to) {
            if (this.fExceptions == null || this.fExceptions.length == 0) {
                return true;
            }
            if (this.fExceptions.length != to.getDebugEngine().getExceptions().length) {
                return false;
            }
            boolean eok = true;
            DebuggeeException[] newExceptions = new DebuggeeException[this.fExceptions.length];
            int i = 0;
            while (i < this.fExceptions.length) {
                newExceptions[i] = new DebuggeeException(this.fExceptions[i], to.getDebugEngine());
                ++i;
            }
            to.getDebugEngine().setExceptions(newExceptions);
            try {
                to.getDebugEngine().changeExceptionStatus();
            }
            catch (EngineRequestException e1) {
                eok = false;
            }
            return eok;
        }

        protected boolean restoreSpecialOptions(DebuggeeProcess to) {
            if (this.fHeapCheckEnabled != to.isHeapCheckEnabled()) {
                try {
                    to.setHeapCheckEnabled(this.fHeapCheckEnabled);
                }
                catch (EngineRequestException e1) {
                    return false;
                }
            }
            return true;
        }
    }
}

