/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.epdc.ERepGetExceptions;
import java.io.Serializable;

public class DebuggeeException
extends DebugModelObject
implements Serializable {
    private int _currentState;
    private int _pendingState;
    private int _defaultState;
    private ERepGetExceptions _excp;
    private static final long serialVersionUID = 20050307L;

    DebuggeeException(ERepGetExceptions excp, DebugEngine engine) {
        super(engine);
        this._excp = excp;
        this._defaultState = this._currentState = excp.getExceptionStatus();
        this._pendingState = this._currentState;
    }

    DebuggeeException(DebuggeeException exception, DebugEngine debugEngine) {
        super(debugEngine);
        this._currentState = exception._currentState;
        this._defaultState = exception._defaultState;
        this._pendingState = exception._pendingState;
        this._excp = exception._excp;
    }

    DebuggeeException(int currentState, int defaultState, int pendingState, ERepGetExceptions excp, DebugEngine debugEngine) {
        super(debugEngine);
        this._currentState = currentState;
        this._defaultState = defaultState;
        this._pendingState = pendingState;
        this._excp = excp;
    }

    public String getName() {
        return this._excp.getExceptionName();
    }

    public boolean getDefaultEnabled() {
        return this._defaultState == 1;
    }

    public boolean getPendingEnabled() {
        return this._pendingState == 1;
    }

    public boolean isEnabled() {
        return this._currentState == 1;
    }

    public void setEnable(boolean enable) {
        this._pendingState = enable ? 1 : 0;
    }

    public void setDefaultEnabled(boolean enable) {
        this._defaultState = enable ? 1 : 0;
    }

    int getPendingState() {
        return this._pendingState;
    }

    void commitPendingStateChange() {
        this._currentState = this._pendingState;
    }

    protected ERepGetExceptions getException() {
        return this._excp;
    }

    @Override
    protected void doCleanupDetails() {
    }
}

