/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EventManager;
import com.ibm.debug.pdt.internal.core.model.IDebugEventProvider;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.ModelEvent;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.debug.core.model.IDebugTarget;

public abstract class DebugModelObject
extends PDTDebugElement
implements IDebugEventProvider {
    private transient Set<IModelEventListener> fEventListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private transient EventManager fEventManager;

    DebugModelObject() {
    }

    DebugModelObject(DebugEngine debugEngine) {
        this(debugEngine == null ? null : debugEngine.getDebugTarget(), debugEngine);
    }

    DebugModelObject(DebugEngine debugEngine, PDTDebugElement parent) {
        this(debugEngine == null ? null : debugEngine.getDebugTarget(), debugEngine, parent);
    }

    DebugModelObject(IDebugTarget debugTarget, DebugEngine debugEngine) {
        this(debugTarget, debugEngine, null);
    }

    DebugModelObject(IDebugTarget debugTarget, DebugEngine debugEngine, PDTDebugElement parent) {
        super(debugTarget, debugEngine, parent);
    }

    @Override
    public void addListener(IModelEventListener eventListener) {
        if (PDTCorePlugin.fModelEvents) {
            PDTCoreUtils.logString(this, ".addEventListener(" + PDTCoreUtils.getBaseName(eventListener) + ")");
        }
        this.fEventListeners.add(eventListener);
    }

    @Override
    public void removeListener(IModelEventListener eventListener) {
        this.fEventListeners.remove(eventListener);
    }

    public void addEvent(ModelEvent event) {
        if (this.fEventManager == null) {
            this.fEventManager = this.getDebugEngine().getEventManager();
        }
        this.fEventManager.addEvent(event, this);
    }

    public void fireEvent(ModelEvent event) {
        if (this.fEventManager == null) {
            return;
        }
        this.fEventManager.fireEvent(event, this.getListeners());
    }

    protected void removeAllEventListeners() {
        this.fEventListeners.clear();
    }

    @Override
    public IModelEventListener[] getListeners() {
        return this.fEventListeners.toArray(new IModelEventListener[this.fEventListeners.size()]);
    }

    @Override
    public String getLabel() {
        return "**UNDEFINED** label for " + this.getClass().getName();
    }
}

