/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.saverestore.IPersister;
import com.ibm.debug.pdt.core.sourcelocator.IRemoteEnginePathContainer;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLStreamsProxy;
import com.ibm.debug.pdt.internal.core.model.AmbiguousBreakpointHandler;
import com.ibm.debug.pdt.internal.core.model.AmbiguousMonitoredExpressionHandler;
import com.ibm.debug.pdt.internal.core.model.BreakpointAddedEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineCommandLogResponseEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineEventAdapter;
import com.ibm.debug.pdt.internal.core.model.DebugEngineTerminatedEvent;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeAttachOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.DebuggeePrepareOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeReconnectOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeStartupOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.DebuggerPersistentProfile;
import com.ibm.debug.pdt.internal.core.model.EPDCRequestProcessor;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestUnsupportedException;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEngineTerminator;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.EventManager;
import com.ibm.debug.pdt.internal.core.model.ExpressionAddedEvent;
import com.ibm.debug.pdt.internal.core.model.GlobalProfile2;
import com.ibm.debug.pdt.internal.core.model.GlobalRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.GlobalSymbol;
import com.ibm.debug.pdt.internal.core.model.GlobalVariable;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IDebugEventProvider;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Line;
import com.ibm.debug.pdt.internal.core.model.LocalFilter;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationConstructionException;
import com.ibm.debug.pdt.internal.core.model.MessageReceivedEvent;
import com.ibm.debug.pdt.internal.core.model.Model;
import com.ibm.debug.pdt.internal.core.model.ModelObjectInputStream;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.ModuleAddedEvent;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ProcessAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessDetachedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessListColumnDetails;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmError;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmOutput;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.Representation;
import com.ibm.debug.pdt.internal.core.model.StackColumnDetails;
import com.ibm.debug.pdt.internal.core.model.SystemProcess;
import com.ibm.debug.pdt.internal.core.model.ThreadAddedEvent;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.DebuggerProfileMigrator;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.core.util.PDTLicenseCheck;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.ERepCommandLog;
import com.ibm.debug.pdt.internal.epdc.ERepContextConvert;
import com.ibm.debug.pdt.internal.epdc.ERepGetExceptions;
import com.ibm.debug.pdt.internal.epdc.ERepGetLanguages;
import com.ibm.debug.pdt.internal.epdc.ERepGetProcessColumns;
import com.ibm.debug.pdt.internal.epdc.ERepGetRegistersGroups;
import com.ibm.debug.pdt.internal.epdc.ERepGetStackColumns;
import com.ibm.debug.pdt.internal.epdc.ERepGetViews;
import com.ibm.debug.pdt.internal.epdc.ERepGlobalList;
import com.ibm.debug.pdt.internal.epdc.ERepGlobalSymbolQuery;
import com.ibm.debug.pdt.internal.epdc.ERepInitializeDE;
import com.ibm.debug.pdt.internal.epdc.ERepJobsListGet;
import com.ibm.debug.pdt.internal.epdc.ERepLocalFilterList;
import com.ibm.debug.pdt.internal.epdc.ERepPartOpen;
import com.ibm.debug.pdt.internal.epdc.ERepPreparePgm;
import com.ibm.debug.pdt.internal.epdc.ERepProcessAttach;
import com.ibm.debug.pdt.internal.epdc.ERepProcessDetailsGet;
import com.ibm.debug.pdt.internal.epdc.ERepProcessListGet;
import com.ibm.debug.pdt.internal.epdc.ERepRegistersDetailsGet;
import com.ibm.debug.pdt.internal.epdc.ERepStackDetailsGet;
import com.ibm.debug.pdt.internal.epdc.ERepVersion;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEntryAutoSet2;
import com.ibm.debug.pdt.internal.epdc.EReqCommandLog;
import com.ibm.debug.pdt.internal.epdc.EReqContextConvert;
import com.ibm.debug.pdt.internal.epdc.EReqExceptionStatusChange;
import com.ibm.debug.pdt.internal.epdc.EReqExpression;
import com.ibm.debug.pdt.internal.epdc.EReqGlobalList;
import com.ibm.debug.pdt.internal.epdc.EReqGlobalSymbolQuery;
import com.ibm.debug.pdt.internal.epdc.EReqHiddenCommandLog;
import com.ibm.debug.pdt.internal.epdc.EReqInitializeDE;
import com.ibm.debug.pdt.internal.epdc.EReqJobsListGet;
import com.ibm.debug.pdt.internal.epdc.EReqLocalFilterList;
import com.ibm.debug.pdt.internal.epdc.EReqLog;
import com.ibm.debug.pdt.internal.epdc.EReqModuleAdd;
import com.ibm.debug.pdt.internal.epdc.EReqModuleRemove;
import com.ibm.debug.pdt.internal.epdc.EReqModuleSideFileUpdate;
import com.ibm.debug.pdt.internal.epdc.EReqMultiRequest;
import com.ibm.debug.pdt.internal.epdc.EReqPartOpen;
import com.ibm.debug.pdt.internal.epdc.EReqPartSet;
import com.ibm.debug.pdt.internal.epdc.EReqPreparePgm;
import com.ibm.debug.pdt.internal.epdc.EReqProcessAttach;
import com.ibm.debug.pdt.internal.epdc.EReqProcessAttach2;
import com.ibm.debug.pdt.internal.epdc.EReqProcessDetailsGet;
import com.ibm.debug.pdt.internal.epdc.EReqProcessListGet;
import com.ibm.debug.pdt.internal.epdc.EReqReSync;
import com.ibm.debug.pdt.internal.epdc.EReqRegistersDetailsGet;
import com.ibm.debug.pdt.internal.epdc.EReqSourcePathUpdate;
import com.ibm.debug.pdt.internal.epdc.EReqStackDetailsGet;
import com.ibm.debug.pdt.internal.epdc.EReqTerminateDE;
import com.ibm.debug.pdt.internal.epdc.EReqVersion;
import com.ibm.debug.pdt.internal.epdc.EReqVersionSecure;
import com.ibm.debug.pdt.internal.epdc.EStdGlobalSymbol;
import com.ibm.debug.pdt.internal.epdc.EStdGlobalVariable;
import com.ibm.debug.pdt.internal.epdc.EStdLocalFilter;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public class DebugEngine
extends DebugModelObject
implements IProcessEventListener {
    static final SystemProcess[] EMPTYSYSTEMPROCESS = new SystemProcess[0];
    private static final GlobalVariable[] EMPTYGLOBALS = new GlobalVariable[0];
    boolean fDateBreakpointsEnabled = false;
    public boolean fAllEntryBreakpointsEnabled = false;
    protected boolean fAllEntryBreakpointsInstalled = false;
    public boolean fZeroAddressBreakpointEnabled = false;
    protected boolean fZeroAddressBreakpointInstalled = false;
    protected int _defaultMemoryRep = -1;
    private String _localSourcePath;
    private boolean _hasBeenInitialized = false;
    private Socket fSocket;
    private EPDCRequestProcessor _EPDCRequestProcessor;
    private DebuggeeProcess _process;
    private DebuggeeProcess _cleanupProcess;
    private PICLStreamsProxy _cleanupStreamsProxy;
    private EventManager _eventManager = new EventManager();
    private HashMap<Integer, ViewInformation> _viewsByType;
    private ViewInformation[] fSupportedViews;
    private int fNumberViews;
    protected HashMap<Integer, Language> _languages;
    private Representation[] _repNames = new Representation[0];
    protected DebuggeeException[] _exceptionInfo;
    private StackColumnDetails[] fStackDetailColumns = new StackColumnDetails[0];
    private Object fStackDetailLock = new Object();
    private boolean fStackDetailsRetrieved = false;
    private int[] _defaultColumnIds = null;
    private HashMap<Integer, GlobalRegisterGroup> _globalRegisterGroups;
    private ProcessListColumnDetails[] _processListColumnDetails;
    private GlobalSymbol[] _globalSymbols;
    protected LocalFilter[] _localFilters = null;
    private static final LocalFilter[] EMPTYFILTERS = new LocalFilter[0];
    private DebuggeeStartupOptions _debuggeeStartupOptions;
    private ErrorOccurredEvent _errorOccurredEventForFileNotFound;
    private byte _dominantLanguage;
    static final int DEFAULT_DATA_REPRESENTATIONS_HAVE_CHANGED = 0x2000000;
    static final int EXCEPTION_FILTERS_HAVE_CHANGED = 0x1000000;
    private transient EPDC_EngineSession _engineSession = new EPDC_EngineSession();
    private static final int MIN_SUPPORTED_EPDC_VERSION = 306;
    private static final int MAX_SUPPORTED_EPDC_VERSION = 311;
    private int _maximumViewFileCacheSize = 500;
    private boolean fProgramTerminating = false;
    private boolean fGlobalExceptionDefaults = false;
    private int fFEFCT = -184549376;
    private final Object fMultiRequestLock = new Object();
    private EReqMultiRequest fMultiRequest = null;
    private static final int PRE_PDT_SPLIT_PROFILE_VERSION = 20050502;
    private static final int TPF344GA_PROFILE_VERSION = 20050502;

    public DebugEngine(IDebugTarget debugTarget) {
        super(debugTarget, null);
        if (PDTLicenseCheck.supportsClientLicenseCheck()) {
            this.fFEFCT |= 0x2000000;
        }
    }

    @Override
    public DebugEngine getDebugEngine() {
        return this;
    }

    protected final EventManager getEventManager() {
        return this._eventManager;
    }

    public void connect(Socket socket) throws IOException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".connect()");
        }
        this.fSocket = socket;
    }

    public int getEngineID() {
        return this._engineSession.getEngineID();
    }

    public void addEventListener(IDebugEngineEventListener eventListener) {
        this.addListener(eventListener);
    }

    public DebuggeeProcess getProcess() {
        return this._process;
    }

    void handleError(EPDC_Reply reply) {
        String message = reply.getMessageText();
        int returnCode = reply.getReturnCode();
        EPDC_Request request = reply.getRequest();
        DebugEngineEventAdapter singleEventProvider = null;
        switch (returnCode) {
            case 322: {
                if (request != null && reply instanceof ERepBreakpointLocation) {
                    if (!Model.willHandleAmbiguousBreakpoints()) break;
                    singleEventProvider = new AmbiguousBreakpointHandler();
                    singleEventProvider.addListener(singleEventProvider);
                    break;
                }
                if (!(request instanceof EReqExpression) || !Model.willHandleAmbiguousMonitoredExpressions()) break;
                singleEventProvider = new AmbiguousMonitoredExpressionHandler();
                singleEventProvider.addListener(singleEventProvider);
                break;
            }
            case 126: 
            case 329: {
                this.addEventListener(new ErrorOccurredEngineTerminator());
                break;
            }
            case 7: {
                if (!(request instanceof EReqPartSet)) break;
                ErrorOccurredEvent event = new ErrorOccurredEvent(this, returnCode, message, request);
                this.saveErrorOccurredEventForFileNotFound(event);
                return;
            }
            case 998: {
                if (!(request instanceof EReqTerminateDE)) break;
                return;
            }
            case 4: {
                if (request.getRequestCode() != 10) break;
                return;
            }
            case 334: {
                String replyMessageText = reply.getMessageText();
                if (replyMessageText == null || replyMessageText.isEmpty()) break;
                this.sendMessage(replyMessageText, reply.getRequest());
                break;
            }
        }
        if (request instanceof EReqExpression && ((EReqExpression)request).isPopup()) {
            return;
        }
        ErrorOccurredEvent event = new ErrorOccurredEvent(this, returnCode, message, request);
        if (singleEventProvider == null) {
            this.addEvent(event);
        } else {
            this.getEventManager().addEvent(event, (IDebugEventProvider)((Object)singleEventProvider));
        }
    }

    void sendMessage(String message, EPDC_Request request) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".sendMessage(" + message + ")");
        }
        if (request != null && request.isSuppressMsgs()) {
            return;
        }
        this.addEvent(new MessageReceivedEvent(this, message, request));
    }

    void add(DebuggeeProcess process) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(DebuggeeProcess<" + process.getProcessID() + ">)");
        }
        this.fProgramTerminating = false;
        process.addEventListener(this);
        this._cleanupProcess = this._process = process;
        this._cleanupStreamsProxy = (PICLStreamsProxy)this._process.getStreamsProxy();
        this.addEvent(new ProcessAddedEvent(this, process));
    }

    public boolean isConnected() {
        Socket tempSocket = this.fSocket;
        if (tempSocket == null) {
            return false;
        }
        return !tempSocket.isClosed();
    }

    public Socket getConnection() {
        return this.fSocket;
    }

    public boolean initialize(byte dominantLanguage, String productPrefix, String debuggerArguments, String remoteSearchPath) throws EngineRequestException {
        EReqInitializeDE request;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".initialize()");
        }
        if (this._hasBeenInitialized) {
            return false;
        }
        if (this.isConnected() && this._EPDCRequestProcessor == null) {
            try {
                this._EPDCRequestProcessor = new EPDCRequestProcessor(this);
            }
            catch (IOException e1) {
                throw new EngineRequestException(e1);
            }
        }
        this._engineSession.setNegotiatedEPDCVersion(0);
        ERepVersion versionReply = null;
        try {
            versionReply = this._engineSession.isAuthenticateConnection() ? (ERepVersion)this.processRequest(new EReqVersionSecure(311, this._engineSession.getUserId(), this._engineSession.getPassword(), this._engineSession)) : (ERepVersion)this.processRequest(new EReqVersion(311, this.getEngineSession()));
        }
        catch (EngineRequestException ere) {
            this.setEnded();
            this._eventManager.fireAllQueuedEvents();
            throw ere;
        }
        int engineEPDCVersion = versionReply.getVersion();
        if (engineEPDCVersion < 306) {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, "ERROR!!! Engine's EPDC support is too down-level for UI to work with", 4);
            }
            try {
                this.terminate();
            }
            catch (EngineRequestException engineRequestException) {
                // empty catch block
            }
            throw new EngineRequestUnsupportedException();
        }
        if (engineEPDCVersion < 311) {
            this._engineSession.setNegotiatedEPDCVersion(engineEPDCVersion);
        } else {
            this._engineSession.setNegotiatedEPDCVersion(311);
        }
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "  Negotiated EPDC version is " + this.getEPDCVersion());
        }
        if (versionReply.isReconnect()) {
            this._dominantLanguage = dominantLanguage;
            request = new EReqReSync(this._dominantLanguage, productPrefix, debuggerArguments, remoteSearchPath, this.getEngineSession());
        } else {
            this._dominantLanguage = dominantLanguage;
            request = new EReqInitializeDE(this._dominantLanguage, productPrefix, debuggerArguments, remoteSearchPath, this.getEngineSession());
        }
        request.setFEFCT(this.fFEFCT);
        this.processRequest(request);
        return versionReply.isReconnect();
    }

    void initialize(ERepInitializeDE initializeReply) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "Initialize from reply");
        }
        if (this._engineSession.isLicenseCheckNeeded() && !PDTLicenseCheck.isLicenceAvailable(this, this.getMode())) {
            try {
                this.terminate();
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logError(e);
            }
            return;
        }
        ERepGetViews[] viewInformation = this._engineSession.getViewInformation();
        this.fSupportedViews = new ViewInformation[viewInformation.length];
        this.fNumberViews = viewInformation.length - 1;
        this.fSupportedViews[0] = null;
        this._viewsByType = new HashMap();
        short i = 1;
        while (i < viewInformation.length) {
            ViewInformation vi = this.fSupportedViews[i] = new ViewInformation(viewInformation[i], i, this);
            this._viewsByType.put(Integer.valueOf(vi.getKind()), vi);
            i = (short)(i + 1);
        }
        String[] repNames = this._engineSession.getRepNames();
        this._repNames = new Representation[repNames.length];
        int j = 1;
        while (j < repNames.length) {
            this._repNames[j] = new Representation(repNames[j], (short)j, this);
            ++j;
        }
        ERepGetLanguages[] langInfo = this._engineSession.getLanguageInfo();
        int j2 = 0;
        while (j2 < langInfo.length) {
            this.add(new Language(langInfo[j2], this), langInfo[j2].getLanguageID());
            ++j2;
        }
        ERepGetExceptions[] excpInfo = this._engineSession.getExceptionInfo();
        this._exceptionInfo = new DebuggeeException[excpInfo.length];
        int j3 = 0;
        while (j3 < excpInfo.length) {
            this.add(new DebuggeeException(excpInfo[j3], this), j3);
            ++j3;
        }
        int defaultSettings = this._engineSession.getDefaultSettings();
        this.fDateBreakpointsEnabled = (defaultSettings & 0x8000000) != 0;
        this.fAllEntryBreakpointsEnabled = (defaultSettings & 0x20000000) != 0;
        this._hasBeenInitialized = true;
    }

    private String getMode() {
        if (this.getDebugTarget() != null) {
            if (this.getDebugTarget().getLaunch() != null) {
                String mode = this.getDebugTarget().getLaunch().getLaunchMode();
                if (mode != null && !mode.trim().isEmpty()) {
                    return mode.trim();
                }
            } else if (this.getDebugTarget() instanceof PDTDebugTarget && ((PDTDebugTarget)this.getDebugTarget()).getStartupInfo().isCodeCoverage()) {
                return "compiled_coverage";
            }
        }
        return "debug";
    }

    public boolean isRunningCC() {
        if (this.getMode().equals("compiled_coverage")) {
            return true;
        }
        return this.getDebugTarget() instanceof PDTDebugTarget && ((PDTDebugTarget)this.getDebugTarget()).isMixedCCEnabled();
    }

    public void setEnded() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".hasEnded()");
        }
        this.addEvent(new DebugEngineTerminatedEvent(this));
        this.doCleanup();
    }

    public boolean hasBeenInitialized() {
        return this._hasBeenInitialized;
    }

    public void terminate() throws EngineRequestException {
        if (this.haveDoneCleanup()) {
            return;
        }
        this.processRequest(new EReqTerminateDE(this.getEngineSession()));
    }

    public ERepCommandLog commandLog(String command, boolean hidden, boolean isImmediate) throws EngineRequestException {
        if (command == null || command.equals("")) {
            command = " ";
        }
        EReqLog request = hidden ? new EReqHiddenCommandLog(command, this.getEngineSession()) : new EReqCommandLog(command, this.getEngineSession());
        request.setImmediate(isImmediate);
        ERepCommandLog reply = (ERepCommandLog)this.processRequest(request);
        if (reply.getStopInfo().getReason() == 23) {
            byte dominantLanguage = ((PDTDebugTarget)this.getDebugTarget()).getStartupInfo().getLanguage();
            String searchPath = null;
            if (this.getLaunch() == null) {
                searchPath = this.getEngineSession().getGlobalEnginePath();
            } else {
                IRemoteEnginePathContainer enginePathContainer;
                ISourceLocator sourceDirector = this.getLaunch().getSourceLocator();
                if (sourceDirector != null && sourceDirector instanceof ISourceLookupDirector && (enginePathContainer = PDTCoreUtils.getDebugEnginePathContainer((ISourceLookupDirector)sourceDirector)) != null) {
                    searchPath = enginePathContainer.getPath();
                }
            }
            this._dominantLanguage = dominantLanguage;
            EReqReSync sync = new EReqReSync(this._dominantLanguage, null, null, searchPath, this.getEngineSession());
            sync.setFEFCT(this.fFEFCT);
            this.processRequest(sync);
        }
        return reply;
    }

    protected void commandLogResponse(String[] responseLines, boolean echo) {
        this.addEvent(new DebugEngineCommandLogResponseEvent(this, responseLines, echo));
    }

    public void reconnectProgram(DebuggeeReconnectOptions options) {
        this._debuggeeStartupOptions = options;
    }

    public ERepPreparePgm prepareProgram(DebuggeePrepareOptions options) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".prepareProgam()");
        }
        if (options == null) {
            return null;
        }
        this._debuggeeStartupOptions = options;
        if (!this._hasBeenInitialized || this._process != null || !this.getEngineSession().supportsDebugInitialization() && !options.runToMainEntryPoint()) {
            return null;
        }
        EReqPreparePgm request = new EReqPreparePgm(this._debuggeeStartupOptions.getDebuggeeName(), options.getDebuggeeArguments(), options.getJobName(), options.runToMainEntryPoint(), options.getDominantLanguage(), this.getEngineSession(), options.getViewOrder());
        return (ERepPreparePgm)this.processRequest(request);
    }

    public ERepProcessAttach attach(DebuggeeAttachOptions options) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".attach");
        }
        if (options == null) {
            throw new EngineRequestException();
        }
        this._debuggeeStartupOptions = options;
        SystemProcess process = options.getProcess();
        EPDC_Request request = process == null ? new EReqProcessAttach(options.getProcessID(), options.getDebuggeeName(), options.getEventHandlerID(), options.getDominantLanguage(), this.getEngineSession(), options.getViewOrder()) : new EReqProcessAttach2(process.getIndex(), options.getDebuggeeName(), options.getDominantLanguage(), this.getEngineSession(), options.getViewOrder());
        if (!this._hasBeenInitialized || this._process != null || !this.getEngineSession().supportsProcessAttach()) {
            throw new EngineRequestUnsupportedException();
        }
        return (ERepProcessAttach)this.processRequest(request);
    }

    public SystemProcess[] getSystemProcessList() {
        ERepProcessListGet reply;
        if (!this.getEngineSession().supportsProcessAttach()) {
            return EMPTYSYSTEMPROCESS;
        }
        try {
            reply = (ERepProcessListGet)this.processRequest(new EReqProcessListGet(this.getEngineSession()));
        }
        catch (EngineRequestException ere) {
            PDTCoreUtils.logError(ere);
            return EMPTYSYSTEMPROCESS;
        }
        String[][] processes = reply.getProcesses();
        SystemProcess[] systemProcesses = new SystemProcess[processes.length];
        int i = 0;
        while (i < processes.length) {
            systemProcesses[i] = new SystemProcess(processes[i], i + 1, this);
            ++i;
        }
        return systemProcesses;
    }

    public ProcessListColumnDetails[] getProcessListColumnDetails() {
        if (this._processListColumnDetails == null) {
            ERepProcessDetailsGet reply;
            if (!this.getEngineSession().supportsProcessAttach()) {
                return null;
            }
            try {
                reply = (ERepProcessDetailsGet)this.processRequest(new EReqProcessDetailsGet(this.getEngineSession()));
            }
            catch (EngineRequestException ere) {
                PDTCoreUtils.logError(ere);
                return null;
            }
            ERepGetProcessColumns[] epdcColumns = reply.getColumnInfo();
            TreeMap<Integer, ProcessListColumnDetails> procCols = new TreeMap<Integer, ProcessListColumnDetails>();
            int i = 0;
            while (i < epdcColumns.length) {
                procCols.put(epdcColumns[i].getColumnID(), new ProcessListColumnDetails(epdcColumns[i]));
                ++i;
            }
            this._processListColumnDetails = procCols.values().toArray(new ProcessListColumnDetails[procCols.size()]);
        }
        return this._processListColumnDetails == null ? null : Arrays.copyOf(this._processListColumnDetails, this._processListColumnDetails.length);
    }

    public int getNumberSupportedViews() {
        return this.fNumberViews;
    }

    public ViewInformation[] getSupportedViews() {
        return this.fSupportedViews == null ? null : Arrays.copyOf(this.fSupportedViews, this.fSupportedViews.length);
    }

    public Representation[] getRepresentations() {
        return this._repNames == null ? null : Arrays.copyOf(this._repNames, this._repNames.length);
    }

    public Language[] getLanguages() {
        if (this._languages == null) {
            return new Language[0];
        }
        Collection<Language> values = this._languages.values();
        return values.toArray(new Language[values.size()]);
    }

    public GlobalSymbol[] getGlobalSymbols() {
        ERepGlobalSymbolQuery reply;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getGlobalSymbols()");
        }
        if (!this.getEngineSession().supportsMonitorGlobalSymbols()) {
            return new GlobalSymbol[0];
        }
        if (this._globalSymbols != null) {
            return Arrays.copyOf(this._globalSymbols, this._globalSymbols.length);
        }
        this._globalSymbols = new GlobalSymbol[0];
        EReqGlobalSymbolQuery request = new EReqGlobalSymbolQuery(this.getEngineSession());
        try {
            reply = (ERepGlobalSymbolQuery)this.processRequest(request);
        }
        catch (EngineRequestException ere) {
            PDTCoreUtils.logError(ere);
            return Arrays.copyOf(this._globalSymbols, this._globalSymbols.length);
        }
        EStdGlobalSymbol[] array = reply.getSymbolArray();
        this._globalSymbols = new GlobalSymbol[array.length];
        int i = 0;
        while (i < array.length) {
            this._globalSymbols[i] = new GlobalSymbol(array[i], this);
            ++i;
        }
        return Arrays.copyOf(this._globalSymbols, this._globalSymbols.length);
    }

    public GlobalVariable[] getGlobalVariables() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getGlobalVariables()");
        }
        if (!this.getEngineSession().supportsMonitorGlobalList()) {
            return new GlobalVariable[0];
        }
        EReqGlobalList request = new EReqGlobalList(this.getEngineSession());
        GlobalVariable[] globals = EMPTYGLOBALS;
        ERepGlobalList reply = (ERepGlobalList)this.processRequest(request);
        EStdGlobalVariable[] array = reply.getGlobalList();
        globals = new GlobalVariable[array.length];
        int i = 0;
        while (i < array.length) {
            globals[i] = new GlobalVariable(array[i], this);
            ++i;
        }
        return globals;
    }

    public LocalFilter[] getLocalFilters() {
        ERepLocalFilterList reply;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getLocalFilters()");
        }
        if (this._localFilters != null) {
            return Arrays.copyOf(this._localFilters, this._localFilters.length);
        }
        if (!this.getEngineSession().supportsLocalFilters()) {
            this._localFilters = EMPTYFILTERS;
            return EMPTYFILTERS;
        }
        EReqLocalFilterList request = new EReqLocalFilterList(this.getEngineSession());
        try {
            reply = (ERepLocalFilterList)this.processRequest(request);
        }
        catch (EngineRequestException ere) {
            PDTCoreUtils.logError(ere);
            return EMPTYFILTERS;
        }
        EStdLocalFilter[] array = reply.getFilterList();
        this._localFilters = new LocalFilter[array.length];
        int i = 0;
        while (i < array.length) {
            this._localFilters[i] = new LocalFilter(array[i], this);
            ++i;
        }
        return Arrays.copyOf(this._localFilters, this._localFilters.length);
    }

    public DebuggeeException[] getExceptions() {
        return this._exceptionInfo == null ? null : Arrays.copyOf(this._exceptionInfo, this._exceptionInfo.length);
    }

    void setExceptions(DebuggeeException[] exceptions) {
        this._exceptionInfo = exceptions;
    }

    public ViewInformation getViewInformation(short index) {
        return this.fSupportedViews[index];
    }

    public ViewInformation getViewInformationByType(short viewType) {
        if (this._viewsByType == null) {
            return null;
        }
        return this._viewsByType.get(viewType);
    }

    public ViewInformation getSourceViewInformation() {
        return this.getViewInformationByType((short)2);
    }

    public ViewInformation getDisassemblyViewInformation() {
        return this.getViewInformationByType((short)4);
    }

    public ViewInformation getMixedViewInformation() {
        return this.getViewInformationByType((short)3);
    }

    public ViewInformation getListingViewInformation() {
        return this.getViewInformationByType((short)5);
    }

    protected String getStmtNumber(EStdView location) {
        String stmtNum = null;
        if (this.getEngineSession().supportsStatementBreakpoints() && this.getEPDCVersion() > 305) {
            try {
                Part part = this._process.getPart(location.getPartID());
                View view = part.getView(location.getViewNum());
                ViewFile file = view.getViewFile(location.getSrcFileIndex());
                Line line = file.getLine(location.getLineNumber());
                String prefix = line.getPrefix(file.getPrefixLength());
                stmtNum = prefix.trim();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return stmtNum;
    }

    public Language getLanguageInfo(int id) {
        if (this._languages == null) {
            return null;
        }
        return this._languages.get(id);
    }

    void add(Language lang, int id) {
        if (this._languages == null) {
            this._languages = new HashMap();
        }
        this._languages.put(id, lang);
    }

    Representation getRepresentation(int index) {
        return this._repNames[index];
    }

    private void add(DebuggeeException exception, int index) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".add(DebuggeeException:" + exception.getName() + ", " + index + ")");
        }
        this._exceptionInfo[index] = exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackColumnDetails[] getStackDetails() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getStackDetails()");
        }
        Object object = this.fStackDetailLock;
        synchronized (object) {
            if (!this.fStackDetailsRetrieved) {
                ERepStackDetailsGet reply;
                this.fStackDetailsRetrieved = true;
                if (!this.getEngineSession().supportsStack()) {
                    return this.fStackDetailColumns;
                }
                try {
                    reply = (ERepStackDetailsGet)this.processRequest(new EReqStackDetailsGet(this.getEngineSession()));
                }
                catch (EngineRequestException ere) {
                    PDTCoreUtils.logError(ere);
                    return this.fStackDetailColumns;
                }
                ERepGetStackColumns[] epdcColumns = reply.getColumnInfo();
                this._defaultColumnIds = reply.getDefaultColumnIds();
                TreeMap<Integer, StackColumnDetails> stackDetailColumns = new TreeMap<Integer, StackColumnDetails>();
                int i = 0;
                while (i < epdcColumns.length) {
                    StackColumnDetails stackCol = new StackColumnDetails(epdcColumns[i], this);
                    stackDetailColumns.put(stackCol.getColumnID(), stackCol);
                    ++i;
                }
                i = 0;
                while (i < this._defaultColumnIds.length) {
                    StackColumnDetails stackColDetails = (StackColumnDetails)stackDetailColumns.get(this._defaultColumnIds[i]);
                    if (stackColDetails != null) {
                        stackColDetails.setDefault();
                    }
                    ++i;
                }
                this.fStackDetailColumns = stackDetailColumns.values().toArray(new StackColumnDetails[stackDetailColumns.size()]);
            }
            return this.fStackDetailColumns;
        }
    }

    protected GlobalRegisterGroup[] getGlobalRegisterGroups() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getGlobalRegisterGroups()");
        }
        if (!this.getEngineSession().supportsRegisters()) {
            return new GlobalRegisterGroup[0];
        }
        if (this._globalRegisterGroups == null) {
            ERepRegistersDetailsGet reply;
            try {
                reply = (ERepRegistersDetailsGet)this.processRequest(new EReqRegistersDetailsGet(this.getEngineSession()));
            }
            catch (EngineRequestException ere) {
                PDTCoreUtils.logError(ere);
                return new GlobalRegisterGroup[0];
            }
            ERepGetRegistersGroups[] registerGroups = reply.getRegisterGroups();
            int[] defaultGroupIds = reply.getDefaultGroupIds();
            this._globalRegisterGroups = new HashMap();
            int i = 0;
            while (i < registerGroups.length) {
                GlobalRegisterGroup regGroup = new GlobalRegisterGroup(registerGroups[i], this);
                this._globalRegisterGroups.put(registerGroups[i].getGroupID(), regGroup);
                ++i;
            }
            int j = 0;
            while (j < defaultGroupIds.length) {
                this.getGlobalRegisterGroup(defaultGroupIds[j]).setDefault();
                ++j;
            }
        }
        Collection<GlobalRegisterGroup> temp = this._globalRegisterGroups.values();
        return temp.toArray(new GlobalRegisterGroup[this._globalRegisterGroups.size()]);
    }

    protected GlobalRegisterGroup getGlobalRegisterGroup(int id) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getRegisterGroup(" + id + ")");
        }
        this.getGlobalRegisterGroups();
        if (this._globalRegisterGroups == null) {
            return null;
        }
        return this._globalRegisterGroups.get(id);
    }

    public Location switchView(Location sourceLocation, ViewInformation targetView) throws EngineRequestException {
        if (sourceLocation == null || !sourceLocation.isComplete() || targetView == null) {
            return null;
        }
        short viewNum = targetView.getViewNum();
        if (viewNum == sourceLocation.getView().getId()) {
            return sourceLocation;
        }
        ERepContextConvert reply = (ERepContextConvert)this.processRequest(new EReqContextConvert(sourceLocation.getEStdView(), viewNum, this.getEngineSession()));
        try {
            return new Location(this._process, reply.getContext());
        }
        catch (LocationConstructionException excp) {
            return null;
        }
    }

    public boolean commitPendingExceptionStateChanges(boolean saveAsDebuggerDefaults) throws EngineRequestException {
        this.changeExceptionStatus();
        return true;
    }

    public void changeExceptionStatus() throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".changeExceptionStatus()");
        }
        if (this._exceptionInfo != null && this._exceptionInfo.length != 0) {
            if (!this.getEngineSession().supportsExceptionFiltering()) {
                return;
            }
            int numExceptions = this._exceptionInfo.length;
            int[] flags = new int[numExceptions];
            int i = 0;
            while (i < numExceptions) {
                flags[i] = this._exceptionInfo[i].getPendingState();
                ++i;
            }
            this.processRequest(new EReqExceptionStatusChange(flags, this.getEngineSession()));
            i = 0;
            while (i < numExceptions) {
                this._exceptionInfo[i].commitPendingStateChange();
                ++i;
            }
        }
    }

    public DebuggeeStartupOptions getDebuggeeStartupOptions() {
        return this._debuggeeStartupOptions;
    }

    public Part[] loadParts(Module module, String name) throws EngineRequestException {
        EReqPartOpen request;
        ERepPartOpen reply;
        int[] epdcPartIDs;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".loadParts(" + name + ")");
        }
        int id = 0;
        if (module != null) {
            id = module.getId();
        }
        if ((epdcPartIDs = (reply = (ERepPartOpen)this.processRequest(request = new EReqPartOpen(id, name, this.getEngineSession()))).getPartIDs()) == null || epdcPartIDs.length == 0) {
            return null;
        }
        Part[] parts = new Part[epdcPartIDs.length];
        int i = 0;
        while (i < epdcPartIDs.length) {
            Part newPart;
            parts[i] = newPart = this.getProcess().getPart(epdcPartIDs[i]);
            ++i;
        }
        return parts;
    }

    public byte getDominantLanguage() {
        return this._dominantLanguage;
    }

    void saveErrorOccurredEventForFileNotFound(ErrorOccurredEvent event) {
        this._errorOccurredEventForFileNotFound = event;
    }

    void fireErrorOccurredEventForFileNotFound() {
        if (this._errorOccurredEventForFileNotFound != null) {
            this.fireEvent(this._errorOccurredEventForFileNotFound);
        }
    }

    public void setLocalSourcePath(String path) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".setLocalSourcePath(" + path + ")");
        }
        this._localSourcePath = path;
    }

    public String getLocalSourcePath() {
        if (this._localSourcePath == null || this._localSourcePath.length() == 0) {
            return null;
        }
        return this._localSourcePath;
    }

    public void updateEnginePaths(String searchPathString) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".updateEnginePaths(" + searchPathString + ")");
        }
        if (!this.getEngineSession().supportsUpdateEngineSearchPath()) {
            return;
        }
        if (searchPathString == null) {
            searchPathString = "";
        }
        EReqSourcePathUpdate request = new EReqSourcePathUpdate(searchPathString, this.getEngineSession());
        this.processRequest(request);
    }

    public void setModuleSideFileLocation(int moduleID, String moduleSideFileLocation) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".setModuleSideFileLocation(" + moduleID + " " + moduleSideFileLocation + ")");
        }
        if (!this.getEngineSession().supportsModuleSideFileUpdate()) {
            return;
        }
        if (moduleSideFileLocation == null) {
            moduleSideFileLocation = "";
        }
        EReqModuleSideFileUpdate request = new EReqModuleSideFileUpdate(moduleID, moduleSideFileLocation, this.getEngineSession());
        this.processRequest(request);
    }

    public boolean canBeReused() {
        return Model.willReuseDebugEngines();
    }

    public void addProgram(String programName, int programType) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".addProgram(" + programName + ", " + programType + ")");
        }
        if (!this.getEngineSession().supportsModuleAdd()) {
            return;
        }
        EReqModuleAdd request = new EReqModuleAdd(programName, programType, this.getEngineSession());
        this.processRequest(request);
    }

    public void removeProgram(Module module) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".removeProgram(" + module.getName() + ")");
        }
        if (!this.getEngineSession().supportsModuleRemove()) {
            return;
        }
        EReqModuleRemove request = new EReqModuleRemove(module.getId(), this.getEngineSession());
        this.processRequest(request);
    }

    public String[] getJobsList(String jobQualification) {
        ERepJobsListGet reply;
        EReqJobsListGet request = new EReqJobsListGet(jobQualification, this.getEngineSession());
        try {
            reply = (ERepJobsListGet)this.processRequest(request);
        }
        catch (EngineRequestException ere) {
            PDTCoreUtils.logError(ere);
            return new String[0];
        }
        String[] jobNames = reply.getJobNames();
        return jobNames;
    }

    public boolean isAcceptingRequests() {
        if (this._EPDCRequestProcessor == null) {
            return false;
        }
        return this._EPDCRequestProcessor.isAcceptingRequests();
    }

    public boolean isIdle() {
        if (this._EPDCRequestProcessor == null) {
            return false;
        }
        return this._EPDCRequestProcessor.isIdle();
    }

    public boolean isDateBreakpointsEnabled() {
        return this.fDateBreakpointsEnabled;
    }

    public boolean isAllEntryBreakpointsEnabled() {
        return this.fAllEntryBreakpointsEnabled;
    }

    public boolean isAllEntryBreakpointsInstalled() {
        return this.fAllEntryBreakpointsInstalled;
    }

    public void setAllEntryBreakpointsInstalled(boolean installed) {
        this.fAllEntryBreakpointsInstalled = installed;
        this.saveDebugObjects();
    }

    public boolean isZeroAddressBreakpointInstalled() {
        return this.fZeroAddressBreakpointInstalled;
    }

    public void setZeroAddressBreakpointInstalled(boolean installed) {
        this.fZeroAddressBreakpointInstalled = installed;
        this.saveDebugObjects();
    }

    public boolean setZeroAddressBreakpointEnabled(boolean enabled) throws EngineRequestException {
        if (this.getDebugTarget() instanceof PDTDebugTarget && ((PDTDebugTarget)this.getDebugTarget()).findZeroAddressBreakpoint() != null) {
            return false;
        }
        ((PDTDebugTarget)this.getDebugTarget()).createZeroAddressBreakpoint(enabled, new OptionalBreakpointData(), null);
        this.fZeroAddressBreakpointEnabled = enabled;
        this.saveDebugObjects();
        return true;
    }

    public boolean setDateBreakpointsEnabled(boolean enable) throws EngineRequestException {
        return this.setSpecialBreakpointsEnabled(enable, this.fAllEntryBreakpointsEnabled);
    }

    public boolean setAllEntryBreakpointsEnabled(boolean enable) throws EngineRequestException {
        return this.setSpecialBreakpointsEnabled(this.fDateBreakpointsEnabled, enable);
    }

    protected boolean setSpecialBreakpointsEnabled(boolean enableDateBreakpoints, boolean enableAllEntryBreakpoints) throws EngineRequestException {
        if (this.fDateBreakpointsEnabled == enableDateBreakpoints && this.fAllEntryBreakpointsEnabled == enableAllEntryBreakpoints) {
            return false;
        }
        EReqBreakpointEntryAutoSet2 request = new EReqBreakpointEntryAutoSet2(enableAllEntryBreakpoints, enableDateBreakpoints, this.getEngineSession());
        this.processRequest(request);
        this.fDateBreakpointsEnabled = enableDateBreakpoints;
        this.fAllEntryBreakpointsEnabled = enableAllEntryBreakpoints;
        this.saveDebugObjects();
        return true;
    }

    int getEPDCVersion() {
        return this._engineSession.getNegotiatedEPDCVersion();
    }

    public int getMaximumViewFileCacheSize() {
        return this._maximumViewFileCacheSize;
    }

    public void setMaximumViewFileCacheSize(int maximumViewFileCacheSize) {
        if (maximumViewFileCacheSize <= 0) {
            return;
        }
        this._maximumViewFileCacheSize = maximumViewFileCacheSize;
    }

    public int getMaxRetrieveLines() {
        if (this.getEngineSession().iszTPFengine() || this.getEngineSession().isTPF41engine()) {
            return 100;
        }
        return 2000;
    }

    @Override
    public final EPDC_EngineSession getEngineSession() {
        return this._engineSession;
    }

    public int[] getDefaultColumnIds() {
        if (this._defaultColumnIds == null) {
            this.getStackDetails();
        }
        return this._defaultColumnIds == null ? null : Arrays.copyOf(this._defaultColumnIds, this._defaultColumnIds.length);
    }

    public int getDefaultMemoryRep() {
        return this._defaultMemoryRep;
    }

    public void setDefaultMemoryRep(int defaultMemoryRep) {
        this._defaultMemoryRep = defaultMemoryRep;
    }

    public String getDbgProfileName(boolean qualified) {
        String baseName = "esro.@" + this._engineSession.getUniqueEngineKey();
        if (!qualified) {
            return baseName;
        }
        Object directoryName = this.getDebuggeeStartupOptions().getSaveRestoreDirectory();
        if (directoryName == null) {
            directoryName = "";
        } else {
            String fileSeparator = System.getProperty("file.separator");
            if (!((String)directoryName).endsWith(fileSeparator)) {
                directoryName = (String)directoryName + fileSeparator;
            }
        }
        return (String)directoryName + baseName;
    }

    public boolean saveDebugObjects() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".saveDebugObjects()");
        }
        GlobalProfile2 globalProfile = new GlobalProfile2(this);
        try {
            IPersister profilePersister = PDTCorePlugin.getPersister();
            IPath savePath = PDTCoreUtils.getProfileSaveRestorePath();
            profilePersister.save(globalProfile, savePath);
            return true;
        }
        catch (Exception ex) {
            String errorMsg = PDTCoreUtils.getSaveErrorMsg(globalProfile, ex);
            PDTCoreUtils.logString(this, errorMsg);
            return false;
        }
    }

    private boolean restoreDebugObjects(String profileName, int flags) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".restoreDebugObjects()");
        }
        GlobalProfile savedProfile = new GlobalProfile();
        try {
            savedProfile.read(profileName);
        }
        catch (ModelObjectInputStream.VersionException ve) {
            savedProfile = new GlobalProfile(20050502);
            try {
                savedProfile.read(profileName);
            }
            catch (Exception e) {
                return DebuggerProfileMigrator.restoreUsingOldProfile(this, ve.actualStreamVersion, profileName, flags);
            }
        }
        catch (ClassNotFoundException cnfe) {
            PDTCoreUtils.logString(this, "No profile will be loaded: unexpected layout for version = 20090819", 1, cnfe);
            return false;
        }
        catch (FileNotFoundException fnfe) {
            return DebuggerProfileMigrator.restoreUsingOldProfile(this, 20050502, profileName, flags);
        }
        catch (Exception e) {
            return false;
        }
        return savedProfile.restore(this, flags);
    }

    public boolean restoreDebugObjects(int flags) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".restoreDebugObjects()");
        }
        if ((flags & 0x1000000) != 0) {
            this.restoreExceptions(this.getEngineSession().getUniqueEngineKey(), this._exceptionInfo);
        }
        GlobalProfile2 savedProfile = new GlobalProfile2(this);
        IPersister profilePersister = PDTCorePlugin.getPersister();
        IPath restorePath = PDTCoreUtils.getProfileSaveRestorePath();
        Object restoredObject = null;
        try {
            restoredObject = profilePersister.restore(savedProfile, restorePath);
        }
        catch (Throwable ex1) {
            if (ex1 instanceof FileNotFoundException) {
                if (PDTCorePlugin.fProfile) {
                    PDTCoreUtils.logString(this, " Cannot find " + savedProfile.getFileName());
                }
                try {
                    restoredObject = this.restoreViaMigration(savedProfile, restorePath);
                }
                catch (Exception ex2) {
                    if (PDTCorePlugin.fProfile) {
                        PDTCoreUtils.logString(this, PDTCoreUtils.getRestoreErrorMsg(savedProfile, false, ex2));
                    }
                    String restoreFile = this.getDebugEngine().getDbgProfileName(true);
                    return this.restoreDebugObjects(restoreFile, flags);
                }
            }
            PDTCoreUtils.logString(this, PDTCoreUtils.getRestoreErrorMsg(savedProfile, true, ex1));
            return false;
        }
        if (restoredObject != null) {
            savedProfile = (GlobalProfile2)restoredObject;
            savedProfile.setReadComplete(true);
            return savedProfile.restore(this, flags);
        }
        return false;
    }

    private void restoreExceptions(String engineKey, DebuggeeException[] exceptions) {
        IPreferencesService prefService = Platform.getPreferencesService();
        String exceptionDefaults = prefService.getString("com.ibm.debug.pdt.core/exceptionsDefault", engineKey, "", null);
        if (PDTCoreUtils.isEmpty(exceptionDefaults)) {
            this.setGlobalExceptionDefaults(false);
            return;
        }
        int numExceptions = exceptions.length;
        boolean updateEngine = false;
        StringTokenizer st = new StringTokenizer(exceptionDefaults, ",");
        if (st.hasMoreTokens()) {
            if (Integer.parseInt(st.nextToken()) == numExceptions) {
                int i = 0;
                while (i < numExceptions) {
                    boolean enable;
                    boolean bl = enable = Integer.parseInt(st.nextToken()) == 1;
                    if (enable != exceptions[i].isEnabled()) {
                        exceptions[i].setEnable(enable);
                        exceptions[i].setDefaultEnabled(enable);
                        this.setGlobalExceptionDefaults(true);
                        updateEngine = true;
                    }
                    ++i;
                }
            } else {
                return;
            }
        }
        if (updateEngine) {
            try {
                this.changeExceptionStatus();
            }
            catch (EngineRequestException e1) {
                PDTCoreUtils.logString(this, "Problem restoring exception defaults", 2, e1);
            }
        }
    }

    public boolean isGlobalExceptionDefaults() {
        return this.fGlobalExceptionDefaults;
    }

    public void setGlobalExceptionDefaults(boolean set) {
        this.fGlobalExceptionDefaults = set;
    }

    private Object restoreViaMigration(GlobalProfile2 savedProfile, IPath restorePath) throws Exception {
        throw new Exception("XML Migration not implemented yet!");
    }

    void setProgramTerminating() {
        this.fProgramTerminating = true;
        if (this._EPDCRequestProcessor != null) {
            this._EPDCRequestProcessor.setProgramTerminating();
        }
    }

    public boolean isProgramTerminating() {
        return this.fProgramTerminating;
    }

    @Override
    protected void doCleanupDetails() {
        if (this._EPDCRequestProcessor != null) {
            this._EPDCRequestProcessor.cleanup();
        }
        this._EPDCRequestProcessor = null;
        this._localSourcePath = null;
        this._viewsByType = null;
        this.fSupportedViews = null;
        this._repNames = null;
        this.fStackDetailColumns = null;
        this._globalRegisterGroups = null;
        this._processListColumnDetails = null;
        this._debuggeeStartupOptions = null;
        this._errorOccurredEventForFileNotFound = null;
        if (this._cleanupProcess != null) {
            this._cleanupProcess.removeListener(this._cleanupStreamsProxy);
            this._cleanupStreamsProxy.cleanup();
        }
    }

    public int getCurrentThreadID() {
        DebuggeeThread currentThread = this.getCurrentThread();
        if (currentThread == null) {
            return 0;
        }
        return currentThread.getId();
    }

    public DebuggeeThread getCurrentThread() {
        DebuggeeThread currentThread = null;
        IPDTDebugTarget dbgTgt = (IPDTDebugTarget)this.getDebugTarget();
        currentThread = dbgTgt.getCurrentThread();
        if (!(currentThread != null && currentThread.getDebugTarget().equals(this.getDebugTarget()) || this.getProcess() == null)) {
            currentThread = this.getProcess().getStoppingThread();
        }
        return currentThread;
    }

    public EPDC_Reply processRequest(EPDC_Request request) throws EngineRequestException {
        return this.processRequest(request, this.getCurrentThreadID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EPDC_Reply processRequest(EPDC_Request request, int threadId) throws EngineRequestException {
        if (this._EPDCRequestProcessor == null) {
            throw new EngineConnectionException();
        }
        Object object = this.fMultiRequestLock;
        synchronized (object) {
            block5: {
                if (this.fMultiRequest == null) break block5;
                this.fMultiRequest.addRequest(request);
                return null;
            }
        }
        return this._EPDCRequestProcessor.processEPDCRequest(request, threadId);
    }

    public boolean startGroupRequest(int groupId) {
        return this._EPDCRequestProcessor.startGroupRequest(groupId);
    }

    public void endGroupRequest(int groupId) {
        this._EPDCRequestProcessor.endGroupRequest(groupId);
    }

    void processImmediateRequest(EPDC_Request request) throws EngineRequestException {
        this.processImmediateRequest(request, this.getCurrentThreadID());
    }

    void processImmediateRequest(EPDC_Request request, int tid) throws EngineRequestException {
        if (this._EPDCRequestProcessor == null) {
            throw new EngineConnectionException();
        }
        this._EPDCRequestProcessor.processImmediateEPDCRequest(request, tid);
    }

    public void setConnectionTerminated() {
        if (this._EPDCRequestProcessor != null) {
            this._EPDCRequestProcessor.setConnectionTerminated();
        }
    }

    @Override
    public void breakpointAdded(BreakpointAddedEvent event) {
    }

    @Override
    public void expressionAdded(ExpressionAddedEvent event) {
    }

    @Override
    public void moduleAdded(ModuleAddedEvent event) {
    }

    @Override
    public void processDetached(ProcessDetachedEvent event) {
    }

    @Override
    public void processEnded(ProcessEndedEvent event) {
        event.getProcess().removeListener(this);
        this._process = null;
    }

    @Override
    public void processStopped(ProcessStoppedEvent event) {
    }

    @Override
    public void programError(ProcessPgmError event) {
    }

    @Override
    public void programOutput(ProcessPgmOutput event) {
    }

    @Override
    public void threadAdded(ThreadAddedEvent event) {
    }

    protected boolean continueWaiting() {
        return ((IPDTDebugTarget)this.getDebugTarget()).continueWaiting();
    }

    public boolean canRestart() {
        return this._debuggeeStartupOptions instanceof DebuggeePrepareOptions;
    }

    public final String getUniqueEngineKey() {
        return this._engineSession.getUniqueEngineKey();
    }

    public int getFEFCT() {
        return this.fFEFCT;
    }

    public void setFEFCT(int flags) {
        this.fFEFCT = flags;
        if (PDTLicenseCheck.supportsClientLicenseCheck()) {
            this.fFEFCT |= 0x2000000;
        }
    }

    public int getCurrentGroupRequestId() {
        return this._EPDCRequestProcessor.getGroupId();
    }

    public void updateViewOrder() {
        int[] viewOrder = this.getRequestedViewOrder();
        if (viewOrder == null || viewOrder.length == 0) {
            return;
        }
        ViewInformation[] viNew = new ViewInformation[this.fSupportedViews.length];
        ERepGetViews[] gvNew = new ERepGetViews[this.fSupportedViews.length];
        ERepGetViews[] gvOriginal = this.getEngineSession().getViewInformation();
        viNew[0] = null;
        gvNew[0] = null;
        short toIndex = 1;
        int[] nArray = viewOrder;
        int n = viewOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int fromIndex = nArray[n2];
            viNew[toIndex] = this.fSupportedViews[fromIndex];
            viNew[toIndex].setViewNum(toIndex);
            gvNew[toIndex] = gvOriginal[fromIndex];
            toIndex = (short)(toIndex + 1);
            ++n2;
        }
        this.fSupportedViews = viNew;
        this.getEngineSession().setViewInformation(gvNew);
    }

    public int[] getRequestedViewOrder() {
        return this._engineSession.getRequestedViewOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMultipleRequest() {
        Object object = this.fMultiRequestLock;
        synchronized (object) {
            if (this.fMultiRequest != null) {
                this.endMultipleRequest(true);
            }
            this.fMultiRequest = new EReqMultiRequest(this.getEngineSession(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessingMultiRequest() {
        Object object = this.fMultiRequestLock;
        synchronized (object) {
            return this.fMultiRequest != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EPDC_Reply endMultipleRequest(boolean async) {
        EReqMultiRequest request;
        block7: {
            request = null;
            Object object = this.fMultiRequestLock;
            synchronized (object) {
                request = this.fMultiRequest;
                this.fMultiRequest = null;
            }
            try {
                if (!async || request == null) break block7;
                final EReqMultiRequest asyncRequest = request;
                if (request.getNumRequests() > 0) {
                    new Job("Processing multi request"){

                        protected IStatus run(IProgressMonitor arg0) {
                            try {
                                DebugEngine.this.processRequest(asyncRequest);
                            }
                            catch (EngineRequestException ere) {
                                PDTCoreUtils.logError(ere);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return null;
            }
            catch (EngineRequestException ere) {
                PDTCoreUtils.logError(ere);
                return null;
            }
        }
        return request == null ? null : this.processRequest(request);
    }

    public static class GlobalProfile
    extends DebuggerPersistentProfile {
        public static final int CURRENT_VERSION = 20090819;
        protected DebuggeeException[] fExceptionInfo;
        protected boolean fAllEntryBreakpointsEnabled;
        protected boolean fDateBreakpointsEnabled;
        protected boolean fEntryBreakpointsAutoSetInstalled;
        protected int fDefaultMemoryRep;
        protected boolean fTeamProfile;

        public GlobalProfile() {
            super(20090819);
        }

        public GlobalProfile(int version) {
            super(version);
        }

        public GlobalProfile(DebugEngine from) {
            super(20090819);
            this.fExceptionInfo = from._exceptionInfo;
            this.fAllEntryBreakpointsEnabled = from.fAllEntryBreakpointsEnabled;
            this.fEntryBreakpointsAutoSetInstalled = from.fAllEntryBreakpointsInstalled;
            this.fDateBreakpointsEnabled = from.fDateBreakpointsEnabled;
            this.fDefaultMemoryRep = from._defaultMemoryRep;
        }

        public GlobalProfile(String attributes) {
            super(20090819);
            try {
                StringTokenizer tokens = new StringTokenizer(attributes, ",");
                this.fAllEntryBreakpointsEnabled = Boolean.parseBoolean(tokens.nextToken());
                this.fDateBreakpointsEnabled = Boolean.parseBoolean(tokens.nextToken());
                this.fEntryBreakpointsAutoSetInstalled = Boolean.parseBoolean(tokens.nextToken());
                this.fDefaultMemoryRep = Integer.parseInt(tokens.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.fTeamProfile = true;
        }

        @Override
        protected void writeObjects(ObjectOutputStream out) throws IOException {
            out.writeObject(this.fExceptionInfo);
            out.writeBoolean(this.fAllEntryBreakpointsEnabled);
            out.writeBoolean(this.fDateBreakpointsEnabled);
            out.writeBoolean(this.fEntryBreakpointsAutoSetInstalled);
            out.writeInt(this.fDefaultMemoryRep);
        }

        @Override
        protected void readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.fExceptionInfo = (DebuggeeException[])in.readObject();
            this.fAllEntryBreakpointsEnabled = in.readBoolean();
            this.fDateBreakpointsEnabled = in.readBoolean();
            this.fEntryBreakpointsAutoSetInstalled = in.readBoolean();
            this.fDefaultMemoryRep = in.readInt();
        }

        public String getTeamDebugString() {
            StringBuilder attributes = new StringBuilder();
            attributes.append(this.fAllEntryBreakpointsEnabled);
            attributes.append(',');
            attributes.append(this.fDateBreakpointsEnabled);
            attributes.append(',');
            attributes.append(this.fEntryBreakpointsAutoSetInstalled);
            attributes.append(',');
            attributes.append(this.fDefaultMemoryRep);
            return attributes.toString();
        }

        public boolean restore(DebugEngine to, int flags) {
            if (!this.isReadComplete() && !this.fTeamProfile) {
                return false;
            }
            boolean completeSuccess = true;
            if ((flags & 0x1000000) != 0) {
                boolean bl = completeSuccess = completeSuccess ? this.restoreExceptions(to) : false;
            }
            if ((flags & 0x800000) != 0) {
                completeSuccess = completeSuccess ? this.restoreSpecialOptions(to) : false;
            }
            return completeSuccess;
        }

        protected boolean restoreExceptions(DebugEngine to) {
            if (this.fExceptionInfo == null || this.fExceptionInfo.length == 0) {
                return true;
            }
            if (this.fExceptionInfo.length != to.getExceptions().length) {
                return true;
            }
            boolean eok = true;
            DebuggeeException[] newExceptions = new DebuggeeException[this.fExceptionInfo.length];
            int i = 0;
            while (i < this.fExceptionInfo.length) {
                newExceptions[i] = new DebuggeeException(this.fExceptionInfo[i], to);
                ++i;
            }
            to.setExceptions(newExceptions);
            try {
                to.changeExceptionStatus();
            }
            catch (EngineRequestException e1) {
                eok = false;
            }
            return eok;
        }

        protected boolean restoreSpecialOptions(DebugEngine to) {
            to._defaultMemoryRep = this.fDefaultMemoryRep;
            try {
                if (to.getEngineSession().supportsEntryAutoSet() || to.getEngineSession().supportsDateBreakpoints()) {
                    to.setSpecialBreakpointsEnabled(this.fDateBreakpointsEnabled, this.fAllEntryBreakpointsEnabled);
                }
            }
            catch (EngineRequestException e1) {
                return false;
            }
            return true;
        }
    }
}

