/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.BreakpointChangedEvent;
import com.ibm.debug.pdt.internal.core.model.BreakpointDeletedEvent;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IBreakpointEventListener;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointClear;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointDisable;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointEnable;
import java.io.Serializable;
import java.util.Map;
import org.eclipse.core.resources.IMarker;

public abstract class Breakpoint
extends DebugModelObject
implements Serializable {
    private transient DebuggeeProcess _owningProcess;
    private transient boolean _saveInProfile = true;
    private transient IMarker fResourceMarker = null;
    private transient IMarker fWorkspaceMarker = null;
    private transient Map<Integer, Object> fProperties = null;
    protected ECPBreakpoint _epdcBkp;
    protected String _workingSetName;
    protected String _userLabel;
    protected String _stackPattern;
    protected boolean _isStackPatternEnabled;
    private static final long serialVersionUID = 20050124L;

    Breakpoint() {
    }

    Breakpoint(DebuggeeProcess owningProcess, ECPBreakpoint chgPkt, Map<Integer, Object> properties) {
        super(owningProcess.getDebugEngine());
        this._owningProcess = owningProcess;
        this.updateFields(chgPkt, properties);
    }

    void change(ECPBreakpoint chgPkt, Map<Integer, Object> properties) {
        this.updateFields(chgPkt, properties);
        this.addEvent(new BreakpointChangedEvent(this, this));
    }

    void updateFields(ECPBreakpoint chgPkt, Map<Integer, Object> properties) {
        Object stackPatternEnabled;
        this.updateProperties(properties);
        this._epdcBkp = chgPkt;
        if (this.getProperty(1) != null) {
            this.fResourceMarker = (IMarker)this.getProperty(1);
        }
        if (this.getProperty(6) != null) {
            this._userLabel = (String)this.getProperty(6);
        }
        if (this.isSaveInProfile() && this._epdcBkp.isDoNotRestore()) {
            this.setSaveInProfile(false);
        }
        if (this.getProperty(8) != null) {
            this._stackPattern = (String)this.getProperty(8);
        }
        if ((stackPatternEnabled = this.getProperty(9)) != null) {
            this._isStackPatternEnabled = Boolean.valueOf(stackPatternEnabled.toString());
        }
    }

    public void updateProperties(Map<Integer, Object> properties) {
        if (this.fProperties == null) {
            this.fProperties = properties;
        } else {
            this.fProperties.putAll(properties);
        }
    }

    public void addEventListener(IBreakpointEventListener eventListener) {
        this.addListener(eventListener);
    }

    public int getId() {
        return this._epdcBkp.getId();
    }

    public Object getProperty(int key) {
        if (this.fProperties != null) {
            return this.fProperties.get(key);
        }
        return null;
    }

    public DebuggeeProcess getProcess() {
        return this._owningProcess;
    }

    public void remove() throws EngineRequestException {
        this.remove(null);
    }

    public void remove(IMarker marker) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "[" + this.getId() + "].remove()");
        }
        EReqBreakpointClear request = new EReqBreakpointClear(this.getId(), this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(1, marker));
        this.getDebugEngine().processRequest(request);
    }

    void prepareToDie() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "[" + this.getId() + "].prepareToDie()");
        }
        this.addEvent(new BreakpointDeletedEvent(this, this));
    }

    public void setEnable(boolean enable) throws EngineRequestException {
        if (enable == this.isEnabled() || !this.getEngineSession().supportsEnableDisableBreakpoints()) {
            return;
        }
        if (enable) {
            this.getDebugEngine().processRequest(new EReqBreakpointEnable(this.getId(), this.getEngineSession()));
        } else {
            this.getDebugEngine().processRequest(new EReqBreakpointDisable(this.getId(), this.getEngineSession()));
        }
    }

    public boolean isEnabled() {
        return this._epdcBkp.isEnabled();
    }

    public boolean isDeferred() {
        return this._epdcBkp.isDeferred();
    }

    public boolean isCaseSensitive() {
        return this._epdcBkp.isCaseSensitive();
    }

    public boolean isStopSynchronous() {
        return this._epdcBkp.isStopSynchronous();
    }

    public boolean isAutoSetEntry() {
        return this._epdcBkp.isAutoSetEntry();
    }

    public boolean isReadOnly() {
        if (this.getEngineSession().supportsModifyingBreakpoints()) {
            return this._epdcBkp.isReadOnly();
        }
        return false;
    }

    public int getEveryVal() {
        return this._epdcBkp.getClause().getEveryVal();
    }

    public String getAddress() {
        return this._epdcBkp.getAddress();
    }

    public int getToVal() {
        return this._epdcBkp.getClause().getToVal();
    }

    public int getFromVal() {
        return this._epdcBkp.getClause().getFromVal();
    }

    public DebuggeeThread getThread() {
        return this._owningProcess.getThread(this._epdcBkp.getDU());
    }

    public int getThreadID() {
        return this._epdcBkp.getDU();
    }

    public String getConditionalExpression() {
        return this._epdcBkp.getExprString();
    }

    public String getBreakpointAction() {
        return this._epdcBkp.getBreakpointAction();
    }

    public String getWorkingSetName() {
        return this._workingSetName;
    }

    public void setWorkingSetName(String name) {
        this._workingSetName = name;
    }

    boolean restore(DebuggeeProcess targetProcess) {
        return false;
    }

    public boolean isSaveInProfile() {
        return this._saveInProfile;
    }

    public void setSaveInProfile(boolean saveInProfile) {
        this._saveInProfile = saveInProfile;
    }

    public void prepareToSave(boolean enable) {
        this._epdcBkp.overrideEnabled(enable);
    }

    public IMarker getResourceMarker() {
        return this.fResourceMarker;
    }

    public void setWorkspaceMarker(IMarker marker) {
        this.fWorkspaceMarker = marker;
    }

    public IMarker getWorkspaceMarker() {
        return this.fWorkspaceMarker;
    }

    public IMarker getMarker() {
        if (this.fResourceMarker != null) {
            return this.fResourceMarker;
        }
        return this.fWorkspaceMarker;
    }

    protected short getRequestAttributes() {
        short attributes = this.isEnabled() ? (short)Short.MIN_VALUE : 0;
        attributes = (short)(attributes | (this.isDeferred() ? 16384 : 0));
        attributes = (short)(attributes | (this.isCaseSensitive() ? 8192 : 0));
        return attributes;
    }

    public void setUserLabel(String userLabel) {
        this._userLabel = userLabel;
    }

    public String getUserLabel() {
        return this._userLabel;
    }

    public void setStackPattern(String stackPattern) {
        this._stackPattern = stackPattern;
    }

    public String getStackPattern() {
        return this._stackPattern;
    }

    public boolean isStackPatternEnabled() {
        return this._isStackPatternEnabled;
    }

    public void setStackPatternEnabled(boolean enabled) {
        this._isStackPatternEnabled = enabled;
    }
}

