/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.core.IAmbiguousMonitorHandler;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugEngineEventAdapter;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.IDebugEventProvider;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExpr2;
import com.ibm.debug.pdt.internal.epdc.ECPMonitorExprBase;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepContextQualGet;
import com.ibm.debug.pdt.internal.epdc.EReqContextQualGet;
import com.ibm.debug.pdt.internal.epdc.EReqExpression;
import com.ibm.debug.pdt.internal.epdc.EReqExpressionFree;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

class AmbiguousMonitoredExpressionHandler
extends DebugEngineEventAdapter
implements IDebugEventProvider {
    private IModelEventListener[] fEventListeners = new IModelEventListener[1];

    AmbiguousMonitoredExpressionHandler() {
    }

    @Override
    public void errorOccurred(final ErrorOccurredEvent event) {
        Job ambiguousMonReqJob = new Job(PICLLabels.AmbiguousMonitoredExpressionHandler_job){

            protected IStatus run(IProgressMonitor arg0) {
                boolean[] monitor;
                ERepContextQualGet reply;
                Object eventSource = event.getSource();
                if (!(eventSource instanceof DebugEngine)) {
                    return this.createErrorStatus();
                }
                DebugEngine engine = (DebugEngine)eventSource;
                EPDC_Request originalRequest = event.getRequest();
                if (!(originalRequest instanceof EReqExpression)) {
                    return this.createErrorStatus();
                }
                EReqExpression originalMonitoredExprRequest = (EReqExpression)originalRequest;
                EStdExpression2 expr = originalMonitoredExprRequest.getExpression();
                if (expr == null) {
                    return this.createErrorStatus();
                }
                EReqContextQualGet request = new EReqContextQualGet(expr.getContext(), engine.getEngineSession());
                try {
                    reply = (ERepContextQualGet)engine.processRequest(request);
                }
                catch (EngineRequestException e) {
                    return this.createErrorStatus();
                }
                int[] entryIDs = reply.getEntryIDs();
                if (entryIDs == null) {
                    return this.createErrorStatus();
                }
                IAmbiguousMonitorHandler handler = AmbiguousMonitoredExpressionHandler.getHandler();
                String[] monitorDescriptions = new String[entryIDs.length];
                EPDC_Reply[] epdcReplies = new EPDC_Reply[entryIDs.length];
                int[] matchingreplyId = new int[entryIDs.length];
                int numGoodEntries = 0;
                String errMsg = null;
                Object[] details = new Object[5];
                int i = 0;
                while (i < entryIDs.length) {
                    block23: {
                        expr.setEntryID(entryIDs[i]);
                        originalMonitoredExprRequest.setReply(null);
                        originalMonitoredExprRequest._replyReceived = false;
                        try {
                            epdcReplies[i] = engine.processRequest(originalMonitoredExprRequest);
                        }
                        catch (EngineRequestException e) {
                            if (errMsg == null) {
                                errMsg = e.getMessage();
                            }
                            break block23;
                        }
                        ECPMonitorExprBase monitorDetails = epdcReplies[i].getMonitorChanges()[0];
                        if (monitorDetails instanceof ECPMonitorExpr2) {
                            details[0] = ((ECPMonitorExpr2)monitorDetails).getExprNodes()[0].getType();
                            details[1] = ((ECPMonitorExpr2)monitorDetails).getExprNodes()[0].getName();
                        } else if (monitorDetails instanceof ECPMonitorExpr) {
                            details[0] = ((ECPMonitorExpr)monitorDetails).getExprTree().getType();
                            details[1] = ((ECPMonitorExpr)monitorDetails).getExprTree().getName();
                        }
                        details[2] = monitorDetails.getContext().getLineNumber();
                        details[3] = monitorDetails.getFileName();
                        details[4] = monitorDetails.getPartName();
                        monitorDescriptions[numGoodEntries] = NLS.bind((String)PICLLabels.AmbiguousMonitoredExpressionHandler_monitorDetails, (Object[])details);
                        matchingreplyId[numGoodEntries] = i;
                        ++numGoodEntries;
                    }
                    ++i;
                }
                if (numGoodEntries == 0) {
                    if (handler != null) {
                        handler.showErrorMessage(errMsg);
                    }
                    return Status.OK_STATUS;
                }
                if (numGoodEntries == 1) {
                    return Status.OK_STATUS;
                }
                if (handler != null) {
                    String[] goodMonitorDescriptions = new String[numGoodEntries];
                    int i2 = 0;
                    while (i2 < numGoodEntries) {
                        goodMonitorDescriptions[i2] = monitorDescriptions[i2];
                        ++i2;
                    }
                    monitor = handler.getSelectedMonitors(goodMonitorDescriptions);
                } else {
                    monitor = new boolean[numGoodEntries];
                    Arrays.fill(monitor, true);
                }
                i = 0;
                while (i < numGoodEntries) {
                    int matchingId;
                    if (!monitor[i] && epdcReplies[matchingId = matchingreplyId[i]] != null) {
                        EReqExpressionFree removeRequest = new EReqExpressionFree(((ECPMonitorExpr2)epdcReplies[matchingId].getMonitorChanges()[0]).getId(), engine.getEngineSession());
                        try {
                            engine.processRequest(removeRequest);
                        }
                        catch (EngineRequestException e) {
                            PDTCoreUtils.logString((Object)this, "Unable to remove ambiguous monitor.", 2, e);
                        }
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }

            private Status createErrorStatus() {
                return new Status(4, "com.ibm.debug.pdt.core", event.getMessage());
            }
        };
        ambiguousMonReqJob.schedule();
    }

    public static IAmbiguousMonitorHandler getHandler() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.core.ambiguousmonitorhandler");
        if (ep == null) {
            return null;
        }
        IConfigurationElement[] configElements = ep.getConfigurationElements();
        if (configElements.length == 0) {
            return null;
        }
        try {
            IAmbiguousMonitorHandler handler = (IAmbiguousMonitorHandler)configElements[0].createExecutableExtension("class");
            return handler;
        }
        catch (CoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
            return null;
        }
    }

    @Override
    public IModelEventListener[] getListeners() {
        return this.fEventListeners;
    }

    @Override
    public void addListener(IModelEventListener listener) {
        this.fEventListeners[0] = listener;
    }

    @Override
    public void removeListener(IModelEventListener listener) {
        this.fEventListeners[0] = null;
    }
}

