/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugEngineEventAdapter;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.IDebugEventProvider;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepContextQualGet;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.EReqContextQualGet;
import com.ibm.debug.pdt.internal.epdc.EStdView;

class AmbiguousBreakpointHandler
extends DebugEngineEventAdapter
implements IDebugEventProvider {
    private IModelEventListener[] fEventListeners = new IModelEventListener[1];

    AmbiguousBreakpointHandler() {
    }

    @Override
    public void errorOccurred(ErrorOccurredEvent event) {
        Object eventSource = event.getSource();
        if (!(eventSource instanceof DebugEngine)) {
            return;
        }
        DebugEngine engine = (DebugEngine)eventSource;
        EPDC_Request originalRequest = event.getRequest();
        if (!(originalRequest instanceof EReqBreakpointLocation)) {
            return;
        }
        EReqBreakpointLocation originalBreakpointRequest = (EReqBreakpointLocation)originalRequest;
        EStdView breakpointContext = originalBreakpointRequest.getBkpContext();
        try {
            EReqContextQualGet request = new EReqContextQualGet(breakpointContext, engine.getEngineSession());
            ERepContextQualGet reply = (ERepContextQualGet)engine.processRequest(request);
            int[] entryIDs = reply.getEntryIDs();
            if (entryIDs == null) {
                return;
            }
            int i = 0;
            while (i < entryIDs.length) {
                originalBreakpointRequest.setEntryID(entryIDs[i]);
                engine.processRequest(originalBreakpointRequest);
                ++i;
            }
        }
        catch (EngineRequestException ere) {
            return;
        }
    }

    @Override
    public IModelEventListener[] getListeners() {
        return this.fEventListeners;
    }

    @Override
    public void addListener(IModelEventListener listener) {
        this.fEventListeners[0] = listener;
    }

    @Override
    public void removeListener(IModelEventListener listener) {
        this.fEventListeners[0] = null;
    }
}

