/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.model;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointAddress;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.Map;

public class AddressBreakpoint
extends LocationBreakpoint {
    private static final long serialVersionUID = 20050525L;

    AddressBreakpoint() {
    }

    public AddressBreakpoint(DebuggeeProcess owningProcess, ECPBreakpoint epdcBkp, Map<Integer, Object> properties) {
        super(owningProcess, epdcBkp, properties);
    }

    public void modify(String addrOrExpr, Location loc, OptionalBreakpointData optData) throws EngineRequestException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".modify()");
        }
        if (!optData.areAllOptionalDataSupported(this.getEngineSession()) || !this.getEngineSession().supportsModifyingBreakpoints() || this.isReadOnly()) {
            return;
        }
        short attributes = this.getRequestAttributes();
        attributes = (short)(attributes | optData.getSyncStopControlAttribute());
        EEveryClause everyClause = optData.getEEveryClause();
        EStdView context = null;
        if (loc != null && loc.isComplete()) {
            context = loc.getEStdView();
        }
        EStdExpression2 conditionalExpr = optData.getEStdExpression2(context, this.getEngineSession());
        EReqBreakpointAddress request = new EReqBreakpointAddress(attributes, everyClause, addrOrExpr, null, null, null, conditionalExpr, optData.getThreadId(), this._epdcBkp.getId(), context, optData.getBreakpointAction(), this.getEngineSession());
        request.putProperty(new EPDC_Request.EProperty(6, optData.getUserLabel()));
        this.getDebugEngine().processRequest(request);
    }

    @Override
    public String getAddress() {
        return this._epdcBkp.getAddress();
    }

    @Override
    boolean restore(DebuggeeProcess targetProcess) {
        return this.restore(targetProcess, new EPDC_Request.EProperty(3, this.getWorkingSetName()));
    }

    boolean restore(DebuggeeProcess targetProcess, EPDC_Request.EProperty property) {
        try {
            targetProcess.setAddressBreakpoint(this.isEnabled(), this._epdcBkp.getAddress(), null, new OptionalBreakpointData(this), property);
            return true;
        }
        catch (EngineRequestException e) {
            return false;
        }
    }

    @Override
    protected void doCleanupDetails() {
    }
}

