/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.launch;

import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.IDebugSessionStartupInfo;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;

public abstract class PICLAbstractStartupInfo
implements IDebugSessionStartupInfo {
    public static final int STOP_IMMEDIATELY = -1;
    public static final int DEBUG_INITIALIZATION = 0;
    public static final int RUN_TO_MAIN = 1;
    public static final int RUN_TO_BREAKPOINT = 2;
    private IProject fProject;
    private ILaunchConfiguration fLaunchConfig;
    private String fTitle;
    private byte fLanguage = (byte)2;
    private URL fProfilePath = null;
    private Socket fSocket;
    private boolean fEngineWaiting;
    private int fStartupBehaviour;
    private EngineParameters fEngineParms;
    private int[] fViewOrder;
    private boolean fAuthenticateSession = false;
    private String fUserId;
    private char[] fPassword;
    private Properties fProperites = new Properties();

    public PICLAbstractStartupInfo() {
    }

    public PICLAbstractStartupInfo(EngineParameters engineParms) {
        this.fEngineParms = engineParms;
        this.fTitle = engineParms.getTitle();
        this.fAuthenticateSession = engineParms.isSecure();
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    public void setLaunchConfig(ILaunchConfiguration config) {
        this.fLaunchConfig = config;
    }

    @Override
    public ILaunchConfiguration getLaunchConfig() {
        return this.fLaunchConfig;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    public byte getLanguage() {
        return this.fLanguage;
    }

    public void setLanguage(byte language) {
        this.fLanguage = language;
    }

    public URL getProfilePath() {
        return this.fProfilePath;
    }

    public void setProfilePath(URL profilePath) {
        this.fProfilePath = profilePath;
    }

    @Override
    public Socket getEngineConnection() {
        return this.fSocket;
    }

    public void setEngineConnection(Socket socket) {
        this.fSocket = socket;
    }

    public void setEngineWaiting(boolean waiting) {
        this.fEngineWaiting = true;
    }

    public boolean isEngineWaiting() {
        return this.fEngineWaiting;
    }

    public void setStartupBehaviour(int startupBehaviour) {
        this.fStartupBehaviour = startupBehaviour;
    }

    public int getStartupBehaviour() {
        return this.fStartupBehaviour;
    }

    public EngineParameters getEngineParms() {
        return this.fEngineParms;
    }

    public void setEngineParms(EngineParameters parms) {
        this.fEngineParms = parms;
    }

    public boolean isAuthenticateSession() {
        return this.fAuthenticateSession;
    }

    public void setAuthenticateSession(boolean authenticateSession) {
        this.fAuthenticateSession = authenticateSession;
    }

    public String getUserId() {
        return this.fUserId;
    }

    public void setUserId(String userId) {
        this.fUserId = userId;
    }

    public char[] getPassword() {
        return this.fPassword;
    }

    public void setPassword(char[] password) {
        this.fPassword = password;
    }

    @Override
    public Properties getProperties() {
        return this.fProperites;
    }

    public boolean isAttach() {
        return false;
    }

    public boolean isCodeCoverage() {
        if (this.fEngineParms == null) {
            return false;
        }
        String startupKey = this.fEngineParms.getStartupKey();
        if (startupKey == null) {
            return false;
        }
        return startupKey.toUpperCase().startsWith("CC");
    }

    public boolean isRecording() {
        if (this.fEngineParms == null) {
            return false;
        }
        String startupKey = this.fEngineParms.getStartupKey();
        if (startupKey == null) {
            return false;
        }
        return startupKey.toUpperCase().startsWith("REC");
    }

    public void setViewOrder(int[] viewOrder) {
        if (viewOrder == null) {
            return;
        }
        this.fViewOrder = Arrays.copyOf(viewOrder, viewOrder.length);
    }

    public int[] getViewOrder() {
        if (this.fViewOrder == null) {
            return null;
        }
        return Arrays.copyOf(this.fViewOrder, this.fViewOrder.length);
    }
}

