/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.engine;

import com.ibm.debug.pdt.internal.core.engine.EngineIdentifier;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class EngineSupport {
    private static EngineIdentifier[] fSupportedEngines = null;
    private static final EngineIdentifier[] EMPTYENGINES = new EngineIdentifier[0];

    private static EngineIdentifier[] getSupportedEnginesList() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.core.enginesupport");
        if (extensionPoint == null) {
            return EMPTYENGINES;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        ArrayList<EngineIdentifier> supportedEngines = new ArrayList<EngineIdentifier>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                short type = Short.parseShort(iConfigurationElement.getAttribute("type"));
                short os = Short.parseShort(iConfigurationElement.getAttribute("os"));
                short hardware = Short.parseShort(iConfigurationElement.getAttribute("hw"));
                EngineIdentifier engine = new EngineIdentifier(type, os, hardware);
                supportedEngines.add(engine);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        if (supportedEngines.isEmpty()) {
            return EMPTYENGINES;
        }
        return supportedEngines.toArray(new EngineIdentifier[supportedEngines.size()]);
    }

    public static boolean isEngineSupported(DebugEngine engine) {
        if (engine == null) {
            return false;
        }
        EngineIdentifier engineId = new EngineIdentifier(engine);
        if (fSupportedEngines == null) {
            fSupportedEngines = EngineSupport.getSupportedEnginesList();
        }
        EngineIdentifier[] engineIdentifierArray = fSupportedEngines;
        int n = fSupportedEngines.length;
        int n2 = 0;
        while (n2 < n) {
            EngineIdentifier engineIdentifier = engineIdentifierArray[n2];
            if (engineId.equals(engineIdentifier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

