/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.engine;

import com.ibm.debug.pdt.internal.core.model.DebugEngine;

public class EngineIdentifier {
    public static final short ANY = -1;
    private short fEngineType = 0;
    private short fPlatformOS = 0;
    private short fPlatformHW = 0;

    public EngineIdentifier(short engineType, short platformOS, short platformHW) throws IllegalArgumentException {
        this.set(engineType, platformOS, platformHW);
    }

    public EngineIdentifier(DebugEngine engine) throws IllegalArgumentException, NullPointerException {
        if (engine == null) {
            throw new NullPointerException();
        }
        int engineType = engine.getEngineID();
        int platformOS = engine.getEngineSession().getEngineOS();
        int platformHW = engine.getEngineSession().getEngineHardware();
        this.set((short)engineType, (short)platformOS, (short)platformHW);
    }

    protected void set(short engineType, short platformOS, short platformHW) throws IllegalArgumentException {
        if (engineType < -1 || engineType >= 12) {
            throw new IllegalArgumentException();
        }
        this.fEngineType = engineType;
        if (platformOS < -1 || platformOS >= 15) {
            throw new IllegalArgumentException();
        }
        this.fPlatformOS = platformOS;
        if (platformHW < -1 || platformHW >= 11) {
            throw new IllegalArgumentException();
        }
        this.fPlatformHW = platformHW;
    }

    public short getEngineType() {
        return this.fEngineType;
    }

    public short getPlatformHW() {
        return this.fPlatformHW;
    }

    public short getPlatformOS() {
        return this.fPlatformOS;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EngineIdentifier)) {
            return false;
        }
        EngineIdentifier engine = (EngineIdentifier)obj;
        if (this.fEngineType != -1 && engine.getEngineType() != -1 && this.fEngineType != engine.getEngineType()) {
            return false;
        }
        if (this.fPlatformOS != -1 && engine.getPlatformOS() != -1 && this.fPlatformOS != engine.getPlatformOS()) {
            return false;
        }
        return this.fPlatformHW == -1 || engine.getPlatformHW() == -1 || this.fPlatformHW == engine.getPlatformHW();
    }

    public int hashCode() {
        return super.hashCode() + this.fEngineType + this.fPlatformHW + this.fPlatformOS;
    }
}

