/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core.breakpoints;

import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.AddressRangeBreakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EnhancedWatchpoint;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.MacroBreakpoint;
import com.ibm.debug.pdt.internal.core.model.ModuleLoadBreakpoint;
import com.ibm.debug.pdt.internal.core.model.OccurrenceBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.core.model.ZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.epdc.ECPBreakpoint;
import java.util.Map;

public class BreakpointFactory {
    public LocationBreakpoint createLineBreakpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        return new LineBreakpoint(process, bkptChgItem, properties);
    }

    public LocationBreakpoint createMacroBreakpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        return new MacroBreakpoint(process, bkptChgItem, properties);
    }

    public LocationBreakpoint createEntryBreakpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        return new EntryBreakpoint(process, bkptChgItem, properties);
    }

    public LocationBreakpoint createAddressBreakpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        if (bkptChgItem.getAddress().contains(";")) {
            return new AddressRangeBreakpoint(process, bkptChgItem, properties);
        }
        return new AddressBreakpoint(process, bkptChgItem, properties);
    }

    public EventBreakpoint createWatchpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        return new Watchpoint(process, bkptChgItem, properties);
    }

    public EventBreakpoint createModuleLoadBreakpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties, boolean runToEntry) {
        return new ModuleLoadBreakpoint(process, bkptChgItem, properties, runToEntry);
    }

    public EventBreakpoint createEnhancedWatchpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        return new EnhancedWatchpoint(process, bkptChgItem, properties);
    }

    public EventBreakpoint createOccurrenceBreakpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        return new OccurrenceBreakpoint(process, bkptChgItem, properties);
    }

    public EventBreakpoint createZeroAddressBreakpoint(DebuggeeProcess process, ECPBreakpoint bkptChgItem, Map<Integer, Object> properties) {
        return new ZeroAddressBreakpoint(process, bkptChgItem, properties);
    }
}

