/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.IPICLStreamProxyListener;
import com.ibm.debug.pdt.internal.core.PICLStreamMonitor;
import com.ibm.debug.pdt.internal.core.model.BreakpointAddedEvent;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExpressionAddedEvent;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.ModuleAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessDetachedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmError;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmOutput;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadAddedEvent;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;

public class PICLStreamsProxy
implements IStreamsProxy,
IProcessEventListener {
    private DebuggeeProcess fProcess = null;
    private PICLStreamMonitor fOutputStreamMonitor = new PICLStreamMonitor(this);
    private PICLStreamMonitor fErrorStreamMonitor = new PICLStreamMonitor(this);
    private boolean fSupported = false;
    private boolean fSupportsAsync = false;
    private Vector<IPICLStreamProxyListener> fInputListeners;

    public PICLStreamsProxy(DebuggeeProcess process) {
        this.fProcess = process;
        EPDC_EngineSession engineSession = this.fProcess.getEngineSession();
        this.fSupported = engineSession.supportsProgramIO();
        this.fSupportsAsync = engineSession.supportsAsync();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.fErrorStreamMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.fOutputStreamMonitor;
    }

    public void write(String input) throws IOException {
        if (this.fSupported && this.fSupportsAsync) {
            try {
                this.fProcess.programInput(input);
            }
            catch (EngineRequestErrorException ere) {
                throw new IOException(ere.getMessage());
            }
            catch (EngineRequestException e) {
                throw new IOException();
            }
        }
        if (this.fInputListeners != null) {
            Iterator<IPICLStreamProxyListener> iter = this.fInputListeners.iterator();
            while (iter.hasNext()) {
                iter.next().write(input, this);
            }
        }
    }

    @Override
    public void breakpointAdded(BreakpointAddedEvent event) {
    }

    @Override
    public void moduleAdded(ModuleAddedEvent event) {
    }

    @Override
    public void expressionAdded(ExpressionAddedEvent event) {
    }

    @Override
    public void processEnded(ProcessEndedEvent event) {
    }

    @Override
    public void processDetached(ProcessDetachedEvent event) {
    }

    @Override
    public void processStopped(ProcessStoppedEvent event) {
    }

    @Override
    public void threadAdded(ThreadAddedEvent event) {
    }

    @Override
    public void programError(ProcessPgmError event) {
        String[] lines = event.getLines();
        if (lines == null) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            if (lines[i] != null) {
                this.fErrorStreamMonitor.writeText(lines[i] + "\n");
            }
            ++i;
        }
    }

    @Override
    public void programOutput(ProcessPgmOutput event) {
        String[] lines = event.getLines();
        if (lines == null) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            if (lines[i] != null) {
                this.fOutputStreamMonitor.writeText(lines[i] + "\n");
            }
            ++i;
        }
    }

    public boolean isSupported() {
        return this.fSupported;
    }

    public void addInputListener(IPICLStreamProxyListener listener) {
        if (this.fInputListeners == null) {
            this.fInputListeners = new Vector();
        }
        if (this.fInputListeners.contains(listener)) {
            return;
        }
        this.fInputListeners.add(listener);
    }

    public void removeInputListener(IPICLStreamProxyListener listener) {
        if (this.fInputListeners != null) {
            this.fInputListeners.remove(listener);
        }
    }

    public void cleanup() {
        if (this.fInputListeners != null) {
            this.fInputListeners.removeAllElements();
            this.fInputListeners = null;
        }
    }
}

