/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLRegister;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.IRegisterGroupEventListener;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegister;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.RegisterAddedEvent;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IThread;

public class PICLRegisterGroup
extends PDTDebugElement
implements IRegisterGroup,
IRegisterGroupEventListener {
    private DebuggeeThread fThread = null;
    private MonitoredRegisterGroup fMonitoredRegisterGroup = null;
    private PICLRegister[] fRegisters;
    private static final IRegister[] EMPTYREGISTERS = new IRegister[0];

    public PICLRegisterGroup(DebuggeeThread thread, MonitoredRegisterGroup registerGroup, IDebugTarget debugTarget) {
        super(debugTarget, ((PDTDebugTarget)debugTarget).getDebugEngine());
        this.fThread = thread;
        this.fMonitoredRegisterGroup = registerGroup;
        this.fMonitoredRegisterGroup.addEventListener(this);
    }

    @Override
    public String getLabel() {
        if (this.haveDoneCleanup()) {
            return "";
        }
        String name = this.fMonitoredRegisterGroup.getName();
        if (name != null && name.length() != 0) {
            return name;
        }
        return PICLLabels.picl_stack_frame_label_unknown;
    }

    public IThread getThread() {
        return this.fThread;
    }

    @Override
    protected void doCleanupDetails() {
    }

    public String getName() throws DebugException {
        return this.getLabel();
    }

    public synchronized IRegister[] getRegisters() throws DebugException {
        if (this.haveDoneCleanup()) {
            return EMPTYREGISTERS;
        }
        if (this.fRegisters != null) {
            return this.fRegisters;
        }
        MonitoredRegister[] registers = this.fMonitoredRegisterGroup.getRegisters();
        Arrays.sort(registers, new Comparator<MonitoredRegister>(){

            @Override
            public int compare(MonitoredRegister register1, MonitoredRegister register2) {
                return register1.getId() - register2.getId();
            }
        });
        this.fRegisters = new PICLRegister[registers.length];
        int i = 0;
        while (i < registers.length) {
            this.fRegisters[i] = new PICLRegister(this, registers[i], this.getDebugTarget());
            ++i;
        }
        return this.fRegisters;
    }

    public boolean hasRegisters() throws DebugException {
        return true;
    }

    @Override
    public void resetChanged() {
        if (this.fRegisters != null) {
            int i = 0;
            while (i < this.fRegisters.length) {
                this.fRegisters[i].resetChanged();
                ++i;
            }
        }
    }

    public int getId() {
        return this.fMonitoredRegisterGroup.getId();
    }

    public MonitoredRegisterGroup getMonitoredRegisterGroup() {
        return this.fMonitoredRegisterGroup;
    }

    public boolean hasRetrievedRegisters() {
        return this.fRegisters != null;
    }

    public void clearRegisters() {
        this.fRegisters = null;
    }

    @Override
    public void registerAdded(RegisterAddedEvent event) {
        this.fRegisters = null;
    }
}

