/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.IPDTDebugTracer;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracerTarget;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLRegisterGroup;
import com.ibm.debug.pdt.internal.core.PICLRegisterValue;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IRegisterEventListener;
import com.ibm.debug.pdt.internal.core.model.MonitoredRegister;
import com.ibm.debug.pdt.internal.core.model.RegisterChangedEvent;
import com.ibm.debug.pdt.internal.core.model.RegisterEndedEvent;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;

public class PICLRegister
extends PDTDebugElement
implements IRegister,
IRegisterEventListener {
    private MonitoredRegister fMonitoredRegister = null;
    private PICLRegisterValue fRegisterValue = null;

    protected PICLRegister(PDTDebugElement parent, MonitoredRegister monitoredRegister, IDebugTarget debugTarget) {
        super(debugTarget, ((PDTDebugTarget)debugTarget).getDebugEngine(), parent);
        this.fMonitoredRegister = monitoredRegister;
        this.fMonitoredRegister.addEventListener(this);
    }

    @Override
    public String getLabel() {
        try {
            return this.getName() + " = " + this.getValue().getValueString();
        }
        catch (DebugException de) {
            return PICLLabels.picl_register_no_label;
        }
    }

    @Override
    protected void doCleanupDetails() {
        if (this.fMonitoredRegister != null) {
            this.fMonitoredRegister.removeListener(this);
        }
    }

    public String getReferenceTypeName() throws DebugException {
        return "";
    }

    public IValue getValue() throws DebugException {
        if (this.haveDoneCleanup()) {
            return null;
        }
        if (this.fRegisterValue == null) {
            this.fRegisterValue = new PICLRegisterValue(this.fMonitoredRegister);
        }
        return this.fRegisterValue;
    }

    public String getName() throws DebugException {
        if (this.haveDoneCleanup()) {
            return "";
        }
        if (!this.fMonitoredRegister.getName().isEmpty()) {
            return this.fMonitoredRegister.getName();
        }
        return PICLLabels.picl_register_no_label;
    }

    public void setValue(String expression) throws DebugException {
        try {
            if (this.getDebugTarget() instanceof IPDTDebugTracerTarget) {
                IPDTDebugTracer[] tracerClasses;
                IPDTDebugTracer[] iPDTDebugTracerArray = tracerClasses = ((IPDTDebugTracerTarget)this.getDebugTarget()).getDebugTracers();
                int n = tracerClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDTDebugTracer tracerClass = iPDTDebugTracerArray[n2];
                    tracerClass.traceUserAction(this, (short)0, new String[]{expression});
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
        try {
            this.fMonitoredRegister.modifyValue(expression);
        }
        catch (EngineRequestException ere) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", ere.getMessage()));
        }
        ((PDTDebugTarget)this.getDebugTarget()).markMemBlksChanged(true);
    }

    public boolean supportsValueModification() {
        return this.fMonitoredRegister.supportsModifying();
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    @Override
    public void registerEnded(RegisterEndedEvent event) {
        event.getRegister().removeListener(this);
    }

    @Override
    public void registerChanged(RegisterChangedEvent event) {
        this.setChanged();
        this.fireChangeEvent(256);
    }

    public IThread getThread() {
        return ((PICLRegisterGroup)this.getParentElement()).getThread();
    }

    public IRegisterGroup getRegisterGroup() throws DebugException {
        return (IRegisterGroup)this.getParentElement();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.isChanged();
    }
}

