/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionChangedEvent;
import com.ibm.debug.pdt.internal.core.model.ExpressionEndedEvent;
import com.ibm.debug.pdt.internal.core.model.IExpressionEventListener;
import com.ibm.debug.pdt.internal.core.model.PDTPendingVariable;
import org.eclipse.debug.core.model.IDebugTarget;

public class PICLMonitorParent
extends PDTDebugElement
implements IExpressionEventListener {
    private static final Object[] NOELEMENTS = new Object[0];
    private Object[] fExpandedElements = NOELEMENTS;
    private PDTPendingVariable fPendingVariable;

    PICLMonitorParent(IDebugTarget debugTarget, DebugEngine debugEngine) {
        super(debugTarget, debugEngine);
        this.fPendingVariable = new PDTPendingVariable(debugTarget);
    }

    public void addExpression(ExpressionBase expression) {
        this.addChild(expression, true);
        expression.addEventListener(this);
    }

    public void setExpandedElements(Object[] state) {
        this.fExpandedElements = state;
    }

    public Object[] getExpandedElements() {
        return this.fExpandedElements;
    }

    @Override
    protected void doCleanupDetails() {
    }

    @Override
    public void expressionEnded(ExpressionEndedEvent event) {
        ExpressionBase expr = event.getExpression();
        expr.removeListener(this);
        this.removeChild(event.getExpression(), true);
    }

    @Override
    public void expressionChanged(ExpressionChangedEvent event) {
    }

    @Override
    public void removeAllChildren() {
        PDTDebugElement[] exprs = super.getChildrenNoExpand();
        int i = 0;
        while (i < exprs.length) {
            try {
                ((ExpressionBase)exprs[i]).remove();
            }
            catch (EngineRequestException engineRequestException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public PDTDebugElement[] getChildren() {
        return this.getChildrenNoExpand();
    }

    @Override
    public PDTDebugElement[] getChildrenNoExpand() {
        PDTDebugElement[] exprs;
        try {
            exprs = super.getChildren();
        }
        catch (EngineRequestException e) {
            return EMPTYCHILDREN;
        }
        PDTDebugElement[] rootNodes = new ExprNodeBase[exprs.length];
        int i = 0;
        while (i < exprs.length) {
            rootNodes[i] = ((ExpressionBase)exprs[i]).getRootNode();
            ++i;
        }
        return rootNodes;
    }

    @Override
    public String getLabel() {
        return this.getClass().getName();
    }

    public PDTPendingVariable getPendingVariable() {
        return this.fPendingVariable;
    }

    public void clearChildren() {
        PDTDebugElement[] children = super.getChildrenNoExpand();
        int i = 0;
        while (i < children.length) {
            this.removeChild(children[i], false);
            ++i;
        }
    }
}

