/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IModuleEventListener;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.ModuleUnloadedEvent;
import com.ibm.debug.pdt.internal.core.model.PartAddedEvent;
import com.ibm.debug.pdt.internal.core.model.PartDeletedEvent;
import org.eclipse.debug.core.model.IDebugTarget;

public class PICLModuleParent
extends PDTDebugElement
implements IModuleEventListener {
    private static final Object[] EMPTYELEMENTS = new Object[0];
    private Object[] fExpandedElements = EMPTYELEMENTS;

    public PICLModuleParent(PDTDebugElement parent, IDebugTarget debugTarget) {
        super(debugTarget, ((PDTDebugTarget)debugTarget).getDebugEngine(), parent);
    }

    @Override
    protected void doCleanupDetails() {
        PDTDebugElement[] modules;
        try {
            modules = this.getChildren();
        }
        catch (EngineRequestException e) {
            return;
        }
        int i = 0;
        while (i < modules.length) {
            ((PICLModule)modules[i]).getModule().removeListener(this);
            ++i;
        }
    }

    @Override
    public String getLabel() {
        return "PICLModuleParent label";
    }

    public void addModule(Module module) {
        if (this.getEngineSession().supportsModules()) {
            module.addEventListener(this);
            this.addChild(new PICLModule(this, module, this.getDebugTarget()), true);
        }
    }

    @Override
    public void partAdded(PartAddedEvent event) {
    }

    @Override
    public void partDeleted(PartDeletedEvent event) {
    }

    @Override
    public void moduleUnloaded(ModuleUnloadedEvent event) {
        PDTDebugElement[] piclModules;
        Module deletedModule = event.getModule();
        PDTDebugElement[] pDTDebugElementArray = piclModules = this.getChildrenNoExpand();
        int n = piclModules.length;
        int n2 = 0;
        while (n2 < n) {
            PDTDebugElement piclModule = pDTDebugElementArray[n2];
            if (((PICLModule)piclModule).getModule().equals(deletedModule)) {
                this.removeChild(piclModule, this.getEngineSession().supportsModules());
                break;
            }
            ++n2;
        }
    }

    public void saveExpandedElements(Object[] elements) {
        this.fExpandedElements = elements == null ? EMPTYELEMENTS : elements;
    }

    public Object[] getExpandedElements() {
        return this.fExpandedElements;
    }

    public void clearChildren() {
        this.removeAllChildren();
    }
}

