/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.IDebugActionRecorder;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;

public class PDTRecorderManager {
    private static final String DEBUG_ACTION_RECORDER = "debugactionrecorder";
    private static final String ATTR_CLASS = "class";
    private IDebugActionRecorder[] fRecorders = null;
    private static PDTRecorderManager fInstance = null;
    private static Object fLock = new Object();

    private PDTRecorderManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDTRecorderManager getInstance() {
        Object object = fLock;
        synchronized (object) {
            if (fInstance == null) {
                PDTRecorderManager temp = new PDTRecorderManager();
                temp.initRecorders();
                fInstance = temp;
            }
            return fInstance;
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        IDebugActionRecorder[] iDebugActionRecorderArray = this.fRecorders;
        int n = this.fRecorders.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugActionRecorder recorder = iDebugActionRecorderArray[n2];
            recorder.addBreakpoint(breakpoint);
            ++n2;
        }
    }

    public void launchAdded(ILaunch launch) {
        IDebugActionRecorder[] iDebugActionRecorderArray = this.fRecorders;
        int n = this.fRecorders.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugActionRecorder recorder = iDebugActionRecorderArray[n2];
            recorder.launch(launch);
            ++n2;
        }
    }

    public void recordDebugAction(IDebugElement debugElement, int actionType) {
        IDebugActionRecorder[] iDebugActionRecorderArray = this.fRecorders;
        int n = this.fRecorders.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugActionRecorder recorder = iDebugActionRecorderArray[n2];
            recorder.record(debugElement, actionType);
            ++n2;
        }
    }

    public void startRecording(String name) {
        IDebugActionRecorder[] iDebugActionRecorderArray = this.fRecorders;
        int n = this.fRecorders.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugActionRecorder recorder = iDebugActionRecorderArray[n2];
            recorder.startRecording(name);
            ++n2;
        }
    }

    public void stopRecording() {
        IDebugActionRecorder[] iDebugActionRecorderArray = this.fRecorders;
        int n = this.fRecorders.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugActionRecorder recorder = iDebugActionRecorderArray[n2];
            recorder.stopRecording();
            ++n2;
        }
    }

    public void insertLine(String content) {
        IDebugActionRecorder[] iDebugActionRecorderArray = this.fRecorders;
        int n = this.fRecorders.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugActionRecorder recorder = iDebugActionRecorderArray[n2];
            recorder.insertLine(content);
            ++n2;
        }
    }

    private void initRecorders() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.core", DEBUG_ACTION_RECORDER);
        if (extensionPoint != null) {
            IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
            ArrayList<IDebugActionRecorder> recorderList = new ArrayList<IDebugActionRecorder>();
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    IDebugActionRecorder recorder = (IDebugActionRecorder)config.createExecutableExtension(ATTR_CLASS);
                    recorderList.add(recorder);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
            this.fRecorders = recorderList.toArray(new IDebugActionRecorder[recorderList.size()]);
        }
    }
}

