/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.IPDTDebuggerEngine;
import com.ibm.debug.pdt.core.ISourceBreakpointAdapter;
import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBaseBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSourceEntryBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSpecialBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLStopAtAllFunctionEntryBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLZeroAddressBreakpoint;
import com.ibm.debug.pdt.core.sourcelocator.IRemoteEnginePathContainer;
import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.IPDTDebugTargetWithLabelProvider;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracer;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracerTarget;
import com.ibm.debug.pdt.internal.core.IPDTLabelProvider;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTRecorderManager;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.PICLModuleParent;
import com.ibm.debug.pdt.internal.core.PICLMonitorParent;
import com.ibm.debug.pdt.internal.core.engine.EngineSupport;
import com.ibm.debug.pdt.internal.core.launch.IPICLAttachInfo;
import com.ibm.debug.pdt.internal.core.launch.IPICLLoadInfo;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.BreakpointAddedEvent;
import com.ibm.debug.pdt.internal.core.model.BreakpointChangedEvent;
import com.ibm.debug.pdt.internal.core.model.BreakpointDeletedEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugEngineCommandLogResponseEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineTerminatedEvent;
import com.ibm.debug.pdt.internal.core.model.DebuggeeAttachOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.DebuggeePrepareOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeReconnectOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeStartupOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.DetachHandler;
import com.ibm.debug.pdt.internal.core.model.EngineBusyException;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.ExpressionAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.IBreakpointEventListener;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IProcessEventListener;
import com.ibm.debug.pdt.internal.core.model.IThreadEventListener;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.MessageReceivedEvent;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.ModuleAddedEvent;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ProcessAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessDetachedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmError;
import com.ibm.debug.pdt.internal.core.model.ProcessPgmOutput;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadChangedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadEndedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.model.ZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepGetEventContent;
import com.ibm.debug.pdt.internal.epdc.ERepPutEventContent;
import com.ibm.debug.pdt.internal.epdc.EReqGetEventContent;
import com.ibm.debug.pdt.internal.epdc.EReqPutEventContent;
import com.ibm.debug.pdt.internal.epdc.EStdNameValuePair;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.osgi.util.NLS;

public class PDTDebugTarget
extends PDTDebugElement
implements IPDTDebugTarget,
IPDTDebugTracerTarget,
IProcessEventListener,
IBreakpointEventListener,
IDebugEngineEventListener,
IBreakpointManagerListener,
IAdaptable,
IThreadEventListener,
IBreakpointsListener,
IPDTDebugTargetWithLabelProvider {
    static final int[] ERRORSTOIGNOREONSTARTUP = new int[]{7, 306, 328, 317, 29, 130, 330};
    protected ILaunch fLaunch = null;
    protected PICLAbstractStartupInfo fStartupInfo = null;
    protected boolean fTeamDebugSession = false;
    protected boolean fReconnect = false;
    private Socket fSocket;
    protected DebuggeeProcess fProcess = null;
    private boolean fStepWithFilters = false;
    private boolean fRunToLocationMode = false;
    private IFolder fViewFileFolder;
    protected byte fCurrentState = 0;
    protected static final byte STATE_UNKNOWN = 0;
    protected static final byte STATE_CONNECTING = 1;
    protected static final byte STATE_CONNECTED = 2;
    protected static final byte STATE_INITIALIZED = 4;
    protected static final byte STATE_PROCESS_STOPPED = 5;
    protected static final byte STATE_PROCESS_ENDED = 6;
    protected static final byte STATE_PROCESS_ADDED = 7;
    protected static final byte STATE_TERMINATING = 8;
    protected static final byte STATE_TERMINATED = 9;
    protected static final byte STATE_WAITING = 10;
    protected static final byte STATE_RUNNING = 11;
    protected static final byte STATE_TERMINATING_PROCESS = 12;
    private String fPlatformLabel;
    private String fConnectionLabel = null;
    private boolean fResumeOnStart = false;
    private boolean fRestartProgram = false;
    protected boolean fIsStoppedByBreakpoint = false;
    protected static final IThread[] EMPTYTHREADS = new IThread[0];
    protected static final Breakpoint[] EMPTYBREAKPOINTLIST = new Breakpoint[0];
    protected static final IBreakpoint[] EMPTYBREAKPOINTS = new IBreakpoint[0];
    protected IBreakpoint[] fStoppingBreakpoints = EMPTYBREAKPOINTS;
    private Vector<GenericLineBreakpoint> fProcessedGenericBPs = new Vector(10);
    protected Hashtable<IMarker, Breakpoint> fBreakpoints = new Hashtable(10);
    protected ArrayList<IBreakpoint> fInstalledSourceLineBreakpoints = new ArrayList(10);
    private volatile Boolean fBrkMgrEnablementChgd = Boolean.FALSE;
    protected HashMap<IBreakpoint, BkpRequest> fBkptPendingActions;
    public static final byte PENDING_DELETE = 1;
    public static final byte PENDING_ENABLE = 2;
    public static final byte PENDING_DISABLE = 3;
    public static final byte PENDING_SKIP = 4;
    public static final byte PENDING_NOSKIP = 5;
    private volatile boolean fBusyProcPnding = false;
    private final String fID = String.valueOf(PDTCorePlugin.getUniqueId());
    private String fProgramName = null;
    private PICLModuleParent fModuleParent;
    private PICLMonitorParent fMonitorParent;
    private ExpressionBase fHoverExpression;
    private int fLastError = 0;
    private String fLastErrorText = null;
    protected boolean fSuppressInfoErrorsDuringStartup = false;
    private EPDC_EngineSession fEngineSession = null;
    private int fKey = 0;
    private boolean fPreferencePageSupported = false;
    boolean fSupportsMultiRequests = false;
    protected ArrayList<IPDTDebugTracer> fDebugTracers = new ArrayList();
    private boolean fIsExceptionHandling = false;
    private boolean fIsMixedCCEnabled = false;
    private boolean fWasMixedCCEnabled = false;
    private Map<String, Object> fProperties = new HashMap<String, Object>();
    private IPDTLabelProvider fLabelProvider;

    @Override
    public void addDebugTracer(IPDTDebugTracer debugTracer) {
        if (debugTracer != null) {
            this.fDebugTracers.add(debugTracer);
        }
    }

    @Override
    public IPDTDebugTracer[] getDebugTracers() {
        return this.fDebugTracers.toArray(new IPDTDebugTracer[this.fDebugTracers.size()]);
    }

    public PDTDebugTarget() {
        super(null, null);
        PDTCorePlugin.addDebugTarget(this);
        this.updateCurrentState((byte)10);
    }

    public PDTDebugTarget(ILaunch launch, PICLAbstractStartupInfo startupInfo, Socket socket, int key) {
        this(launch, startupInfo, socket);
        this.fKey = key;
    }

    @Override
    public int getKey() {
        return this.fKey;
    }

    public PDTDebugTarget(ILaunch launch, PICLAbstractStartupInfo startupInfo, Socket socket) {
        this();
        this.fLaunch = launch;
        this.fStartupInfo = startupInfo;
        this.setSessionNameFromStartupInfo();
        this.fSocket = socket;
        this.addListeners();
        if (PDTCorePlugin.getInstance().isRecordDebugActions()) {
            PDTRecorderManager.getInstance().launchAdded(launch);
        }
    }

    protected void addListeners() {
    }

    protected void removeListeners() {
        this.getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public IBreakpointManager getBreakpointManager() {
        try {
            return DebugPlugin.getDefault().getBreakpointManager();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public EPDC_EngineSession getEngineSession() {
        if (this.fEngineSession == null && this.getDebugEngine() != null) {
            this.fEngineSession = super.getEngineSession();
        }
        return this.fEngineSession;
    }

    @Override
    public void modelStateChanged(ModelStateReadyEvent event) {
    }

    public boolean supportsDebugInitialization() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsDebugInitialization();
    }

    public boolean supportsJobName() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsJobName();
    }

    public boolean supportsProgramList() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProgramList();
    }

    public boolean supportsHostAddress() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsHostAddress();
    }

    public boolean supportsMultipleThreads() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsMultipleThreads();
    }

    public boolean supportsTerminateType() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsTerminateType();
    }

    public boolean supportsForkFollowBoth() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsForkFollowBoth();
    }

    public boolean supportsChildProcesses() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsChildProcesses();
    }

    public boolean supportsIncludeFiles() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsIncludeFiles();
    }

    public boolean supportsDebugOnDemand() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsDebugOnDemand();
    }

    public boolean supportsStartup() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStartup();
    }

    public boolean supportsProcessListStartup() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProcessListStartup();
    }

    public boolean supportsPostMortemDebug() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsPostMortemDebug();
    }

    public boolean supportsPostMortemCapable() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsPostMortemCapable();
    }

    public boolean supportsEnhancedStorage() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsEnhancedStorage();
    }

    public boolean supportsAsync() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAsync();
    }

    public boolean supportsTeamDebug() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsTeamDebug();
    }

    public boolean supportsGetList() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsGetList();
    }

    public boolean supportsPlayback() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsPlayback();
    }

    public boolean supportsChangeSourceFile() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsChangeSourceFile();
    }

    public boolean supportsRestart() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsRestart() && PDTCorePlugin.isRestartSupported();
    }

    public boolean supportsModuleAdd() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsModuleAdd();
    }

    public boolean supportsModuleRemove() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsModuleRemove();
    }

    public boolean supportsProcessAttach() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProcessAttach();
    }

    public boolean supportsProcessDetach() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProcessDetach();
    }

    public boolean supportsProcessDetachKill() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProcessDetachKill();
    }

    public boolean supportsProcessDetachKeep() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProcessDetachKeep();
    }

    public boolean supportsProcessDetachRelease() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProcessDetachRelease();
    }

    public boolean supportsLocalSourceFiles() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsLocalSourceFiles();
    }

    public boolean supportsSearchLocalFirst() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsSearchLocalFirst();
    }

    public boolean supportsUpdateEngineSearchPath() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsUpdateEngineSearchPath();
    }

    public boolean supportsModuleSideFileUpdate() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsModuleSideFileUpdate();
    }

    public boolean supportsLineBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsLineBreakpoints();
    }

    public boolean supportsStatementBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStatementBreakpoints();
    }

    public boolean supportsFunctionBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsFunctionBreakpoints();
    }

    public boolean supportsAddressBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddressBreakpoints();
    }

    public boolean supportsChangeAddrBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsChangeAddrBreakpoints();
    }

    public boolean supportsEnhancedWatchpointBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsEnhancedWatchpointBreakpoints();
    }

    public boolean supportsLoadBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsLoadBreakpoints();
    }

    public boolean supportsOccurrenceBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsOccurrenceBreakpoints();
    }

    public boolean supportsEnableDisableBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsEnableDisableBreakpoints();
    }

    public boolean supportsModifyingBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsModifyingBreakpoints();
    }

    public boolean supportsDeferredBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsDeferredBreakpoints();
    }

    public boolean supportsEntryAutoSet() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsEntryAutoSet();
    }

    public boolean supportsExpressionOnConditionalBkp() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsExpressionOnConditionalBkp();
    }

    public boolean supportsBreakpointActions() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsBreakpointActions();
    }

    public boolean supportsAddrBkpMonitor_8Bytes() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddrBkpMonitor_8Bytes();
    }

    public boolean supportsAddrBkpMonitor_4Bytes() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddrBkpMonitor_4Bytes();
    }

    public boolean supportsAddrBkpMonitor_2Bytes() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddrBkpMonitor_2Bytes();
    }

    public boolean supportsAddrBkpMonitor_1Bytes() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddrBkpMonitor_1Bytes();
    }

    public boolean supportsAddrBkpMonitor_0_128Bytes() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddrBkpMonitor_0_128Bytes();
    }

    public boolean supportsDateBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsDateBreakpoints();
    }

    public boolean supportsThreadOnConditionalBkp() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsThreadOnConditionalBkp();
    }

    public boolean supportsFreqOnConditionalBkp() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsFreqOnConditionalBkp();
    }

    public boolean supportsAmbiguousBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAmbiguousBreakpoints();
    }

    public boolean supportsAmbiguousAllBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAmbiguousAllBreakpoints();
    }

    public boolean supportsEngineBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsEngineBreakpoints();
    }

    public boolean supportsAddrBkpMonitor_Auto() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddrBkpMonitor_Auto();
    }

    public boolean supportsChgAddrContionalBkp() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsChgAddrContionalBkp();
    }

    public boolean supportsThreadSpecificOnlyBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsThreadSpecificOnlyBreakpoints();
    }

    public boolean supportsMacroBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsMacroBreakpoints();
    }

    public boolean supportsMacroGroupBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsMacroGroupBreakpoints();
    }

    public boolean supportsBreakpointSyncAsyncStopControl() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsBreakpointSyncAsyncStopControl();
    }

    public boolean supportsSourceEntryBreakpoint() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsSourceEntryBreakpoint();
    }

    public boolean supportsAddressRangeBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsAddressRangeBreakpoints();
    }

    public boolean supportsZeroAddressBreakpoints() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsZeroAddressBreakpoint();
    }

    public boolean supportsEnableDisableMonitors() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsEnableDisableMonitors();
    }

    public boolean supportsMonitorAnyLocals() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsMonitorAnyLocals();
    }

    public boolean supportsLocalFilters() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsLocalFilters();
    }

    public boolean supportsMonitorGlobalList() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsMonitorGlobalList();
    }

    public boolean supportsMonitorGlobalSymbols() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsMonitorGlobalSymbols();
    }

    public boolean supportsMonitoringExpressions() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsMonitoringExpressions();
    }

    public boolean supportsNewMonitorFormat() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsNewMonitorFormat();
    }

    public boolean supportsLocalVariables() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsLocalVariables();
    }

    public boolean supportsRegisters() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsRegisters();
    }

    public boolean supportsStack() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStack();
    }

    public boolean supportsStorage() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStorage();
    }

    public boolean supportsCommandLog() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsCommandLog();
    }

    public boolean supportsHiddenCommandLog() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsHiddenCommandLog();
    }

    public boolean supportsProgramIO() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsProgramIO();
    }

    public boolean supportsModules() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsModules();
    }

    public boolean supportsThreadFreezeThaw() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsThreadFreezeThaw();
    }

    public boolean supportsStepOver() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStepOver();
    }

    public boolean supportsStepInto() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStepInto();
    }

    public boolean supportsStepDebug() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStepDebug();
    }

    public boolean supportsStepReturn() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStepReturn();
    }

    public boolean supportsRunToLocation() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsRunToLocation();
    }

    public boolean supportsJumpToLocation() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsJumpToLocation();
    }

    public boolean supportsHalt() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsHalt();
    }

    public boolean supportsStorageUsageCheck() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsStorageUsageCheck();
    }

    public boolean supportsSkipNext() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsSkipNext();
    }

    public boolean supportsExceptionFiltering() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsExceptionFiltering();
    }

    public boolean supportsExceptionExamine() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsExceptionExamine();
    }

    public boolean supportsExceptionStep() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsExceptionStep();
    }

    public boolean supportsExceptionRun() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsExceptionRun();
    }

    public boolean supportsRememberForkChoice() {
        return this.getEngineSession() == null ? false : this.getEngineSession().supportsRememberForkChoice();
    }

    public final boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (this.fBreakpoints.containsKey(breakpoint.getMarker())) {
            return true;
        }
        return breakpoint instanceof PICLSpecialBreakpoint && ((PICLSpecialBreakpoint)breakpoint).getDebugTarget() == this;
    }

    protected void updateCurrentState(byte state) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, "**state change** " + this.getStateAsText(this.fCurrentState) + " >>> " + this.getStateAsText(state));
        }
        this.fCurrentState = state;
    }

    protected String getStateAsText(byte state) {
        return switch (state) {
            case 1 -> PICLLabels.picl_debug_target_state_connecting;
            case 2 -> PICLLabels.picl_debug_target_state_connected;
            case 5 -> PICLLabels.picl_debug_target_state_processstopped;
            case 7 -> PICLLabels.picl_debug_target_state_processadded;
            case 6 -> PICLLabels.picl_debug_target_state_processended;
            case 12 -> PICLLabels.picl_debug_target_state_processterminating;
            case 9 -> PICLLabels.picl_debug_target_state_engine_terminated;
            case 8 -> PICLLabels.picl_debug_target_state_engine_terminating;
            case 10 -> PICLLabels.picl_debug_target_state_waiting;
            case 11 -> PICLLabels.picl_debug_target_state_running;
            case 4 -> PICLLabels.picl_debug_target_state_initialized;
            default -> "<unknown [" + state + "]>";
        };
    }

    @Override
    public void breakpointChanged(BreakpointChangedEvent event) {
        IBreakpoint piclBp;
        Breakpoint modelBp;
        IMarker marker;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointChanged(BreakpointChangedEvent)");
        }
        if ((marker = (modelBp = event.getBreakpoint()).getMarker()) != null && marker.exists() && (piclBp = this.getBreakpointManager().getBreakpoint(marker)) != null) {
            if (PDTCoreUtils.isSourceLineBreakpoint(piclBp) || PDTCoreUtils.isSourceEntryBreakpoint(piclBp)) {
                if (this.fInstalledSourceLineBreakpoints.contains(piclBp) && modelBp.isDeferred()) {
                    this.breakpointUnInstalled(piclBp);
                } else if (!this.fInstalledSourceLineBreakpoints.contains(piclBp) && !modelBp.isDeferred()) {
                    this.breakpointInstalled(piclBp);
                }
            } else {
                try {
                    if (piclBp instanceof PICLBreakpoint) {
                        boolean skipAll;
                        ((PICLBreakpoint)piclBp).updateMarker(modelBp, this);
                        boolean bl = skipAll = !this.getBreakpointManager().isEnabled();
                        if (this.fRunToLocationMode || skipAll) {
                            if (modelBp.isEnabled()) {
                                if (!piclBp.isEnabled()) {
                                    piclBp.setEnabled(true);
                                }
                                try {
                                    modelBp.setEnable(false);
                                }
                                catch (EngineConnectionException engineConnectionException) {
                                }
                                catch (EngineRequestException e) {
                                    PDTCoreUtils.logError(e);
                                }
                            }
                        } else if (piclBp.isEnabled() != modelBp.isEnabled()) {
                            piclBp.setEnabled(modelBp.isEnabled());
                        }
                    }
                }
                catch (CoreException ce) {
                    PDTCoreUtils.logError((Exception)((Object)ce));
                }
                this.getBreakpointManager().fireBreakpointChanged(piclBp);
            }
        }
    }

    @Override
    public void breakpointDeleted(BreakpointDeletedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointDeleted(BreakpointDeletedEvent)");
        }
        Breakpoint breakpoint = event.getBreakpoint();
        breakpoint.removeListener(this);
        IMarker marker = breakpoint.getMarker();
        if (marker != null) {
            this.fBreakpoints.remove(marker);
            try {
                IBreakpoint iBP = this.getBreakpointManager().getBreakpoint(marker);
                if (iBP != null) {
                    if (PDTCoreUtils.isSourceLineBreakpoint(iBP) || PDTCoreUtils.isSourceEntryBreakpoint(iBP)) {
                        this.breakpointUnInstalled(iBP);
                    } else {
                        this.getBreakpointManager().removeBreakpoint(iBP, true);
                    }
                }
            }
            catch (CoreException ce) {
                PDTCoreUtils.logError((Exception)((Object)ce));
            }
        }
    }

    private int breakpointUnInstalled(IBreakpoint breakpoint) {
        IConfigurationElement[] sourceBPAdapters;
        block8: {
            if (this.fInstalledSourceLineBreakpoints.contains(breakpoint)) {
                this.fInstalledSourceLineBreakpoints.remove(breakpoint);
            }
            if (breakpoint instanceof GenericLineBreakpoint) {
                return ((GenericLineBreakpoint)breakpoint).decrementInstallCount();
            }
            if (breakpoint instanceof PICLSourceEntryBreakpoint) {
                return ((PICLSourceEntryBreakpoint)breakpoint).decrementInstallCount();
            }
            sourceBPAdapters = PDTCorePlugin.getSourceBreakpointAdapters();
            if (sourceBPAdapters != null) break block8;
            return 0;
        }
        try {
            int i = 0;
            while (i < sourceBPAdapters.length) {
                Object adapterClass = sourceBPAdapters[i].createExecutableExtension("class");
                if (adapterClass instanceof ISourceBreakpointAdapter && ((ISourceBreakpointAdapter)adapterClass).isSourceLineBreakpoint(breakpoint)) {
                    return ((ISourceBreakpointAdapter)adapterClass).decrementSourceLineBreakpointInstallCount(breakpoint);
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            PDTCoreUtils.logError((Exception)((Object)ce));
        }
        return 0;
    }

    protected int breakpointInstalled(IBreakpoint breakpoint) {
        IConfigurationElement[] sourceBPAdapters;
        block8: {
            if (!this.fInstalledSourceLineBreakpoints.contains(breakpoint)) {
                this.fInstalledSourceLineBreakpoints.add(breakpoint);
            }
            if (breakpoint instanceof GenericLineBreakpoint) {
                return ((GenericLineBreakpoint)breakpoint).incrementInstallCount();
            }
            if (breakpoint instanceof PICLSourceEntryBreakpoint) {
                return ((PICLSourceEntryBreakpoint)breakpoint).incrementInstallCount();
            }
            sourceBPAdapters = PDTCorePlugin.getSourceBreakpointAdapters();
            if (sourceBPAdapters != null) break block8;
            return 0;
        }
        try {
            int i = 0;
            while (i < sourceBPAdapters.length) {
                Object adapterClass = sourceBPAdapters[i].createExecutableExtension("class");
                if (adapterClass instanceof ISourceBreakpointAdapter && ((ISourceBreakpointAdapter)adapterClass).isSourceLineBreakpoint(breakpoint)) {
                    return ((ISourceBreakpointAdapter)adapterClass).incrementSourceLineBreakpointInstallCount(breakpoint);
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            PDTCoreUtils.logError((Exception)((Object)ce));
        }
        return 0;
    }

    public boolean canResume() {
        if (this.isPostMortem()) {
            return false;
        }
        if (this.supportsAsync()) {
            IThread[] threads = EMPTYTHREADS;
            try {
                threads = this.getThreads();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            IThread[] iThreadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                IThread thread = iThreadArray[n2];
                if (thread.canResume()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return this.isSuspended();
    }

    public boolean canSuspend() {
        if (this.supportsAsync()) {
            IThread[] threads = EMPTYTHREADS;
            try {
                threads = this.getThreads();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            IThread[] iThreadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                IThread thread = iThreadArray[n2];
                if (thread.canSuspend()) {
                    return true;
                }
                ++n2;
            }
        } else if (this.fCurrentState == 11) {
            return this.supportsHalt();
        }
        return false;
    }

    public boolean canTerminate() {
        if (this.isPostMortem()) {
            return true;
        }
        return !this.isTerminated();
    }

    public boolean canDisconnect() {
        if (this.isTerminated()) {
            return false;
        }
        if (this.supportsAsync()) {
            return this.supportsProcessDetachRelease();
        }
        if (this.isSuspended() || this.canSuspend()) {
            return this.supportsProcessDetachRelease();
        }
        return false;
    }

    @Override
    public boolean isAcceptingRequests() {
        if (this.getDebugEngine() == null) {
            return false;
        }
        return this.getDebugEngine().isAcceptingRequests();
    }

    public boolean isIdle() {
        if (this.getDebugEngine() == null) {
            return false;
        }
        return this.getDebugEngine().isIdle();
    }

    public boolean addPendingBkpChange(IBreakpoint bkp, byte action) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".addPendingBkpChange()");
        }
        if (this.fBusyProcPnding) {
            return false;
        }
        if (this.fBkptPendingActions == null) {
            this.fBkptPendingActions = new HashMap();
        }
        if (!this.fBkptPendingActions.containsKey(bkp)) {
            this.fBkptPendingActions.put(bkp, new BkpRequest(bkp, action));
        }
        return true;
    }

    public boolean isiSeriesOS() {
        return this.getEngineSession() == null ? false : this.getEngineSession().isiSeriesOS();
    }

    public boolean is390() {
        return this.getEngineSession() == null ? false : this.getEngineSession().is390();
    }

    public boolean is390OS() {
        return this.getEngineSession() == null ? false : this.getEngineSession().is390OS();
    }

    public boolean isCOBOL() {
        return this.getDebugEngine() == null ? false : this.getDebugEngine().getDominantLanguage() == 6;
    }

    public boolean isFORTRAN() {
        return this.getDebugEngine() == null ? false : this.getDebugEngine().getDominantLanguage() == 11;
    }

    public boolean isPICL() {
        return this.getEngineSession() == null ? false : this.getEngineSession().isPICL();
    }

    public final boolean isTerminated() {
        return this.fCurrentState == 9;
    }

    public final boolean isPostMortem() {
        if (this.fProcess != null) {
            return this.fProcess.isPostMortem();
        }
        return false;
    }

    public final boolean isDisconnected() {
        return this.isTerminated();
    }

    public final boolean isSuspended() {
        return this.fCurrentState == 5;
    }

    public DebuggeeThread getStoppingThread() {
        if (this.fProcess == null) {
            return null;
        }
        return this.fProcess.getStoppingThread();
    }

    @Override
    public void debugEngineTerminated(DebugEngineTerminatedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".debugEngineTerminated(DebugEngineTerminatedEvent)");
        }
        this.updateCurrentState((byte)9);
        try {
            this.getEngineSession().terminateEPDCDumping(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doCleanup();
    }

    public void disconnect() throws DebugException {
        this.disconnect(0);
    }

    protected void disconnect(int disconnectMode) throws DebugException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".disconnect()");
        }
        if (this.isTerminated()) {
            return;
        }
        if (disconnectMode == 2 && !this.getEngineSession().supportsProcessDetachKill() || disconnectMode == 1 && !this.getEngineSession().supportsProcessDetachKeep()) {
            disconnectMode = 0;
        }
        if (!this.supportsAsync() && !this.isSuspended()) {
            this.fProcess.addEventListener(new DetachHandler(disconnectMode));
            this.suspend();
        } else {
            try {
                this.fProcess.detach(disconnectMode);
            }
            catch (EngineRequestException e) {
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), null));
            }
        }
    }

    public boolean launchEngine(int key) {
        IPDTDebuggerEngine engine;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".launchEngine(int)");
        }
        if ((engine = PDTCorePlugin.getLocalPICLEngine()) == null) {
            return false;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        String[] envArray = null;
        if (launchManager != null && this.fStartupInfo != null) {
            try {
                envArray = launchManager.getEnvironment(this.fStartupInfo.getLaunchConfig());
            }
            catch (CoreException ce) {
                PDTCoreUtils.logError((Exception)((Object)ce));
            }
        }
        return engine.launchEngine(key, envArray);
    }

    @Override
    public void errorOccurred(ErrorOccurredEvent event) {
        this.fLastError = event.getReturnCode();
        this.fLastErrorText = event.getMessage();
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ">>>> Error event from model!!!!! <<<<", 4);
            PDTCoreUtils.logString(this, ">>>> Error code=" + this.fLastError + " text=" + this.fLastErrorText, 4);
        }
        boolean clearError = false;
        if (this.fSuppressInfoErrorsDuringStartup) {
            int i = 0;
            while (i < ERRORSTOIGNOREONSTARTUP.length) {
                if (this.fLastError == ERRORSTOIGNOREONSTARTUP[i]) {
                    clearError = true;
                    break;
                }
                ++i;
            }
        }
        if (this.fLastError == 303) {
            clearError = true;
        }
        if (clearError) {
            this.fLastError = 0;
            this.fLastErrorText = null;
        }
    }

    public void stopMonitoringLocals() {
        try {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                ((DebuggeeThread)threads[i]).stopMonitoringLocalsOnNextStep();
                ++i;
            }
        }
        catch (DebugException de) {
            PDTCoreUtils.logError((Exception)((Object)de));
        }
    }

    public void stopMonitoringRegisters() {
        try {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                ((DebuggeeThread)threads[i]).stopMonitoringRegistersOnNextStep();
                ++i;
            }
        }
        catch (DebugException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
        }
    }

    @Override
    public void expressionLocalAdded(ExpressionAddedEvent event) {
    }

    @Override
    public void threadChanged(ThreadChangedEvent event) {
        if (event.isStateChanged()) {
            event.getThread().fireChangeEvent(256);
        } else {
            event.getThread().fireChangeEvent(512);
        }
    }

    @Override
    public void threadEnded(ThreadEndedEvent event) {
    }

    @Override
    public void threadStopped(ThreadStoppedEvent event) {
        Breakpoint[] stoppingBreakpoints;
        DebuggeeThread thread = event.getThread();
        ProcessStopInfo stopInfo = event.getStopInfo();
        DebuggeeThread stoppingThread = this.getStoppingThread();
        this.traceThreadEvent(event);
        int[] stoppingBreakpointIds = stopInfo.getBreakpointsHit();
        if (stoppingBreakpointIds.length > 0) {
            ArrayList<Breakpoint> stoppingBreakpointList = new ArrayList<Breakpoint>();
            int i = 0;
            while (i < stoppingBreakpointIds.length) {
                Breakpoint bp = this.fProcess.getBreakpoint(stoppingBreakpointIds[i]);
                if (!stoppingBreakpointList.contains(bp)) {
                    stoppingBreakpointList.add(bp);
                }
                ++i;
            }
            stoppingBreakpoints = stoppingBreakpointList.toArray(new Breakpoint[stoppingBreakpointList.size()]);
        } else {
            stoppingBreakpoints = EMPTYBREAKPOINTLIST;
        }
        this.saveStoppingBreakpoints(stoppingBreakpoints);
        if (this.supportsAsync()) {
            int detail = 0;
            detail = stopInfo.isStoppedByBreakpoint() ? 16 : (thread.isStepping() ? 8 : 32);
            if (thread.isStepping()) {
                thread.postStepping();
            } else {
                thread.postResume();
            }
            this.postResume();
            int threadID = thread.getId();
            int stoppingThreadID = stoppingThread.getId();
            if (threadID == stoppingThreadID) {
                thread.fireSuspendEvent(detail);
            } else {
                thread.fireChangeEvent(512);
            }
        } else if (!thread.equals(stoppingThread)) {
            if (thread.isStepping()) {
                thread.postStepping();
            } else {
                thread.postResume();
            }
        }
        if (this.fRunToLocationMode) {
            this.endRunToLocationMode();
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointManagerEnablementChanged()");
        }
        if (!this.isAcceptingRequests()) {
            this.setBrkMgrEnablementChgd();
            return;
        }
        this.setSkipForAllTargetBreakpoints(!enabled);
    }

    public void setBrkMgrEnablementChgd() {
        this.fBrkMgrEnablementChgd = Boolean.TRUE;
    }

    public void setSkipForAllTargetBreakpoints(boolean skip) {
        IBreakpoint[] bkps = this.getBreakpointManager().getBreakpoints();
        if (this.fSupportsMultiRequests) {
            this.getDebugEngine().startMultipleRequest();
        }
        int i = 0;
        while (i < bkps.length) {
            if (bkps[i] instanceof PICLBaseBreakpoint && ((PICLBaseBreakpoint)bkps[i]).getDebugTarget() == this) {
                ((PICLBaseBreakpoint)bkps[i]).setSkip(skip);
            } else {
                Breakpoint bp = this.fBreakpoints.get(bkps[i].getMarker());
                try {
                    if (bp != null && PDTCoreUtils.isSourceLineBreakpoint(bkps[i])) {
                        if (!(bp instanceof LineBreakpoint)) {
                            return;
                        }
                        LineBreakpoint modelBP = (LineBreakpoint)bp;
                        if (skip && modelBP.isEnabled()) {
                            modelBP.setEnable(false);
                        } else if (!skip && !modelBP.isEnabled()) {
                            modelBP.setEnable(true);
                        }
                    }
                }
                catch (EngineRequestException ere) {
                    PDTCoreUtils.logError(ere);
                }
            }
            ++i;
        }
        if (this.fSupportsMultiRequests) {
            this.getDebugEngine().endMultipleRequest(true);
        }
    }

    public final boolean supportsStepFilters() {
        return this.supportsStepDebug();
    }

    public final boolean isStepFiltersEnabled() {
        return this.fStepWithFilters;
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.fStepWithFilters = enabled;
    }

    @Override
    public void postResume() {
        this.updateCurrentState((byte)5);
    }

    @Override
    public void programError(ProcessPgmError event) {
    }

    @Override
    public void programOutput(ProcessPgmOutput event) {
    }

    public boolean hasThreads() throws DebugException {
        if (this.fProcess == null) {
            return false;
        }
        return this.fProcess.hasThreads();
    }

    public final boolean supportsBrkptType(String BrkptType) {
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLLineBreakpoint")) {
            return this.supportsLineBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLAddressBreakpoint")) {
            return this.supportsAddressBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLMacroBreakpoint")) {
            return this.supportsMacroBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLEntryBreakpoint")) {
            return this.supportsFunctionBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLLoadBreakpoint")) {
            return this.supportsLoadBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLWatchBreakpoint")) {
            return this.supportsChangeAddrBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLOccurrenceBreakpoint")) {
            return this.supportsOccurrenceBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLAddressRangeBreakpoint")) {
            return this.supportsAddressRangeBreakpoints();
        }
        if (BrkptType.equals("com.ibm.debug.pdt.core.PICLZeroAddressBreakpoint")) {
            return this.supportsZeroAddressBreakpoints();
        }
        return false;
    }

    public ILaunch getLaunch() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getLaunch()");
        }
        return this.fLaunch;
    }

    @Override
    public void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    public IProcess getProcess() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getProcess()");
        }
        return this.fProcess;
    }

    public String getLastErrorText() {
        return this.fLastErrorText;
    }

    public int getLastError() {
        return this.fLastError;
    }

    public void setError(int errorCode, String errorText) {
        this.fLastError = errorCode;
        this.fLastErrorText = errorText;
    }

    @Override
    public void processEnded(ProcessEndedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".processEnded(ProcessEndedEvent)");
        }
        this.updateCurrentState((byte)6);
        this.uninstallAllBreakpoints();
        this.fModuleParent.clearChildren();
        this.fMonitorParent.clearChildren();
        this.removeAllChildren();
        this.fProcess.removeListener(this);
        this.fProcess.fireTerminateEvent();
        this.fProcess = null;
        if (!this.fRestartProgram) {
            try {
                this.terminateEngine();
            }
            catch (DebugException debugException) {}
        } else {
            this.fRestartProgram = false;
        }
    }

    @Override
    public void moduleAdded(ModuleAddedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".moduleAdded(ModuleAddedEvent)");
        }
        this.fModuleParent.addModule(event.getModule());
    }

    @Override
    public void expressionAdded(ExpressionAddedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".monitoredExpressionAdded(ExpressionAddedEvent)");
        }
        this.fMonitorParent.addExpression(event.getExpression());
    }

    public void terminate() throws DebugException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".terminate()");
        }
        byte terminateType = this.fEngineSession != null ? this.fEngineSession.getTerminateType() : (byte)0;
        this.terminate(terminateType);
    }

    public void terminate(byte terminateType) throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        DebugEngine debugEngine = this.getDebugEngine();
        if (debugEngine == null) {
            this.debugEngineTerminated(null);
            return;
        }
        if (!debugEngine.isConnected()) {
            this.updateCurrentState((byte)9);
            this.fireTerminateEvent();
        } else {
            if (!this.isAcceptingRequests()) {
                try {
                    this.getDebugEngine().setConnectionTerminated();
                    this.fSocket.close();
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    PDTCoreUtils.logError(e);
                    this.debugEngineTerminated(null);
                }
                return;
            }
            try {
                if (this.fProcess == null || this.fProcess.isTerminated()) {
                    this.terminateEngine();
                } else {
                    this.updateCurrentState((byte)12);
                    try {
                        this.fProcess.terminate(terminateType);
                    }
                    catch (EngineRequestException e) {}
                }
            }
            catch (DebugException e) {
                this.debugEngineTerminated(null);
            }
        }
    }

    private void terminateEngine() throws DebugException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".terminateEngine()");
        }
        if (this.haveDoneCleanup() || this.isTerminated()) {
            return;
        }
        this.updateCurrentState((byte)8);
        try {
            this.getDebugEngine().terminate();
        }
        catch (EngineRequestException e) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), null));
        }
    }

    @Override
    public void threadAdded(ThreadAddedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".threadAdded(ThreadAddedEvent)");
        }
        event.getThread().addEventListener(this);
    }

    protected void uninstallAllBreakpoints() {
        GenericLineBreakpoint iBP;
        Enumeration markers = ((Hashtable)this.fBreakpoints.clone()).keys();
        while (markers.hasMoreElements()) {
            IMarker marker = (IMarker)markers.nextElement();
            Breakpoint modelBP = this.fBreakpoints.remove(marker);
            try {
                IBreakpoint iBP2 = this.getBreakpointManager().getBreakpoint(marker);
                if (iBP2 instanceof PICLZeroAddressBreakpoint) {
                    if (((PICLZeroAddressBreakpoint)iBP2).isActive()) continue;
                    this.getBreakpointManager().removeBreakpoint(iBP2, true);
                    continue;
                }
                if (iBP2 instanceof PICLBreakpoint) {
                    this.getBreakpointManager().removeBreakpoint(iBP2, true);
                    continue;
                }
                if (iBP2 == null || modelBP.isDeferred()) continue;
                this.breakpointUnInstalled(iBP2);
            }
            catch (CoreException iBP2) {
                // empty catch block
            }
        }
        try {
            if (this.fProcessedGenericBPs != null) {
                Iterator<GenericLineBreakpoint> iter = this.fProcessedGenericBPs.iterator();
                iBP = null;
                while (iter.hasNext()) {
                    iBP = iter.next();
                    if (iBP == null || !iBP.hasBeenProcessed()) continue;
                    iBP.delete();
                }
            }
        }
        catch (CoreException iter) {
            // empty catch block
        }
        try {
            IMarker[] stopAtAllFunctionsBPMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.debug.pdt.PICLStopAtAllFunctionEntryBreakpoint", true, 2);
            if (stopAtAllFunctionsBPMarkers == null) {
                return;
            }
            int i = 0;
            while (i < stopAtAllFunctionsBPMarkers.length) {
                iBP = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(stopAtAllFunctionsBPMarkers[i]);
                if (iBP != null && iBP instanceof PICLStopAtAllFunctionEntryBreakpoint && ((PICLStopAtAllFunctionEntryBreakpoint)((Object)iBP)).getDebugTarget() == this) {
                    this.getBreakpointManager().removeBreakpoint((IBreakpoint)iBP, true);
                    return;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCleanupDetails() {
        try {
            if (this.getBreakpointManager() != null) {
                this.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
                this.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            }
            this.uninstallAllBreakpoints();
            this.fBkptPendingActions = null;
            this.fProcessedGenericBPs = null;
            if (this.getModuleParent() != null) {
                this.getModuleParent().doCleanup();
                this.fModuleParent = null;
            }
            if (this.getMonitorParent() != null) {
                this.getMonitorParent().doCleanup();
                this.fMonitorParent = null;
            }
            this.removeListeners();
            if (this.getDebugEngine() != null) {
                try {
                    this.getDebugEngine().doCleanup();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setDebugEngine(null);
            }
            if (this.fViewFileFolder != null) {
                IFolder iFolder = this.fViewFileFolder;
                synchronized (iFolder) {
                    if (this.fViewFileFolder.exists()) {
                        this.fViewFileFolder.delete(true, null);
                    }
                }
            }
            PDTCorePlugin.removeDebugTarget(this);
            if (this.fLaunch != null) {
                this.fireTerminateEvent();
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public PICLModuleParent getModuleParent() {
        return this.fModuleParent;
    }

    public PICLMonitorParent getMonitorParent() {
        return this.fMonitorParent;
    }

    @Override
    public void resetChanged() {
        this.fLastError = 0;
        this.fLastErrorText = null;
        if (this.getMonitorParent() != null) {
            this.getMonitorParent().resetChanged();
        }
    }

    public Breakpoint getBreakpoint(IMarker marker) {
        return this.fBreakpoints.get(marker);
    }

    public DebuggeeException[] getSupportedExceptions() {
        if (this.getDebugEngine() == null) {
            return null;
        }
        return this.getDebugEngine().getExceptions();
    }

    public void commitExceptionChanges(boolean setAsDefaults) throws EngineRequestException {
        this.getDebugEngine().commitPendingExceptionStateChanges(setAsDefaults);
    }

    @Override
    public void commandLogResponse(DebugEngineCommandLogResponseEvent event) {
    }

    public void sendCommand(String commandLine) throws EngineRequestException {
        this.getDebugEngine().commandLog(commandLine, false, false);
    }

    protected String removeExtension(String name) {
        int posn = name.lastIndexOf(46);
        return name.substring(0, posn);
    }

    public boolean attachToProcess(IPICLAttachInfo attachInfo) {
        String processID;
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".attachToProcess(PICLAttachInfo)");
        }
        if (attachInfo.getProcessID() == null) {
            return false;
        }
        try {
            processID = attachInfo.getProcessID();
        }
        catch (NumberFormatException e) {
            try {
                this.terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            return false;
        }
        boolean runToBrkpt = attachInfo.getStartupBehaviour() == 2;
        DebuggeeAttachOptions attachOptions = new DebuggeeAttachOptions(attachInfo.getProcessPath(), processID, 0, PDTCoreUtils.getProfileSaveRestoreLocation(), true, runToBrkpt, attachInfo.getLanguage());
        this.fSuppressInfoErrorsDuringStartup = true;
        boolean success = false;
        if (attachInfo instanceof PICLAbstractStartupInfo) {
            attachOptions.setViewOrder(((PICLAbstractStartupInfo)((Object)attachInfo)).getViewOrder());
        }
        try {
            this.getDebugEngine().attach(attachOptions);
            success = true;
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, " Process attached");
            }
        }
        catch (EngineRequestException e1) {
            this.logException(e1);
            try {
                this.terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return success;
    }

    @Override
    public void breakpointAdded(BreakpointAddedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointAdded()");
        }
        final Breakpoint modelBp = event.getBreakpoint();
        final IMarker resourceMarker = modelBp.getResourceMarker();
        final PDTDebugTarget dbgTgt = this;
        if (resourceMarker != null) {
            final IBreakpoint iBP = this.getBreakpointManager().getBreakpoint(resourceMarker);
            if (iBP != null && iBP instanceof PICLBaseBreakpoint) {
                ((PICLBaseBreakpoint)iBP).setDebugTarget(this);
            }
            if (iBP != null && iBP instanceof PICLBreakpoint) {
                ((PICLBreakpoint)iBP).setModelBreakpoint(modelBp);
            }
            Job bkptInstalljob = new Job("Breakpoint installation"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (iBP != null && !modelBp.isDeferred()) {
                        PDTDebugTarget.this.breakpointInstalled(iBP);
                    }
                    dbgTgt.fBreakpoints.put(resourceMarker, modelBp);
                    modelBp.addEventListener(dbgTgt);
                    return Status.OK_STATUS;
                }
            };
            bkptInstalljob.setSystem(true);
            bkptInstalljob.schedule();
            modelBp.setSaveInProfile(false);
            return;
        }
        Job bkptCreationjob = new Job("Breakpoint registration"){

            protected IStatus run(IProgressMonitor arg0) {
                try {
                    PICLBreakpoint.createPICLBreakpoint(modelBp, dbgTgt);
                }
                catch (CoreException ce) {
                    PDTCoreUtils.logError((Exception)((Object)ce));
                    return new Status(4, "com.ibm.debug.pdt.core", NLS.bind((String)PICLMessages.PICLBreakpoint_setup_failed, (Object)modelBp.getLabel()));
                }
                dbgTgt.fBreakpoints.put(modelBp.getWorkspaceMarker(), modelBp);
                modelBp.addEventListener(dbgTgt);
                return Status.OK_STATUS;
            }
        };
        bkptCreationjob.setSystem(true);
        bkptCreationjob.schedule();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.fSupportsMultiRequests) {
            return;
        }
        this.addBreakpoint(breakpoint);
    }

    private void addBreakpoint(IBreakpoint breakpoint) {
        block24: {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".breakpointAdded(IBreakpoint)");
            }
            if (this.isTerminated()) {
                return;
            }
            if (PDTCorePlugin.getInstance().isRecordDebugActions()) {
                PDTRecorderManager.getInstance().breakpointAdded(breakpoint);
            }
            final IMarker marker = breakpoint.getMarker();
            try {
                if (breakpoint instanceof PICLBreakpoint) {
                    final PICLBreakpoint piclBkpt = (PICLBreakpoint)breakpoint;
                    if (piclBkpt.isImported()) {
                        final DebuggeeProcess process = (DebuggeeProcess)this.getProcess();
                        Job j = new Job("Create breakpoint"){

                            protected IStatus run(IProgressMonitor monitor) {
                                piclBkpt.createModelBreakpoint(marker, process);
                                return Status.OK_STATUS;
                            }
                        };
                        j.schedule();
                        if (this.getDebugEngine().isProcessingMultiRequest()) {
                            try {
                                j.join();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    break block24;
                }
                if (breakpoint instanceof GenericLineBreakpoint) {
                    Job j = new Job("Create source line breakpoint"){

                        protected IStatus run(IProgressMonitor monitor) {
                            PDTDebugTarget.this.setSourceLineBreakpoint(marker);
                            return Status.OK_STATUS;
                        }
                    };
                    j.schedule();
                    if (this.getDebugEngine().isProcessingMultiRequest()) {
                        try {
                            j.join();
                        }
                        catch (InterruptedException process) {}
                    }
                    break block24;
                }
                if (breakpoint instanceof PICLSourceEntryBreakpoint) {
                    ((PICLSourceEntryBreakpoint)breakpoint).setDebugTarget(this);
                    Job j = new Job("Create source entry breakpoint"){

                        protected IStatus run(IProgressMonitor monitor) {
                            PDTDebugTarget.this.setSourceEntryBreakpoint(marker);
                            return Status.OK_STATUS;
                        }
                    };
                    j.schedule();
                    if (this.getDebugEngine().isProcessingMultiRequest()) {
                        try {
                            j.join();
                        }
                        catch (InterruptedException process) {}
                    }
                    break block24;
                }
                IConfigurationElement[] sourceBPAdapters = PDTCorePlugin.getSourceBreakpointAdapters();
                if (sourceBPAdapters == null) {
                    return;
                }
                int i = 0;
                while (i < sourceBPAdapters.length) {
                    Object adapterClass = sourceBPAdapters[i].createExecutableExtension("class");
                    if (adapterClass instanceof ISourceBreakpointAdapter && ((ISourceBreakpointAdapter)adapterClass).isSourceLineBreakpoint(breakpoint)) {
                        Job j = new Job("Create source line breakpoint"){

                            protected IStatus run(IProgressMonitor monitor) {
                                PDTDebugTarget.this.setSourceLineBreakpoint(marker);
                                return Status.OK_STATUS;
                            }
                        };
                        j.schedule();
                        if (this.getDebugEngine().isProcessingMultiRequest()) {
                            try {
                                j.join();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                PDTCoreUtils.logError((Exception)((Object)ce));
            }
        }
    }

    public void breakpointChanged(IBreakpoint piclBp, IMarkerDelta delta) {
        if (this.fSupportsMultiRequests) {
            return;
        }
        this.changeBreakpoint(piclBp);
    }

    private void changeBreakpoint(IBreakpoint piclBp) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointChanged(IBreakpoint, IMarkerDelta)");
        }
        if (PDTCoreUtils.isSourceLineBreakpoint(piclBp)) {
            this.updateModelLineBreakpointFromSourceBreakpointMarker(piclBp);
        }
        if (PDTCoreUtils.isSourceEntryBreakpoint(piclBp)) {
            this.updateModelEntryBreakpointFromSourceBreakpointMarker(piclBp);
        }
    }

    protected void updateModelLineBreakpointFromSourceBreakpointMarker(IBreakpoint piclBp) {
        boolean attributeChanged;
        int modelBPLineNumber;
        IMarker marker = piclBp.getMarker();
        Breakpoint bp = this.fBreakpoints.get(marker);
        if (!(bp instanceof LineBreakpoint)) {
            return;
        }
        final LineBreakpoint modelBp = (LineBreakpoint)bp;
        OptionalBreakpointData modelBpOptData = new OptionalBreakpointData(bp);
        final int markerLineNumber = marker.getAttribute("lineNumber", 0);
        final String markerObjectName = marker.getAttribute("objectName", "*");
        final String markerModuleName = marker.getAttribute("moduleName", "*");
        final OptionalBreakpointData markerOptData = new OptionalBreakpointData(marker);
        if (modelBp.isDeferred()) {
            modelBPLineNumber = modelBp.getDeferredBreakpointLineNumber(this.getDebugEngine().getSourceViewInformation());
        } else {
            Location modelBPLocation = modelBp.getLocationWithinView(this.getDebugEngine().getSourceViewInformation());
            modelBPLineNumber = modelBPLocation.getLineNumber();
        }
        final String modelBPFileName = modelBp.getFileName();
        String modelBPModuleName = modelBp.getModuleName();
        String modelBPObjectName = modelBp.getPartName();
        boolean positionChanged = false;
        if (markerLineNumber != modelBPLineNumber) {
            positionChanged = true;
        }
        if (!positionChanged && (markerModuleName != null && !markerModuleName.equals("*") || modelBPModuleName != null && !modelBPModuleName.equals("*")) && !markerModuleName.equals(modelBPModuleName)) {
            positionChanged = true;
        }
        if (!positionChanged && (markerObjectName != null && !markerObjectName.equals("*") || modelBPObjectName != null && !modelBPObjectName.equals("*")) && !markerObjectName.equals(modelBPObjectName)) {
            positionChanged = true;
        }
        final boolean enableSetting = this.getEnableSetting(piclBp);
        final boolean enableChanged = enableSetting ^ modelBp.isEnabled();
        boolean bl = attributeChanged = !modelBpOptData.equals(markerOptData);
        if (enableChanged && (positionChanged || attributeChanged)) {
            PDTCoreUtils.logString(this, "Changing breakpoint's enable/disable and another attribute is not supported", 2);
        }
        if (positionChanged || attributeChanged || enableChanged) {
            final EPDC_Request.EProperty markerProp = new EPDC_Request.EProperty(1, marker);
            Job modifyBrkptJob = new Job("Modify source line breakpoint"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (enableChanged) {
                            modelBp.setEnable(enableSetting);
                        } else {
                            modelBp.modifyDeferred(enableSetting, markerLineNumber, null, markerModuleName, markerObjectName, modelBPFileName, markerOptData, markerProp, true);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (EngineRequestException e) {
                        PDTDebugTarget.this.logException(e);
                        return new Status(2, "com.ibm.debug.pdt.core", e.getMessage());
                    }
                }
            };
            modifyBrkptJob.schedule();
            if (this.getDebugEngine().isProcessingMultiRequest()) {
                try {
                    modifyBrkptJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void updateModelEntryBreakpointFromSourceBreakpointMarker(IBreakpoint piclBp) {
        IMarker marker = piclBp.getMarker();
        final Breakpoint modelBp = this.fBreakpoints.get(marker);
        if (modelBp == null) {
            if (this.isTerminated()) {
                this.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
                this.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            }
            return;
        }
        final boolean enableSetting = this.getEnableSetting(piclBp);
        final boolean enableChanged = enableSetting ^ modelBp.isEnabled();
        if (enableChanged) {
            Job modifyBrkptJob = new Job("Modify source entry breakpoint"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (enableChanged) {
                            modelBp.setEnable(enableSetting);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (EngineRequestException e) {
                        PDTDebugTarget.this.logException(e);
                        return new Status(2, "com.ibm.debug.pdt.core", e.getMessage());
                    }
                }
            };
            modifyBrkptJob.schedule();
            if (this.getDebugEngine().isProcessingMultiRequest()) {
                try {
                    modifyBrkptJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean getEnableSetting(IBreakpoint piclBp) {
        boolean skipAll;
        boolean bl = skipAll = !this.getBreakpointManager().isEnabled();
        if (skipAll) {
            return false;
        }
        try {
            return piclBp.isEnabled();
        }
        catch (CoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
            return true;
        }
    }

    public void breakpointRemoved(IBreakpoint ibreakpoint, IMarkerDelta delta) {
        if (this.fSupportsMultiRequests) {
            return;
        }
        this.removeBreakpoint(ibreakpoint);
    }

    public void removeBreakpoint(IBreakpoint ibreakpoint) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".breakpointRemoved(IBreakpoint, IMarkerDelta)");
        }
        if (ibreakpoint instanceof PICLBaseBreakpoint && ((PICLBaseBreakpoint)ibreakpoint).getDebugTarget() != this) {
            return;
        }
        if (this.isTerminated()) {
            return;
        }
        if (!this.isAcceptingRequests()) {
            this.addPendingBkpChange(ibreakpoint, (byte)1);
            return;
        }
        if (ibreakpoint instanceof PICLStopAtAllFunctionEntryBreakpoint && !this.getProcess().isTerminated()) {
            this.getDebugEngine().setAllEntryBreakpointsInstalled(false);
        }
        boolean keepZeroAddressbreakpoint = true;
        if (ibreakpoint instanceof PICLZeroAddressBreakpoint && !this.getProcess().isTerminated()) {
            this.getDebugEngine().setZeroAddressBreakpointInstalled(false);
            keepZeroAddressbreakpoint = false;
        }
        final IBreakpoint thisIBreakpoint = ibreakpoint;
        final Breakpoint breakpoint = this.fBreakpoints.get(ibreakpoint.getMarker());
        if (!(breakpoint == null || breakpoint instanceof ZeroAddressBreakpoint && keepZeroAddressbreakpoint)) {
            Job removeBpJob = new Job("Remove breakpoint..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        breakpoint.remove(thisIBreakpoint.getMarker());
                    }
                    catch (EngineRequestException e) {
                        PDTCoreUtils.logError(e);
                        return new Status(4, "com.ibm.debug.pdt.core", 0, e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            removeBpJob.schedule();
            if (this.getDebugEngine().isProcessingMultiRequest()) {
                try {
                    removeBpJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean connectAndInit(byte language) {
        ILaunchConfiguration lc;
        DebugEngine debugEngine = this.getDebugEngine();
        this.getEngineSession().setupEPDCDumping(this);
        try {
            this.updateCurrentState((byte)1);
            debugEngine.connect(this.fSocket);
            this.updateCurrentState((byte)2);
        }
        catch (Exception e) {
            this.fLastError = 316;
            this.fLastErrorText = PICLMessages.picl_common_comm_failure;
            this.updateCurrentState((byte)9);
            try {
                if (this.fSocket != null) {
                    this.fSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        debugEngine.addEventListener(this);
        ILaunch launch = this.getLaunch();
        String searchPath = null;
        if (launch == null) {
            searchPath = this.fEngineSession.getGlobalEnginePath();
        } else {
            IRemoteEnginePathContainer enginePathContainer;
            ISourceLocator sourceDirector = launch.getSourceLocator();
            if (sourceDirector != null && sourceDirector instanceof ISourceLookupDirector && (enginePathContainer = PDTCoreUtils.getDebugEnginePathContainer((ISourceLookupDirector)sourceDirector)) != null) {
                searchPath = enginePathContainer.getPath();
            }
        }
        try {
            this.fReconnect = debugEngine.initialize(language, null, null, searchPath);
        }
        catch (EngineRequestException e3) {
            this.logException(e3);
            return false;
        }
        if (!EngineSupport.isEngineSupported(this.getDebugEngine())) {
            this.fLastError = 316;
            this.fLastErrorText = PICLMessages.picl_debug_target_error_unsupported_engine;
            try {
                this.terminate();
            }
            catch (DebugException e1) {
                this.updateCurrentState((byte)9);
                try {
                    if (this.fSocket != null) {
                        this.fSocket.close();
                    }
                }
                catch (IOException enginePathContainer) {
                    // empty catch block
                }
            }
            this.logException(new EngineRequestException(this.fLastErrorText));
            return false;
        }
        debugEngine.setLocalSourcePath(searchPath);
        if (this.getEngineSession().supportsEventContent() && (lc = this.fStartupInfo.getLaunchConfig()) != null) {
            try {
                Map<String, String> attributes = PDTCoreUtils.getEventAttributes(lc);
                this.sendEventAttributes((short)300, attributes, 0);
                this.loadPreferenceXML(lc);
            }
            catch (Exception e) {
                PDTCoreUtils.logError(e);
            }
        }
        this.updateCurrentState((byte)4);
        return true;
    }

    private void loadPreferenceXML(ILaunchConfiguration launchConfig) throws EngineRequestException {
        EReqGetEventContent request = new EReqGetEventContent(301, this.fEngineSession);
        ERepGetEventContent reply = (ERepGetEventContent)this.getDebugEngine().processRequest(request, 0);
        String xml = reply.getXML();
        if (!xml.isEmpty()) {
            try {
                ILaunchConfigurationWorkingCopy lcwc = null;
                lcwc = launchConfig instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)launchConfig : launchConfig.getWorkingCopy();
                lcwc.setAttribute("com.ibm.debug.pdt.event_prefPage_XML", xml);
                lcwc.doSave();
                this.fPreferencePageSupported = true;
            }
            catch (CoreException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
    }

    public boolean isEnginePreferencePageSupported() {
        return this.fPreferencePageSupported;
    }

    /*
     * Unable to fully structure code
     */
    public void sendEventAttributes(short eventType, Map<String, String> attributes, int threadId) throws EngineRequestException {
        block14: {
            block15: {
                block16: {
                    launchConfig = this.getStartupInfo().getLaunchConfig();
                    engineSession = this.getEngineSession();
                    pairs = new EStdNameValuePair[attributes.size()];
                    idx = 0;
                    for (Map.Entry<String, String> entry : attributes.entrySet()) {
                        pairs[idx++] = new EStdNameValuePair(entry.getKey(), entry.getValue(), engineSession);
                    }
                    if (this.getProcess() != null && threadId != 0) {
                        if (this.supportsAsync()) {
                            thread = ((DebuggeeProcess)this.getProcess()).getThread(threadId);
                            this.preResume(false);
                            thread.preResume();
                            thread.fireResumeEvent(32);
                        } else {
                            this.preResume(true);
                            this.fireResumeEvent(32);
                        }
                    }
                    try {
                        request = new EReqPutEventContent(eventType, pairs, this.fEngineSession);
                        reply = (ERepPutEventContent)this.getDebugEngine().processRequest(request, threadId);
                        break block14;
                    }
                    catch (EngineRequestException e) {
                        if (e instanceof EngineConnectionException) break block15;
                        if (this.supportsAsync()) {
                            thread = ((DebuggeeProcess)this.getProcess()).getThread(threadId);
                            this.postResume();
                            thread.resetState();
                            thread.fireSuspendEvent(32);
                            break block16;
                        }
                        threads = this.fProcess.getThreads();
                        i = 0;
                        ** while (i < threads.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        threads[i].resetState();
                        ++i;
                        continue;
                    }
lbl35:
                    // 1 sources

                    this.postResume();
                    this.fireSuspendEvent(32);
                }
                if (!(e instanceof EngineBusyException)) {
                    throw e;
                }
            }
            return;
        }
        attributesToSave = reply.getFields();
        if (attributesToSave.length > 0) {
            try {
                tempMap = new HashMap<String, String>();
                var14_17 = attributesToSave;
                var13_18 = attributesToSave.length;
                var12_19 = 0;
                while (var12_19 < var13_18) {
                    attribute = var14_17[var12_19];
                    name = attribute.getName();
                    if (name != null && !name.isEmpty()) {
                        tempMap.put(name, attribute.getValue());
                    }
                    ++var12_19;
                }
                PDTCoreUtils.setEventAttributes(launchConfig, tempMap, true);
            }
            catch (CoreException e) {
                PDTCoreUtils.logError((Exception)e);
            }
        }
    }

    public String getEventXML(short eventType, int threadId) throws EngineRequestException {
        EReqGetEventContent request = new EReqGetEventContent(eventType, this.getEngineSession());
        ERepGetEventContent reply = null;
        reply = (ERepGetEventContent)this.getDebugEngine().processRequest(request, threadId);
        return reply.getXML();
    }

    public void createWatchBreakpoint(boolean enable, String addrOrExpr, int byteCount, OptionalBreakpointData optBpData, EPDC_Request.EProperty property, EStdView esv, String bkpFileName, String bkpModuleName, String bkpPartName, String bkpRestoreAddress) throws EngineRequestException {
        if (this.fProcess != null) {
            this.fProcess.setWatchpoint(false, enable, addrOrExpr, byteCount, optBpData, property, esv, bkpFileName, bkpModuleName, bkpPartName, bkpRestoreAddress);
        }
    }

    public void createZeroAddressBreakpoint(boolean enable, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (this.fProcess != null) {
            this.fProcess.setZeroAddressBreakpoint(enable, optBpData, property);
        }
    }

    public PICLZeroAddressBreakpoint findZeroAddressBreakpoint() {
        IBreakpointManager bkpm = this.getBreakpointManager();
        IBreakpoint[] bkps = bkpm.getBreakpoints(this.getModelIdentifier());
        int i = 0;
        while (i < bkps.length) {
            IBreakpoint bkp = bkps[i];
            if (bkp instanceof PICLZeroAddressBreakpoint && ((PICLZeroAddressBreakpoint)bkp).getDebugTarget() == this) {
                return (PICLZeroAddressBreakpoint)bkp;
            }
            ++i;
        }
        return null;
    }

    public void createDeferredEntryBreakpoint(boolean enabled, String moduleName, String partName, String functionName, boolean caseSensitive, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (this.fProcess != null) {
            this.fProcess.setDeferredEntryBreakpoint(enabled, functionName, moduleName, partName, caseSensitive, optBpData, property);
        }
    }

    public void createDeferredLineBreakpoint(boolean enabled, int lineNumber, String stmtNumber, String moduleName, String partName, String fileName, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (this.fProcess != null) {
            this.fProcess.setDeferredLineBreakpoint(enabled, lineNumber, stmtNumber, null, moduleName, partName, fileName, optBpData, property);
        }
    }

    public void createDeferredMacroBreakpoint(String moduleName, String partName, String macroName, OptionalBreakpointData optData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (this.fProcess != null) {
            this.fProcess.setDeferredMacroBreakpoint(true, macroName, moduleName, partName, optData, property);
        }
    }

    public void createEntryBreakpoint(boolean enabled, Function function, boolean caseSensitive, OptionalBreakpointData optBpData) throws EngineRequestException {
        function.setBreakpoint(enabled, caseSensitive, optBpData);
    }

    public void createLineBreakpoint(boolean enabled, Location location, String stmtNum, OptionalBreakpointData optBpData, EPDC_Request.EProperty property, String engineData) throws EngineRequestException {
        if (this.getDebugEngine().getEngineSession().isSLD()) {
            stmtNum = this.cleanStatementNumber(stmtNum);
        }
        location.getViewFile().setBreakpoint(enabled, location.getLineNumber(), stmtNum, optBpData, property, engineData);
    }

    public void createLoadBreakpoint(boolean enabled, String moduleName, OptionalBreakpointData optBpData, EPDC_Request.EProperty property, boolean isRunToEntry) throws EngineRequestException {
        if (this.fProcess != null) {
            this.fProcess.setModuleLoadBreakpoint(enabled, moduleName, optBpData, property, isRunToEntry);
        }
    }

    public void createOccurrenceBreakpoint(boolean enabled, String condition, OptionalBreakpointData optBpData, EPDC_Request.EProperty property) throws EngineRequestException {
        if (this.fProcess != null) {
            this.fProcess.setOccurrenceBreakpoint(enabled, condition, optBpData, property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineIsWaiting(Socket socket) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".engineIsWaiting(Socket, boolean)");
        }
        this.fSocket = socket;
        this.setProperty("ENGINE_SOCKET", socket);
        try {
            if (this.fSocket != null) {
                this.fSocket.setTcpNoDelay(true);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.setDebugEngine(new DebugEngine(this));
        this.fireCreationEvent();
        this.fModuleParent = new PICLModuleParent(this, this);
        this.fMonitorParent = new PICLMonitorParent(this, this.getDebugEngine());
        EPDC_EngineSession engineSession = this.getEngineSession();
        if (this.fStartupInfo == null) {
            try {
                this.terminate();
            }
            catch (DebugException de) {
                PDTCoreUtils.logError((Exception)((Object)de));
            }
            return;
        }
        engineSession.setAuthenticateConnection(this.fStartupInfo.isAuthenticateSession());
        if (engineSession.isAuthenticateConnection()) {
            engineSession.setUserId(this.fStartupInfo.getUserId());
            engineSession.setPassword(this.fStartupInfo.getPassword());
        }
        if (!this.connectAndInit(this.fStartupInfo.getLanguage())) {
            try {
                this.terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            return;
        }
        if (this.fStartupInfo instanceof PICLNoTargetStartupInfo) {
            PICLAbstractStartupInfo pICLAbstractStartupInfo = this.fStartupInfo;
            synchronized (pICLAbstractStartupInfo) {
                this.fStartupInfo.notifyAll();
            }
        } else if (this.fReconnect) {
            this.reconnectProgram((IPICLLoadInfo)((Object)this.fStartupInfo));
        } else {
            this.fStartupInfo.setViewOrder(ViewInformation.getPreferredViewOrder(this.getDebugEngine()));
            if (this.fStartupInfo instanceof IPICLLoadInfo && !this.fStartupInfo.isAttach()) {
                this.loadProgram((IPICLLoadInfo)((Object)this.fStartupInfo));
            } else if (this.fStartupInfo instanceof IPICLAttachInfo) {
                this.attachToProcess((IPICLAttachInfo)((Object)this.fStartupInfo));
            }
        }
    }

    protected void setSourceLineBreakpoint(IMarker marker) {
    }

    protected void setSourceEntryBreakpoint(IMarker marker) {
    }

    @Override
    public void messageReceived(MessageReceivedEvent event) {
    }

    @Override
    public void postStepping() {
        this.postResume();
    }

    @Override
    public void preResume(boolean resumeAllThreads) {
        this.resetChanged();
        this.fIsStoppedByBreakpoint = false;
        this.fStoppingBreakpoints = EMPTYBREAKPOINTS;
        if (resumeAllThreads) {
            DebuggeeThread[] threads = this.fProcess.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].preResume();
                ++i;
            }
        }
        this.updateCurrentState((byte)11);
    }

    @Override
    public void preStepping(boolean stepAllThreads) {
        this.resetChanged();
        this.fIsStoppedByBreakpoint = false;
        this.fStoppingBreakpoints = EMPTYBREAKPOINTS;
        if (stepAllThreads) {
            DebuggeeThread[] threads = this.fProcess.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].preStepping();
                ++i;
            }
        }
        this.updateCurrentState((byte)11);
    }

    @Override
    public void processAdded(ProcessAddedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".processAdded(ProcessAddedEvent)");
        }
        if (event != null) {
            this.fProcess = event.getProcess();
            if (this.fLabelProvider != null) {
                this.fProcess.setLabelProvider(this.fLabelProvider);
            }
            this.fProcess.addEventListener(this);
            this.fProcess.fireCreationEvent();
            this.updateCurrentState((byte)7);
        }
        if (this.fTeamDebugSession && this.fProcess != null) {
            EngineParameters engParms = this.fStartupInfo.getEngineParms();
            String temp = engParms.getAttribute("com.ibm.debug.pdt.team.processId");
            if (temp != null) {
                this.fProcess.setProcessID(temp);
            }
            if ((temp = engParms.getAttribute("com.ibm.debug.pdt.team.pgmName")) != null) {
                this.fProcess.setQualifiedName(temp);
            }
            if ((temp = engParms.getAttribute("com.ibm.debug.pdt.team.profileName")) != null) {
                this.fProcess.setBasePgmProfileName(temp);
            }
            if ((temp = engParms.getAttribute("com.ibm.debug.pdt.team.engine")) != null) {
                DebugEngine.GlobalProfile profile = new DebugEngine.GlobalProfile(temp);
                profile.restore(this.getDebugEngine(), 0x800000);
            }
            if ((temp = engParms.getAttribute("com.ibm.debug.pdt.team.dominantThread")) != null) {
                int i = 0;
                try {
                    i = Integer.parseInt(temp);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ProcessStopInfo psi = new ProcessStopInfo(i);
                this.fProcess.setProcessStopInfo(psi);
            }
        }
        if (this.getLaunch() != null) {
            DebuggeeStartupOptions startupOptions = this.getDebugEngine().getDebuggeeStartupOptions();
            if (startupOptions instanceof DebuggeePrepareOptions && ((DebuggeePrepareOptions)startupOptions).runToMainEntryPoint() && !startupOptions.executeAfterStartup()) {
                try {
                    ((DebuggeeProcess)this.getProcess()).runToMainEntryPoint();
                }
                catch (EngineRequestException e) {
                    this.logException(e);
                }
            }
            this.getLaunch().addProcess(this.getProcess());
            IBreakpointManager manager = this.getBreakpointManager();
            manager.addBreakpointListener((IBreakpointListener)this);
            this.fSupportsMultiRequests = this.getDebugEngine().getEngineSession().supportsMultipleRequests();
            if (this.fSupportsMultiRequests) {
                manager.addBreakpointListener((IBreakpointsListener)this);
            }
            manager.addBreakpointManagerListener((IBreakpointManagerListener)this);
            this.fResumeOnStart = startupOptions.executeAfterStartup();
        }
    }

    @Override
    public void processDetached(ProcessDetachedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".processDetached(ProcessDetachedEvent)");
        }
        this.updateCurrentState((byte)6);
        try {
            this.terminate();
        }
        catch (DebugException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
        }
        this.removeAllChildren();
        this.fProcess.removeListener(this);
        this.fProcess.fireTerminateEvent();
        this.fProcess = null;
    }

    private void processPendingBkpRequests() {
        if (this.fBkptPendingActions != null && !this.fBkptPendingActions.isEmpty()) {
            this.fBusyProcPnding = true;
            Collection<BkpRequest> actions = this.fBkptPendingActions.values();
            Iterator<BkpRequest> iter = actions.iterator();
            block13: while (iter.hasNext()) {
                BkpRequest req = iter.next();
                IBreakpoint bkp = req.fBkp;
                byte action = req.fAction;
                iter.remove();
                try {
                    switch (action) {
                        case 1: {
                            this.breakpointRemoved(bkp, null);
                            if (!(bkp instanceof PICLStopAtAllFunctionEntryBreakpoint)) continue block13;
                            try {
                                this.getDebugEngine().setAllEntryBreakpointsEnabled(false);
                                break;
                            }
                            catch (EngineRequestException e) {
                                Status status = new Status(4, "com.ibm.debug.pdt.core", 0, e.getMessage(), (Throwable)e);
                                throw new CoreException((IStatus)status);
                            }
                        }
                        case 3: {
                            bkp.setEnabled(false);
                            break;
                        }
                        case 2: {
                            bkp.setEnabled(true);
                            break;
                        }
                        case 4: {
                            ((PICLBaseBreakpoint)bkp).setSkip(true);
                            break;
                        }
                        case 5: {
                            ((PICLBaseBreakpoint)bkp).setSkip(false);
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    PDTCoreUtils.logError((Exception)((Object)e));
                }
            }
            this.fBusyProcPnding = false;
        }
        while (this.fBrkMgrEnablementChgd.equals(Boolean.TRUE)) {
            boolean currentEnablement = this.getBreakpointManager().isEnabled();
            this.fBrkMgrEnablementChgd = Boolean.FALSE;
            boolean supportsMultiRequests = this.getDebugEngine().getEngineSession().supportsMultipleRequests();
            if (supportsMultiRequests) {
                this.getDebugEngine().startMultipleRequest();
            }
            IBreakpoint[] bkps = this.getBreakpointManager().getBreakpoints();
            int i = 0;
            while (i < bkps.length) {
                if (bkps[i] instanceof PICLBaseBreakpoint && ((PICLBaseBreakpoint)bkps[i]).getDebugTarget() == this) {
                    ((PICLBaseBreakpoint)bkps[i]).setSkip(!currentEnablement);
                } else {
                    Breakpoint bp = this.fBreakpoints.get(bkps[i].getMarker());
                    try {
                        if (bp != null && PDTCoreUtils.isSourceLineBreakpoint(bkps[i])) {
                            if (!(bp instanceof LineBreakpoint)) {
                                return;
                            }
                            modelBP = (LineBreakpoint)bp;
                            if (currentEnablement && !modelBP.isEnabled()) {
                                modelBP.setEnable(false);
                            } else if (!currentEnablement && modelBP.isEnabled()) {
                                modelBP.setEnable(true);
                            }
                        } else if (bp != null && PDTCoreUtils.isSourceLineBreakpoint(bkps[i])) {
                            if (!(bp instanceof EntryBreakpoint)) {
                                return;
                            }
                            modelBP = (EntryBreakpoint)bp;
                            if (currentEnablement && !modelBP.isEnabled()) {
                                modelBP.setEnable(false);
                            } else if (!currentEnablement && modelBP.isEnabled()) {
                                modelBP.setEnable(true);
                            }
                        }
                    }
                    catch (EngineRequestException ere) {
                        PDTCoreUtils.logError(ere);
                    }
                }
                ++i;
            }
            if (!supportsMultiRequests) continue;
            this.getDebugEngine().endMultipleRequest(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processStopped(ProcessStoppedEvent event) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".processStopped(ProcessStoppedEvent)");
        }
        if ((stopInfo = event.getProcessStopInfo()).getReason() == 22) {
            block15: {
                try {
                    this.fProcess.run(false);
                    break block15;
                }
                catch (EngineRequestException e) {
                    if (e instanceof EngineConnectionException) break block15;
                    threads = this.fProcess.getThreads();
                    i = 0;
                    ** while (i < threads.length)
                }
lbl-1000:
                // 1 sources

                {
                    threads[i].resetState();
                    ++i;
                    continue;
                }
lbl15:
                // 1 sources

                this.postResume();
                this.fireSuspendEvent(32);
                PDTCoreUtils.logError(e);
            }
            return;
        }
        stoppingThread = this.fProcess.getStoppingThread();
        stoppingBreakpointIds = stopInfo.getBreakpointsHit();
        if (stoppingBreakpointIds.length > 0) {
            stoppingBreakpoints = new Breakpoint[stoppingBreakpointIds.length];
            i = 0;
            while (i < stoppingBreakpoints.length) {
                stoppingBreakpoints[i] = this.fProcess.getBreakpoint(stoppingBreakpointIds[i]);
                ++i;
            }
        } else {
            stoppingBreakpoints = PDTDebugTarget.EMPTYBREAKPOINTLIST;
        }
        this.saveStoppingBreakpoints(stoppingBreakpoints);
        this.fIsStoppedByBreakpoint = stopInfo.isStoppedByBreakpoint();
        this.processPendingBkpRequests();
        detail = 0;
        if (stoppingThread != null) {
            detail = stopInfo.isStoppedByBreakpoint() != false ? 16 : (stoppingThread.isStepping() != false ? 8 : 32);
            if (stoppingThread.isStepping()) {
                stoppingThread.postStepping();
            } else {
                stoppingThread.postResume();
            }
        }
        this.postResume();
        if (stoppingThread != null) {
            stoppingThread.fireSuspendEvent(detail);
        }
        this.fireSuspendEvent(0);
        if (this.fResumeOnStart) {
            this.fResumeOnStart = false;
            try {
                this.resume();
            }
            catch (DebugException de) {
                PDTCoreUtils.logError((Exception)de);
            }
        }
    }

    @Override
    public String getId() {
        return this.fID;
    }

    @Override
    public String getLabel() {
        if (this.fPlatformLabel == null) {
            StringBuilder platformLabel = new StringBuilder();
            if (this.fTeamDebugSession) {
                platformLabel.append("[");
                platformLabel.append(PICLLabels.TeamDebugLabel);
                platformLabel.append("] ");
            }
            if (this.getDebugEngine() != null && this.getEngineSession() != null && this.getDebugEngine().hasBeenInitialized()) {
                String engineLabel = this.getEngineSession().getEngineLabel();
                if (engineLabel != null) {
                    platformLabel.append(engineLabel);
                } else {
                    platformLabel.append(this.getEngineSession().getEngineOSString());
                    platformLabel.append(" ");
                    platformLabel.append(this.getEngineSession().getEngineHardwareString());
                }
                this.fPlatformLabel = platformLabel.toString();
            }
        }
        Object[] substitutionText = new String[]{this.fPlatformLabel == null ? PICLLabels.picl_debug_target_platform_unknown : this.fPlatformLabel, this.getConnectionLabel()};
        StringBuilder label = new StringBuilder(NLS.bind((String)PICLLabels.picl_debug_target_label_full2, (Object[])substitutionText));
        if (this.fLastError != 0) {
            Object[] subText = new String[]{String.valueOf(this.fLastError), this.fLastErrorText};
            label.append(" ");
            label.append(PDTCoreUtils.getLineBreakFreeString(NLS.bind((String)PICLLabels.picl_debug_target_label_error, (Object[])subText)));
        }
        if (this.fLabelProvider != null) {
            return this.fLabelProvider.getLabel(this, label.toString());
        }
        return label.toString();
    }

    public void setConnectionLabel(String string) {
        this.fConnectionLabel = string;
    }

    public String getName() {
        return this.getLabel();
    }

    @Override
    public IBreakpoint[] getStoppingBreakpoints() {
        return Arrays.copyOf(this.fStoppingBreakpoints, this.fStoppingBreakpoints.length);
    }

    public IThread[] getThreads() throws DebugException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".getThreads()");
        }
        if (this.fProcess == null) {
            return EMPTYTHREADS;
        }
        return this.fProcess.getThreads();
    }

    public boolean isStoppedByBreakpoint() {
        return this.fIsStoppedByBreakpoint;
    }

    protected boolean reconnectProgram(IPICLLoadInfo loadInfo) {
        DebuggeeReconnectOptions options = new DebuggeeReconnectOptions(loadInfo.getProgramName(), 0, PDTCoreUtils.getProfileSaveRestoreLocation(), true, false);
        this.getDebugEngine().reconnectProgram(options);
        this.postResume();
        return true;
    }

    protected boolean loadProgram(IPICLLoadInfo loadInfo) {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".loadProgram(PICLLoadInfo)");
        }
        boolean runToMain = loadInfo.getStartupBehaviour() == 1;
        boolean runToBrkpt = loadInfo.getStartupBehaviour() == 2;
        DebuggeePrepareOptions prepareOptions = new DebuggeePrepareOptions(loadInfo.getProgramName(), loadInfo.getProgramParms(), 0, PDTCoreUtils.getProfileSaveRestoreLocation(), runToMain, true, runToBrkpt, null, loadInfo.getLanguage());
        this.fSuppressInfoErrorsDuringStartup = true;
        boolean success = false;
        if (loadInfo instanceof PICLAbstractStartupInfo) {
            prepareOptions.setViewOrder(((PICLAbstractStartupInfo)((Object)loadInfo)).getViewOrder());
        }
        try {
            this.getDebugEngine().prepareProgram(prepareOptions);
            success = true;
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, "  Engine prepared");
            }
        }
        catch (EngineRequestException e) {
            this.logException(e);
            try {
                this.terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return success;
    }

    public void restartProgram() throws DebugException {
        DebugEngine dbgEngine;
        this.fRestartProgram = true;
        if (this.fProcess != null) {
            DebuggeeProcess oldProcess = this.fProcess;
            this.fProcess.terminate();
            ILaunch launch = this.getLaunch();
            if (launch != null) {
                IProcess[] iProcessArray = launch.getProcesses();
                int n = iProcessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess proc = iProcessArray[n2];
                    if (proc == oldProcess) {
                        launch.removeProcess(proc);
                    }
                    ++n2;
                }
            }
        }
        if ((dbgEngine = this.getDebugEngine()) == null) {
            return;
        }
        IMemoryBlockManager memoryBlockManager = DebugPlugin.getDefault().getMemoryBlockManager();
        IMemoryBlock[] memoryBlocks = memoryBlockManager.getMemoryBlocks((IDebugTarget)this);
        memoryBlockManager.removeMemoryBlocks(memoryBlocks);
        DebuggeeStartupOptions options = dbgEngine.getDebuggeeStartupOptions();
        if (options instanceof DebuggeePrepareOptions) {
            try {
                dbgEngine.prepareProgram((DebuggeePrepareOptions)options);
            }
            catch (EngineRequestException e) {
                throw new DebugException(Status.CANCEL_STATUS);
            }
        }
    }

    public void resume() throws DebugException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".resume()");
        }
        try {
            this.resume(false);
        }
        catch (EngineRequestException e) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), (Throwable)e));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void resume(boolean exception) throws EngineRequestException {
        block6: {
            if (!this.canResume()) {
                return;
            }
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(this, ".resume()");
            }
            this.traceThreadAction(null, (short)4);
            this.preResume(true);
            this.fireResumeEvent(32);
            try {
                this.fProcess.run(exception);
                break block6;
            }
            catch (EngineRequestException e) {
                if (e instanceof EngineConnectionException) break block6;
                threads = this.fProcess.getThreads();
                i = 0;
                ** while (i < threads.length)
            }
lbl-1000:
            // 1 sources

            {
                threads[i].resetState();
                ++i;
                continue;
            }
lbl19:
            // 1 sources

            this.postResume();
            this.fireSuspendEvent(32);
            if (!(e instanceof EngineBusyException)) {
                throw e;
            }
        }
    }

    public void suspend() throws DebugException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString(this, ".suspend()");
        }
        this.traceThreadAction(null, (short)5);
        if (this.fProcess == null) {
            return;
        }
        try {
            this.fProcess.halt();
        }
        catch (EngineRequestException e) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, e.getMessage(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFolder getViewFileCache() throws CoreException {
        block6: {
            if (this.fViewFileFolder == null) {
                this.fViewFileFolder = PDTCoreUtils.getViewFileCache(this.getId());
                try {
                    if (this.fViewFileFolder.members().length <= 0) break block6;
                    IFolder iFolder = PDTCoreUtils.getViewFileCache(this.getId());
                    synchronized (iFolder) {
                        this.fViewFileFolder.delete(true, null);
                    }
                }
                catch (CoreException e) {
                    PDTCoreUtils.logError((Exception)((Object)e));
                }
            }
        }
        return this.fViewFileFolder;
    }

    @Override
    public void saveToProfile() {
    }

    public void markMemBlksChanged(boolean fireEvent) {
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    private String getConnectionLabel() {
        if (this.fConnectionLabel == null) {
            if (this.fSocket == null) {
                return PICLLabels.picl_debug_target_state_disconnected;
            }
            this.fConnectionLabel = this.fSocket.getInetAddress().getHostName() + ":" + this.fSocket.getPort();
        }
        return this.fConnectionLabel;
    }

    public void saveStoppingBreakpoints(Breakpoint[] modelBreakpointsHit) {
        if (modelBreakpointsHit == null || modelBreakpointsHit.length == 0) {
            this.fStoppingBreakpoints = EMPTYBREAKPOINTS;
        } else {
            this.fStoppingBreakpoints = new IBreakpoint[modelBreakpointsHit.length];
            int i = 0;
            while (i < modelBreakpointsHit.length) {
                Enumeration<IMarker> bpMarkers = this.fBreakpoints.keys();
                while (bpMarkers.hasMoreElements()) {
                    IMarker bpMarker = bpMarkers.nextElement();
                    if (modelBreakpointsHit[i] != this.getBreakpoint(bpMarker)) continue;
                    this.fStoppingBreakpoints[i] = this.getBreakpointManager().getBreakpoint(bpMarker);
                    break;
                }
                ++i;
            }
        }
    }

    protected ViewFile getViewFile(IMarker marker, ViewInformation viewInformation) {
        IResource resource = marker.getResource();
        String resourceFileName = resource.getName();
        if (resource instanceof IProject || resource instanceof IWorkspaceRoot) {
            try {
                String markerType = marker.getType();
                if (markerType.equals("com.ibm.debug.pdt.core.PICLLineBreakpoint") || markerType.equals("com.ibm.debug.pdt.core.PICLEntryBreakpoint") || markerType.equals("com.ibm.debug.pdt.MonitoredExpression") || markerType.equals("com.ibm.debug.pdt.PICLLocationMarker")) {
                    resourceFileName = (String)marker.getAttribute("fileName");
                }
            }
            catch (CoreException ce) {
                PDTCoreUtils.logError((Exception)((Object)ce));
            }
        }
        return this.getViewFile(resourceFileName, viewInformation);
    }

    @Deprecated
    protected ViewFile getViewFile(String resourceFileName, ViewInformation viewInformation) {
        Module[] modules = this.fProcess.getModules(false);
        int i = 0;
        while (i < modules.length) {
            Part[] parts;
            Module m = modules[i];
            if (m != null && (parts = m.getParts()) != null && parts.length != 0) {
                int j = 0;
                while (j < parts.length) {
                    View v;
                    Part p = parts[j];
                    if (p != null && (v = p.getView(viewInformation)) != null) {
                        ViewFile[] viewFiles = v.getViewFiles();
                        int k = 0;
                        while (k < viewFiles.length) {
                            ViewFile vf = viewFiles[i];
                            if (vf != null) {
                                try {
                                    String resourceNameWithoutExtension = resourceFileName.substring(0, resourceFileName.lastIndexOf("."));
                                    if (this.is390() && vf.getBaseFileName().equalsIgnoreCase(resourceFileName) || this.is390() && vf.getBaseFileName().equalsIgnoreCase(resourceNameWithoutExtension)) {
                                        if (PDTCorePlugin.fModel) {
                                            PDTCoreUtils.logString(this, "Found file! Module=" + m.getQualifiedName() + " Part=" + p.getName() + " File=" + vf.getFileName());
                                        }
                                        return vf;
                                    }
                                    if (vf.getBaseFileName().equals(resourceFileName)) {
                                        if (PDTCorePlugin.fModel) {
                                            PDTCoreUtils.logString(this, "Found file! Module=" + m.getQualifiedName() + " Part=" + p.getName() + " File=" + vf.getFileName());
                                        }
                                        return vf;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    protected void logException(EngineRequestException e) {
    }

    @Override
    public DebuggeeThread getCurrentThread() {
        return null;
    }

    public boolean isReconnect() {
        return this.fReconnect;
    }

    @Override
    public boolean continueWaiting() {
        return false;
    }

    public String getSessionName() {
        if (PDTCoreUtils.isEmpty(this.fProgramName)) {
            this.fProgramName = this.getConnectionLabel().replace(':', '_');
        }
        return this.fProgramName;
    }

    private void setSessionNameFromStartupInfo() {
        EngineParameters eparms = this.fStartupInfo.getEngineParms();
        if (eparms == null) {
            return;
        }
        this.fProgramName = eparms.getProgramName();
        if (PDTCoreUtils.isEmpty(this.fProgramName)) {
            this.fProgramName = eparms.getTitle();
        }
    }

    public PICLAbstractStartupInfo getStartupInfo() {
        return this.fStartupInfo;
    }

    @Override
    public void updateStartupInfo(EngineParameters engineParms) {
        this.fStartupInfo.setEngineParms(engineParms);
    }

    protected IMemoryBlockRetrieval getMemorySupport() {
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IMemoryBlockRetrieval.class || adapter == IMemoryBlockRetrievalExtension.class) {
            return this.getMemorySupport();
        }
        return super.getAdapter(adapter);
    }

    public Socket getSocket() {
        return this.fSocket;
    }

    public void traceThreadEvent(ThreadEvent event) {
        try {
            for (IPDTDebugTracer tracer : this.fDebugTracers) {
                tracer.traceThreadEvent(event);
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public void traceThreadAction(DebuggeeThread thread, short actionType) {
        try {
            IPDTDebugTracer[] iPDTDebugTracerArray = this.getDebugTracers();
            int n = iPDTDebugTracerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPDTDebugTracer tracer = iPDTDebugTracerArray[n2];
                tracer.traceThreadAction(thread, actionType);
                ++n2;
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public void traceException(DebuggeeThread thread, String exception) {
        try {
            IPDTDebugTracer[] iPDTDebugTracerArray = this.getDebugTracers();
            int n = iPDTDebugTracerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPDTDebugTracer tracer = iPDTDebugTracerArray[n2];
                tracer.traceException(thread, exception);
                ++n2;
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public void traceExec(DebuggeeThread thread, String execProgram, boolean runToMain) {
        try {
            IPDTDebugTracer[] iPDTDebugTracerArray = this.getDebugTracers();
            int n = iPDTDebugTracerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPDTDebugTracer tracer = iPDTDebugTracerArray[n2];
                tracer.traceExec(thread, execProgram, runToMain);
                ++n2;
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public void traceEvent(DebuggeeThread thread, short eventType, String xml, Map<String, String> attributes) {
        try {
            IPDTDebugTracer[] iPDTDebugTracerArray = this.getDebugTracers();
            int n = iPDTDebugTracerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPDTDebugTracer tracer = iPDTDebugTracerArray[n2];
                tracer.traceEvent(thread, eventType, xml, attributes);
                ++n2;
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public boolean enterRunToLocationMode(boolean skipBPsOnRunToLoc) {
        boolean bpManagerIsEnabled = DebugPlugin.getDefault().getBreakpointManager().isEnabled();
        if (skipBPsOnRunToLoc && bpManagerIsEnabled) {
            this.fRunToLocationMode = true;
            this.setSkipForAllTargetBreakpoints(true);
            return true;
        }
        return false;
    }

    public boolean endRunToLocationMode() {
        if (this.fRunToLocationMode) {
            this.fRunToLocationMode = false;
            this.setSkipForAllTargetBreakpoints(false);
            return true;
        }
        return false;
    }

    protected void setHandlingException(boolean value) {
        this.fIsExceptionHandling = value;
    }

    public boolean isExceptionBeingHandled() {
        return this.fIsExceptionHandling;
    }

    private String cleanStatementNumber(String stmtNum) {
        int i = stmtNum.length() - 1;
        while (i >= 0) {
            char c = stmtNum.charAt(i);
            if (Character.isDigit(c)) {
                return stmtNum.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public ExpressionBase getHoverExpression() {
        return this.fHoverExpression;
    }

    public void setHoverExpression(ExpressionBase hoverExpression) {
        this.fHoverExpression = hoverExpression;
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        if (this.fSupportsMultiRequests && breakpoints.length > 0) {
            if (breakpoints.length != 1) {
                this.getDebugEngine().startMultipleRequest();
                IBreakpoint[] iBreakpointArray = breakpoints;
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp = iBreakpointArray[n2];
                    this.addBreakpoint(bp);
                    ++n2;
                }
                this.getDebugEngine().endMultipleRequest(true);
            } else {
                this.addBreakpoint(breakpoints[0]);
            }
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fSupportsMultiRequests && breakpoints.length > 0) {
            if (breakpoints.length != 1) {
                this.getDebugEngine().startMultipleRequest();
                IBreakpoint[] iBreakpointArray = breakpoints;
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp = iBreakpointArray[n2];
                    this.removeBreakpoint(bp);
                    ++n2;
                }
                this.getDebugEngine().endMultipleRequest(true);
            } else {
                this.removeBreakpoint(breakpoints[0]);
            }
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fSupportsMultiRequests && breakpoints.length > 0) {
            if (breakpoints.length != 1) {
                this.getDebugEngine().startMultipleRequest();
                IBreakpoint[] iBreakpointArray = breakpoints;
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp = iBreakpointArray[n2];
                    this.changeBreakpoint(bp);
                    ++n2;
                }
                this.getDebugEngine().endMultipleRequest(true);
            } else {
                this.changeBreakpoint(breakpoints[0]);
            }
        }
    }

    @Override
    public void setLabelProvider(IPDTLabelProvider provider) {
        this.fLabelProvider = provider;
    }

    public boolean isMixedCCEnabled() {
        return this.fIsMixedCCEnabled;
    }

    public void setMixedCCEnabled(boolean flag) {
        this.fIsMixedCCEnabled = flag;
        this.fWasMixedCCEnabled |= flag;
    }

    public boolean wasMixedCCEverEnabled() {
        return this.fWasMixedCCEnabled;
    }

    public void setProperty(String key, Object value) {
        this.fProperties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.fProperties.get(key);
    }

    public static class BkpRequest {
        public IBreakpoint fBkp;
        public byte fAction;

        BkpRequest(IBreakpoint bkp, byte action) {
            this.fBkp = bkp;
            this.fAction = action;
        }
    }

    public static class PICLNoTargetStartupInfo
    extends PICLAbstractStartupInfo {
    }
}

