/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;

public abstract class PDTDebugElement
extends DebugElement
implements Comparable<PDTDebugElement> {
    private transient DebugEngine fDebugEngine;
    private transient boolean fChanged = false;
    private transient PDTDebugElement fParent = null;
    public static final transient PDTDebugElement[] EMPTYCHILDREN = new PDTDebugElement[0];
    private transient List<PDTDebugElement> fChildren = null;
    private transient Object fChildLock = new Object();
    private transient boolean fDoneCleanup = false;

    public PDTDebugElement() {
        super(null);
    }

    public PDTDebugElement(IDebugTarget target, DebugEngine debugEngine) {
        super(target);
        this.fDebugEngine = debugEngine;
    }

    public PDTDebugElement(IDebugTarget target, DebugEngine debugEngine, PDTDebugElement parent) {
        this(target, debugEngine);
        this.fParent = parent;
    }

    public String getModelIdentifier() {
        return "com.ibm.debug.pdt";
    }

    public abstract String getLabel();

    public DebugEngine getDebugEngine() {
        return this.fDebugEngine;
    }

    public EPDC_EngineSession getEngineSession() {
        return this.fDebugEngine.getEngineSession();
    }

    public void fireCreationEvent() {
        if (PDTCorePlugin.fFireCoreEvents) {
            PDTCoreUtils.logEvent("CREATION", this);
        }
        super.fireCreationEvent();
    }

    public void fireChangeEvent(int detail) {
        if (PDTCorePlugin.fFireCoreEvents) {
            PDTCoreUtils.logEvent("CHANGE  EVENT + detail: " + PDTDebugElement.printEventDetail(detail), this);
        }
        super.fireChangeEvent(detail);
    }

    public void fireResumeEvent(int detail) {
        if (PDTCorePlugin.fFireCoreEvents) {
            PDTCoreUtils.logEvent("RESUME  EVENT + detail: " + PDTDebugElement.printEventDetail(detail), this);
        }
        super.fireResumeEvent(detail);
    }

    public void fireSuspendEvent(int detail) {
        if (PDTCorePlugin.fFireCoreEvents) {
            PDTCoreUtils.logEvent("SUSPEND  EVENT + detail: " + PDTDebugElement.printEventDetail(detail), this);
        }
        super.fireSuspendEvent(detail);
    }

    public void fireTerminateEvent() {
        if (PDTCorePlugin.fFireCoreEvents) {
            PDTCoreUtils.logEvent("TERMINATION  EVENT", this);
        }
        super.fireTerminateEvent();
    }

    private static String printEventDetail(int detail) {
        switch (detail) {
            case 1: {
                return "STEP_INTO";
            }
            case 2: {
                return "STEP_OVER";
            }
            case 4: {
                return "STEP_RETURN";
            }
            case 8: {
                return "STEP_END";
            }
            case 16: {
                return "BREAKPOINT";
            }
            case 64: {
                return "EVALUATION";
            }
            case 128: {
                return "EVALUATION_IMPLICIT";
            }
            case 32: {
                return "CLIENT_REQUEST";
            }
            case 256: {
                return "STATE";
            }
            case 512: {
                return "CONTENT";
            }
            case 0: {
                return "UNSPECIFIED";
            }
        }
        return "**UNKNOWN**";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMemoryBlockRetrieval.class || adapter == IMemoryBlockRetrievalExtension.class) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        if (adapter == IDebugElement.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void setDebugEngine(DebugEngine debugEngine) {
        this.fDebugEngine = debugEngine;
    }

    public void setChanged() {
        this.fChanged = true;
    }

    public void resetChanged() {
        this.fChanged = false;
        PDTDebugElement[] values = this.getChildrenNoExpand();
        int i = 0;
        while (i < values.length) {
            values[i].resetChanged();
            ++i;
        }
    }

    public boolean isChanged() {
        return this.fChanged;
    }

    public PDTDebugElement getParentElement() {
        return this.fParent;
    }

    public PDTDebugElement[] getChildren() throws EngineRequestException {
        return this.getChildrenInternal();
    }

    public PDTDebugElement[] getChildrenNoExpand() {
        return this.getChildrenInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDTDebugElement[] getChildrenInternal() {
        Object object = this.fChildLock;
        synchronized (object) {
            if (this.fChildren == null || this.fChildren.isEmpty()) {
                return EMPTYCHILDREN;
            }
            return this.fChildren.toArray(new PDTDebugElement[this.fChildren.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        Object object = this.fChildLock;
        synchronized (object) {
            block4: {
                if (this.fChildren != null) break block4;
                return false;
            }
            return !this.fChildren.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(PDTDebugElement child, boolean fireCreationEvent) {
        Object object = this.fChildLock;
        synchronized (object) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList<PDTDebugElement>();
            }
            if (this.fChildren.contains(child)) {
                return;
            }
            this.fChildren.add(child);
        }
        if (fireCreationEvent) {
            child.fireCreationEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putChild(PDTDebugElement child, int idx) {
        Object object = this.fChildLock;
        synchronized (object) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList<PDTDebugElement>();
            }
            this.fChildren.add(idx, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChildren() {
        Object object = this.fChildLock;
        synchronized (object) {
            PDTDebugElement[] children = this.getChildrenNoExpand();
            int i = 0;
            while (i < children.length) {
                this.removeChild(children[i], false);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeChild(PDTDebugElement child, boolean fireEvent) {
        child.doCleanup();
        Object object = this.fChildLock;
        synchronized (object) {
            if (this.fChildren != null) {
                int idx = this.fChildren.indexOf(child);
                if (this.fChildren.remove(child) && fireEvent) {
                    child.fireTerminateEvent();
                }
                return idx;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void doCleanup() {
        if (this.haveDoneCleanup()) {
            return;
        }
        this.fDoneCleanup = true;
        Object object = this.fChildLock;
        synchronized (object) {
            PDTDebugElement[] childrenToClean = this.getChildrenNoExpand();
            int i = 0;
            while (i < childrenToClean.length) {
                if (childrenToClean[i] != null) {
                    this.removeChild(childrenToClean[i], false);
                }
                ++i;
            }
        }
        this.doCleanupDetails();
    }

    protected abstract void doCleanupDetails();

    public boolean haveDoneCleanup() {
        return this.fDoneCleanup;
    }

    @Override
    public int compareTo(PDTDebugElement o) {
        return 0;
    }
}

