/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.IPDTDebuggerEngine;
import com.ibm.debug.pdt.core.IPDTzPICLDebuggerEngine;
import com.ibm.debug.pdt.core.saverestore.IPersister;
import com.ibm.debug.pdt.internal.core.IDebugSessionStartupInfo;
import com.ibm.debug.pdt.internal.core.ISpecializedDebugTargetProvider;
import com.ibm.debug.pdt.internal.core.ISpecializedDebugTargetProviderWithMode;
import com.ibm.debug.pdt.internal.core.util.DefaultBIDIEngine;
import com.ibm.debug.pdt.internal.core.util.IBIDIEngine;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.osgi.framework.BundleContext;

public class PDTCorePlugin
extends Plugin {
    public static final String PLUGINID = "com.ibm.debug.pdt.core";
    public static boolean fFireCoreEvents = false;
    public static boolean fLogEventStack = false;
    public static boolean fModel = false;
    public static boolean fModelEvents = false;
    public static boolean fEPDCThreads = false;
    public static boolean fEPDCRequestOnMainThread = false;
    public static boolean fModelEPDC = false;
    public static boolean fLogEPDCBusy = false;
    public static boolean fDumpEPDC = false;
    public static String fDumpEPDCFile;
    public static boolean fLogEngineErrors;
    public static boolean fProfile;
    public static long fElapsedTime;
    public static boolean fTiming;
    private static final String RESTARTSUPPORTEXTENSIONPOINT = "com.ibm.debug.pdt.core.restartsupport";
    private static boolean fRestartSupported;
    private static boolean fRetrievedRestartSupported;
    private static final String ISOURCEBREAKPOINTADAPTER = "com.ibm.debug.pdt.core.isourcebreakpointadapter";
    private static boolean retrievedSourceBreakpointAdapters;
    private static IConfigurationElement[] fSourceBreakpointAdapters;
    public static final String IDEBUGGABLEPROJECT = "com.ibm.debug.pdt.core.idebuggableproject";
    public static final String PROJNATURE = "projectnature";
    public static final String CLASS = "class";
    private static boolean retrievedIDebuggableProject;
    private static IConfigurationElement[] fDebuggableProjPlugins;
    public static final String IPDTDEBUGGERENGINE = "com.ibm.debug.pdt.core.debuggerengines";
    public static final String OS_ATTRIBUTE = "os";
    public static final String ARCH_ATTRIBUTE = "arch";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PICL_ATTRIBUTE_VALUE = "picl";
    public static final String ZPICL_ATTRIBUTE_VALUE = "zpicl";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String IPERSISTER = "com.ibm.debug.pdt.core.profilepersister";
    private static final String ISOURCELINEBREAKPOINTINFOPROVIDER = "com.ibm.debug.pdt.core.isourcelinebreakpointinfoprovider";
    private static boolean retrievedISourceLineBreakpointInfoProviders;
    private static IConfigurationElement[] fSourceLineBreakpointInfoProviders;
    private static final String LINKEDRESOURCEMAPPER = "com.ibm.debug.pdt.core.linkedresourcesmapper";
    private static boolean retrievedLinkedResourceMappers;
    private static IConfigurationElement[] fLinkedResourceMappers;
    private static IPDTDebuggerEngine fPICLEngineLauncher;
    private static IPDTzPICLDebuggerEngine fZPICLEngineLauncher;
    private static IPersister fPersister;
    private static final String BIDIENGINE = "com.ibm.debug.pdt.core.bidiengine";
    private static boolean retrievedBIDIEngines;
    private static IConfigurationElement[] fBIDIEngines;
    private static IBIDIEngine fBIDIEngineImplementation;
    private static final Object fBIDILock;
    private static final String SPECIALIZEDTARGETPROVIDER = "com.ibm.debug.pdt.core.specializedtargetprovider";
    private static boolean fgRetrievedSpecializedTargetProviders;
    private static List<ISpecializedDebugTargetProvider> fgSpecializedTargetProviders;
    private static PDTCorePlugin fInstance;
    private static final Object fUniqueIdLock;
    private static Integer fUniqueId;
    private static HashMap<String, IPDTDebugTarget> fDebugTargets;
    private Object fCurrentSelection;
    private static boolean fSortLocals;
    private boolean fRecordDebugActions = false;

    static {
        fProfile = false;
        fElapsedTime = 0L;
        fTiming = false;
        fRestartSupported = false;
        fRetrievedRestartSupported = false;
        retrievedSourceBreakpointAdapters = false;
        retrievedIDebuggableProject = false;
        retrievedISourceLineBreakpointInfoProviders = false;
        retrievedLinkedResourceMappers = false;
        retrievedBIDIEngines = false;
        fBIDILock = new Object();
        fgRetrievedSpecializedTargetProviders = false;
        fgSpecializedTargetProviders = new LinkedList<ISpecializedDebugTargetProvider>();
        fInstance = new PDTCorePlugin();
        fUniqueIdLock = new Object();
        fUniqueId = 0;
        fDebugTargets = new HashMap();
        fSortLocals = false;
    }

    public static PDTCorePlugin getInstance() {
        return fInstance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.isDebugging()) {
            PDTCorePlugin.initializeTrace();
        }
    }

    private static void initializeTrace() {
        fFireCoreEvents = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/fireCoreEvents"));
        fLogEventStack = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/eventStack"));
        fEPDCThreads = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/epdc/threads"));
        fEPDCRequestOnMainThread = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/epdc/requestOnMainThread"));
        fDumpEPDC = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/epdc/trace"));
        fDumpEPDCFile = Platform.getDebugOption((String)"com.ibm.debug.pdt.core/epdc/dumpFile");
        fLogEPDCBusy = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/epdc/logBusy"));
        fLogEngineErrors = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/epdc/engineErrors"));
        fModel = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/model/trace"));
        fModelEvents = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/model/events"));
        fModelEPDC = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/model/epdcProcessing"));
        fProfile = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/profile"));
        fTiming = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ibm.debug.pdt.core/timing"));
        if (fTiming) {
            fElapsedTime = System.currentTimeMillis();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        PDTCorePlugin.terminateAllPDTDebugTargets();
        fDebugTargets.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugTarget(IPDTDebugTarget target) {
        HashMap<String, IPDTDebugTarget> hashMap = fDebugTargets;
        synchronized (hashMap) {
            fDebugTargets.put(target.getId(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugTarget(IPDTDebugTarget target) {
        HashMap<String, IPDTDebugTarget> hashMap = fDebugTargets;
        synchronized (hashMap) {
            fDebugTargets.remove(target.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPDTDebugTarget[] getDebugTargets() {
        HashMap<String, IPDTDebugTarget> hashMap = fDebugTargets;
        synchronized (hashMap) {
            return fDebugTargets.values().toArray(new IPDTDebugTarget[fDebugTargets.size()]);
        }
    }

    public static void terminateAllPDTDebugTargets() {
        IPDTDebugTarget[] pdts = PDTCorePlugin.getDebugTargets();
        if (pdts != null && pdts.length > 0) {
            int i = 0;
            while (i < pdts.length) {
                try {
                    if (pdts[i].isAcceptingRequests()) {
                        pdts[i].terminate();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public static IPDTDebugTarget getDebugTarget(ISourceLookupDirector director) {
        if (director == null) {
            return null;
        }
        IPDTDebugTarget[] iPDTDebugTargetArray = PDTCorePlugin.getDebugTargets();
        int n = iPDTDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDTDebugTarget debugTarget = iPDTDebugTargetArray[n2];
            ILaunch launch = debugTarget.getLaunch();
            if (launch != null && director.equals(launch.getSourceLocator())) {
                return debugTarget;
            }
            ++n2;
        }
        return null;
    }

    public static IPDTDebugTarget getDebugTarget(int key) {
        IPDTDebugTarget[] iPDTDebugTargetArray = PDTCorePlugin.getDebugTargets();
        int n = iPDTDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDTDebugTarget debugTarget = iPDTDebugTargetArray[n2];
            if (debugTarget.getKey() == key) {
                return debugTarget;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isRestartSupported() {
        if (!fRetrievedRestartSupported) {
            fRetrievedRestartSupported = true;
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(RESTARTSUPPORTEXTENSIONPOINT);
            fRestartSupported = extPoint.getExtensions().length > 0;
        }
        return fRestartSupported;
    }

    public static IConfigurationElement[] getSourceBreakpointAdapters() {
        if (!retrievedSourceBreakpointAdapters) {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(ISOURCEBREAKPOINTADAPTER);
            if (ep != null) {
                fSourceBreakpointAdapters = ep.getConfigurationElements();
            }
            retrievedSourceBreakpointAdapters = true;
        }
        return Arrays.copyOf(fSourceBreakpointAdapters, fSourceBreakpointAdapters.length);
    }

    public static IConfigurationElement[] getDebuggableProjectPlugins() {
        if (!retrievedIDebuggableProject) {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(IDEBUGGABLEPROJECT);
            if (ep != null) {
                fDebuggableProjPlugins = ep.getConfigurationElements();
            }
            retrievedIDebuggableProject = true;
        }
        return Arrays.copyOf(fDebuggableProjPlugins, fDebuggableProjPlugins.length);
    }

    public static IConfigurationElement[] getSourceLineBreakpointInfoProviders() {
        if (!retrievedISourceLineBreakpointInfoProviders) {
            retrievedISourceLineBreakpointInfoProviders = true;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(ISOURCELINEBREAKPOINTINFOPROVIDER);
            if (ep != null) {
                fSourceLineBreakpointInfoProviders = ep.getConfigurationElements();
            }
        }
        return Arrays.copyOf(fSourceLineBreakpointInfoProviders, fSourceLineBreakpointInfoProviders.length);
    }

    public static IConfigurationElement[] getLinkedResourceMappers() {
        if (!retrievedLinkedResourceMappers) {
            retrievedLinkedResourceMappers = true;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(LINKEDRESOURCEMAPPER);
            if (ep != null) {
                fLinkedResourceMappers = ep.getConfigurationElements();
            }
        }
        return Arrays.copyOf(fLinkedResourceMappers, fLinkedResourceMappers.length);
    }

    public static IPDTDebuggerEngine getLocalPICLEngine() {
        if (fPICLEngineLauncher != null) {
            return fPICLEngineLauncher;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(IPDTDEBUGGERENGINE);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getAttribute(OS_ATTRIBUTE).equals(Platform.getOS()) && element.getAttribute(ARCH_ATTRIBUTE).equals(Platform.getOSArch()) && element.getAttribute(TYPE_ATTRIBUTE).equals(PICL_ATTRIBUTE_VALUE)) {
                try {
                    Object callback = element.createExecutableExtension("class");
                    if (callback instanceof IPDTDebuggerEngine) {
                        fPICLEngineLauncher = (IPDTDebuggerEngine)callback;
                        return fPICLEngineLauncher;
                    }
                }
                catch (CoreException e1) {
                    PDTCoreUtils.logError((Exception)((Object)e1));
                }
            }
            ++i;
        }
        return null;
    }

    public static IPDTzPICLDebuggerEngine getLocalZPICLEngine() {
        if (fZPICLEngineLauncher != null) {
            return fZPICLEngineLauncher;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(IPDTDEBUGGERENGINE);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getAttribute(OS_ATTRIBUTE).equals(Platform.getOS()) && element.getAttribute(ARCH_ATTRIBUTE).equals(Platform.getOSArch()) && element.getAttribute(TYPE_ATTRIBUTE).equals(ZPICL_ATTRIBUTE_VALUE)) {
                try {
                    Object callback = element.createExecutableExtension("class");
                    if (callback instanceof IPDTzPICLDebuggerEngine) {
                        fZPICLEngineLauncher = (IPDTzPICLDebuggerEngine)callback;
                        return fZPICLEngineLauncher;
                    }
                }
                catch (CoreException e1) {
                    PDTCoreUtils.logError((Exception)((Object)e1));
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBIDIEngine getBIDIEngine() {
        Object object = fBIDILock;
        synchronized (object) {
            if (!retrievedBIDIEngines) {
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(BIDIENGINE);
                if (ep != null) {
                    fBIDIEngines = ep.getConfigurationElements();
                }
                retrievedBIDIEngines = true;
                if (fBIDIEngines != null) {
                    int i = 0;
                    while (i < fBIDIEngines.length) {
                        try {
                            Object engineClass = fBIDIEngines[i].createExecutableExtension("class");
                            if (engineClass instanceof IBIDIEngine) {
                                fBIDIEngineImplementation = (IBIDIEngine)engineClass;
                                break;
                            }
                        }
                        catch (CoreException ce) {
                            PDTCoreUtils.logError((Exception)((Object)ce));
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            PDTCoreUtils.logString(ncdfe, ": IBM JRE was not found.  Compiled Language Debugger BIDI string conversion has been disabled.");
                        }
                        ++i;
                    }
                }
            }
            if (fBIDIEngineImplementation == null) {
                fBIDIEngineImplementation = new DefaultBIDIEngine();
            }
            return fBIDIEngineImplementation;
        }
    }

    public static IPDTDebugTarget getSpecializedDebugTarget(ILaunch launch, IDebugSessionStartupInfo startupInfo, ILaunchConfiguration launchConfig, int key, String mode) {
        return PDTCorePlugin.getSpecializedDebugTarget(launch, startupInfo, launchConfig, key, mode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPDTDebugTarget getSpecializedDebugTarget(ILaunch launch, IDebugSessionStartupInfo startupInfo, ILaunchConfiguration launchConfig, int key, String mode, Properties defaultProperties) {
        List<ISpecializedDebugTargetProvider> list = fgSpecializedTargetProviders;
        synchronized (list) {
            if (!fgRetrievedSpecializedTargetProviders) {
                fgRetrievedSpecializedTargetProviders = true;
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(SPECIALIZEDTARGETPROVIDER);
                if (ep != null) {
                    IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
                    int n = iConfigurationElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        try {
                            Object provider = element.createExecutableExtension("class");
                            if (provider instanceof ISpecializedDebugTargetProvider) {
                                fgSpecializedTargetProviders.add((ISpecializedDebugTargetProvider)provider);
                            }
                        }
                        catch (CoreException e) {
                            PDTCoreUtils.logError((Exception)((Object)e));
                        }
                        ++n2;
                    }
                }
            }
        }
        for (ISpecializedDebugTargetProvider provider : fgSpecializedTargetProviders) {
            IPDTDebugTarget specialTarget;
            IPDTDebugTarget iPDTDebugTarget = specialTarget = provider instanceof ISpecializedDebugTargetProviderWithMode ? ((ISpecializedDebugTargetProviderWithMode)provider).createDebugTarget(launch, startupInfo, launchConfig, key, mode, defaultProperties) : provider.createDebugTarget(launch, startupInfo, launchConfig, key);
            if (specialTarget == null) continue;
            return specialTarget;
        }
        return null;
    }

    public static IPDTDebugTarget getSpecializedDebugTarget(ILaunch launch, IDebugSessionStartupInfo startupInfo, ILaunchConfiguration launchConfig, int key) {
        return PDTCorePlugin.getSpecializedDebugTarget(launch, startupInfo, launchConfig, key, null);
    }

    public Object getCurrentSelection() {
        return this.fCurrentSelection;
    }

    public void setCurrentSelection(Object currentSelection) {
        this.fCurrentSelection = currentSelection;
    }

    public static IPersister getPersister() {
        if (fPersister != null) {
            return fPersister;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(IPERSISTER);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        if (elements.length == 1) {
            IConfigurationElement element = elements[0];
            try {
                Object callback = element.createExecutableExtension("class");
                if (callback instanceof IPersister) {
                    fPersister = (IPersister)callback;
                    return fPersister;
                }
            }
            catch (CoreException e1) {
                PDTCoreUtils.logError((Exception)((Object)e1));
            }
        }
        return null;
    }

    public static boolean isSortLocals() {
        return fSortLocals;
    }

    public static void setSortLocals(boolean sort) {
        fSortLocals = sort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUniqueId() {
        Object object = fUniqueIdLock;
        synchronized (object) {
            fUniqueId = fUniqueId + 1;
            return fUniqueId;
        }
    }

    public void setRecordDebugActions(boolean flag) {
        this.fRecordDebugActions = flag;
    }

    public boolean isRecordDebugActions() {
        return this.fRecordDebugActions;
    }
}

