/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.DebugException;
import org.eclipse.osgi.util.NLS;

public class OptionalBreakpointData {
    public static final String NULLSTRING = "!NULL!";
    private final String fStopIfExpression;
    private final String fBreakpointAction;
    private final int fThreadId;
    private final int fEveryValue;
    private final int fFromValue;
    private final int fToValue;
    private final boolean fSuspendAllThreads;
    private String fUserLabel;
    private String fStackPattern;
    private boolean fIsStackPatternEnabled;

    public OptionalBreakpointData() {
        this((EPDC_EngineSession)null);
    }

    public OptionalBreakpointData(String stopIfExpression, String breakpointAction, int threadId, int everyValue, int fromValue, int toValue, boolean suspendAllThreads) {
        this.fStopIfExpression = PDTCoreUtils.isEmpty(stopIfExpression) ? NULLSTRING : stopIfExpression;
        this.fBreakpointAction = PDTCoreUtils.isEmpty(breakpointAction) ? NULLSTRING : breakpointAction;
        this.fThreadId = threadId;
        this.fEveryValue = everyValue;
        this.fFromValue = fromValue;
        this.fToValue = toValue;
        this.fSuspendAllThreads = suspendAllThreads;
        this.fUserLabel = NULLSTRING;
    }

    public OptionalBreakpointData(EPDC_EngineSession engineSession) {
        this.fUserLabel = NULLSTRING;
        this.fBreakpointAction = NULLSTRING;
        this.fStopIfExpression = NULLSTRING;
        this.fThreadId = 0;
        this.fToValue = 0;
        this.fFromValue = 1;
        this.fEveryValue = 1;
        this.fSuspendAllThreads = engineSession == null ? false : engineSession.isBrkptSuspendAllThreads();
    }

    public OptionalBreakpointData(IMarker marker) {
        this.fStopIfExpression = marker.getAttribute("condtionalExpression", NULLSTRING);
        this.fBreakpointAction = marker.getAttribute("breakpointAction", NULLSTRING);
        this.fThreadId = marker.getAttribute("threadNumber", 0);
        this.fEveryValue = marker.getAttribute("everyValue", 1);
        this.fFromValue = marker.getAttribute("fromValue", 1);
        this.fToValue = marker.getAttribute("toValue", 0);
        this.fSuspendAllThreads = marker.getAttribute("syncStopControl", false);
        this.fUserLabel = marker.getAttribute("userLabel", NULLSTRING);
    }

    public OptionalBreakpointData(Breakpoint breakpoint) {
        this.fStopIfExpression = PDTCoreUtils.isEmpty(breakpoint.getConditionalExpression()) ? NULLSTRING : breakpoint.getConditionalExpression();
        this.fBreakpointAction = PDTCoreUtils.isEmpty(breakpoint.getBreakpointAction()) ? NULLSTRING : breakpoint.getBreakpointAction();
        this.fThreadId = breakpoint.getThreadID();
        this.fEveryValue = breakpoint.getEveryVal();
        this.fFromValue = breakpoint.getFromVal();
        this.fToValue = breakpoint.getToVal();
        this.fSuspendAllThreads = breakpoint.isStopSynchronous();
        this.fUserLabel = PDTCoreUtils.isEmpty(breakpoint.getUserLabel()) ? NULLSTRING : breakpoint.getUserLabel();
        this.fStackPattern = breakpoint.getStackPattern();
        this.fIsStackPatternEnabled = breakpoint.isStackPatternEnabled();
    }

    public static boolean isConditional(IMarker marker) {
        if (marker == null) {
            return false;
        }
        return !marker.getAttribute("condtionalExpression", NULLSTRING).equals(NULLSTRING);
    }

    public boolean isExpressionConditionSupported(EPDC_EngineSession engineSession) {
        return this.fStopIfExpression.equals(NULLSTRING) || engineSession.supportsExpressionOnConditionalBkp();
    }

    public boolean isThreadConditionSupported(EPDC_EngineSession engineSession) {
        return this.fThreadId == 0 || engineSession.supportsThreadOnConditionalBkp();
    }

    public boolean isFrequencyConditionSupported(EPDC_EngineSession engineSession) {
        return this.fEveryValue == 1 && this.fFromValue == 1 && this.fToValue == 0 || engineSession.supportsFreqOnConditionalBkp();
    }

    public boolean isActionSupported(EPDC_EngineSession engineSession) {
        return this.fBreakpointAction.equals(NULLSTRING) || engineSession.supportsBreakpointActions();
    }

    public boolean isSuspendAllThreadsSupported(EPDC_EngineSession engineSession) {
        return !this.fSuspendAllThreads || engineSession.supportsBreakpointSyncAsyncStopControl();
    }

    public boolean isThreadSpecific() {
        return this.fThreadId != 0;
    }

    public boolean isPeriodic() {
        return this.hasHitCount() || this.hasRange();
    }

    public boolean isStopSynchronous() {
        return this.fSuspendAllThreads;
    }

    public short getSyncStopControlAttribute() {
        return this.fSuspendAllThreads ? (short)128 : 0;
    }

    public EEveryClause getEEveryClause() {
        return new EEveryClause(this.fEveryValue, this.fFromValue, this.fToValue);
    }

    public EStdExpression2 getEStdExpression2(EStdView context, EPDC_EngineSession engineSession) {
        if (this.fStopIfExpression.equals(NULLSTRING)) {
            return null;
        }
        return new EStdExpression2(context, this.fStopIfExpression, this.fThreadId, 0, engineSession);
    }

    public int getThreadId(DebuggeeProcess process) {
        return this.getThreadId(process.getEngineSession(), process.getDebugEngine());
    }

    public int getThreadId(EPDC_EngineSession engineSession, DebugEngine debugEngine) {
        if (this.fThreadId == 0 && engineSession.supportsThreadSpecificOnlyBreakpoints()) {
            return debugEngine.getCurrentThreadID();
        }
        return this.fThreadId;
    }

    public boolean areAllOptionalDataSupported(EPDC_EngineSession engineSession) {
        return this.isExpressionConditionSupported(engineSession) && this.isThreadConditionSupported(engineSession) && this.isFrequencyConditionSupported(engineSession) && this.isActionSupported(engineSession) && this.isSuspendAllThreadsSupported(engineSession);
    }

    public void putAttributes(Map<String, Object> attributes) {
        attributes.put("condtionalExpression", this.fStopIfExpression);
        attributes.put("breakpointAction", this.fBreakpointAction);
        attributes.put("threadNumber", this.fThreadId);
        attributes.put("everyValue", this.fEveryValue);
        attributes.put("fromValue", this.fFromValue);
        attributes.put("toValue", this.fToValue);
        attributes.put("syncStopControl", this.fSuspendAllThreads);
        attributes.put("userLabel", this.fUserLabel);
    }

    private boolean hasHitCount() {
        return this.fEveryValue > 1;
    }

    private boolean hasRange() {
        return this.fFromValue > 1 || this.fToValue > this.fFromValue;
    }

    public boolean hasConditionalExpression() {
        return !this.fStopIfExpression.equals(NULLSTRING);
    }

    public boolean hasStopAction() {
        return !this.fBreakpointAction.equals(NULLSTRING);
    }

    public boolean hasUserLabel() {
        return !this.fUserLabel.equals(NULLSTRING);
    }

    public void setUserLabel(String userLabel) {
        this.fUserLabel = PDTCoreUtils.isEmpty(userLabel) ? NULLSTRING : userLabel;
    }

    public static String getDetailsForLabel(org.eclipse.debug.core.model.Breakpoint coreBreakpoint) {
        OptionalBreakpointData optData = null;
        Breakpoint pdtBreakpoint = null;
        if (coreBreakpoint instanceof PICLBreakpoint) {
            if (((PICLBreakpoint)coreBreakpoint).isImported()) {
                optData = new OptionalBreakpointData(coreBreakpoint.getMarker());
            } else {
                pdtBreakpoint = ((PICLBreakpoint)coreBreakpoint).getModelBreakpoint();
                optData = new OptionalBreakpointData(pdtBreakpoint);
            }
        } else if (coreBreakpoint instanceof GenericLineBreakpoint) {
            optData = new OptionalBreakpointData(coreBreakpoint.getMarker());
        }
        if (optData == null) {
            return "";
        }
        String SIMPLE_BINDING = " [{0}]";
        String START_DETAILED_BINDING = " [{0}: ";
        String END_DETAILED_BINDING = "]";
        StringBuilder detailer = new StringBuilder();
        if (pdtBreakpoint != null && pdtBreakpoint.isDeferred()) {
            detailer.append(NLS.bind((String)" [{0}]", (Object)BreakpointLabels.breakpoint_modifier_deferred));
        }
        if (optData.isThreadSpecific()) {
            boolean haveOutputThreadSpecific = false;
            if (pdtBreakpoint != null) {
                DebuggeeThread thread = pdtBreakpoint.getThread();
                if (!pdtBreakpoint.isDeferred() && thread != null) {
                    detailer.append(NLS.bind((String)" [{0}: ", (Object)BreakpointLabels.breakpoint_modifier_thread));
                    try {
                        detailer.append(thread.getName());
                    }
                    catch (DebugException e) {
                        detailer.append(thread.getId());
                    }
                    detailer.append("]");
                    haveOutputThreadSpecific = true;
                }
            }
            if (!haveOutputThreadSpecific) {
                detailer.append(NLS.bind((String)" [{0}]", (Object)BreakpointLabels.breakpoint_modifier_thread));
            }
        }
        if (optData.isPeriodic()) {
            detailer.append(NLS.bind((String)" [{0}: ", (Object)BreakpointLabels.breakpoint_modifier_frequency));
            if (optData.hasHitCount()) {
                detailer.append(optData.fEveryValue);
            }
            if (optData.hasRange()) {
                detailer.append(NLS.bind((String)" {0}[", (Object)BreakpointLabels.breakpoint_modifier_frequency_range));
                detailer.append(optData.fFromValue);
                if (optData.fToValue < optData.fFromValue) {
                    detailer.append("+");
                } else {
                    detailer.append(", ");
                    detailer.append(optData.fToValue);
                }
                detailer.append("]");
            }
            detailer.append("]");
        }
        if (optData.hasConditionalExpression()) {
            detailer.append(NLS.bind((String)" [{0}: ", (Object)BreakpointLabels.breakpoint_modifier_conditional));
            detailer.append(optData.fStopIfExpression);
            detailer.append("]");
        }
        if (optData.hasStopAction()) {
            detailer.append(NLS.bind((String)" [{0}]", (Object)BreakpointLabels.breakpoint_modifier_action));
        }
        if (optData.isStopSynchronous()) {
            detailer.append(NLS.bind((String)" [{0}]", (Object)BreakpointLabels.breakpoint_modifier_synchronous));
        }
        if (optData.hasUserLabel()) {
            detailer.append(" [").append(optData.fUserLabel).append("]");
        }
        return detailer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OptionalBreakpointData)) {
            return false;
        }
        OptionalBreakpointData target = (OptionalBreakpointData)o;
        return this.fSuspendAllThreads == target.fSuspendAllThreads && this.fEveryValue == target.fEveryValue && this.fFromValue == target.fFromValue && this.fToValue == target.fToValue && this.fThreadId == target.fThreadId && this.fBreakpointAction.equals(target.fBreakpointAction) && this.fStopIfExpression.equals(target.fStopIfExpression) && this.fUserLabel.equals(target.fUserLabel);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getStopIfExpression() {
        return this.fStopIfExpression.equals(NULLSTRING) ? null : this.fStopIfExpression;
    }

    public String getUserLabel() {
        return this.fUserLabel.equals(NULLSTRING) ? null : this.fUserLabel;
    }

    public String getBreakpointAction() {
        return this.fBreakpointAction.equals(NULLSTRING) ? null : this.fBreakpointAction;
    }

    public int getEveryValue() {
        return this.fEveryValue;
    }

    public int getFromValue() {
        return this.fFromValue;
    }

    public int getToValue() {
        return this.fToValue;
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public String getStackPattern() {
        return this.fStackPattern;
    }

    public boolean isStackPatternEnabled() {
        return this.fIsStackPatternEnabled;
    }
}

