/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.util.DebuggerOptionDescriptor;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.net.Socket;

public class OldEngineParameters
extends EngineParameters {
    protected static final String OPTION_A = "-a";
    protected static final String OPTION_HELP = "-help";
    protected static final String OPTION_I = "-i";
    protected static final String OPTION_QADDRESS = "-qaddress";
    protected static final String OPTION_QCONNECT = "-qconnect";
    protected static final String OPTION_QDAEMON = "-qdaemon";
    protected static final String OPTION_QDISPLAY = "-qdisplay";
    protected static final String OPTION_QHOST = "-qhost";
    protected static final String OPTION_QLANG = "-qlang";
    protected static final String OPTION_QPID = "-qpid";
    protected static final String OPTION_QPORT = "-qport";
    protected static final String OPTION_QPROTOCOL = "-qprotocol";
    protected static final String OPTION_QQUIET = "-qquiet";
    protected static final String OPTION_QSESSION = "-qsession";
    protected static final String OPTION_QTITLE = "-qtitle";
    protected static final String OPTION_QUIPORT = "-quiport";
    protected static final String OPTION_S = "-s";
    protected static final String OPTION_QREMOTESOURCE = "-qremotesource";
    protected static final String OPTION_HOST = "-host";
    protected static final String OPTION_PORT = "-port";
    protected static final String OPTION_PASSWORD = "-password";
    protected static final String OPTION_USER = "-user";
    protected static final String OPTION_UUID = "-uuid";

    public OldEngineParameters() {
        this.setOptionDescriptors();
    }

    @Override
    public String getProgramName() {
        return this.debuggeeName();
    }

    public String getRemoteSourcePath() {
        return this.valueByName(OPTION_QREMOTESOURCE);
    }

    @Override
    public String getProgramParms() {
        return this.debuggeeArgs();
    }

    @Override
    public int getLoadStartupBehaviour() {
        if (this.valueByName(OPTION_S) != null) {
            return 2;
        }
        if (this.valueByName(OPTION_I) != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getAttachStartupBehaviour() {
        if (this.valueByName(OPTION_S) != null) {
            return 2;
        }
        return -1;
    }

    public boolean isAttach() {
        return this.valueByName(OPTION_A) != null;
    }

    @Override
    public String getProcessID() {
        return this.valueByName(OPTION_A);
    }

    public boolean isJavaAttach() {
        String pid = this.valueByName(OPTION_A);
        return pid != null && this.valueByName(OPTION_A).equals("0");
    }

    public void setInfo(String[] inputStrings, Socket socket) {
        this.rebuild(new String[0], false);
        this.fSocket = socket;
        this.host = socket.getInetAddress().getHostAddress();
        String conduit = inputStrings[1];
        this.title = inputStrings[2];
        this.arguments = "";
        String argCountString = inputStrings[3];
        if (argCountString != null && !argCountString.equals("") && argCountString.length() != 0) {
            this.arguments = inputStrings[4];
        }
        this.rebuild(this.arguments);
        this.parseAttributes(this.arguments);
        if (this.host == null) {
            this.host = this.valueByName(OPTION_HOST);
        }
        if (conduit == null) {
            conduit = this.valueByName(OPTION_PASSWORD);
        }
        if (conduit == null) {
            conduit = this.valueByName(OPTION_PORT);
        }
        if (!(this.host == null || conduit == null || this.host.equals("") || conduit.equals("") || conduit.equals("0"))) {
            try {
                this.fSocket = new Socket(this.host, Integer.parseInt(conduit));
            }
            catch (Exception e) {
                PDTCoreUtils.logError(e);
            }
        }
    }

    @Override
    protected void setOptionDescriptors() {
        super.setOptionDescriptors();
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_A, OPTION_A.length(), true, true));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_A, OPTION_A.length(), false, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_HELP, OPTION_HELP.length(), false, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_I, OPTION_I.length(), false, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QADDRESS, OPTION_QADDRESS.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QCONNECT, OPTION_QCONNECT.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QDAEMON, OPTION_QDAEMON.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QDAEMON, OPTION_QDAEMON.length(), false, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QDISPLAY, OPTION_QDISPLAY.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QHOST, OPTION_QHOST.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QLANG, OPTION_QLANG.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QPID, OPTION_QPID.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QPID, OPTION_QPID.length(), false, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QPORT, OPTION_QPORT.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QPROTOCOL, OPTION_QPROTOCOL.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QQUIET, OPTION_QQUIET.length(), false, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QTITLE, OPTION_QTITLE.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QUIPORT, OPTION_QUIPORT.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_S, OPTION_S.length(), false, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_QREMOTESOURCE, OPTION_QREMOTESOURCE.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_HOST, OPTION_HOST.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_PORT, OPTION_PORT.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_PASSWORD, OPTION_PASSWORD.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_USER, OPTION_USER.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_UUID, OPTION_UUID.length(), true, false));
    }

    public String getUser() {
        return this.valueByName(OPTION_USER);
    }

    public String getProfileUUID() {
        return this.valueByName(OPTION_UUID);
    }
}

