/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.EFSEditorFile;
import com.ibm.debug.pdt.internal.core.FileEditorFile;
import com.ibm.debug.pdt.internal.core.LocalEditorFile;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class MixedEditorFile
extends AbstractEditorFile {
    private FileEditorFile fSourceEditorFile;

    public MixedEditorFile(ViewFile viewFile, Object sourceFile) {
        super(viewFile);
        if (sourceFile instanceof IFile) {
            this.fSourceEditorFile = new EFSEditorFile(viewFile, (IFile)sourceFile, false);
        } else if (sourceFile instanceof LocalFileStorage) {
            this.fSourceEditorFile = new LocalEditorFile(viewFile, (LocalFileStorage)sourceFile, false);
        }
        this.determineName();
        this.fFileStartLine = this.fViewFile.getFirstLineNumber();
        this.fFileEndLine = this.fViewFile.getLastLineNumber();
    }

    @Override
    public boolean isFileLocal() {
        return true;
    }

    @Override
    void loadFile() throws IOException, CoreException {
        this.fSourceEditorFile.loadFile();
    }

    @Override
    public synchronized int loadLines(int start, int end) {
        this.fSourceEditorFile.loadLines(this.fSourceEditorFile.getFileStartLine(), this.fSourceEditorFile.getFileEndLine());
        return super.loadLines(start, end);
    }

    @Override
    String getSourceLine(int lineNumber) {
        return this.fSourceEditorFile.getSourceLine(lineNumber);
    }

    @Override
    public void close() {
        this.fSourceEditorFile.close();
    }

    @Override
    public IFile getFile() {
        return null;
    }

    @Override
    public boolean isTempCopy() {
        return false;
    }
}

