/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.FileEditorFile;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.io.BufferedInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class LocalEditorFile
extends FileEditorFile {
    private LocalFileStorage fLocalFileStorage;
    private boolean fUseCopy;

    public LocalEditorFile(ViewFile viewFile, LocalFileStorage localFileStorage, boolean useCopy) {
        super(viewFile);
        this.fUseCopy = useCopy;
        this.fLocalFileStorage = localFileStorage;
        this.fFullName = this.fLocalFileStorage.getFullPath().toOSString();
        this.fBaseName = this.fLocalFileStorage.getName();
    }

    @Override
    InputStream getInputStream() throws CoreException {
        return new BufferedInputStream(this.fLocalFileStorage.getContents());
    }

    @Override
    String getEncoding() {
        return null;
    }

    @Override
    public IFile getFile() {
        if (this.fFile == null && this.fUseCopy) {
            try {
                IFolder viewFileFolder = this.getDebugTarget().getViewFileCache();
                IFile tempFile = viewFileFolder.getFile(this.fLocalFileStorage.getFullPath());
                if (!tempFile.exists()) {
                    PDTCoreUtils.mkDir((IFolder)tempFile.getParent());
                    tempFile.createLink(this.fLocalFileStorage.getFullPath(), 0, null);
                    tempFile.setSessionProperty(ViewFile.VIEWFILE_KEY, (Object)this.fViewFile);
                    this.fFile = tempFile;
                    this.setTempCopy(true);
                    this.loadBreakpoints();
                }
            }
            catch (CoreException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
        return this.fFile;
    }

    @Override
    public int hashCode() {
        return this.fLocalFileStorage.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return this.fLocalFileStorage.equals((Object)((LocalEditorFile)((Object)o)).fLocalFileStorage);
        }
        return false;
    }
}

