/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.CoreException;

public abstract class FileEditorFile
extends AbstractEditorFile {
    private String[] fSourceLines = EMPTYLINES;
    private int fSourceStartLine;

    public FileEditorFile(ViewFile viewFile) {
        super(viewFile);
    }

    @Override
    public boolean isFileLocal() {
        return true;
    }

    abstract InputStream getInputStream() throws IOException, CoreException;

    abstract String getEncoding();

    @Override
    protected void loadFile() throws IOException, CoreException {
        LineNumberReader reader = this.getReader();
        String lastLineFromEngine = "";
        do {
            if (reader.getLineNumber() + 1 == this.fViewFile.getLastLineNumber()) {
                lastLineFromEngine = reader.readLine();
                continue;
            }
            reader.readLine();
        } while (reader.ready());
        this.validateSourceInformation(reader.getLineNumber(), lastLineFromEngine);
        reader.close();
    }

    private void validateSourceInformation(int readerLastLine, String lastLine) {
        int viewFileLastLine = this.fViewFile.getLastLineNumber();
        if (viewFileLastLine > 0) {
            this.fFileEndLine = Math.min(readerLastLine, viewFileLastLine);
            if (readerLastLine != viewFileLastLine) {
                if (PDTDebugUtils.isiSeriesEngine(this.fViewFile.getDebugTarget()) && lastLine.toLowerCase().contains("/eof")) {
                    PDTCoreUtils.logString((Object)this, "Line number mismatch for " + this.getName() + " reader lines:" + readerLastLine + " viewfile lines:" + viewFileLastLine + ". Possibly caused by /eof statement", 2);
                } else {
                    this.fError = PICLMessages.picl_file_mismatch_eror;
                    PDTCoreUtils.logString((Object)this, "Line number mismatch for " + this.getName() + " reader lines:" + readerLastLine + " viewfile lines:" + viewFileLastLine, 2);
                }
            }
        } else {
            this.fFileEndLine = readerLastLine;
        }
    }

    @Override
    public synchronized int loadLines(int start, int end) {
        int numLines = end - start + 1;
        this.fSourceLines = new String[numLines];
        this.fSourceStartLine = start;
        try {
            LineNumberReader reader = this.getReader();
            while (reader.ready() && reader.getLineNumber() + 1 < start) {
                reader.readLine();
            }
            int i = 0;
            while (i < numLines) {
                this.fSourceLines[i] = reader.readLine();
                if (!reader.ready()) break;
                ++i;
            }
            reader.close();
        }
        catch (IOException e) {
            PDTCoreUtils.logError(e);
            return 0;
        }
        catch (CoreException ce) {
            PDTCoreUtils.logError((Exception)((Object)ce));
            return 0;
        }
        return super.loadLines(start, end);
    }

    private LineNumberReader getReader() throws IOException, CoreException {
        InputStreamReader isReader = null;
        isReader = this.getEncoding() == null ? new InputStreamReader(this.getInputStream(), Charset.defaultCharset()) : new InputStreamReader(this.getInputStream(), this.getEncoding());
        return new LineNumberReader(isReader);
    }

    @Override
    synchronized String getSourceLine(int lineNumber) {
        try {
            return this.fSourceLines[lineNumber - this.fSourceStartLine];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "line is out of bounds";
        }
    }
}

