/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.util.ArgumentTokenizer;
import com.ibm.debug.pdt.internal.core.util.DebuggerOptionDescriptor;
import com.ibm.debug.pdt.internal.core.util.DebuggerOptions;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.net.Socket;
import java.util.HashMap;
import java.util.Set;

public abstract class EngineParameters
extends DebuggerOptions {
    protected Socket fSocket;
    protected String title;
    protected String arguments;
    protected String host;
    protected String port;
    protected static final String OPTION_LAUNCHER = "-launcher";
    protected static final String OPTION_PROJECT = "-project";
    protected static final String OPTION_SOCKETSTYLE = "-socketStyle";
    protected static final String OPTION_STARTUPKEY = "-startupKey";
    protected static final String OPTION_SECURE = "-qsecure";
    private HashMap<String, String> fAttributes = new HashMap();

    public Socket getConnection() {
        return this.fSocket;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getArguments() {
        return this.arguments;
    }

    public abstract String getProgramName();

    public abstract String getProgramParms();

    public abstract int getLoadStartupBehaviour();

    public abstract int getAttachStartupBehaviour();

    public abstract String getProcessID();

    public String getProject() {
        return this.valueByName(OPTION_PROJECT);
    }

    public String getLauncher() {
        return this.valueByName(OPTION_LAUNCHER);
    }

    public String getSocketStyle() {
        return this.valueByName(OPTION_SOCKETSTYLE);
    }

    public String getStartupKey() {
        return this.valueByName(OPTION_STARTUPKEY);
    }

    public boolean isStartupKeyAnInteger() {
        String key = this.getStartupKey();
        if (PDTCoreUtils.isEmpty(key)) {
            return false;
        }
        try {
            Integer.parseInt(key);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public String getValue(String property) {
        return this.valueByName(property);
    }

    public boolean isSecure() {
        return this.valueByName(OPTION_SECURE) != null;
    }

    protected void setOptionDescriptors() {
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_LAUNCHER, OPTION_LAUNCHER.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_PROJECT, OPTION_PROJECT.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_SOCKETSTYLE, OPTION_SOCKETSTYLE.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_STARTUPKEY, OPTION_STARTUPKEY.length(), true, false));
        this.addOptionDescriptor(new DebuggerOptionDescriptor(OPTION_SECURE, OPTION_SECURE.length(), false, false));
    }

    public String getAttribute(String key) {
        return this.fAttributes.get(key);
    }

    public Set<String> getAttributeKeys() {
        return this.fAttributes.keySet();
    }

    void parseAttributes(String args) {
        ArgumentTokenizer tokenizer = new ArgumentTokenizer(args);
        String token = tokenizer.nextToken();
        while (!token.isEmpty()) {
            int eIdx;
            if (token.startsWith("-")) {
                token = token.substring(1);
            }
            if ((eIdx = token.indexOf("=")) > -1) {
                this.fAttributes.put(token.substring(0, eIdx), token.substring(eIdx + 1));
            }
            token = tokenizer.nextToken();
        }
    }
}

