/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.ERepStringFind;
import com.ibm.debug.pdt.internal.epdc.EReqStringFind;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EngineEditorFile
extends AbstractEditorFile {
    private boolean fUseCopy;
    Job fDeleteJob = null;

    public EngineEditorFile(ViewFile viewFile, boolean useCopy) {
        super(viewFile);
        this.determineName();
        this.fUseCopy = useCopy;
        this.fFileStartLine = this.fViewFile.getFirstLineNumber();
        this.fFileEndLine = this.fViewFile.getLastLineNumber();
    }

    @Override
    public boolean isFileLocal() {
        return false;
    }

    @Override
    void loadFile() {
    }

    int getViewNum() {
        try {
            return this.fViewFile.getView().getId();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    String getSourceLine(int lineNumber) {
        return null;
    }

    @Override
    public Location findString(String text, int startingLine, int startingColumn, boolean caseSensitive) {
        DebugEngine debugEngine = this.fViewFile.getDebugEngine();
        int numberOfLinesToSearch = this.getFileEndLine() - this.getFileStartLine() + 1;
        EStdView epdcLocation = new Location(this.fViewFile, startingLine).getEStdView();
        if (epdcLocation == null) {
            return null;
        }
        EReqStringFind request = new EReqStringFind(epdcLocation, text, numberOfLinesToSearch, startingColumn, caseSensitive, this.fViewFile.getEngineSession());
        try {
            ERepStringFind reply = (ERepStringFind)debugEngine.processRequest(request);
            return new Location(this.fViewFile, reply.getLineNumber(), reply.getColumnNumber());
        }
        catch (EngineRequestException ere) {
            return null;
        }
    }

    @Override
    public IFile getFile() {
        if (this.fFile == null && this.fUseCopy) {
            try {
                String fileName;
                if (this.fDeleteJob != null) {
                    try {
                        this.fDeleteJob.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Language lang = this.fViewFile.getPart().getLanguage();
                IFolder viewFileFolder = this.getDebugTarget().getViewFileCache();
                IFile localFile = (viewFileFolder = viewFileFolder.getFolder(Integer.toString(this.fViewFile.getPart().getId()))).getFile(fileName = this.fViewFile.isIncludeFile() ? lang.appendIncludeFileExtension(this.getName()) : lang.appendFileExtension(this.getName()));
                IFolder fileFolder = (IFolder)localFile.getParent();
                if (!fileFolder.exists()) {
                    PDTCoreUtils.mkDir(fileFolder);
                }
                if (!localFile.exists()) {
                    localFile.create(this.fViewFile.getInputStream(), true, null);
                    localFile.setCharset("UTF-8", null);
                    if (this.fViewFile.getEngineSession().isAIX()) {
                        localFile.setPersistentProperty(new QualifiedName("", "remote_file_subsystem_key"), ":aix");
                    }
                }
                localFile.setSessionProperty(ViewFile.VIEWFILE_KEY, (Object)this.fViewFile);
                localFile.setSessionProperty(ViewFile.VIEWFILE_ENGINESUPPLIED_KEY, (Object)Boolean.toString(true));
                this.setFileReadOnly(localFile, true);
                this.fFile = localFile;
                this.setTempCopy(true);
                this.loadBreakpoints();
            }
            catch (Exception e) {
                PDTCoreUtils.logError(e);
            }
        }
        return this.fFile;
    }

    private void setFileReadOnly(IFile file, boolean readOnly) {
        ResourceAttributes attributes = file.getResourceAttributes();
        if (attributes == null) {
            return;
        }
        attributes.setReadOnly(readOnly);
        try {
            file.setResourceAttributes(attributes);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (this.fFile != null && this.isTempCopy()) {
            this.setFileReadOnly(this.fFile, false);
            final IFile fileToDelete = this.fFile;
            this.fDeleteJob = new Job("Removing Debug cached file"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor arg0) {
                    try {
                        IFolder iFolder = EngineEditorFile.this.getDebugTarget().getViewFileCache();
                        synchronized (iFolder) {
                            if (fileToDelete.exists()) {
                                fileToDelete.delete(false, null);
                            }
                        }
                    }
                    catch (CoreException e) {
                        PDTCoreUtils.logError((Exception)((Object)e));
                    }
                    EngineEditorFile.this.fDeleteJob = null;
                    return Status.OK_STATUS;
                }
            };
            this.fDeleteJob.setSystem(true);
            this.fDeleteJob.schedule(1000L);
            this.fFile = null;
        } else {
            super.close();
        }
    }
}

