/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.IEPDCFormatter2;
import com.ibm.debug.pdt.core.IEPDCFormatter3;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class EPDCFormatter
implements IEPDCFormatter2,
IEPDCFormatter3 {
    private HashMap<String, EPDCSession> fEPDCSessions = new HashMap();
    private static final int MAXFILES = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startSession(IPDTDebugTarget debugTarget) {
        try {
            HashMap<String, EPDCSession> hashMap = this.fEPDCSessions;
            synchronized (hashMap) {
                this.fEPDCSessions.put(debugTarget.getId(), new EPDCSession());
            }
        }
        catch (IOException e) {
            PDTCoreUtils.logError(e);
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream(IPDTDebugTarget debugTarget) {
        EPDCSession session = null;
        HashMap<String, EPDCSession> hashMap = this.fEPDCSessions;
        synchronized (hashMap) {
            session = this.fEPDCSessions.get(debugTarget.getId());
        }
        if (session != null) {
            return session.getOutputStream();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endSession(IPDTDebugTarget debugTarget) {
        EPDCSession session = null;
        HashMap<String, EPDCSession> hashMap = this.fEPDCSessions;
        synchronized (hashMap) {
            session = this.fEPDCSessions.remove(debugTarget.getId());
        }
        if (session != null) {
            session.endSession();
        }
    }

    @Override
    public boolean isEnabled() {
        return Platform.getPreferencesService().getBoolean("com.ibm.debug.pdt.core", "trace_EPDC", false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEPDCDumpLocation(IPDTDebugTarget debugTarget) {
        EPDCSession session = null;
        HashMap<String, EPDCSession> hashMap = this.fEPDCSessions;
        synchronized (hashMap) {
            session = this.fEPDCSessions.get(debugTarget.getId());
        }
        if (session != null) {
            return session.getDumpFileLocation();
        }
        return null;
    }

    private static class EPDCSession {
        private BufferedOutputStream fFileOutputStream = null;
        private String fDumpFileLocation = null;

        EPDCSession() throws IOException {
            Closeable f;
            IPreferencesService prefService = Platform.getPreferencesService();
            String fileDir = prefService.getString("com.ibm.debug.pdt.core", "trace_file_dir", "", null);
            String baseDumpFileName = fileDir + "/" + prefService.getString("com.ibm.debug.pdt.core", "trace_file_name", "epdcdump", null);
            String fileCountStr = null;
            String dumpLogName = fileDir + "/dumplog";
            int nextFileNum = 1;
            if (new File(dumpLogName).exists()) {
                f = new DataInputStream(new FileInputStream(dumpLogName));
                try {
                    if (((FilterInputStream)f).available() > 0) {
                        nextFileNum = ((DataInputStream)f).readInt();
                    }
                }
                finally {
                    ((FilterInputStream)f).close();
                }
            }
            fileCountStr = String.valueOf(nextFileNum + 100).substring(1);
            this.fDumpFileLocation = baseDumpFileName + fileCountStr + ".hex";
            this.fFileOutputStream = new BufferedOutputStream(new FileOutputStream(this.fDumpFileLocation));
            PDTCoreUtils.logString(null, "Logging engine trace to file " + this.fDumpFileLocation);
            if (++nextFileNum >= 100) {
                nextFileNum = 1;
            }
            f = new DataOutputStream(new FileOutputStream(dumpLogName));
            try {
                ((DataOutputStream)f).writeInt(nextFileNum);
            }
            finally {
                ((FilterOutputStream)f).close();
            }
        }

        OutputStream getOutputStream() {
            return this.fFileOutputStream;
        }

        void endSession() {
            if (this.fFileOutputStream != null) {
                try {
                    this.fFileOutputStream.flush();
                    this.fFileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        String getDumpFileLocation() {
            return this.fDumpFileLocation;
        }
    }
}

