/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.internal.core.FileEditorFile;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.io.BufferedInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;

public class EFSEditorFile
extends FileEditorFile {
    private IFile fOriginalFile;
    private boolean fFirstTime;

    public EFSEditorFile(ViewFile viewFile, IFile file, boolean useCopy) {
        super(viewFile);
        this.fOriginalFile = file;
        if (!useCopy) {
            this.fFile = this.fOriginalFile;
            try {
                this.fFile.setSessionProperty(ViewFile.VIEWFILE_KEY, (Object)this.fViewFile);
            }
            catch (CoreException e) {
                PDTCoreUtils.logError((Exception)((Object)e));
            }
        }
        this.fBaseName = this.fOriginalFile.getName();
        this.fFullName = this.fOriginalFile.getFullPath().toOSString();
        this.fFirstTime = true;
    }

    @Override
    InputStream getInputStream() throws CoreException {
        return new BufferedInputStream(this.fOriginalFile.getContents());
    }

    @Override
    String getEncoding() {
        try {
            return this.fOriginalFile.getCharset();
        }
        catch (CoreException e) {
            return null;
        }
    }

    @Override
    public IFile getFile() throws CoreException {
        if (this.fFile == null) {
            IFolder viewFileFolder = this.getDebugTarget().getViewFileCache();
            IFile targetFile = viewFileFolder.getFile(this.fOriginalFile.getFullPath());
            if (!targetFile.exists()) {
                PDTCoreUtils.mkDir((IFolder)targetFile.getParent());
                this.fOriginalFile.copy(targetFile.getFullPath(), false, null);
            }
            this.fFile = targetFile;
            this.setTempCopy(true);
            this.fFile.setSessionProperty(ViewFile.VIEWFILE_KEY, (Object)this.fViewFile);
        }
        if (this.fFirstTime) {
            this.fFirstTime = false;
            this.loadBreakpoints();
        }
        return this.fFile;
    }

    public IFile getOriginalFile() {
        return this.fOriginalFile;
    }

    @Override
    public int hashCode() {
        return this.fOriginalFile.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return this.fOriginalFile.equals((Object)((EFSEditorFile)((Object)o)).fOriginalFile);
        }
        return false;
    }
}

