/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.core;

import com.ibm.debug.pdt.core.IPDTDebugConstants;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.EFSEditorFile;
import com.ibm.debug.pdt.internal.core.EngineEditorFile;
import com.ibm.debug.pdt.internal.core.LocalEditorFile;
import com.ibm.debug.pdt.internal.core.MixedEditorFile;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Line;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public abstract class AbstractEditorFile
extends PlatformObject
implements IStorage {
    static final String[] EMPTYLINES = new String[0];
    ViewFile fViewFile;
    boolean fInitialzied = false;
    String fBaseName;
    String fFullName;
    private boolean[] fLineIsExecutable = new boolean[0];
    private ByteArrayInputStream fEditorBuffer;
    private int fBufferStartLine = 1;
    private int fBufferEndLine;
    int fFileStartLine = 1;
    int fFileEndLine;
    private String[] fSearchLines = null;
    protected IFile fFile = null;
    private boolean fTempCopy = false;
    private HashMap<Integer, Long> fMarkerMap;
    private boolean fSetMarkers = false;
    protected String fError = null;
    private int fHashCode;

    public AbstractEditorFile(ViewFile viewFile) {
        this.fViewFile = viewFile;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void init() throws IOException, CoreException {
        if (!this.fInitialzied) {
            this.loadFile();
            this.fInitialzied = true;
        }
    }

    public String getFullPathName() {
        return this.fFullName;
    }

    public String getName() {
        return this.fBaseName;
    }

    public synchronized int getBufferStartLine() {
        return this.fBufferStartLine;
    }

    public synchronized int getBufferEndLine() {
        return this.fBufferEndLine;
    }

    public int getFileStartLine() {
        return this.fFileStartLine;
    }

    public int getFileEndLine() {
        return this.fFileEndLine;
    }

    public synchronized boolean isLineExecutable(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.fLineIsExecutable.length) {
            return false;
        }
        return this.fLineIsExecutable[lineNumber];
    }

    protected void determineName() {
        if (this.fViewFile == null) {
            return;
        }
        String baseName = this.fViewFile.getBaseFileName();
        String fullName = this.fViewFile.getFileName();
        if (baseName == null) {
            baseName = PICLLabels.EngineSuppliedView_labelUnknown;
        }
        if (fullName == null) {
            fullName = PICLLabels.EngineSuppliedView_labelUnknown;
        }
        this.fBaseName = baseName;
        this.fFullName = fullName;
    }

    public synchronized int loadLines(int start, int end) {
        boolean isMixedView;
        Line[] lines;
        block12: {
            if (start < this.fFileStartLine) {
                start = this.fFileStartLine;
            }
            if (end > this.fFileEndLine) {
                end = this.fFileEndLine;
            }
            lines = this.fViewFile.getLines(start, end - start + 1);
            isMixedView = this.fViewFile.getView().isMixedView();
            if (lines.length != 0) break block12;
            PDTCoreUtils.logString((Object)this, String.format(": viewfile for '%s' returned no lines for range [%d, %d]", this.fViewFile.getFileName(), start, end));
            return 0;
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(lines.length * 80);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buffer, "UTF-8"));
            this.fLineIsExecutable = new boolean[lines.length + 1];
            int prefixLength = this.fViewFile.getPrefixLength();
            EPDC_EngineSession engineSession = this.fViewFile.getEngineSession();
            int i = 1;
            Line[] lineArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                Line line = lineArray[n2];
                this.fLineIsExecutable[i++] = line.isExecutable();
                if (line.isLocalSource()) {
                    writer.write(line.getPrefix(prefixLength));
                    writer.append("  ");
                    String sourceLine = "";
                    sourceLine = isMixedView ? this.getSourceLine(line.getPrefixAsInt(prefixLength)) : this.getSourceLine(line.getLineNumber());
                    if (sourceLine != null) {
                        writer.write(sourceLine);
                    }
                    writer.newLine();
                } else if (line.getText(prefixLength, engineSession) == null) {
                    writer.newLine();
                } else {
                    writer.write(line.getPrefix(prefixLength));
                    writer.append("  ");
                    String tempLine = this.fViewFile.getPrintableLine(line.getTextNoPrefix(prefixLength, engineSession));
                    writer.write(tempLine);
                    if (!tempLine.endsWith(IPDTDebugConstants.LINE_SEPARATOR)) {
                        writer.newLine();
                    }
                }
                ++n2;
            }
            writer.flush();
            this.fEditorBuffer = new ByteArrayInputStream(buffer.toByteArray());
            this.fBufferStartLine = start;
            this.fBufferEndLine = end;
            return this.fBufferEndLine - this.fBufferStartLine + 1;
        }
        catch (IOException e) {
            PDTCoreUtils.logError(e);
            return 0;
        }
    }

    public InputStream getContents() throws CoreException {
        if (this.fEditorBuffer != null) {
            this.fEditorBuffer.reset();
        }
        return this.fEditorBuffer;
    }

    public Location findString(String text, int startingLine, int startingColumn, boolean caseSensitive) {
        Location foundLocation;
        String searchText;
        String string = searchText = caseSensitive ? text : text.toUpperCase();
        if (this.fSearchLines == null) {
            this.fSearchLines = this.getAllLines();
        }
        if ((foundLocation = this.searchLines(searchText, startingLine - 1, this.fSearchLines.length, startingColumn, caseSensitive)) != null) {
            return foundLocation;
        }
        return this.searchLines(searchText, 0, startingLine, 0, caseSensitive);
    }

    private Location searchLines(String searchText, int startLineNumber, int endLineNumber, int searchColumn, boolean caseSensitive) {
        int prefixLength = this.fViewFile.getPrefixLength() + 1;
        int lineNumber = startLineNumber;
        while (lineNumber < endLineNumber) {
            int foundIndex;
            String searchLine = this.fSearchLines[lineNumber].substring(prefixLength);
            if (!caseSensitive) {
                searchLine = searchLine.toUpperCase();
            }
            if ((foundIndex = searchLine.indexOf(searchText, searchColumn)) > -1) {
                Location foundLocation = new Location(this.fViewFile, lineNumber + 1, searchColumn + foundIndex);
                return foundLocation;
            }
            searchColumn = 0;
            ++lineNumber;
        }
        return null;
    }

    private synchronized String[] getAllLines() {
        int currentBufferStartLine = this.fBufferStartLine;
        int currentBufferEndLine = this.fBufferEndLine;
        int linesLoaded = this.loadLines(this.fFileStartLine, this.fFileEndLine);
        InputStream inStream = null;
        try {
            inStream = this.getContents();
        }
        catch (CoreException e1) {
            return EMPTYLINES;
        }
        BufferedReader reader = null;
        try {
            String[] lines = new String[linesLoaded];
            InputStreamReader isr = new InputStreamReader(inStream, "UTF-8");
            reader = new LineNumberReader(isr);
            int i = 0;
            do {
                lines[i++] = ((LineNumberReader)reader).readLine();
            } while (reader.ready());
            String[] stringArray = lines;
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = EMPTYLINES;
            return stringArray;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            this.loadLines(currentBufferStartLine, currentBufferEndLine);
        }
    }

    public static AbstractEditorFile createEngineFile(ViewFile viewFile, Object sourceFile, boolean useCopy) {
        if (viewFile.isMixedView() && !(sourceFile instanceof ViewFile)) {
            return new MixedEditorFile(viewFile, sourceFile);
        }
        if (sourceFile instanceof IFile) {
            return new EFSEditorFile(viewFile, (IFile)sourceFile, useCopy);
        }
        if (sourceFile instanceof LocalFileStorage) {
            return new LocalEditorFile(viewFile, (LocalFileStorage)sourceFile, useCopy);
        }
        if (sourceFile instanceof ViewFile) {
            return new EngineEditorFile((ViewFile)sourceFile, useCopy);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block12: {
            if (this.fFile != null) {
                try {
                    try {
                        IMarker[] markersToDelete;
                        if (this.isTempCopy()) {
                            IFolder iFolder = this.getDebugTarget().getViewFileCache();
                            synchronized (iFolder) {
                                if (this.fFile.exists()) {
                                    this.fFile.delete(false, null);
                                }
                                break block12;
                            }
                        }
                        this.fFile.setSessionProperty(ViewFile.VIEWFILE_KEY, null);
                        IMarker[] iMarkerArray = markersToDelete = this.fFile.findMarkers("com.ibm.debug.pdt.core.PICLLocationBreakpoint", true, 1);
                        int n = markersToDelete.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker marker = iMarkerArray[n2];
                            this.deleteMarker(marker, (IResource)this.fFile);
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        PDTCoreUtils.logError((Exception)((Object)e));
                        this.fFile = null;
                    }
                }
                finally {
                    this.fFile = null;
                }
            }
        }
    }

    public abstract boolean isFileLocal();

    abstract void loadFile() throws IOException, CoreException;

    public boolean equals(Object o) {
        if (o instanceof AbstractEditorFile && ((Object)((Object)this)).getClass().equals(o.getClass()) && this.fViewFile.equals(((AbstractEditorFile)((Object)o)).fViewFile)) {
            return this.fFullName.equals(((AbstractEditorFile)((Object)o)).fFullName) && this.fBaseName.equals(((AbstractEditorFile)((Object)o)).fBaseName);
        }
        return false;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = 7;
            this.fHashCode = 37 * this.fHashCode + this.fViewFile.hashCode();
            this.fHashCode = 37 * this.fHashCode + this.fFullName.hashCode();
            this.fHashCode = 37 * this.fHashCode + this.fBaseName.hashCode();
        }
        return this.fHashCode;
    }

    abstract String getSourceLine(int var1);

    public abstract IFile getFile() throws CoreException;

    protected IPDTDebugTarget getDebugTarget() {
        return (IPDTDebugTarget)this.fViewFile.getDebugTarget();
    }

    public void setTempCopy(boolean temp) {
        this.fTempCopy = temp;
    }

    public boolean isTempCopy() {
        return this.fTempCopy;
    }

    public IPath getFullPath() {
        if (this.fFile != null) {
            return this.fFile.getLocation();
        }
        return null;
    }

    public void addMarker(final LocationBreakpoint bkp) throws CoreException {
        if (!this.fSetMarkers) {
            return;
        }
        if (this.fFile == null) {
            return;
        }
        if (this.fMarkerMap == null) {
            this.fMarkerMap = new HashMap();
        }
        if (this.fMarkerMap.containsKey(bkp.getId())) {
            return;
        }
        String markerType = null;
        markerType = bkp instanceof EntryBreakpoint ? "com.ibm.debug.pdt.core.PICLEntryBreakpoint" : (bkp instanceof AddressBreakpoint ? "com.ibm.debug.pdt.core.PICLAddressBreakpoint" : "com.ibm.debug.pdt.core.PICLLineBreakpoint");
        final int lineNumber = bkp.getLocationWithinView(this.fViewFile.getView()).getLineNumber();
        final boolean conditional = bkp.getConditionalExpression() != null;
        final IMarker[] bkpMarkerParm = new IMarker[1];
        final String markerTypeParm = markerType;
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker bkpMarker = AbstractEditorFile.this.fFile.createMarker(markerTypeParm);
                bkpMarker.setAttributes(new String[]{"org.eclipse.debug.core.enabled", "lineNumber", "isConditional"}, new Object[]{bkp.isEnabled(), lineNumber, conditional});
                bkpMarkerParm[0] = bkpMarker;
            }
        }, (ISchedulingRule)this.fFile, 1, null);
        this.fMarkerMap.put(bkp.getId(), bkpMarkerParm[0].getId());
    }

    public void removeMarker(LocationBreakpoint bkp) throws CoreException {
        if (this.fFile == null) {
            return;
        }
        if (this.fMarkerMap == null || !this.fMarkerMap.containsKey(bkp.getId())) {
            return;
        }
        long markerID = this.fMarkerMap.get(bkp.getId());
        this.fMarkerMap.remove(bkp.getId());
        IMarker marker = this.fFile.findMarker(markerID);
        this.deleteMarker(marker, (IResource)this.fFile);
    }

    public void updateMarker(final LocationBreakpoint bkp, final int lineNumber) throws CoreException {
        if (this.fFile == null || this.fMarkerMap == null) {
            return;
        }
        if (!this.fMarkerMap.containsKey(bkp.getId())) {
            return;
        }
        long markerID = this.fMarkerMap.get(bkp.getId());
        final IMarker marker = this.fFile.findMarker(markerID);
        if (marker == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                marker.setAttributes(new String[]{"org.eclipse.debug.core.enabled", "lineNumber", "isConditional"}, new Object[]{bkp.isEnabled(), lineNumber, bkp.getConditionalExpression() != null});
            }
        }, (ISchedulingRule)this.fFile, 1, null);
    }

    private void deleteMarker(final IMarker marker, IResource resource) throws CoreException {
        if (marker == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                marker.delete();
            }
        }, (ISchedulingRule)resource, 1, null);
    }

    protected void loadBreakpoints() throws CoreException {
        LocationBreakpoint[] breakpoints;
        LocationBreakpoint[] locationBreakpointArray = breakpoints = this.fViewFile.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            LocationBreakpoint locationBreakpoint = locationBreakpointArray[n2];
            this.addMarker(locationBreakpoint);
            ++n2;
        }
    }

    public void setMarkers(boolean enabled) {
        this.fSetMarkers = enabled;
    }

    public String getErrorMessage() {
        return this.fError;
    }

    public void clearErrorMessage() {
        this.fError = null;
    }

    public boolean isIncludeFile() {
        return this.fViewFile.isIncludeFile();
    }
}

