/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.sourcelocator;

import com.ibm.debug.pdt.core.sourcelocator.ViewFileSourceContainer;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;

public class RemoteEngineContainer
extends ViewFileSourceContainer {
    public static final String TYPE_ID = "com.ibm.debug.pdt.core.sourceContainer.RemoteEngine";

    public Object[] findSourceElements(String name) throws CoreException {
        if (this.fViewFile != null) {
            try {
                this.fViewFile.verify();
            }
            catch (EngineConnectionException e) {
                return EMPTY;
            }
            if (this.fViewFile.isEngineVerified()) {
                return new Object[]{this.fViewFile};
            }
        }
        return EMPTY;
    }

    public String getName() {
        String debugEngineLabel = PICLLabels.sourcelocation_debugEngine_label;
        String globalEnginePath = null;
        if (this.fViewFile != null) {
            globalEnginePath = this.fViewFile.getEngineSession().getGlobalEnginePath();
        }
        if (globalEnginePath == null || globalEnginePath.length() == 0) {
            return debugEngineLabel;
        }
        return debugEngineLabel + " : " + globalEnginePath;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsRemoteEngineContainer(DefaultSourceContainer container) {
        try {
            if (container == null) {
                return false;
            }
            ISourceContainer[] subContainers = container.getSourceContainers();
            if (subContainers == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= subContainers.length) {
                    return false;
                }
                if (subContainers[i] instanceof RemoteEngineContainer) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteEngineContainer) {
            return true;
        }
        return obj instanceof DefaultSourceContainer && this.containsRemoteEngineContainer((DefaultSourceContainer)obj);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

