/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.sourcelocator;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.sourcelocator.ViewFileSourceContainer;
import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineConnectionException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.sourcelocator.PDTLookupResult;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class PDTSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        if (object instanceof IDebugLocationProvider) {
            ViewFile viewFile = ((IDebugLocationProvider)object).getViewFile();
            if ((viewFile = this.getCurrentViewFile(viewFile)) != null) {
                return viewFile.getBaseFileName();
            }
        }
        return null;
    }

    public String getQualifiedSourceName(Object object) {
        if (object instanceof IDebugLocationProvider) {
            ViewFile viewFile = ((IDebugLocationProvider)object).getViewFile();
            if ((viewFile = this.getCurrentViewFile(viewFile)) != null) {
                return viewFile.getFileName();
            }
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString((Object)this, ".findSourceElements(" + object.toString() + ")");
        }
        ViewFile viewFile = null;
        IDebugTarget debugTarget = null;
        if (object instanceof IDebugLocationProvider) {
            debugTarget = ((IDebugLocationProvider)object).getDebugTarget();
            if (debugTarget == null || debugTarget.isTerminated()) {
                return EMPTY;
            }
        } else {
            PDTCoreUtils.logString((Object)this, ".findSourceElements(" + object.toString() + "):  object type is not supported");
            return EMPTY;
        }
        viewFile = ((IDebugLocationProvider)object).getViewFile();
        viewFile = this.getCurrentViewFile(viewFile);
        if (viewFile == null) {
            if (object instanceof StackFrame && !((StackFrame)object).isDebuggable()) {
                return new Object[]{new PDTLookupResult(debugTarget, null, object)};
            }
            PDTCoreUtils.logString((Object)this, ".findSourceElements(" + object.toString() + "):  location could not be found for object type");
            return EMPTY;
        }
        if (!viewFile.isSourceRequired()) {
            boolean verifed;
            try {
                verifed = viewFile.verify();
            }
            catch (EngineConnectionException e) {
                return EMPTY;
            }
            if (verifed) {
                return new Object[]{new PDTLookupResult(debugTarget, viewFile, object)};
            }
            return new Object[]{new PDTLookupResult(debugTarget, viewFile, object, null)};
        }
        if (viewFile.isLookupOverride()) {
            return new Object[]{viewFile.getLookupOverride()};
        }
        this.initViewFileSourceContainers(this.getSourceContainers(), viewFile);
        Object[] results = this.findSource(object);
        if (results.length == 0) {
            try {
                viewFile.setEditorFile(null);
            }
            catch (Exception e) {
                PDTCoreUtils.logString((Object)this, "Error nullifying the editor content after failed source lookup.", 1, e);
            }
            return new Object[]{new PDTLookupResult(debugTarget, viewFile, object, null)};
        }
        Object[] finalResults = new Object[results.length];
        int i = 0;
        while (i < results.length) {
            finalResults[i] = new PDTLookupResult(debugTarget, viewFile, object, results[i]);
            ++i;
        }
        return finalResults;
    }

    public Object[] findSource(Object object) throws CoreException {
        Object[] results = super.findSourceElements(object);
        String qualifiedSourceName = this.getQualifiedSourceName(object);
        if (results != null && qualifiedSourceName != null) {
            int maxMatchingSegments = -1;
            LocalFileStorage bestLFS = null;
            String[] qualifiedNameSegments = qualifiedSourceName.split("/");
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof LocalFileStorage) {
                    LocalFileStorage lfs = (LocalFileStorage)result;
                    String[] segments = lfs.getFullPath().segments();
                    int last = qualifiedNameSegments.length - 1;
                    int match = 0;
                    int i = segments.length - 1;
                    while (i >= 0) {
                        if (last < 0 || !segments[i].equals(qualifiedNameSegments[last])) break;
                        --last;
                        ++match;
                        --i;
                    }
                    if (match > maxMatchingSegments) {
                        maxMatchingSegments = match;
                        bestLFS = lfs;
                    }
                }
                ++n2;
            }
            if (bestLFS != null) {
                return new Object[]{bestLFS};
            }
            if (results.length > 0) {
                return new Object[]{results[0]};
            }
        }
        return results;
    }

    private void initViewFileSourceContainers(ISourceContainer[] containers, ViewFile vf) throws CoreException {
        int i = 0;
        while (i < containers.length) {
            ISourceContainer container = containers[i];
            if (container.isComposite()) {
                this.initViewFileSourceContainers(container.getSourceContainers(), vf);
            }
            if (container instanceof ViewFileSourceContainer) {
                ((ViewFileSourceContainer)container).setViewFile(vf);
            }
            ++i;
        }
    }

    private ViewFile getCurrentViewFile(ViewFile viewFile) {
        if (viewFile == null) {
            return null;
        }
        View currentView = viewFile.getPart().getCurrentView();
        if (viewFile.getView() == currentView) {
            return viewFile;
        }
        DebugEngine dbgEngine = currentView.getDebugEngine();
        try {
            Location newLoc = dbgEngine.switchView(new Location(viewFile, viewFile.getFirstLineNumber()), currentView.getViewInformation());
            return newLoc.getViewFile();
        }
        catch (EngineRequestException e) {
            return viewFile;
        }
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        block6: {
            IPDTDebugTarget debugTarget = PDTCorePlugin.getDebugTarget(director);
            if (debugTarget == null) {
                return;
            }
            boolean targetHasSuspendedThread = false;
            try {
                IThread[] iThreadArray = debugTarget.getThreads();
                int n = iThreadArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IThread thread = iThreadArray[n2];
                    if (thread.isSuspended()) {
                        targetHasSuspendedThread = true;
                        if (thread.hasStackFrames()) {
                            ((DebugElement)thread.getTopStackFrame()).fireChangeEvent(512);
                            return;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                if (!targetHasSuspendedThread) break block6;
                PDTCoreUtils.logString((Object)this, ".sourceContainersChanged(): failed to fire a change event for the top stack frame of the current thread", 2, e);
            }
        }
    }
}

