/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLEventBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class PICLZeroAddressBreakpoint
extends PICLEventBreakpoint {
    private static IMarker fZeroBreakpointMarker = null;
    private static Collection<PICLZeroAddressBreakpoint> fChildren = new ArrayList<PICLZeroAddressBreakpoint>();

    public PICLZeroAddressBreakpoint() {
    }

    public PICLZeroAddressBreakpoint(ZeroAddressBreakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
        dbgtgt.getDebugEngine().setZeroAddressBreakpointInstalled(true);
    }

    @Override
    public String getLabel() {
        return BreakpointLabels.zero_address_breakpoint_type_label;
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLZeroAddressBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        return new HashMap<String, Object>();
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        boolean enabled = false;
        enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
        enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
        OptionalBreakpointData optBpData = new OptionalBreakpointData(marker);
        try {
            process.setZeroAddressBreakpoint(enabled, optBpData, PICLZeroAddressBreakpoint.getMarkerAsProperty(marker));
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString((Object)this, "Import of breakpoint failed", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IMarker createMarker() throws CoreException {
        Collection<PICLZeroAddressBreakpoint> collection = fChildren;
        synchronized (collection) {
            if (fZeroBreakpointMarker == null || !fZeroBreakpointMarker.exists()) {
                fZeroBreakpointMarker = super.createMarker();
                fChildren.clear();
            } else {
                fChildren.add(this);
                this.getDebugTarget().getDebugEngine().setZeroAddressBreakpointInstalled(true);
            }
            return fZeroBreakpointMarker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws CoreException {
        Collection<PICLZeroAddressBreakpoint> collection = fChildren;
        synchronized (collection) {
            super.delete();
            if (!fChildren.contains((Object)this)) {
                for (PICLZeroAddressBreakpoint c : fChildren) {
                    c.delete();
                }
                fChildren.clear();
            }
            fZeroBreakpointMarker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean enabled) throws CoreException {
        Collection<PICLZeroAddressBreakpoint> collection = fChildren;
        synchronized (collection) {
            if (this.getDebugTarget() == null || this.getDebugTarget().getProcess() == null || this.getDebugTarget().getProcess().isTerminated()) {
                this.fEnabled = enabled;
            } else {
                super.setEnabled(enabled);
            }
            if (!fChildren.contains((Object)this)) {
                for (PICLZeroAddressBreakpoint c : fChildren) {
                    c.setEnabled(enabled);
                }
            }
        }
    }

    public boolean equals(Object item) {
        if (item instanceof PICLZeroAddressBreakpoint) {
            if (this.getModelBreakpoint() == null) {
                return ((PICLZeroAddressBreakpoint)((Object)item)).getModelBreakpoint() == null;
            }
            return this.getModelBreakpoint().equals(((PICLZeroAddressBreakpoint)((Object)item)).getModelBreakpoint());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerBreakpoint() {
        Collection<PICLZeroAddressBreakpoint> collection = fChildren;
        synchronized (collection) {
            if (!fChildren.contains((Object)this)) {
                super.registerBreakpoint();
            }
        }
    }

    public boolean isActive() {
        if (this.getDebugTarget() != null && this.getDebugTarget().getProcess() != null && !this.getDebugTarget().getProcess().isTerminated()) {
            return true;
        }
        for (PICLZeroAddressBreakpoint b : fChildren) {
            if (b.getDebugTarget() == null || b.getDebugTarget().getProcess() == null || b.getDebugTarget().getProcess().isTerminated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSkip(boolean skip) {
        boolean oldSetting = this.getDebugTarget().getDebugEngine().fZeroAddressBreakpointEnabled;
        super.setSkip(skip);
        if (skip) {
            this.getDebugTarget().getDebugEngine().fZeroAddressBreakpointEnabled = oldSetting;
            this.getDebugTarget().getDebugEngine().saveDebugObjects();
        }
    }
}

