/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLEventBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class PICLWatchBreakpoint
extends PICLEventBreakpoint {
    public PICLWatchBreakpoint() {
    }

    public PICLWatchBreakpoint(Watchpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    @Override
    public String getLabel() {
        return this.bindLabel(BreakpointLabels.watch_breakpoint_type_label, this.getCoreIdentifier());
    }

    protected String getCoreIdentifier() {
        String coreId = null;
        coreId = this.isImported() ? this.getMarker().getAttribute("addressOrExpression", null) : ((Watchpoint)this.fBreakpoint).getExpression();
        if (PDTCoreUtils.isEmpty(coreId)) {
            coreId = BreakpointLabels.unknown_breakpoint_type_label;
        }
        return coreId;
    }

    public String getAddress() {
        return ((Watchpoint)this.fBreakpoint).getAddress();
    }

    public int getByteCount() {
        return ((Watchpoint)this.fBreakpoint).getByteCount();
    }

    public String getExpression() {
        return ((Watchpoint)this.fBreakpoint).getExpression();
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLWatchBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        Watchpoint watchBkpt = (Watchpoint)bkpt;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.enabled", watchBkpt.isEnabled());
        attributes.put("addressOrExpression", watchBkpt.getExpression());
        attributes.put("moduleName", watchBkpt.getModuleName());
        attributes.put("partName", watchBkpt.getPartName());
        attributes.put("fileName", watchBkpt.getFileName());
        attributes.put("byteCount", watchBkpt.getByteCount());
        return attributes;
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        OptionalBreakpointData optBpData;
        String addressOrExpression = null;
        String fileName = null;
        String moduleName = null;
        String partName = null;
        int byteCount = 0;
        EStdView esv = null;
        boolean enabled = false;
        try {
            enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
            addressOrExpression = this.getAttributeAsString(marker, "addressOrExpression");
            fileName = this.getAttributeAsString(marker, "fileName");
            moduleName = this.getAttributeAsString(marker, "moduleName");
            partName = this.getAttributeAsString(marker, "partName");
            byteCount = marker.getAttribute("byteCount", 0);
            esv = new EStdView(0, 0, 0, 0);
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            return;
        }
        try {
            process.setWatchpoint(true, enabled, addressOrExpression, byteCount, optBpData, PICLWatchBreakpoint.getMarkerAsProperty(marker), esv, fileName, moduleName, partName, null);
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString((Object)this, "Import of breakpoint failed", 1);
        }
    }
}

