/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.core.breakpoints.PICLSpecialBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.osgi.util.NLS;

public class PICLStopAtAllFunctionEntryBreakpoint
extends PICLSpecialBreakpoint {
    public PICLStopAtAllFunctionEntryBreakpoint(IResource resource, PDTDebugTarget debugTarget, boolean enabled) throws CoreException {
        super(resource, debugTarget, enabled);
        try {
            debugTarget.getDebugEngine().setAllEntryBreakpointsEnabled(enabled);
            debugTarget.getDebugEngine().setAllEntryBreakpointsInstalled(true);
        }
        catch (EngineRequestException e) {
            throw new CoreException((IStatus)new Status(4, this.getModelIdentifier(), e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public String getLabel() {
        String processLabel;
        String programLabel;
        PDTDebugTarget dbgtgt = this.getDebugTarget();
        String baseLabel = dbgtgt != null && (PDTDebugUtils.isiSeriesEngine(dbgtgt) || dbgtgt.isCOBOL() || dbgtgt.isFORTRAN()) ? PICLLabels.StopAtAllEntryPointsBreakpoint_entry_baseLabel : PICLLabels.StopAtAllEntryPointsBreakpoint_baseLabel;
        if (dbgtgt == null || dbgtgt.getProcess() == null) {
            programLabel = "*unknown*";
            processLabel = "*unknown*";
        } else {
            DebuggeeProcess proc = (DebuggeeProcess)dbgtgt.getProcess();
            processLabel = proc.getProcessID();
            programLabel = proc.getBasePgmProfileName();
        }
        return NLS.bind((String)PICLLabels.StopAtAllEntryPointsBreakpoint_identifierFormat, (Object[])new Object[]{baseLabel, programLabel, processLabel});
    }

    @Override
    protected String getType() {
        return "com.ibm.debug.pdt.PICLStopAtAllFunctionEntryBreakpoint";
    }

    public void delete() throws CoreException {
        super.delete();
        try {
            this.fDbgTgt.getDebugEngine().setAllEntryBreakpointsEnabled(false);
        }
        catch (EngineRequestException e) {
            Status status = new Status(4, "com.ibm.debug.pdt.core", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public void setRegistered(boolean registered) throws CoreException {
        super.setRegistered(registered);
        if (!registered) {
            try {
                if (this.fDbgTgt.isAcceptingRequests()) {
                    this.fDbgTgt.getDebugEngine().setAllEntryBreakpointsEnabled(false);
                } else {
                    this.fDbgTgt.addPendingBkpChange((IBreakpoint)this, (byte)3);
                }
            }
            catch (EngineRequestException e) {
                Status status = new Status(4, "com.ibm.debug.pdt.core", 0, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
    }

    @Override
    protected boolean isSet() {
        return this.fDbgTgt.getDebugEngine().isAllEntryBreakpointsEnabled();
    }

    @Override
    public void setBreakpoint2(boolean enable) throws Exception {
        DebugEngine debugEngine = this.fDbgTgt.getDebugEngine();
        if (debugEngine.setAllEntryBreakpointsEnabled(enable)) {
            this.fireBreakpointChangedEvent();
        }
    }

    @Override
    public void prepareToSave() {
        this.fDbgTgt.getDebugEngine().fAllEntryBreakpointsEnabled = this.fEnabled;
    }

    public static PICLStopAtAllFunctionEntryBreakpoint findBreakpoint(PDTDebugTarget dbgtgt) {
        if (dbgtgt == null) {
            return null;
        }
        IBreakpointManager bkpm = dbgtgt.getBreakpointManager();
        IBreakpoint[] bkps = bkpm.getBreakpoints(dbgtgt.getModelIdentifier());
        int i = 0;
        while (i < bkps.length) {
            IBreakpoint bkp = bkps[i];
            if (bkp instanceof PICLStopAtAllFunctionEntryBreakpoint && ((PICLStopAtAllFunctionEntryBreakpoint)bkp).getDebugTarget() == dbgtgt) {
                return (PICLStopAtAllFunctionEntryBreakpoint)bkp;
            }
            ++i;
        }
        return null;
    }
}

