/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLBaseBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

public class PICLSourceEntryBreakpoint
extends PICLBaseBreakpoint {
    public PICLSourceEntryBreakpoint() {
    }

    public PICLSourceEntryBreakpoint(IResource resource, String moduleName, String partName, String entryName, int lineNumber) {
        this(resource, moduleName, partName, entryName, lineNumber, null);
    }

    public PICLSourceEntryBreakpoint(final IResource resource, final String moduleName, final String partName, final String entryName, final int lineNumber, final String path) {
        WorkspaceJob body = new WorkspaceJob("Job Schedule"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IMarker breakpointmarker = resource.createMarker("com.ibm.debug.pdt.core.PICLSourceEntryBreakpoint");
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("org.eclipse.debug.core.id", "com.ibm.debug.pdt.common");
                attributes.put("lineNumber", lineNumber);
                attributes.put("org.eclipse.debug.core.enabled", true);
                attributes.put("entryName", entryName);
                attributes.put("objectName", partName);
                attributes.put("moduleName", moduleName);
                if (path != null && !path.isEmpty()) {
                    attributes.put("resourcePath", path);
                }
                OptionalBreakpointData optData = new OptionalBreakpointData();
                optData.putAttributes(attributes);
                breakpointmarker.setAttributes(attributes);
                PICLSourceEntryBreakpoint.this.setMarker(breakpointmarker);
                if (resource == ResourcesPlugin.getWorkspace().getRoot()) {
                    PICLSourceEntryBreakpoint.this.setRegistered(true);
                    PICLSourceEntryBreakpoint.this.registerBreakpoint();
                } else {
                    PICLSourceEntryBreakpoint.this.setRegistered(false);
                }
                return Status.OK_STATUS;
            }
        };
        body.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        body.schedule();
    }

    public void registerBreakpoint() throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
    }

    @Override
    public String getModelIdentifier() {
        return "com.ibm.debug.pdt.common";
    }

    @Override
    public String getLabel() {
        if (!this.getModelIdentifier().equals("com.ibm.debug.pdt.common")) {
            return null;
        }
        IMarker marker = this.getMarker();
        if (marker == null) {
            return BreakpointLabels.unknown_breakpoint_type_label;
        }
        try {
            String entryName = (String)marker.getAttribute("entryName");
            return entryName;
        }
        catch (CoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
            return BreakpointLabels.unknown_breakpoint_type_label;
        }
    }

    public boolean isInstalled() {
        return this.getInstallCount() > 0;
    }

    public int getInstallCount() {
        if (this.getMarker() == null) {
            return 0;
        }
        return this.getMarker().getAttribute("installCount", 0);
    }

    public synchronized int incrementInstallCount() throws CoreException {
        int installCount = this.getInstallCount() + 1;
        this.setAttribute("installCount", installCount);
        return installCount;
    }

    public synchronized int decrementInstallCount() throws CoreException {
        int installCount = this.getInstallCount();
        if (installCount == 0) {
            return 0;
        }
        this.setAttribute("installCount", --installCount);
        return installCount;
    }

    private void resetInstallCount() {
        try {
            this.setAttribute("installCount", 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.resetInstallCount();
    }

    public boolean isConditional() {
        return OptionalBreakpointData.isConditional(this.getMarker());
    }

    @Override
    public void prepareToSave() {
    }
}

