/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLEventBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.OccurrenceBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class PICLOccurrenceBreakpoint
extends PICLEventBreakpoint {
    public PICLOccurrenceBreakpoint() {
    }

    public PICLOccurrenceBreakpoint(OccurrenceBreakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLOccurrenceBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.enabled", bkpt.isEnabled());
        attributes.put("occurrenceCondition", ((OccurrenceBreakpoint)bkpt).getCondition());
        return attributes;
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        OptionalBreakpointData optBpData;
        String condition = null;
        boolean enabled = false;
        try {
            enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
            condition = this.getAttributeAsString(marker, "occurrenceCondition");
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            return;
        }
        try {
            process.setOccurrenceBreakpoint(enabled, condition, optBpData, PICLOccurrenceBreakpoint.getMarkerAsProperty(marker));
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString((Object)this, "Import of breakpoint failed", 1);
        }
    }

    @Override
    public String getLabel() {
        String condition = this.getCondition();
        if (condition == null) {
            condition = BreakpointLabels.unknown_breakpoint_type_label;
        }
        return this.bindLabel(BreakpointLabels.occurrence_breakpoint_type_label, condition);
    }

    public String getCondition() {
        String condition = null;
        condition = this.isImported() ? this.getMarker().getAttribute("occurrenceCondition", null) : ((OccurrenceBreakpoint)this.fBreakpoint).getCondition();
        return condition;
    }
}

