/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.MacroBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class PICLMacroBreakpoint
extends PICLLocationBreakpoint {
    public PICLMacroBreakpoint() {
    }

    public PICLMacroBreakpoint(MacroBreakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    @Override
    public String getLabel() {
        int index;
        String macroName = this.getMacroName();
        if (macroName == null) {
            macroName = BreakpointLabels.unknown_breakpoint_type_label;
        }
        if ((index = macroName.indexOf(" [macro")) > 0) {
            macroName = macroName.substring(0, index);
        }
        return this.bindLabel(this.isMacroGroup() ? BreakpointLabels.macrogroup_breakpoint_type_label : BreakpointLabels.macro_breakpoint_type_label, macroName);
    }

    public String getMacroName() {
        String macroName = null;
        macroName = this.isImported() ? this.getMarker().getAttribute("macroName", null) : ((MacroBreakpoint)this.fBreakpoint).getFunctionName();
        return macroName;
    }

    public boolean isMacroGroup() {
        String macro = this.getMacroName();
        if (macro == null) {
            return false;
        }
        return macro.indexOf("[macro group]") >= 0;
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLMacroBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        MacroBreakpoint macroBkpt = (MacroBreakpoint)bkpt;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.enabled", macroBkpt.isEnabled());
        attributes.put("lineNumber", this.getMarkerLineNumber(macroBkpt, dbgtgt));
        attributes.put("moduleName", macroBkpt.getModuleName());
        attributes.put("partName", macroBkpt.getPartName());
        attributes.put("macroName", macroBkpt.getFunctionName());
        return attributes;
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        OptionalBreakpointData optBpData;
        String moduleName = null;
        String partName = null;
        String macroName = null;
        boolean enabled = false;
        try {
            enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
            partName = this.getAttributeAsString(marker, "partName");
            moduleName = this.getAttributeAsString(marker, "moduleName");
            macroName = this.getAttributeAsString(marker, "macroName");
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            return;
        }
        try {
            process.setDeferredMacroBreakpoint(enabled, macroName, moduleName, partName, optBpData, PICLMacroBreakpoint.getMarkerAsProperty(marker));
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString(this, "Import of breakpoint failed", 1);
        }
    }
}

