/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IDebugTarget;

public abstract class PICLLocationBreakpoint
extends PICLBreakpoint
implements IDebugLocationProvider {
    public PICLLocationBreakpoint() {
    }

    public PICLLocationBreakpoint(Breakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    protected int getMarkerLineNumber(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        try {
            LocationBreakpoint locBP = (LocationBreakpoint)bkpt;
            Part part = locBP.getPart();
            ViewInformation viewInfo = part != null ? part.getCurrentView().getViewInformation() : locBP.getViewInformation();
            int sourceLineNumber = locBP.getLineNumber(viewInfo);
            if (sourceLineNumber > 0) {
                return sourceLineNumber;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    public Location getLocation(ViewInformation viewInfo) {
        if (viewInfo == null) {
            return null;
        }
        return ((LocationBreakpoint)this.fBreakpoint).getLocationWithinView(viewInfo);
    }

    public boolean supportsView(ViewInformation vi) {
        Location loc = this.getLocation(vi);
        return loc != null;
    }

    public ViewInformation getViewInformation() {
        IDebugTarget pdt = this.getDebugTarget();
        ViewInformation[] vis = pdt.getDebugEngine().getSupportedViews();
        int i = 0;
        while (i < vis.length) {
            if (vis[i] != null && this.supportsView(vis[i])) {
                Location loc = this.getLocation(vis[i]);
                try {
                    return loc.getPart().getCurrentView().getViewInformation();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public ViewFile getViewFile() {
        Location loc = this.getLocation(this.getViewInformation());
        if (loc == null) {
            return null;
        }
        return loc.getViewFile();
    }
}

