/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLEventBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ModuleLoadBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class PICLLoadBreakpoint
extends PICLEventBreakpoint {
    public PICLLoadBreakpoint() {
    }

    public PICLLoadBreakpoint(ModuleLoadBreakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    @Override
    public String getLabel() {
        String moduleName = this.getModuleName();
        if (moduleName == null) {
            moduleName = BreakpointLabels.unknown_breakpoint_type_label;
        }
        return this.bindLabel(BreakpointLabels.load_breakpoint_type_label, moduleName);
    }

    public String getModuleName() {
        String moduleName = null;
        moduleName = this.isImported() ? this.getMarker().getAttribute("moduleName", null) : ((ModuleLoadBreakpoint)this.fBreakpoint).getModuleName();
        return moduleName;
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLLoadBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        ModuleLoadBreakpoint moduleLoadBkpt = (ModuleLoadBreakpoint)bkpt;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.enabled", moduleLoadBkpt.isEnabled());
        attributes.put("moduleName", moduleLoadBkpt.getModuleName());
        return attributes;
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        OptionalBreakpointData optBpData;
        String moduleName = null;
        boolean enabled = false;
        try {
            enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
            moduleName = this.getAttributeAsString(marker, "moduleName");
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            return;
        }
        try {
            boolean runToEntry = this.fBreakpoint instanceof ModuleLoadBreakpoint && ((ModuleLoadBreakpoint)this.fBreakpoint).isRunToEntry();
            process.setModuleLoadBreakpoint(enabled, moduleName, optBpData, PICLLoadBreakpoint.getMarkerAsProperty(marker), runToEntry);
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString((Object)this, "Import of breakpoint failed", 1);
        }
    }
}

