/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.osgi.util.NLS;

public class PICLLineBreakpoint
extends PICLLocationBreakpoint
implements ILineBreakpoint {
    public PICLLineBreakpoint() {
    }

    public PICLLineBreakpoint(Breakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    @Override
    public String getLabel() {
        String bpType = BreakpointLabels.line_breakpoint_type_label;
        String fileName = this.getFileName();
        if (fileName == null) {
            fileName = BreakpointLabels.unknown_breakpoint_type_label;
        }
        String lineOrStmtNumber = this.getStatementNumber();
        try {
            if (lineOrStmtNumber != null && !lineOrStmtNumber.trim().equals("")) {
                bpType = BreakpointLabels.statement_breakpoint_type_label;
            } else {
                lineOrStmtNumber = String.valueOf(this.getLineNumber());
            }
        }
        catch (CoreException ce) {
            PDTCoreUtils.logError((Exception)((Object)ce));
            lineOrStmtNumber = BreakpointLabels.unknown_breakpoint_type_label;
        }
        Object[] binding = new String[]{bpType, fileName, lineOrStmtNumber};
        String basicLabel = NLS.bind((String)BreakpointLabels.pdt_line_breakpoint_label_format, (Object[])binding);
        return basicLabel + OptionalBreakpointData.getDetailsForLabel(this);
    }

    public int getCharEnd() throws CoreException {
        return -1;
    }

    public int getCharStart() throws CoreException {
        return -1;
    }

    public String getStatementNumber() {
        String statementNumber = null;
        if (this.isImported()) {
            try {
                statementNumber = this.getAttributeAsString(this.getMarker(), "statementNumber");
            }
            catch (CoreException e) {
                return null;
            }
        } else {
            IDebugTarget idbgtgt = this.getDebugTarget();
            if (idbgtgt != null && !idbgtgt.isTerminated() && idbgtgt.supportsStatementBreakpoints()) {
                statementNumber = ((LineBreakpoint)this.fBreakpoint).getStatementNumber();
            }
        }
        return statementNumber;
    }

    public int getLineNumber() throws CoreException {
        if (this.isImported()) {
            return this.getMarker().getAttribute("lineNumber", 0);
        }
        try {
            if (this.fBreakpoint.isDeferred()) {
                return ((LineBreakpoint)this.fBreakpoint).getDeferredBreakpointLineNumber(this.getDebugTarget().getDebugEngine().getSourceViewInformation());
            }
            IDebugTarget idbgtgt = this.getDebugTarget();
            if (idbgtgt != null && !idbgtgt.isTerminated()) {
                Location loc = null;
                loc = this.getLocation(((LineBreakpoint)this.fBreakpoint).getViewInformation());
                if (loc != null) {
                    return loc.getLineNumber();
                }
                return this.getLocation(this.getViewInformation()).getLineNumber();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public String getFileName() {
        String fileName = null;
        fileName = this.isImported() ? this.getMarker().getAttribute("fileName", null) : ((LineBreakpoint)this.fBreakpoint).getFileName();
        return fileName;
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLLineBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        LineBreakpoint lineBkpt = (LineBreakpoint)bkpt;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.enabled", lineBkpt.isEnabled());
        attributes.put("lineNumber", this.getMarkerLineNumber(lineBkpt, dbgtgt));
        if (lineBkpt.getOriginalLocation() != null) {
            attributes.put("originalLineNumber", lineBkpt.getOriginalLocation().getLineNumber());
        }
        attributes.put("statementNumber", lineBkpt.getStatementNumber());
        attributes.put("moduleName", lineBkpt.getModuleName());
        attributes.put("partName", lineBkpt.getPartName());
        attributes.put("fileName", lineBkpt.getFileName());
        return attributes;
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        boolean enabled = false;
        int lineNumber = 0;
        String stmtNumber = null;
        String functionName = null;
        String moduleName = null;
        String partName = null;
        String fileName = null;
        OptionalBreakpointData optBpData = null;
        try {
            enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
            lineNumber = marker.getAttribute("lineNumber", -1);
            if (lineNumber < 0) {
                lineNumber = marker.getAttribute("originalLineNumber", 0);
            }
            partName = this.getAttributeAsString(marker, "partName");
            moduleName = this.getAttributeAsString(marker, "moduleName");
            functionName = this.getAttributeAsString(marker, "functionName");
            stmtNumber = this.getAttributeAsString(marker, "statementNumber");
            fileName = this.getAttributeAsString(marker, "fileName");
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            return;
        }
        try {
            process.setDeferredLineBreakpoint(enabled, lineNumber, stmtNumber, functionName, moduleName, partName, fileName, optBpData, PICLLineBreakpoint.getMarkerAsProperty(marker));
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString(this, "Import of breakpoint failed", 1);
        }
    }
}

