/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class PICLEntryBreakpoint
extends PICLLocationBreakpoint
implements Comparable<PICLEntryBreakpoint> {
    public PICLEntryBreakpoint() {
    }

    public PICLEntryBreakpoint(EntryBreakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    @Override
    public String getLabel() {
        String functionName = this.getFunctionName();
        if (functionName == null) {
            functionName = BreakpointLabels.unknown_breakpoint_type_label;
        }
        return this.bindLabel(BreakpointLabels.entry_breakpoint_type_label, functionName);
    }

    public String getFunctionName() {
        String functionName = null;
        functionName = this.isImported() ? this.getMarker().getAttribute("functionName", null) : ((EntryBreakpoint)this.fBreakpoint).getFunctionName();
        return functionName;
    }

    @Override
    public int compareTo(PICLEntryBreakpoint arg0) {
        return this.getLabel().compareTo(arg0.getLabel());
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLEntryBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        EntryBreakpoint entryBkpt = (EntryBreakpoint)bkpt;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.enabled", entryBkpt.isEnabled());
        attributes.put("lineNumber", this.getMarkerLineNumber(entryBkpt, dbgtgt));
        attributes.put("moduleName", entryBkpt.getModuleName());
        attributes.put("partName", entryBkpt.getPartName());
        attributes.put("functionName", entryBkpt.getFunctionName());
        attributes.put("caseSensitive", entryBkpt.isCaseSensitive());
        return attributes;
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        OptionalBreakpointData optBpData;
        String partName = null;
        String moduleName = null;
        String functionName = null;
        boolean caseSensitive = false;
        boolean enabled = false;
        try {
            enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
            partName = this.getAttributeAsString(marker, "partName");
            moduleName = this.getAttributeAsString(marker, "moduleName");
            functionName = this.getAttributeAsString(marker, "functionName");
            caseSensitive = marker.getAttribute("caseSensitive", false);
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            return;
        }
        if (process.getEngineSession().iszPICL()) {
            partName = "*";
        }
        try {
            process.setDeferredEntryBreakpoint(enabled, functionName, moduleName, partName, caseSensitive, optBpData, PICLEntryBreakpoint.getMarkerAsProperty(marker));
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString(this, "Import of breakpoint failed", 1);
        }
    }
}

