/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLAddressBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLAddressRangeBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBaseBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLEnhancedWatchBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLEntryBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLLoadBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLMacroBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLOccurrenceBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLWatchBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.AddressRangeBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EnhancedWatchpoint;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.MacroBreakpoint;
import com.ibm.debug.pdt.internal.core.model.ModuleLoadBreakpoint;
import com.ibm.debug.pdt.internal.core.model.OccurrenceBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.core.model.ZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.osgi.util.NLS;

public abstract class PICLBreakpoint
extends PICLBaseBreakpoint {
    protected Breakpoint fBreakpoint;

    public PICLBreakpoint() {
        this.imported = true;
    }

    public static void createPICLBreakpoint(Breakpoint modelBp, PDTDebugTarget dbgTgt) throws CoreException {
        if (modelBp instanceof LineBreakpoint) {
            new PICLLineBreakpoint(modelBp, dbgTgt);
        } else if (modelBp instanceof AddressRangeBreakpoint) {
            new PICLAddressRangeBreakpoint((AddressRangeBreakpoint)modelBp, dbgTgt);
        } else if (modelBp instanceof AddressBreakpoint) {
            new PICLAddressBreakpoint((AddressBreakpoint)modelBp, dbgTgt);
        } else if (modelBp instanceof MacroBreakpoint) {
            new PICLMacroBreakpoint((MacroBreakpoint)modelBp, dbgTgt);
        } else if (modelBp instanceof EntryBreakpoint) {
            new PICLEntryBreakpoint((EntryBreakpoint)modelBp, dbgTgt);
        } else if (modelBp instanceof ModuleLoadBreakpoint) {
            new PICLLoadBreakpoint((ModuleLoadBreakpoint)modelBp, dbgTgt);
        } else if (modelBp instanceof Watchpoint) {
            if (modelBp instanceof EnhancedWatchpoint) {
                new PICLEnhancedWatchBreakpoint((EnhancedWatchpoint)modelBp, dbgTgt);
            } else {
                new PICLWatchBreakpoint((Watchpoint)modelBp, dbgTgt);
            }
        } else if (modelBp instanceof OccurrenceBreakpoint) {
            new PICLOccurrenceBreakpoint((OccurrenceBreakpoint)modelBp, dbgTgt);
        } else if (modelBp instanceof ZeroAddressBreakpoint) {
            new PICLZeroAddressBreakpoint((ZeroAddressBreakpoint)modelBp, dbgTgt);
        } else {
            if (PDTCorePlugin.fModel) {
                PDTCoreUtils.logString(modelBp, " - PICLBreakpoint.createPICLBreakpoint(): unknown breakpoint type", 2);
            }
            return;
        }
    }

    public PICLBreakpoint(Breakpoint breakpoint, PDTDebugTarget dbgtgt) throws CoreException {
        super(dbgtgt);
        IMarker marker = this.createMarker();
        this.fBreakpoint = breakpoint;
        this.fBreakpoint.setWorkspaceMarker(marker);
        this.setMarker(marker);
        this.registerBreakpoint();
        this.fEnabled = this.fBreakpoint.isEnabled();
        this.setSkip(!DebugPlugin.getDefault().getBreakpointManager().isEnabled());
        this.updateMarker(this.fBreakpoint, dbgtgt);
    }

    protected final void finalize() {
    }

    public Breakpoint getModelBreakpoint() {
        return this.fBreakpoint;
    }

    protected void registerBreakpoint() {
        try {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
        catch (CoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
        }
    }

    public synchronized boolean isInstalled() {
        return true;
    }

    public synchronized int getInstallCount() {
        return 1;
    }

    public boolean isEnabled() throws CoreException {
        return this.fEnabled;
    }

    public boolean isDeferred() {
        return this.isImported() ? true : this.fBreakpoint.isDeferred();
    }

    public boolean isReadOnly() {
        return this.fBreakpoint.isReadOnly();
    }

    public boolean isConditional() {
        return this.hasConditionalExpression();
    }

    public boolean hasConditionalExpression() {
        return !PDTCoreUtils.isEmpty(this.getConditionalExpression());
    }

    public boolean isThreadSpecific() {
        return this.fBreakpoint.getThreadID() != 0;
    }

    public boolean isPeriodic() {
        return this.hasHitCount() || this.hasRange();
    }

    private boolean hasHitCount() {
        return this.fBreakpoint.getEveryVal() > 1;
    }

    private boolean hasRange() {
        return this.fBreakpoint.getFromVal() > 1 || this.fBreakpoint.getToVal() > this.fBreakpoint.getFromVal();
    }

    public boolean hasStopAction() {
        return !PDTCoreUtils.isEmpty(this.fBreakpoint.getBreakpointAction());
    }

    public boolean isStopSynchronous() {
        return this.fBreakpoint.isStopSynchronous();
    }

    public String getConditionalExpression() {
        if (this.isImported()) {
            String conditionalExpr = this.getMarker().getAttribute("condtionalExpression", "!NULL!");
            if (conditionalExpr.equals("!NULL!")) {
                return null;
            }
            return conditionalExpr;
        }
        return this.fBreakpoint.getConditionalExpression();
    }

    public void setWorkingSetName(String name) {
        this.fBreakpoint.setWorkingSetName(name);
    }

    public String getWorkingSetName() {
        return this.fBreakpoint.getWorkingSetName();
    }

    @Override
    public void prepareToSave() {
        this.fBreakpoint.prepareToSave(this.fEnabled);
    }

    @Override
    public void setBreakpoint2(boolean enable) throws Exception {
        this.fBreakpoint.setEnable(enable);
        super.setBreakpoint2(enable);
    }

    protected abstract String getMarkerType();

    protected IMarker createMarker() throws CoreException {
        final IMarker[] marker = new IMarker[1];
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
                marker[0] = resource.createMarker(PICLBreakpoint.this.getMarkerType());
            }
        }, null, 1, null);
        return marker[0];
    }

    protected String bindLabel(String bpType, String bpValue) {
        Object[] binding = new String[]{bpType, bpValue};
        return NLS.bind((String)BreakpointLabels.pdt_standard_breakpoint_label_format, (Object[])binding) + OptionalBreakpointData.getDetailsForLabel(this);
    }

    public void setModelBreakpoint(Breakpoint modelBreakpoint) {
        this.fBreakpoint = modelBreakpoint;
    }

    public void updateMarker(Breakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        final IMarker marker = bkpt.getMarker();
        final Map<String, Object> attributes = this.getAttributes(bkpt, dbgtgt);
        OptionalBreakpointData bkptData = new OptionalBreakpointData(bkpt);
        bkptData.putAttributes(attributes);
        if (!attributes.equals(marker.getAttributes())) {
            Job j = new Job("update breakpoint marker"){

                protected IStatus run(IProgressMonitor arg0) {
                    try {
                        IWorkspaceRunnable body = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                marker.setAttributes(attributes);
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(body, PICLBreakpoint.this.getMarkerRule(), 1, null);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule();
        }
    }

    abstract Map<String, Object> getAttributes(Breakpoint var1, PDTDebugTarget var2);

    public abstract void createModelBreakpoint(IMarker var1, DebuggeeProcess var2);

    public String getAttributeAsString(IMarker marker, String attr) throws CoreException {
        String attrAsString = null;
        Object attrValue = marker.getAttribute(attr);
        if (attrValue != null) {
            attrAsString = attrValue.toString();
        }
        return attrAsString;
    }

    public static EPDC_Request.EProperty getMarkerAsProperty(IMarker marker) {
        return new EPDC_Request.EProperty(1, marker);
    }
}

