/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.PICLZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class PICLBaseBreakpoint
extends Breakpoint {
    protected PDTDebugTarget fDbgTgt;
    protected boolean fEnabled = true;
    protected boolean fSkip = false;
    protected boolean imported = false;
    public static final String SKIPJOBFAMILY = "SkipJobFamily";

    protected PICLBaseBreakpoint(PDTDebugTarget debugTarget) {
        this.fDbgTgt = debugTarget;
    }

    public PICLBaseBreakpoint() {
    }

    public String getModelIdentifier() {
        return "com.ibm.debug.pdt";
    }

    public PDTDebugTarget getDebugTarget() {
        return this.fDbgTgt;
    }

    public abstract String getLabel();

    public abstract void prepareToSave();

    public void setSkip(boolean skip) {
        SkipJob job = new SkipJob(this, skip);
        job.schedule();
        if (this.getDebugTarget() != null && this.getDebugTarget().getDebugEngine() != null && this.getDebugTarget().getDebugEngine().isProcessingMultiRequest()) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setBreakpoint(boolean set) {
        try {
            this.setBreakpoint2(set);
        }
        catch (Exception e) {
            PDTCoreUtils.logError(e);
        }
    }

    public void setBreakpoint2(boolean enable) throws Exception {
        super.setEnabled(enable);
    }

    public void setEnabled(boolean enabled) throws CoreException {
        if (this.isImported()) {
            this.fEnabled = enabled;
            super.setEnabled(enabled);
        } else {
            if (this.fDbgTgt != null && !this.fDbgTgt.supportsEnableDisableBreakpoints()) {
                throw new CoreException(Status.OK_STATUS);
            }
            new EnableJob(this, enabled).schedule();
        }
    }

    public void setDebugTarget(PDTDebugTarget debugTarget) {
        this.fDbgTgt = debugTarget;
    }

    public boolean isImported() {
        return this.imported;
    }

    class EnableJob
    extends Job {
        private boolean fEnableSetting;
        private PICLBaseBreakpoint fBreakpoint;

        public EnableJob(PICLBaseBreakpoint breakpoint, boolean enableSetting) {
            super("Enable/Disable breakpoint");
            this.fBreakpoint = breakpoint;
            this.fEnableSetting = enableSetting;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                PICLBaseBreakpoint.this.fEnabled = this.fEnableSetting;
                if (!this.fEnableSetting) {
                    this.fBreakpoint.setBreakpoint2(false);
                } else if (!PICLBaseBreakpoint.this.fSkip) {
                    this.fBreakpoint.setBreakpoint2(true);
                } else if (PICLBaseBreakpoint.this.fSkip && this.fBreakpoint instanceof PICLZeroAddressBreakpoint) {
                    this.fBreakpoint.getDebugTarget().getDebugEngine().fZeroAddressBreakpointEnabled = PICLBaseBreakpoint.this.fEnabled;
                    this.fBreakpoint.getDebugTarget().getDebugEngine().saveDebugObjects();
                }
                DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this.fBreakpoint);
            }
            catch (Exception e) {
                PICLBaseBreakpoint.this.fEnabled = !this.fEnableSetting;
                PICLBaseBreakpoint.this.fDbgTgt.addPendingBkpChange((IBreakpoint)this.fBreakpoint, this.fEnableSetting ? (byte)2 : 3);
            }
            return Status.OK_STATUS;
        }
    }

    class SkipJob
    extends Job {
        private boolean fSkipSetting;
        private PICLBaseBreakpoint fBreakpoint;

        public SkipJob(PICLBaseBreakpoint breakpoint, boolean skipSetting) {
            super("Skip breakpoint");
            this.fBreakpoint = breakpoint;
            this.fSkipSetting = skipSetting;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                PICLBaseBreakpoint.this.fSkip = this.fSkipSetting;
                if (this.fSkipSetting) {
                    this.fBreakpoint.setBreakpoint2(false);
                } else if (PICLBaseBreakpoint.this.fEnabled) {
                    this.fBreakpoint.setBreakpoint2(true);
                }
            }
            catch (Exception e) {
                PICLBaseBreakpoint.this.fSkip = !this.fSkipSetting;
                PICLBaseBreakpoint.this.fDbgTgt.addPendingBkpChange((IBreakpoint)this.fBreakpoint, this.fSkipSetting ? (byte)4 : 5);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return PICLBaseBreakpoint.SKIPJOBFAMILY.equals(family);
        }
    }
}

